/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.tree.gui.ClassificationRegressionTreeIcon;
import com.insightful.miner.tree.gui.ColorBroker;
import com.insightful.miner.tree.model.ClassificationRegressionTreeNode;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.Component;
import java.awt.MediaTracker;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class CRTreeRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon imageTileIcon = new ImageIcon();
    private MediaTracker _tracker;
    private TreeCollection treeColl = null;

    public CRTreeRenderer(TreeCollection tc) {
        this.treeColl = tc;
        this._tracker = new MediaTracker(this);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object CRNode, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, CRNode, sel, expanded, leaf, row, hasFocus);
        this.setBackgroundSelectionColor(ColorBroker.getColor("treeBackgroundSelectionColor"));
        this.setTextSelectionColor(ColorBroker.getColor("treeSelectionColor"));
        this.setBorderSelectionColor(ColorBroker.getColor("treeSelectionColor"));
        ClassificationRegressionTreeIcon treeIcon = new ClassificationRegressionTreeIcon(this.treeColl, this.getProb(CRNode), 0.0, this.getRecordRatio(CRNode), -1.0, this.treeColl.getDisplaySizeGraphic(), true, false, false, this.isRegression(CRNode));
        this.setIcon(treeIcon);
        this.setToolTipText(this.getToolTipText(CRNode));
        return this;
    }

    protected String getToolTipText(Object value) {
        ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)value;
        if (node == null) {
            return "";
        }
        return node.getToolTipString();
    }

    protected boolean isRegression(Object value) {
        ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)value;
        if (node == null) {
            return true;
        }
        return node.isRegression();
    }

    protected double getRecordRatio(Object value) {
        ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)value;
        if (node == null) {
            return -1.0;
        }
        return node.getRecordRatio();
    }

    protected double getDiversityRatio(Object value) {
        ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)value;
        if (node == null) {
            return -1.0;
        }
        return node.getDiversityRatio();
    }

    protected double[] getProb(Object value) {
        ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)value;
        if (node == null) {
            return new double[1];
        }
        if (node.isRegression()) {
            return node.getPredictionProportion();
        }
        return node.getYvalProb();
    }
}

