/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoStroke$ArrowInfo;
import com.nwoods.jgo.JGoView;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.util.Vector;

public class JGoStroke
extends JGoDrawable {
    public static final int ChangedAddPoint = 101;
    public static final int ChangedRemovePoint = 102;
    public static final int ChangedModifiedPoint = 103;
    public static final int ChangedArrowHeads = 104;
    public static final int ChangedArrowLength = 105;
    public static final int ChangedArrowShaftLength = 106;
    public static final int ChangedArrowAngle = 107;
    public static final int ChangedHighlight = 108;
    public static final int ChangedAllPoints = 110;
    protected Vector myPoints = new Vector();
    private JGoPen myHighlightPen = null;
    private JGoStroke$ArrowInfo myArrowInfo = null;
    private transient Point \u0144 = null;

    public JGoStroke() {
        this.setBrush(JGoBrush.black);
    }

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        JGoStroke jGoStroke = (JGoStroke)super.copyObject(jGoCopyEnvironment);
        if (jGoStroke != null) {
            int n = 0;
            while (n < this.myPoints.size()) {
                Point point = (Point)this.myPoints.get(n);
                jGoStroke.myPoints.add(n, new Point(point));
                ++n;
            }
            if (this.myArrowInfo != null) {
                jGoStroke.myArrowInfo = new JGoStroke$ArrowInfo(this);
                jGoStroke.myArrowInfo.myLength = this.myArrowInfo.myLength;
                jGoStroke.myArrowInfo.myShaftLength = this.myArrowInfo.myShaftLength;
                jGoStroke.myArrowInfo.myAngle = this.myArrowInfo.myAngle;
            }
            jGoStroke.myHighlightPen = this.myHighlightPen;
        }
        return jGoStroke;
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        Point point;
        Point point2;
        CubicCurve2D.Double double_;
        Point point3;
        Point point4;
        Point point5;
        Point point6;
        int n;
        Stroke stroke;
        JGoPen jGoPen = this.getPen();
        if (jGoPen == null || jGoPen.getStyle() == 0) {
            return;
        }
        int n2 = this.getNumPoints();
        JGoPen jGoPen2 = this.getHighlight();
        if (jGoPen2 != null && jGoPen2.getStyle() != 0) {
            if (this.\u0144() && n2 >= 4) {
                stroke = jGoPen2.getStroke();
                if (stroke != null) {
                    graphics2D.setStroke(stroke);
                    graphics2D.setColor(jGoPen2.getColor());
                    n = 3;
                    while (n < n2) {
                        point6 = this.getPoint(n - 3);
                        point5 = this.getPoint(n - 2);
                        if (n + 4 >= n2) {
                            n = n2 - 1;
                        }
                        point4 = this.getPoint(n - 1);
                        point3 = this.getPoint(n);
                        double_ = new CubicCurve2D.Double(point6.x, point6.y, point5.x, point5.y, point4.x, point4.y, point3.x, point3.y);
                        graphics2D.draw(double_);
                        n += 4;
                    }
                }
            } else {
                int n3 = 1;
                while (n3 < n2) {
                    point2 = this.getPoint(n3 - 1);
                    point = this.getPoint(n3);
                    JGoDrawable.drawLine(graphics2D, jGoPen2, point2.x, point2.y, point.x, point.y);
                    ++n3;
                }
            }
        }
        if (this.\u0144() && n2 >= 4) {
            stroke = jGoPen.getStroke();
            if (stroke != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setColor(jGoPen.getColor());
                n = 3;
                while (n < n2) {
                    point6 = this.getPoint(n - 3);
                    point5 = this.getPoint(n - 2);
                    if (n + 4 >= n2) {
                        n = n2 - 1;
                    }
                    point4 = this.getPoint(n - 1);
                    point3 = this.getPoint(n);
                    double_ = new CubicCurve2D.Double(point6.x, point6.y, point5.x, point5.y, point4.x, point4.y, point3.x, point3.y);
                    graphics2D.draw(double_);
                    n += 4;
                }
            }
        } else {
            int n4 = 1;
            while (n4 < n2) {
                point2 = this.getPoint(n4 - 1);
                point = this.getPoint(n4);
                this.drawLine(graphics2D, point2.x, point2.y, point.x, point.y);
                ++n4;
            }
        }
        this.\u0147(graphics2D);
    }

    boolean \u0144() {
        return (this.getFlags() & 0x1000) != 0;
    }

    void \u0145(boolean bl) {
        boolean bl2 = this.\u0144();
        if (bl2 != bl) {
            if (bl) {
                this.setFlags(this.getFlags() | 0x1000);
            } else {
                this.setFlags(this.getFlags() & 0xFFFFEFFF);
            }
            this.update(109, bl2 ? 1 : 0, null);
        }
    }

    public final int addPoint(Point point) {
        return this.addPoint(point.x, point.y);
    }

    public int addPoint(int n, int n2) {
        Point point = new Point(n, n2);
        this.myPoints.add(point);
        this.\u010e(true);
        int n3 = this.myPoints.size() - 1;
        this.update(101, n3, point);
        return n3;
    }

    public final int insertPoint(int n, Point point) {
        return this.insertPoint(n, point.x, point.y);
    }

    public int insertPoint(int n, int n2, int n3) {
        Point point = new Point(n2, n3);
        int n4 = n;
        try {
            this.myPoints.add(n, point);
        }
        catch (Exception exception) {
            this.myPoints.add(point);
            n4 = this.myPoints.size() - 1;
        }
        this.\u010e(true);
        this.update(101, n4, point);
        return n4;
    }

    public void removePoint(int n) {
        if (n >= 0 && n < this.getNumPoints()) {
            Point point = (Point)this.myPoints.elementAt(n);
            this.myPoints.removeElementAt(n);
            this.\u010e(true);
            this.update(102, n, point);
        }
    }

    public Point getPoint(int n) {
        if (n >= 0 && n < this.getNumPoints()) {
            return (Point)this.myPoints.elementAt(n);
        }
        return null;
    }

    public int getPointX(int n) {
        Point point = this.getPoint(n);
        if (point != null) {
            return point.x;
        }
        return -1;
    }

    public int getPointY(int n) {
        Point point = this.getPoint(n);
        if (point != null) {
            return point.y;
        }
        return -1;
    }

    public final void setPoint(int n, Point point) {
        this.setPoint(n, point.x, point.y);
    }

    public void setPoint(int n, int n2, int n3) {
        Point point = this.getPoint(n);
        if (point != null && (point.x != n2 || point.y != n3)) {
            if (this.\u0144 == null) {
                this.\u0144 = new Point(point);
            } else {
                this.\u0144.x = point.x;
                this.\u0144.y = point.y;
            }
            point.x = n2;
            point.y = n3;
            this.\u010e(true);
            this.update(103, n, this.\u0144);
        }
    }

    public void removeAllPoints() {
        this.foredate(110);
        this.myPoints.removeAllElements();
        this.\u010e(true);
        this.update(110, 0, null);
    }

    public void setPoints(Vector vector) {
        this.foredate(110);
        this.myPoints.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            Point point = (Point)vector.get(n);
            Point point2 = new Point(point.x, point.y);
            this.myPoints.add(point2);
            ++n;
        }
        this.\u010e(true);
        this.update(110, 0, null);
    }

    public Vector copyPoints() {
        Vector<Point> vector = new Vector<Point>();
        int n = this.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            Point point = this.getPoint(n2);
            vector.add(n2, new Point(point));
            ++n2;
        }
        return vector;
    }

    public int getNumPoints() {
        return this.myPoints.size();
    }

    public Point getStartPoint() {
        return this.getPoint(0);
    }

    public Point getEndPoint() {
        return this.getPoint(this.getNumPoints() - 1);
    }

    protected int getFirstPickPoint() {
        return 0;
    }

    protected int getLastPickPoint() {
        return this.getNumPoints() - 1;
    }

    public Rectangle handleResize(Graphics2D graphics2D, JGoView jGoView, Rectangle rectangle, Point point, int n, int n2, int n3, int n4) {
        if (n < 100) {
            return super.handleResize(graphics2D, jGoView, rectangle, point, n, n2, n3, n4);
        }
        this.setPoint(n - 100, point);
        return null;
    }

    protected void geometryChange(Rectangle rectangle) {
        if (rectangle.width == this.getWidth() && rectangle.height == this.getHeight()) {
            Rectangle rectangle2 = this.getBoundingRect();
            int n = rectangle2.x - rectangle.x;
            int n2 = rectangle2.y - rectangle.y;
            if (n == 0 && n2 == 0) {
                return;
            }
            this.foredate(110);
            this.setSuspendUpdates(true);
            int n3 = 0;
            while (n3 < this.getNumPoints()) {
                Point point = this.getPoint(n3);
                if (point != null) {
                    int n4 = point.x + n;
                    int n5 = point.y + n2;
                    this.setPoint(n3, n4, n5);
                }
                ++n3;
            }
            this.\u010e(false);
            this.setSuspendUpdates(false);
            this.update(110, 0, null);
        } else {
            Rectangle rectangle3 = this.getBoundingRect();
            double d = 1.0;
            if (rectangle.width != 0) {
                d = (double)rectangle3.width / (double)rectangle.width;
            }
            double d2 = 1.0;
            if (rectangle.height != 0) {
                d2 = (double)rectangle3.height / (double)rectangle.height;
            }
            this.foredate(110);
            this.setSuspendUpdates(true);
            int n = 0;
            while (n < this.getNumPoints()) {
                Point point = this.getPoint(n);
                if (point != null) {
                    int n6 = rectangle3.x + (int)Math.rint((double)(point.x - rectangle.x) * d);
                    int n7 = rectangle3.y + (int)Math.rint((double)(point.y - rectangle.y) * d2);
                    this.setPoint(n, n6, n7);
                }
                ++n;
            }
            this.\u010e(false);
            this.setSuspendUpdates(false);
            this.update(110, 0, null);
        }
    }

    protected void gainedSelection(JGoSelection jGoSelection) {
        if (!this.isResizable()) {
            jGoSelection.createBoundingHandle(this);
            return;
        }
        int n = this.getLastPickPoint();
        int n2 = this.getFirstPickPoint();
        while (n2 <= n) {
            Point point = this.getPoint(n2);
            if (point != null) {
                jGoSelection.createResizeHandle(this, point.x, point.y, 100 + n2, true);
            }
            ++n2;
        }
    }

    public Rectangle getBoundingRect() {
        if (this.\u010f()) {
            this.\u0146();
        }
        return super.getBoundingRect();
    }

    public void setBoundingRect(int n, int n2, int n3, int n4) {
        this.\u010e(false);
        super.setBoundingRect(n, n2, n3, n4);
    }

    private void \u0146() {
        Rectangle rectangle;
        this.\u010e(false);
        JGoArea jGoArea = this.getParent();
        Rectangle rectangle2 = rectangle = jGoArea != null ? new Rectangle(this.\u0107()) : null;
        if (this.getNumPoints() == 0) {
            this.setBoundingRectForce(this.getLeft(), this.getTop(), 0, 0);
            if (jGoArea != null) {
                jGoArea.geometryChangeChild(this, rectangle);
            }
            return;
        }
        Point point = this.getPoint(0);
        int n = point.x;
        int n2 = point.y;
        int n3 = point.x;
        int n4 = point.y;
        int n5 = 1;
        while (n5 < this.getNumPoints()) {
            point = this.getPoint(n5);
            n = Math.min(n, point.x);
            n2 = Math.min(n2, point.y);
            n3 = Math.max(n3, point.x);
            n4 = Math.max(n4, point.y);
            ++n5;
        }
        boolean bl = this.hasArrowAtEnd();
        boolean bl2 = this.hasArrowAtStart();
        if (bl || bl2) {
            Point point2;
            Point point3;
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new JGoStroke$ArrowInfo(this);
            }
            int[] nArray = this.myArrowInfo.\u0142();
            int[] nArray2 = this.myArrowInfo.\u0143();
            if (bl) {
                point3 = this.getArrowToAnchorPoint();
                point2 = this.getArrowToEndPoint();
                if (point3 != null && point2 != null) {
                    this.calculateFilledArrowhead(point3.x, point3.y, point2.x, point2.y, 1, nArray, nArray2);
                    n5 = 0;
                    while (n5 < 4) {
                        n = Math.min(n, nArray[n5]);
                        n2 = Math.min(n2, nArray2[n5]);
                        n3 = Math.max(n3, nArray[n5]);
                        n4 = Math.max(n4, nArray2[n5]);
                        ++n5;
                    }
                }
            }
            if (bl2) {
                point3 = this.getArrowFromAnchorPoint();
                point2 = this.getArrowFromEndPoint();
                if (point3 != null && point2 != null) {
                    this.calculateFilledArrowhead(point3.x, point3.y, point2.x, point2.y, 0, nArray, nArray2);
                    n5 = 0;
                    while (n5 < 4) {
                        n = Math.min(n, nArray[n5]);
                        n2 = Math.min(n2, nArray2[n5]);
                        n3 = Math.max(n3, nArray[n5]);
                        n4 = Math.max(n4, nArray2[n5]);
                        ++n5;
                    }
                }
            }
        }
        if (this.setBoundingRectForce(n, n2, n3 - n, n4 - n2) && jGoArea != null) {
            jGoArea.geometryChangeChild(this, rectangle);
        }
    }

    public void expandRectByPenWidth(Rectangle rectangle) {
        JGoPen jGoPen = this.getPen();
        if (jGoPen != null) {
            int n = 2 * jGoPen.getWidth();
            if (this.getHighlight() != null) {
                n = Math.max(n, 2 * this.getHighlight().getWidth());
            }
            rectangle.grow(n, n);
        }
    }

    public boolean isPointInObj(Point point) {
        int n = this.getSegmentNearPoint(point);
        return n >= 0;
    }

    public int getSegmentNearPoint(Point point) {
        int n;
        Rectangle rectangle = this.getBoundingRect();
        int n2 = n = this.getPen() != null ? this.getPen().getWidth() : 1;
        if (point.x < rectangle.x - n || point.x > rectangle.x + rectangle.width + n || point.y < rectangle.y - n || point.y > rectangle.y + rectangle.height + n) {
            return -1;
        }
        if (this.getNumPoints() <= 1) {
            return -1;
        }
        n += 3;
        int n3 = 0;
        while (n3 < this.getNumPoints() - 1) {
            Point point2 = this.getPoint(n3);
            Point point3 = this.getPoint(n3 + 1);
            int n4 = Math.max(point2.x, point3.x) + n;
            int n5 = Math.min(point2.x, point3.x) - n;
            if (n5 <= point.x && point.x <= n4) {
                int n6;
                if (point2.x != point3.x) {
                    double d = -((double)(point2.y - point3.y)) / (double)(point2.x - point3.x);
                    n6 = (int)(d * (double)(-point.x + point2.x) + (double)point2.y);
                } else {
                    n6 = point.y;
                }
                int n7 = n6 - n;
                int n8 = n6 + n;
                if (n7 < point.y && point.y < n8) {
                    return n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    public void setArrowHeads(boolean bl, boolean bl2) {
        boolean bl3 = this.hasArrowAtEnd();
        boolean bl4 = this.hasArrowAtStart();
        if (bl3 != bl2 || bl4 != bl) {
            int n = 0;
            int n2 = 0;
            if (bl) {
                n |= 0x8000;
            } else {
                n2 |= 0x8000;
            }
            if (bl2) {
                n |= 0x4000;
            } else {
                n2 |= 0x4000;
            }
            this.setFlags(this.getFlags() & ~n2 | n);
            this.\u010e(true);
            this.update(104, (bl3 ? 2 : 0) + (bl4 ? 1 : 0), null);
        }
    }

    public boolean hasArrowAtEnd() {
        return (this.getFlags() & 0x4000) != 0;
    }

    public boolean hasArrowAtStart() {
        return (this.getFlags() & 0x8000) != 0;
    }

    public Point getArrowToEndPoint() {
        return this.getEndPoint();
    }

    public Point getArrowToAnchorPoint() {
        return this.getPoint(this.getNumPoints() - 2);
    }

    public Point getArrowFromEndPoint() {
        return this.getStartPoint();
    }

    public Point getArrowFromAnchorPoint() {
        return this.getPoint(1);
    }

    public void setArrowLength(double d) {
        double d2 = this.getArrowLength();
        if (d2 != d) {
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new JGoStroke$ArrowInfo(this);
            }
            this.myArrowInfo.myLength = d;
            this.\u010e(true);
            this.update(105, 0, new Double(d2));
        }
    }

    public double getArrowLength() {
        if (this.myArrowInfo != null) {
            return this.myArrowInfo.myLength;
        }
        return 10.0;
    }

    public void setArrowShaftLength(double d) {
        double d2 = this.getArrowShaftLength();
        if (d2 != d) {
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new JGoStroke$ArrowInfo(this);
            }
            this.myArrowInfo.myShaftLength = d;
            this.\u010e(true);
            this.update(106, 0, new Double(d2));
        }
    }

    public double getArrowShaftLength() {
        if (this.myArrowInfo != null) {
            return this.myArrowInfo.myShaftLength;
        }
        return 8.0;
    }

    public void setArrowAngle(double d) {
        double d2 = this.getArrowAngle();
        if (d2 != d && Math.abs(d) < 3.0) {
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new JGoStroke$ArrowInfo(this);
            }
            this.myArrowInfo.myAngle = d;
            this.\u010e(true);
            this.update(107, 0, new Double(d2));
        }
    }

    public double getArrowAngle() {
        if (this.myArrowInfo != null) {
            return this.myArrowInfo.myAngle;
        }
        return 0.7853981633974483;
    }

    private void \u0147(Graphics2D graphics2D) {
        boolean bl = this.hasArrowAtEnd();
        boolean bl2 = this.hasArrowAtStart();
        if (bl || bl2) {
            Point point;
            Point point2;
            if (this.myArrowInfo == null) {
                this.myArrowInfo = new JGoStroke$ArrowInfo(this);
            }
            int[] nArray = this.myArrowInfo.\u0142();
            int[] nArray2 = this.myArrowInfo.\u0143();
            if (bl) {
                point2 = this.getArrowToAnchorPoint();
                point = this.getArrowToEndPoint();
                if (point2 != null && point != null) {
                    this.calculateFilledArrowhead(point2.x, point2.y, point.x, point.y, 1, nArray, nArray2);
                    this.drawArrowhead(graphics2D, true, nArray, nArray2);
                }
            }
            if (bl2) {
                point2 = this.getArrowFromAnchorPoint();
                point = this.getArrowFromEndPoint();
                if (point2 != null && point != null) {
                    this.calculateFilledArrowhead(point2.x, point2.y, point.x, point.y, 0, nArray, nArray2);
                    this.drawArrowhead(graphics2D, false, nArray, nArray2);
                }
            }
        }
    }

    protected void calculateFilledArrowhead(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        int n6 = n3 - n;
        int n7 = n4 - n2;
        double d = Math.sqrt(n6 * n6 + n7 * n7);
        if (d <= 1.0) {
            d = 1.0;
        }
        double d2 = (double)n6 / d;
        double d3 = (double)n7 / d;
        double d4 = this.getArrowLength();
        double d5 = this.getArrowShaftLength();
        double d6 = this.getArrowAngle();
        int n8 = (int)Math.round(d4 * Math.tan(d6 / 2.0));
        double d7 = -d5;
        double d8 = 0.0;
        double d9 = -d4;
        double d10 = n8;
        double d11 = -d4;
        double d12 = -n8;
        nArray[0] = n3 + (int)Math.round(d2 * d7 - d3 * d8);
        nArray2[0] = n4 + (int)Math.round(d3 * d7 + d2 * d8);
        nArray[1] = n3 + (int)Math.round(d2 * d9 - d3 * d10);
        nArray2[1] = n4 + (int)Math.round(d3 * d9 + d2 * d10);
        nArray[2] = n3;
        nArray2[2] = n4;
        nArray[3] = n3 + (int)Math.round(d2 * d11 - d3 * d12);
        nArray2[3] = n4 + (int)Math.round(d3 * d11 + d2 * d12);
    }

    protected void drawArrowhead(Graphics2D graphics2D, boolean bl, int[] nArray, int[] nArray2) {
        JGoPen jGoPen = this.getPen();
        if (jGoPen.getStyle() != 65535) {
            jGoPen = JGoPen.makeStockPen(jGoPen.getColor());
        }
        JGoDrawable.drawPolygon(graphics2D, jGoPen, this.getBrush(), nArray, nArray2, 4);
    }

    public void setHighlight(JGoPen jGoPen) {
        JGoPen jGoPen2 = this.getHighlight();
        if (jGoPen2 != jGoPen) {
            this.myHighlightPen = jGoPen;
            this.update(108, 0, jGoPen2);
        }
    }

    public JGoPen getHighlight() {
        return this.myHighlightPen;
    }

    public void copyOldValueForUndo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 101: {
                jGoDocumentChangedEdit.setOldValue(new Point((Point)jGoDocumentChangedEdit.getOldValue()));
                return;
            }
            case 102: {
                jGoDocumentChangedEdit.setOldValue(new Point((Point)jGoDocumentChangedEdit.getOldValue()));
                return;
            }
            case 103: {
                jGoDocumentChangedEdit.setOldValue(new Point((Point)jGoDocumentChangedEdit.getOldValue()));
                return;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                return;
            }
            case 110: {
                JGoDocumentChangedEdit jGoDocumentChangedEdit2;
                if (!jGoDocumentChangedEdit.isBeforeChanging() && (jGoDocumentChangedEdit2 = jGoDocumentChangedEdit.findBeforeChangingEdit()) != null) {
                    jGoDocumentChangedEdit.setOldValue(jGoDocumentChangedEdit2.getNewValue());
                }
                return;
            }
        }
        super.copyOldValueForUndo(jGoDocumentChangedEdit);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 101: {
                jGoDocumentChangedEdit.setNewValue(new Point(this.getPoint(jGoDocumentChangedEdit.getOldValueInt())));
                return;
            }
            case 102: {
                jGoDocumentChangedEdit.setNewValue(new Point(this.getPoint(jGoDocumentChangedEdit.getOldValueInt())));
                return;
            }
            case 103: {
                jGoDocumentChangedEdit.setNewValue(new Point(this.getPoint(jGoDocumentChangedEdit.getOldValueInt())));
                return;
            }
            case 104: {
                jGoDocumentChangedEdit.setNewValueInt((this.hasArrowAtEnd() ? 2 : 0) + (this.hasArrowAtStart() ? 1 : 0));
                return;
            }
            case 105: {
                jGoDocumentChangedEdit.setNewValue(new Double(this.getArrowLength()));
                return;
            }
            case 106: {
                jGoDocumentChangedEdit.setNewValue(new Double(this.getArrowShaftLength()));
                return;
            }
            case 107: {
                jGoDocumentChangedEdit.setNewValue(new Double(this.getArrowAngle()));
                return;
            }
            case 108: {
                jGoDocumentChangedEdit.setNewValue(this.getHighlight());
                return;
            }
            case 109: {
                jGoDocumentChangedEdit.setNewValueBoolean(this.\u0144());
                return;
            }
            case 110: {
                Vector vector = this.copyPoints();
                jGoDocumentChangedEdit.setNewValue(vector);
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 1: {
                Rectangle rectangle = new Rectangle(this.getBoundingRect());
                this.setBoundingRectForce((Rectangle)jGoDocumentChangedEdit.getValue(bl));
                this.geometryChange(rectangle);
                this.update();
                return;
            }
            case 101: {
                if (bl) {
                    this.removePoint(jGoDocumentChangedEdit.getOldValueInt());
                } else {
                    this.insertPoint(jGoDocumentChangedEdit.getOldValueInt(), (Point)jGoDocumentChangedEdit.getNewValue());
                }
                return;
            }
            case 102: {
                if (bl) {
                    this.insertPoint(jGoDocumentChangedEdit.getOldValueInt(), (Point)jGoDocumentChangedEdit.getOldValue());
                } else {
                    this.removePoint(jGoDocumentChangedEdit.getOldValueInt());
                }
                return;
            }
            case 103: {
                if (bl) {
                    this.setPoint(jGoDocumentChangedEdit.getOldValueInt(), (Point)jGoDocumentChangedEdit.getOldValue());
                } else {
                    this.setPoint(jGoDocumentChangedEdit.getOldValueInt(), (Point)jGoDocumentChangedEdit.getNewValue());
                }
                return;
            }
            case 104: {
                int n = jGoDocumentChangedEdit.getValueInt(bl);
                boolean bl2 = (n & 2) != 0;
                boolean bl3 = (n & 1) != 0;
                this.setArrowHeads(bl2, bl3);
                return;
            }
            case 105: {
                this.setArrowLength(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 106: {
                this.setArrowShaftLength(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 107: {
                this.setArrowAngle(jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 108: {
                this.setHighlight((JGoPen)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 109: {
                this.\u0145(jGoDocumentChangedEdit.getValueBoolean(bl));
                return;
            }
            case 110: {
                Vector vector = (Vector)jGoDocumentChangedEdit.getValue(bl);
                this.setPoints(vector);
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }
}

