/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;

class CachedTile {
    Raster tile;
    RenderedImage owner;
    int tileX;
    int tileY;
    Long key;
    long memorySize;
    long timeStamp;
    CachedTile previous;
    CachedTile next;

    public CachedTile(RenderedImage renderedImage, int n, int n2, Raster raster) {
        this.tile = raster;
        this.owner = renderedImage;
        this.tileX = n;
        this.tileY = n2;
        this.key = CachedTile.hashKey(renderedImage, n, n2);
        this.memorySize = this.tileMemorySize(raster);
    }

    public RenderedImage getOwner() {
        return this.owner;
    }

    public static long getOwnerHashCode(Long l) {
        return l >>> 32;
    }

    public Raster getTile() {
        return this.tile;
    }

    public static Long hashKey(int n, int n2) {
        long l = n2;
        return new Long((long)n << 32 | (l &= 0xFFFFFFFFL));
    }

    public static Long hashKey(RenderedImage renderedImage, int n, int n2) {
        long l = n2 * renderedImage.getNumXTiles() + n;
        return new Long((long)renderedImage.hashCode() << 32 | (l &= 0xFFFFFFFFL));
    }

    private long tileMemorySize(Raster raster) {
        DataBuffer dataBuffer = raster.getDataBuffer();
        return (long)DataBuffer.getDataTypeSize(dataBuffer.getDataType()) / 8L * (long)dataBuffer.getSize() * (long)dataBuffer.getNumBanks();
    }

    public String toString() {
        RenderedImage renderedImage = this.getOwner();
        String string = renderedImage == null ? "null" : renderedImage.toString();
        Raster raster = this.getTile();
        String string2 = raster == null ? "null" : raster.toString();
        return String.valueOf(this.getClass().getName()) + "@" + Integer.toHexString(this.hashCode()) + ": owner = " + string + " tileX = " + Integer.toString(this.tileX) + " tileY = " + Integer.toString(this.tileY) + " tile = " + string2 + " key = " + Long.toHexString(this.key) + " memorySize = " + Long.toString(this.memorySize) + " timeStamp = " + Long.toString(this.timeStamp);
    }
}

