/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.CopyPropertyGenerator;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertyGeneratorFromSource;
import javax.media.jai.PropertySource;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;

class PropertySourceImpl
implements PropertySource {
    Vector pg;
    Vector sources;
    Vector suppNames = new Vector();
    Hashtable sourceForProp;
    boolean isRendered;
    Object op;
    private Hashtable propNames;

    public PropertySourceImpl(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, RenderableOp renderableOp) {
        this.isRendered = false;
        this.sources = vector;
        this.pg = vector2;
        this.op = renderableOp;
        this.sourceForProp = hashtable;
        if (vector3 != null) {
            this.suppNames = vector3;
        }
        this.hashNames();
    }

    public PropertySourceImpl(Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, RenderedOp renderedOp) {
        this.isRendered = true;
        this.sources = vector;
        this.pg = vector2;
        this.op = renderedOp;
        this.sourceForProp = hashtable;
        if (vector3 != null) {
            this.suppNames = vector3;
        }
        this.hashNames();
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        if (this.pg == null) {
            this.pg = new Vector();
        }
        this.pg.addElement(propertyGenerator);
        this.removeSuppressedProps(propertyGenerator);
        this.hashNames();
    }

    public void copyPropertyFromSource(String string, int n) {
        string = string.toLowerCase();
        PropertyGeneratorFromSource propertyGeneratorFromSource = new PropertyGeneratorFromSource(n, string);
        this.addPropertyGenerator(propertyGeneratorFromSource);
    }

    public Object getProperty(String string) {
        Object object;
        Serializable serializable;
        string = string.toLowerCase();
        Object v = this.propNames.get(string);
        Object object2 = null;
        if (v == null) {
            return Image.UndefinedProperty;
        }
        if (v instanceof PropertyGenerator) {
            serializable = (PropertyGenerator)v;
            object2 = this.isRendered ? serializable.getProperty(string, (RenderedOp)this.op) : serializable.getProperty(string, (RenderableOp)this.op);
        } else if (v instanceof Integer) {
            int n = (Integer)v;
            object = (PropertySource)this.sources.elementAt(n);
            object2 = object.getProperty(string);
        }
        if (this.isRendered && object2 != null && string.equals("roi")) {
            serializable = (ROI)object2;
            object = ((RenderedOp)this.op).getBounds();
            if (!((Rectangle)object).contains(((ROI)serializable).getBounds())) {
                object2 = ((ROI)serializable).intersect(new ROIShape((Shape)object));
            }
        }
        return object2;
    }

    public String[] getPropertyNames() {
        int n = 0;
        String[] stringArray = new String[this.propNames.size()];
        Enumeration enumeration = this.propNames.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        return PlanarImage.getPropertyNames(stringArray, string);
    }

    private void hashNames() {
        PlanarImage planarImage;
        Object object;
        Object object2;
        this.propNames = new Hashtable();
        if (this.sources != null) {
            int n = this.sources.size() - 1;
            while (n >= 0) {
                String[] stringArray;
                object2 = this.sources.elementAt(n);
                if (object2 instanceof PropertySource && (stringArray = (object = (PropertySource)object2).getPropertyNames()) != null) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        String string = stringArray[n2].toLowerCase();
                        if (!this.suppNames.contains(string)) {
                            this.propNames.put(string, new Integer(n));
                        }
                        ++n2;
                    }
                }
                --n;
            }
        }
        if (this.pg != null) {
            object2 = ((AbstractList)this.pg).iterator();
            while (object2.hasNext()) {
                PropertyGenerator propertyGenerator = (PropertyGenerator)object2.next();
                object = propertyGenerator.getPropertyNames();
                if (object == null) continue;
                int n = 0;
                while (n < ((Object)object).length) {
                    String string = ((String)object[n]).toLowerCase();
                    if (!this.suppNames.contains(string)) {
                        this.propNames.put(string, propertyGenerator);
                    }
                    ++n;
                }
            }
        }
        if (this.isRendered && (planarImage = ((RenderedOp)this.op).getRendering()) != null && (object2 = planarImage.getPropertyNames()) != null) {
            object = new CopyPropertyGenerator(planarImage);
            int n = 0;
            while (n < ((String[])object2).length) {
                String string = object2[n].toLowerCase();
                if (!this.suppNames.contains(string)) {
                    this.propNames.put(string, object);
                }
                ++n;
            }
        }
        if (this.sourceForProp != null) {
            Enumeration enumeration = this.sourceForProp.keys();
            while (enumeration.hasMoreElements()) {
                object2 = ((String)enumeration.nextElement()).toLowerCase();
                object = (Integer)this.sourceForProp.get(object2);
                this.propNames.put(object2, object);
            }
        }
    }

    public void removePropertyGenerator(PropertyGenerator propertyGenerator) {
        if (this.pg != null && this.pg.contains(propertyGenerator)) {
            this.pg.removeElement(propertyGenerator);
        }
        this.hashNames();
    }

    private void removeSuppressedProps(PropertyGenerator propertyGenerator) {
        String[] stringArray = propertyGenerator.getPropertyNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].toLowerCase();
            if (this.suppNames.contains(string)) {
                this.suppNames.remove(string);
            }
            ++n;
        }
    }

    public void suppressProperty(String string) {
        this.suppNames.addElement(string.toLowerCase());
        this.hashNames();
    }
}

