/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.jdo.util.JDOUtils;
import org.castor.persist.ProposedEntity;
import org.castor.util.Messages;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLHelper;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class SQLStatementLoad {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$jdo$engine$SQLStatementLoad == null ? (class$org$exolab$castor$jdo$engine$SQLStatementLoad = SQLStatementLoad.class$("org.exolab.castor.jdo.engine.SQLStatementLoad")) : class$org$exolab$castor$jdo$engine$SQLStatementLoad));
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private final int _numberOfExtendLevels;
    private final Collection _extendingClassDescriptors;
    private String _statementNoLock;
    private String _statementLock;
    private QueryExpression _queryExpression;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$SQLStatementLoad;

    public SQLStatementLoad(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = engine.getDescriptor().getTableName();
        this._numberOfExtendLevels = SQLHelper.numberOfExtendingClassDescriptors(engine.getDescriptor());
        this._extendingClassDescriptors = engine.getDescriptor().getExtended();
        this.buildStatement();
    }

    private void buildStatement() throws MappingException {
        try {
            int i;
            QueryExpression expr = this._factory.getQueryExpression();
            HashMap<String, Boolean> identitiesUsedForTable = new HashMap<String, Boolean>();
            Vector<String> joinTables = new Vector<String>();
            JDOClassDescriptor curDesc = this._engine.getDescriptor();
            while (curDesc.getExtends() != null) {
                JDOClassDescriptor baseDesc = (JDOClassDescriptor)curDesc.getExtends();
                String[] curDescIdNames = SQLHelper.getIdentitySQLNames(curDesc);
                String[] baseDescIdNames = SQLHelper.getIdentitySQLNames(baseDesc);
                expr.addInnerJoin(curDesc.getTableName(), curDescIdNames, baseDesc.getTableName(), baseDescIdNames);
                joinTables.add(baseDesc.getTableName());
                curDesc = baseDesc;
            }
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            SQLFieldInfo[] fields = this._engine.getInfo();
            String aliasOld = null;
            String alias = null;
            for (int i2 = 0; i2 < fields.length; ++i2) {
                int j;
                JDOClassDescriptor classDescriptor;
                boolean isTableNameAlreadyAdded;
                SQLFieldInfo field = fields[i2];
                if (i2 > 0) {
                    aliasOld = alias;
                }
                alias = field.getTableName();
                if (i2 == 0 && field.isJoined()) {
                    String[] identities = SQLHelper.getIdentitySQLNames(this._engine.getDescriptor());
                    for (int j2 = 0; j2 < identities.length; ++j2) {
                        expr.addColumn(curDesc.getTableName(), identities[j2]);
                    }
                    identitiesUsedForTable.put(curDesc.getTableName(), Boolean.TRUE);
                }
                if (!(alias.equals(aliasOld) || field.isJoined() || (isTableNameAlreadyAdded = identitiesUsedForTable.containsKey((classDescriptor = (JDOClassDescriptor)field.getFieldDescriptor().getContainingClassDescriptor()).getTableName())))) {
                    String[] identities = SQLHelper.getIdentitySQLNames(classDescriptor);
                    for (j = 0; j < identities.length; ++j) {
                        expr.addColumn(alias, identities[j]);
                    }
                    identitiesUsedForTable.put(classDescriptor.getTableName(), Boolean.TRUE);
                }
                if (field.isJoined()) {
                    int offset = 0;
                    String[] rightCol = field.getJoinFields();
                    String[] leftCol = new String[ids.length - offset];
                    for (j = 0; j < leftCol.length; ++j) {
                        leftCol[j] = ids[j + offset].getName();
                    }
                    if (joinTables.contains(field.getTableName()) || this._engine.getDescriptor().getTableName().equals(field.getTableName())) {
                        alias = alias.replace('.', '_') + "_f" + i2;
                        expr.addOuterJoin(this._mapTo, leftCol, field.getTableName(), rightCol, alias);
                    } else {
                        expr.addOuterJoin(this._mapTo, leftCol, field.getTableName(), rightCol);
                        joinTables.add(field.getTableName());
                    }
                }
                for (int j3 = 0; j3 < field.getColumnInfo().length; ++j3) {
                    expr.addColumn(alias, field.getColumnInfo()[j3].getName());
                }
                expr.addTable(field.getTableName(), alias);
            }
            LinkedList classDescriptorsToAdd = new LinkedList();
            JDOClassDescriptor classDescriptor = null;
            SQLHelper.addExtendingClassDescriptors(classDescriptorsToAdd, this._engine.getDescriptor().getExtended());
            if (classDescriptorsToAdd.size() > 0) {
                Iterator iter = classDescriptorsToAdd.iterator();
                while (iter.hasNext()) {
                    Persistence persistenceEngine;
                    classDescriptor = (JDOClassDescriptor)iter.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Adding outer left join for " + classDescriptor.getJavaClass().getName() + " on table " + classDescriptor.getTableName()));
                    }
                    String[] engDescIdNames = SQLHelper.getIdentitySQLNames(this._engine.getDescriptor());
                    String[] clsDescIdNames = SQLHelper.getIdentitySQLNames(classDescriptor);
                    expr.addOuterJoin(this._mapTo, engDescIdNames, classDescriptor.getTableName(), clsDescIdNames);
                    try {
                        persistenceEngine = this._factory.getPersistence(classDescriptor);
                    }
                    catch (MappingException e) {
                        throw new QueryException("Problem obtaining persistence engine for ClassDescriptor " + classDescriptor.getJavaClass().getName(), e);
                    }
                    SQLColumnInfo[] idInfos = ((SQLEngine)persistenceEngine).getColumnInfoForIdentities();
                    for (int i3 = 0; i3 < idInfos.length; ++i3) {
                        expr.addColumn(classDescriptor.getTableName(), idInfos[i3].getName());
                    }
                    SQLFieldInfo[] fieldInfos = ((SQLEngine)persistenceEngine).getInfo();
                    for (int i4 = 0; i4 < fieldInfos.length; ++i4) {
                        boolean hasFieldToAdd = false;
                        SQLColumnInfo[] columnInfos = fieldInfos[i4].getColumnInfo();
                        if (classDescriptor.getTableName().equals(fieldInfos[i4].getTableName())) {
                            for (int j = 0; j < columnInfos.length; ++j) {
                                expr.addColumn(classDescriptor.getTableName(), fieldInfos[i4].getColumnInfo()[j].getName());
                            }
                            hasFieldToAdd = true;
                        }
                        if (!hasFieldToAdd) continue;
                        expr.addTable(classDescriptor.getTableName());
                    }
                }
            }
            QueryExpression find = (QueryExpression)expr.clone();
            for (i = 0; i < ids.length; ++i) {
                expr.addParameter(this._mapTo, ids[i].getName(), "=");
            }
            this._statementNoLock = expr.getStatement(false);
            this._statementLock = expr.getStatement(true);
            if (fields.length == 0) {
                for (i = 0; i < ids.length; ++i) {
                    find.addColumn(this._mapTo, ids[i].getName());
                }
            }
            this._queryExpression = find;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format("jdo.loading", this._type, this._statementNoLock));
                LOG.trace((Object)Messages.format("jdo.loading.with.lock", this._type, this._statementLock));
                LOG.trace((Object)Messages.format("jdo.finding", this._type, this._queryExpression));
            }
        }
        catch (QueryException ex) {
            LOG.warn((Object)"Problem building SQL", (Throwable)ex);
            throw new MappingException(ex);
        }
    }

    public String getLoadStatement() {
        return this._statementNoLock;
    }

    public QueryExpression getQueryExpression() {
        return (QueryExpression)this._queryExpression.clone();
    }

    public Object executeStatement(Connection conn, Identity identity, ProposedEntity entity, AccessMode accessMode) throws PersistenceException {
        int fieldIndex;
        SQLFieldInfo[] fields;
        SQLColumnInfo[] ids;
        ResultSet rs;
        PreparedStatement stmt;
        block27: {
            stmt = null;
            rs = null;
            ids = this._engine.getColumnInfoForIdentities();
            fields = this._engine.getInfo();
            String sqlString = accessMode == AccessMode.DbLocked ? this._statementLock : this._statementNoLock;
            stmt = conn.prepareStatement(sqlString);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format("jdo.loading", this._type, stmt.toString()));
            }
            fieldIndex = 1;
            if (identity.size() != ids.length) {
                throw new PersistenceException("Size of identity field mismatched! expected: " + ids.length + " found: " + identity.size());
            }
            for (int i = 0; i < ids.length; ++i) {
                stmt.setObject(fieldIndex++, ids[i].toSQL(identity.get(i)));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.format("jdo.loading", this._type, stmt.toString()));
            }
            if (!(rs = stmt.executeQuery()).next()) {
                throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", this._type, identity));
            }
            if (this._extendingClassDescriptors.size() <= 0) break block27;
            Object[] returnValues = SQLHelper.calculateNumberOfFields(this._extendingClassDescriptors, ids.length, fields.length, this._numberOfExtendLevels, rs);
            JDOClassDescriptor potentialLeafDescriptor = (JDOClassDescriptor)returnValues[0];
            if (potentialLeafDescriptor != null && !potentialLeafDescriptor.getJavaClass().getName().equals(this._type)) {
                entity.initializeFields(potentialLeafDescriptor.getFields().length);
                entity.setActualEntityClass(potentialLeafDescriptor.getJavaClass());
                entity.setExpanded(true);
            }
            if (potentialLeafDescriptor == null) break block27;
            Object var13_15 = null;
            JDOUtils.closeResultSet(rs);
            JDOUtils.closeStatement(stmt);
            return var13_15;
        }
        try {
            ArrayList res;
            boolean notNull;
            SQLColumnInfo[] columns;
            SQLFieldInfo field;
            int i;
            int columnIndex = ids.length + 1;
            HashSet<String> processedTables = new HashSet<String>();
            if (fields[0].isJoined()) {
                processedTables.add(this._engine.getDescriptor().getTableName());
            }
            fieldIndex = 1;
            String tableName = null;
            for (i = 0; i < fields.length; ++i) {
                field = fields[i];
                columns = field.getColumnInfo();
                tableName = field.getTableName();
                if (i > 0 && !field.isJoined() && !processedTables.contains(tableName)) {
                    columnIndex += ids.length;
                }
                processedTables.add(tableName);
                if (!field.isJoined() && field.getJoinFields() == null) {
                    entity.setField(columns[0].toJava(SQLTypeInfos.getValue(rs, columnIndex++, columns[0].getSqlType())), i);
                    ++fieldIndex;
                    continue;
                }
                if (!field.isMulti()) {
                    notNull = false;
                    Object[] id = new Object[columns.length];
                    for (int j = 0; j < columns.length; ++j) {
                        id[j] = columns[j].toJava(SQLTypeInfos.getValue(rs, columnIndex++, columns[j].getSqlType()));
                        ++fieldIndex;
                        if (id[j] == null) continue;
                        notNull = true;
                    }
                    entity.setField(notNull ? new Identity(id) : null, i);
                    continue;
                }
                res = new ArrayList();
                notNull = false;
                Object[] id = new Object[columns.length];
                for (int j = 0; j < columns.length; ++j) {
                    id[j] = columns[j].toJava(SQLTypeInfos.getValue(rs, columnIndex, columns[j].getSqlType()));
                    if (id[j] != null) {
                        notNull = true;
                    }
                    ++fieldIndex;
                    ++columnIndex;
                }
                if (notNull) {
                    res.add(new Identity(id));
                }
                entity.setField(res, i);
            }
            while (rs.next()) {
                fieldIndex = 1;
                columnIndex = ids.length + 1;
                processedTables.clear();
                if (fields[0].isJoined()) {
                    processedTables.add(this._engine.getDescriptor().getTableName());
                }
                for (i = 0; i < fields.length; ++i) {
                    field = fields[i];
                    columns = field.getColumnInfo();
                    tableName = field.getTableName();
                    if (i > 0 && !field.isJoined() && !processedTables.contains(tableName)) {
                        columnIndex += ids.length;
                    }
                    processedTables.add(tableName);
                    if (field.isMulti()) {
                        Identity com;
                        res = (ArrayList)entity.getField(i);
                        notNull = false;
                        Object[] id = new Object[columns.length];
                        for (int j = 0; j < columns.length; ++j) {
                            id[j] = columns[j].toJava(SQLTypeInfos.getValue(rs, columnIndex, columns[j].getSqlType()));
                            if (id[j] != null) {
                                notNull = true;
                            }
                            ++columnIndex;
                        }
                        ++fieldIndex;
                        if (!notNull || res.contains(com = new Identity(id))) continue;
                        res.add(com);
                        continue;
                    }
                    ++fieldIndex;
                    columnIndex += columns.length;
                }
            }
        }
        catch (SQLException except) {
            try {
                LOG.fatal((Object)Messages.format("jdo.loadFatal", this._type, accessMode == AccessMode.DbLocked ? this._statementLock : this._statementNoLock), (Throwable)except);
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
            catch (Throwable throwable) {
                JDOUtils.closeResultSet(rs);
                JDOUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JDOUtils.closeResultSet(rs);
        JDOUtils.closeStatement(stmt);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

