/*
 * Decompiled with CFR 0.152.
 */
package ejbsplus;

import com.insightful.splus.ClientObjectFactory;
import com.insightful.splus.ClientObjectFactoryImpl;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusLogin;
import com.insightful.splus.SplusSession;
import ejbsplus.SplusEngineClient;
import ejbsplus.SplusEngineException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class SplusEngineEJB
implements SessionBean {
    private String shome = null;
    private SplusSession session = null;
    private SplusEngineClient client = null;
    private String m_host = null;
    private String m_username = null;
    private String m_password = null;
    private int m_rmiPort = 1099;
    private String m_workingDirectory = "";
    private String m_xDisplay = "";
    private String m_prompt = "";
    private String m_script = "";
    private SessionContext context;

    public void setSessionContext(SessionContext sessionContext) {
        this.context = sessionContext;
    }

    public void ejbPassivate() {
        this.hangup();
    }

    public void ejbActivate() {
    }

    public void ejbCreate() throws RemoteException, CreateException, SplusEngineException {
        try {
            this.shome = System.getProperty("splus.shome", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SplusEngineException("Bad security when getting \"splus.shome\"!");
        }
        if (this.shome.length() == 0) {
            throw new SplusEngineException("Property \"splus.shome\" must be set on server!");
        }
        System.setProperty("splus.client.mode", "true");
    }

    public void ejbRemove() {
        this.hangup();
    }

    private void connect() throws SplusEngineException {
        if (this.session != null) {
            return;
        }
        if (this.m_username == null) {
            try {
                String[] stringArray = this.client.getLoginData();
                this.m_host = stringArray[0];
                this.m_username = stringArray[1];
                this.m_password = stringArray[2];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SplusEngineException(exception.getMessage());
            }
        }
        if (this.m_host == null || this.m_host.length() == 0 || this.m_username == null || this.m_username.length() == 0 || this.m_password == null || this.m_password.length() == 0) {
            throw new SplusEngineException("Login cancelled");
        }
        try {
            int n = this.m_host.indexOf(":");
            if (n > -1) {
                this.m_rmiPort = Integer.decode(this.m_host.substring(n + 1));
                this.m_host = this.m_host.substring(0, n);
            }
            SplusLogin splusLogin = new SplusLogin();
            this.session = splusLogin.newSession(this.m_host, this.m_username, this.m_password, this.m_rmiPort, this.m_workingDirectory, this.m_xDisplay, this.m_prompt, this.m_script, new String[0]);
        }
        catch (Exception exception) {
            throw new SplusEngineException(exception.getMessage());
        }
        try {
            this.session.setClientObjectFactory((ClientObjectFactory)new ClientObjectFactoryImpl());
        }
        catch (Exception exception) {
            throw new SplusEngineException(exception.getMessage());
        }
    }

    private void hangup() {
        if (this.session != null) {
            try {
                this.session.sessionExit(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.session = null;
        }
    }

    private void reconnect() throws SplusEngineException {
        this.hangup();
        this.connect();
    }

    private SplusSession getSession() throws SplusEngineException {
        if (this.session == null) {
            this.connect();
        }
        return this.session;
    }

    public SplusDataResult eval(String string, SplusEngineClient splusEngineClient) throws RemoteException, SplusEngineException {
        this.client = splusEngineClient;
        SplusDataResult splusDataResult = null;
        try {
            splusDataResult = this.getSession().evalDataQuery(string, true, true, true, true, true, 2, true, true);
        }
        catch (Exception exception) {
            if (exception.getMessage().equals("Login cancelled")) {
                System.out.println("S-PLUS login cancelled");
            }
            exception.printStackTrace();
        }
        return splusDataResult;
    }
}

