/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.util.Map;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaObjectRetrievalFailureException;
import org.springframework.orm.jpa.JpaOptimisticLockingFailureException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class EntityManagerFactoryUtils {
    public static final int ENTITY_MANAGER_SYNCHRONIZATION_ORDER = 900;
    private static final Log logger = LogFactory.getLog(EntityManagerFactoryUtils.class);

    public static EntityManager getTransactionalEntityManager(EntityManagerFactory emf) throws DataAccessResourceFailureException {
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, null);
    }

    public static EntityManager getTransactionalEntityManager(EntityManagerFactory emf, Map properties) throws DataAccessResourceFailureException {
        try {
            return EntityManagerFactoryUtils.doGetTransactionalEntityManager(emf, properties);
        }
        catch (PersistenceException ex) {
            throw new DataAccessResourceFailureException("Could not obtain JPA EntityManager", ex);
        }
    }

    public static EntityManager doGetTransactionalEntityManager(EntityManagerFactory emf, Map properties) throws PersistenceException {
        EntityManager em;
        Assert.notNull(emf, "No EntityManagerFactory specified");
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(emf);
        if (emHolder != null) {
            if (!emHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                try {
                    emHolder.getEntityManager().joinTransaction();
                }
                catch (TransactionRequiredException ex) {
                    logger.debug((Object)"Could not join JTA transaction because none was active", (Throwable)ex);
                }
                emHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.registerSynchronization(new EntityManagerSynchronization(emHolder, emf, false));
            }
            return emHolder.getEntityManager();
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        logger.debug((Object)"Opening JPA EntityManager");
        EntityManager entityManager = em = !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for JPA EntityManager");
            emHolder = new EntityManagerHolder(em);
            emHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization(new EntityManagerSynchronization(emHolder, emf, true));
            TransactionSynchronizationManager.bindResource(emf, emHolder);
        }
        return em;
    }

    public static DataAccessException convertJpaAccessExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof IllegalStateException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof IllegalArgumentException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof EntityNotFoundException) {
            return new JpaObjectRetrievalFailureException((EntityNotFoundException)ex);
        }
        if (ex instanceof NoResultException) {
            return new EmptyResultDataAccessException(ex.getMessage(), 1);
        }
        if (ex instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1);
        }
        if (ex instanceof OptimisticLockException) {
            return new JpaOptimisticLockingFailureException((OptimisticLockException)ex);
        }
        if (ex instanceof EntityExistsException) {
            return new DataIntegrityViolationException(ex.getMessage(), ex);
        }
        if (ex instanceof TransactionRequiredException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), ex);
        }
        if (ex instanceof PersistenceException) {
            return new JpaSystemException((PersistenceException)((Object)ex));
        }
        return null;
    }

    private static class EntityManagerSynchronization
    extends TransactionSynchronizationAdapter {
        private final EntityManagerHolder entityManagerHolder;
        private final EntityManagerFactory entityManagerFactory;
        private final boolean newEntityManager;
        private boolean holderActive = true;

        public EntityManagerSynchronization(EntityManagerHolder emHolder, EntityManagerFactory emf, boolean newEntityManager) {
            this.entityManagerHolder = emHolder;
            this.entityManagerFactory = emf;
            this.newEntityManager = newEntityManager;
        }

        public int getOrder() {
            return 900;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.entityManagerFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.entityManagerFactory, this.entityManagerHolder);
            }
        }

        public void beforeCompletion() {
            if (this.newEntityManager) {
                TransactionSynchronizationManager.unbindResource(this.entityManagerFactory);
                this.holderActive = false;
                this.entityManagerHolder.getEntityManager().close();
            }
        }

        public void afterCompletion(int status) {
            this.entityManagerHolder.setSynchronizedWithTransaction(false);
        }
    }
}

