/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.ExtensionHandlerJava;
import org.apache.xalan.extensions.ExtensionHandlerJavaClass;
import org.apache.xalan.extensions.ExtensionHandlerJavaPackage;
import org.apache.xpath.XPathProcessorException;

public class ExtensionsTable {
    public Hashtable m_extensionFunctionNamespaces = new Hashtable();

    public ExtensionsTable() {
        String uri = "http://xml.apache.org/xslt/java";
        ExtensionHandlerJava fh = new ExtensionHandlerJavaPackage(uri, "xslt-javaclass", "");
        this.addExtensionNamespace(uri, fh);
        uri = "http://xsl.lotus.com/java";
        this.addExtensionNamespace(uri, fh);
        uri = "http://xml.apache.org/xalan";
        fh = new ExtensionHandlerJavaClass(uri, "javaclass", "org.apache.xalan.lib.Extensions");
        this.addExtensionNamespace(uri, fh);
    }

    public void addExtensionNamespace(String uri, ExtensionHandler extNS) {
        this.m_extensionFunctionNamespaces.put(uri, extNS);
    }

    public boolean elementAvailable(String ns, String elemName) throws TransformerException {
        boolean isAvailable = false;
        if (ns != null) {
            ExtensionHandler extNS = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(ns);
            if (extNS == null) {
                extNS = this.makeJavaNamespace(ns);
                this.addExtensionNamespace(ns, extNS);
            }
            if (extNS != null) {
                isAvailable = extNS.isElementAvailable(elemName);
            }
        }
        return isAvailable;
    }

    public Object extFunction(String ns, String funcName, Vector argVec, Object methodKey, ExpressionContext exprContext) throws TransformerException {
        Object result = null;
        if (ns != null) {
            ExtensionHandler extNS = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(ns);
            if (extNS == null) {
                extNS = this.makeJavaNamespace(ns);
                this.addExtensionNamespace(ns, extNS);
            }
            if (extNS != null) {
                try {
                    result = extNS.callFunction(funcName, argVec, methodKey, exprContext);
                }
                catch (TransformerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new TransformerException(e);
                }
            } else {
                throw new XPathProcessorException("Extension function '" + ns + ":" + funcName + "' is unknown");
            }
        }
        return result;
    }

    public boolean functionAvailable(String ns, String funcName) throws TransformerException {
        boolean isAvailable = false;
        if (ns != null) {
            ExtensionHandler extNS = (ExtensionHandler)this.m_extensionFunctionNamespaces.get(ns);
            if (extNS == null) {
                extNS = this.makeJavaNamespace(ns);
                this.addExtensionNamespace(ns, extNS);
            }
            if (extNS != null) {
                isAvailable = extNS.isFunctionAvailable(funcName);
            }
        }
        return isAvailable;
    }

    public ExtensionHandler get(String extns) {
        return (ExtensionHandler)this.m_extensionFunctionNamespaces.get(extns);
    }

    public ExtensionHandler makeJavaNamespace(String ns) throws TransformerException {
        int lastSlash;
        if (ns == null || ns.trim().length() == 0) {
            return null;
        }
        String className = ns;
        if (className.startsWith("class:")) {
            className = className.substring(6);
        }
        if ((lastSlash = className.lastIndexOf("/")) != -1) {
            className = className.substring(lastSlash + 1);
        }
        if (className == null || className.trim().length() == 0) {
            return null;
        }
        try {
            ExtensionHandler.getClassForName(className);
            return new ExtensionHandlerJavaClass(ns, "javaclass", className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new ExtensionHandlerJavaPackage(ns, "javapackage", String.valueOf(className) + ".");
        }
    }
}

