/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.opimage.StreamRIF;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedImageAdapter;

public class FileLoadRIF
implements RenderedImageFactory {
    private static final StreamRIF streamRIF = new StreamRIF();

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        try {
            String string = (String)parameterBlock.getObjectParameter(0);
            FileSeekableStream fileSeekableStream = new FileSeekableStream(string);
            ImageDecodeParam imageDecodeParam = null;
            if (parameterBlock.getNumParameters() > 1) {
                imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
            }
            ParameterBlock parameterBlock2 = new ParameterBlock();
            parameterBlock2.add(fileSeekableStream);
            parameterBlock2.add(imageDecodeParam);
            RenderingHints.Key key = JAI.KEY_OPERATION_BOUND;
            int n = 2;
            if (renderingHints == null) {
                renderingHints = new RenderingHints(key, new Integer(n));
            } else if (!renderingHints.containsKey(key)) {
                renderingHints.put(key, new Integer(n));
            }
            RenderedImage renderedImage = streamRIF.create(parameterBlock2, renderingHints);
            return renderedImage == null ? null : new FileLoadImage(renderedImage, (InputStream)fileSeekableStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private class FileLoadImage
    extends RenderedImageAdapter {
        private InputStream stream;

        public FileLoadImage(RenderedImage renderedImage, InputStream inputStream) {
            super(renderedImage);
            this.stream = inputStream;
        }

        protected void finalize() throws Throwable {
            this.stream.close();
            super.finalize();
        }
    }
}

