/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

public class ReaderWriterLock {
    protected int numActiveReaders = 0;
    protected int numWaitingReaders = 0;
    protected int numWaitingWriters = 0;
    protected boolean activeWriter = false;

    boolean allowReaderIn() {
        return this.numWaitingWriters == 0 && !this.activeWriter;
    }

    boolean allowWriterIn() {
        return this.numActiveReaders == 0 && !this.activeWriter;
    }

    public synchronized void getReadLock() {
        ++this.numWaitingReaders;
        while (!this.allowReaderIn()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.numWaitingReaders;
        ++this.numActiveReaders;
    }

    public synchronized void getWriteLock() {
        ++this.numWaitingWriters;
        while (!this.allowWriterIn()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        --this.numWaitingWriters;
        this.activeWriter = true;
    }

    public synchronized void releaseReadLock() {
        --this.numActiveReaders;
        this.notifyAll();
    }

    public synchronized void releaseWriteLock() {
        this.activeWriter = false;
        this.notifyAll();
    }
}

