/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.tools.jpeg;

import java.awt.Image;
import java.awt.image.PixelGrabber;

class JpegInfo {
    static int PRECISION = 8;
    static int[] COMP_ID = new int[]{1, 2, 3};
    static int[] H_SAMP_FACTOR = new int[]{1, 1, 1};
    static int[] V_SAMP_FACTOR = new int[]{1, 1, 1};
    static int[] Q_TABLE_NUMBER = new int[]{0, 1, 1};
    static int[] D_C_TABLE_NUMBER = new int[]{0, 1, 1};
    static int[] A_C_TABLE_NUMBER = new int[]{0, 1, 1};
    static int ss = 0;
    static int se = 63;
    static int ah = 0;
    static int al = 0;
    private String comment;
    private int imageHeight;
    private int imageWidth;
    private int[] blockWidth;
    private int[] blockHeight;
    private Image imageObj = null;
    private int numberOfComponents = 3;
    private Object[] components = null;
    private int[] compWidth = null;
    private int[] compHeight = null;
    private int maxHsampFactor;
    private int maxVsampFactor;
    private boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
    private boolean[] lastRowIsDummy = new boolean[]{false, false, false};

    JpegInfo(Image image) {
        this.imageObj = image;
        this.components = new Object[this.numberOfComponents];
        this.compWidth = new int[this.numberOfComponents];
        this.compHeight = new int[this.numberOfComponents];
        this.blockWidth = new int[this.numberOfComponents];
        this.blockHeight = new int[this.numberOfComponents];
        this.imageWidth = image.getWidth(null);
        this.imageHeight = image.getHeight(null);
        this.comment = "JPEG Encoder, skynamics AG, Munich";
        this.getYCCArray();
    }

    public void dispose() {
        this.comment = null;
        this.blockWidth = null;
        this.blockHeight = null;
        this.imageObj = null;
        this.components = null;
        this.compWidth = null;
        this.compHeight = null;
    }

    void setComment(String string) {
        this.comment.concat(string);
    }

    String getComment() {
        return this.comment;
    }

    int getImageHeight() {
        return this.imageHeight;
    }

    int getImageWidth() {
        return this.imageWidth;
    }

    int getBlockWidth(int n) {
        return this.blockWidth[n];
    }

    int getBlockHeight(int n) {
        return this.blockHeight[n];
    }

    int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    Object getComponent(int n) {
        return this.components[n];
    }

    public boolean isLastColumnDummy(int n) {
        return this.lastColumnIsDummy[n];
    }

    public boolean isLastRowDummy(int n) {
        return this.lastRowIsDummy[n];
    }

    private void getYCCArray() {
        int[] nArray = new int[this.imageWidth * this.imageHeight];
        PixelGrabber pixelGrabber = new PixelGrabber(this.imageObj.getSource(), 0, 0, this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth);
        this.maxHsampFactor = 1;
        this.maxVsampFactor = 1;
        int n = 0;
        while (n < this.numberOfComponents) {
            this.maxHsampFactor = Math.max(this.maxHsampFactor, H_SAMP_FACTOR[n]);
            this.maxVsampFactor = Math.max(this.maxVsampFactor, V_SAMP_FACTOR[n]);
            ++n;
        }
        n = 0;
        while (n < this.numberOfComponents) {
            this.compWidth[n] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.maxHsampFactor * H_SAMP_FACTOR[n];
            if (this.compWidth[n] != this.imageWidth / this.maxHsampFactor * H_SAMP_FACTOR[n]) {
                this.lastColumnIsDummy[n] = true;
            }
            this.blockWidth[n] = (int)Math.ceil((double)this.compWidth[n] / 8.0);
            this.compHeight[n] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.maxVsampFactor * V_SAMP_FACTOR[n];
            if (this.compHeight[n] != this.imageHeight / this.maxVsampFactor * V_SAMP_FACTOR[n]) {
                this.lastRowIsDummy[n] = true;
            }
            this.blockHeight[n] = (int)Math.ceil((double)this.compHeight[n] / 8.0);
            ++n;
        }
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error: " + interruptedException.getMessage());
        }
        float[][] fArray = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] fArray2 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] fArray3 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] fArray4 = new float[this.compHeight[1]][this.compWidth[1]];
        float[][] fArray5 = new float[this.compHeight[2]][this.compWidth[2]];
        int n2 = 0;
        n = 0;
        while (n < this.imageHeight) {
            int n3 = 0;
            while (n3 < this.imageWidth) {
                int n4 = nArray[n2] >> 16 & 0xFF;
                int n5 = nArray[n2] >> 8 & 0xFF;
                int n6 = nArray[n2] & 0xFF;
                fArray[n][n3] = (float)(0.299 * (double)n4 + 0.587 * (double)n5 + 0.114 * (double)n6);
                fArray3[n][n3] = 128.0f + (float)(-0.16874 * (double)n4 - 0.33126 * (double)n5 + 0.5 * (double)n6);
                fArray2[n][n3] = 128.0f + (float)(0.5 * (double)n4 - 0.41869 * (double)n5 - 0.08131 * (double)n6);
                ++n2;
                ++n3;
            }
            ++n;
        }
        this.components[0] = fArray;
        this.components[1] = fArray3;
        this.components[2] = fArray2;
    }
}

