/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.PNGSuggestedPaletteEntry;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Date;
import java.util.Vector;

public abstract class PNGEncodeParam
implements ImageEncodeParam {
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE = 3;
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    protected int bitDepth;
    protected boolean bitDepthSet = false;
    private boolean useInterlacing = false;
    private float[] chromaticity = null;
    private boolean chromaticitySet = false;
    private float gamma;
    private boolean gammaSet = false;
    private int[] paletteHistogram = null;
    private boolean paletteHistogramSet = false;
    private byte[] ICCProfileData = null;
    private boolean ICCProfileDataSet = false;
    private int[] physicalDimension = null;
    private boolean physicalDimensionSet = false;
    private PNGSuggestedPaletteEntry[] suggestedPalette = null;
    private boolean suggestedPaletteSet = false;
    private int[] significantBits = null;
    private boolean significantBitsSet = false;
    private int SRGBIntent;
    private boolean SRGBIntentSet = false;
    private String[] text = null;
    private boolean textSet = false;
    private Date modificationTime;
    private boolean modificationTimeSet = false;
    boolean transparencySet = false;
    private String[] zText = null;
    private boolean zTextSet = false;
    Vector chunkType = new Vector();
    Vector chunkData = new Vector();

    private static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public synchronized void addPrivateChunk(String string, byte[] byArray) {
        this.chunkType.add(string);
        this.chunkData.add((byte[])byArray.clone());
    }

    public int filterRow(byte[] byArray, byte[] byArray2, byte[][] byArray3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int[] nArray = new int[5];
        int n12 = 0;
        while (n12 < 5) {
            nArray[n12] = Integer.MAX_VALUE;
            ++n12;
        }
        int n13 = 0;
        int n14 = n2;
        while (n14 < n + n2) {
            int n15 = byArray[n14] & 0xFF;
            n13 += n15;
            ++n14;
        }
        nArray[0] = n13;
        byte[] byArray4 = byArray3[1];
        int n16 = 0;
        int n17 = n2;
        while (n17 < n + n2) {
            int n18 = byArray[n17] & 0xFF;
            n11 = byArray[n17 - n2] & 0xFF;
            n10 = n18 - n11;
            byArray4[n17] = (byte)n10;
            n16 += PNGEncodeParam.abs(n10);
            ++n17;
        }
        nArray[1] = n16;
        byte[] byArray5 = byArray3[2];
        n11 = 0;
        n10 = n2;
        while (n10 < n + n2) {
            int n19 = byArray[n10] & 0xFF;
            n9 = byArray2[n10] & 0xFF;
            n8 = n19 - n9;
            byArray5[n10] = (byte)n8;
            n11 += PNGEncodeParam.abs(n8);
            ++n10;
        }
        nArray[2] = n11;
        byte[] byArray6 = byArray3[3];
        n9 = 0;
        n8 = n2;
        while (n8 < n + n2) {
            int n20 = byArray[n8] & 0xFF;
            n7 = byArray[n8 - n2] & 0xFF;
            n6 = byArray2[n8] & 0xFF;
            n5 = n20 - (n7 + n6) / 2;
            byArray6[n8] = (byte)n5;
            n9 += PNGEncodeParam.abs(n5);
            ++n8;
        }
        nArray[3] = n9;
        byte[] byArray7 = byArray3[4];
        n7 = 0;
        n6 = n2;
        while (n6 < n + n2) {
            n5 = byArray[n6] & 0xFF;
            n4 = byArray[n6 - n2] & 0xFF;
            n3 = byArray2[n6] & 0xFF;
            int n21 = byArray2[n6 - n2] & 0xFF;
            int n22 = PNGEncodeParam.paethPredictor(n4, n3, n21);
            int n23 = n5 - n22;
            byArray7[n6] = (byte)n23;
            n7 += PNGEncodeParam.abs(n23);
            ++n6;
        }
        nArray[4] = n7;
        n5 = 0;
        n4 = nArray[0];
        n3 = 1;
        while (n3 < 5) {
            if (nArray[n3] < n4) {
                n4 = nArray[n3];
                n5 = n3;
            }
            ++n3;
        }
        if (n5 == 0) {
            System.arraycopy(byArray, n2, byArray3[0], n2, n);
        }
        return n5;
    }

    public int getBitDepth() {
        if (!this.bitDepthSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam11"));
        }
        return this.bitDepth;
    }

    public float[] getChromaticity() {
        if (!this.chromaticitySet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam12"));
        }
        return (float[])this.chromaticity.clone();
    }

    public String[] getCompressedText() {
        if (!this.zTextSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam22"));
        }
        return this.zText;
    }

    public static PNGEncodeParam getDefaultEncodeParam(RenderedImage renderedImage) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return new Palette();
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        if (n == 1 || n == 2) {
            return new Gray();
        }
        return new RGB();
    }

    public float getGamma() {
        if (!this.gammaSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam13"));
        }
        return this.gamma;
    }

    public byte[] getICCProfileData() {
        if (!this.ICCProfileDataSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam15"));
        }
        return (byte[])this.ICCProfileData.clone();
    }

    public boolean getInterlacing() {
        return this.useInterlacing;
    }

    public Date getModificationTime() {
        if (!this.modificationTimeSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam21"));
        }
        return this.modificationTime;
    }

    public synchronized int getNumPrivateChunks() {
        return this.chunkType.size();
    }

    public int[] getPaletteHistogram() {
        if (!this.paletteHistogramSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam14"));
        }
        return this.paletteHistogram;
    }

    public int[] getPhysicalDimension() {
        if (!this.physicalDimensionSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam16"));
        }
        return (int[])this.physicalDimension.clone();
    }

    public synchronized byte[] getPrivateChunkData(int n) {
        return (byte[])this.chunkData.elementAt(n);
    }

    public synchronized String getPrivateChunkType(int n) {
        return (String)this.chunkType.elementAt(n);
    }

    public int getSRGBIntent() {
        if (!this.SRGBIntentSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam19"));
        }
        return this.SRGBIntent;
    }

    public int[] getSignificantBits() {
        if (!this.significantBitsSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam18"));
        }
        return (int[])this.significantBits.clone();
    }

    public PNGSuggestedPaletteEntry[] getSuggestedPalette() {
        if (!this.suggestedPaletteSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam17"));
        }
        return (PNGSuggestedPaletteEntry[])this.suggestedPalette.clone();
    }

    public String[] getText() {
        if (!this.textSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam20"));
        }
        return this.text;
    }

    public boolean isBackgroundSet() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam24"));
    }

    public boolean isChromaticitySet() {
        return this.chromaticitySet;
    }

    public boolean isCompressedTextSet() {
        return this.zTextSet;
    }

    public boolean isGammaSet() {
        return this.gammaSet;
    }

    public boolean isICCProfileDataSet() {
        return this.ICCProfileDataSet;
    }

    public boolean isModificationTimeSet() {
        return this.modificationTimeSet;
    }

    public boolean isPaletteHistogramSet() {
        return this.paletteHistogramSet;
    }

    public boolean isPhysicalDimensionSet() {
        return this.physicalDimensionSet;
    }

    public boolean isSRGBIntentSet() {
        return this.SRGBIntentSet;
    }

    public boolean isSignificantBitsSet() {
        return this.significantBitsSet;
    }

    public boolean isSuggestedPaletteSet() {
        return this.suggestedPaletteSet;
    }

    public boolean isTextSet() {
        return this.textSet;
    }

    public boolean isTransparencySet() {
        return this.transparencySet;
    }

    public static final int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = PNGEncodeParam.abs(n4 - n);
        int n6 = PNGEncodeParam.abs(n4 - n2);
        int n7 = PNGEncodeParam.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    public synchronized void removeAllPrivateChunks() {
        this.chunkType = new Vector();
        this.chunkData = new Vector();
    }

    public synchronized void removeUnsafeToCopyPrivateChunks() {
        Vector<String> vector = new Vector<String>();
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n = this.getNumPrivateChunks();
        int n2 = 0;
        while (n2 < n) {
            String string = this.getPrivateChunkType(n2);
            char c = string.charAt(3);
            if (c >= 'a' && c <= 'z') {
                vector.add(string);
                vector2.add(this.getPrivateChunkData(n2));
            }
            ++n2;
        }
        this.chunkType = vector;
        this.chunkData = vector2;
    }

    public abstract void setBitDepth(int var1);

    public void setChromaticity(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float[] fArray = new float[]{f, f2, f3, f4, f5, f6, f7, f8};
        this.setChromaticity(fArray);
    }

    public void setChromaticity(float[] fArray) {
        if (fArray.length != 8) {
            throw new IllegalArgumentException();
        }
        this.chromaticity = (float[])fArray.clone();
        this.chromaticitySet = true;
    }

    public void setCompressedText(String[] stringArray) {
        this.zText = stringArray;
        this.zTextSet = true;
    }

    public void setGamma(float f) {
        this.gamma = f;
        this.gammaSet = true;
    }

    public void setICCProfileData(byte[] byArray) {
        this.ICCProfileData = (byte[])byArray.clone();
        this.ICCProfileDataSet = true;
    }

    public void setInterlacing(boolean bl) {
        this.useInterlacing = bl;
    }

    public void setModificationTime(Date date) {
        this.modificationTime = date;
        this.modificationTimeSet = true;
    }

    public void setPaletteHistogram(int[] nArray) {
        this.paletteHistogram = (int[])nArray.clone();
        this.paletteHistogramSet = true;
    }

    public void setPhysicalDimension(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        this.setPhysicalDimension(nArray);
    }

    public void setPhysicalDimension(int[] nArray) {
        this.physicalDimension = (int[])nArray.clone();
        this.physicalDimensionSet = true;
    }

    public void setSRGBIntent(int n) {
        this.SRGBIntent = n;
        this.SRGBIntentSet = true;
    }

    public void setSignificantBits(int[] nArray) {
        this.significantBits = (int[])nArray.clone();
        this.significantBitsSet = true;
    }

    public void setSuggestedPalette(PNGSuggestedPaletteEntry[] pNGSuggestedPaletteEntryArray) {
        this.suggestedPalette = (PNGSuggestedPaletteEntry[])pNGSuggestedPaletteEntryArray.clone();
        this.suggestedPaletteSet = true;
    }

    public void setText(String[] stringArray) {
        this.text = stringArray;
        this.textSet = true;
    }

    public void unsetBackground() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam23"));
    }

    public void unsetBitDepth() {
        this.bitDepthSet = false;
    }

    public void unsetChromaticity() {
        this.chromaticity = null;
        this.chromaticitySet = false;
    }

    public void unsetCompressedText() {
        this.zText = null;
        this.zTextSet = false;
    }

    public void unsetGamma() {
        this.gammaSet = false;
    }

    public void unsetICCProfileData() {
        this.ICCProfileData = null;
        this.ICCProfileDataSet = false;
    }

    public void unsetModificationTime() {
        this.modificationTime = null;
        this.modificationTimeSet = false;
    }

    public void unsetPaletteHistogram() {
        this.paletteHistogram = null;
        this.paletteHistogramSet = false;
    }

    public void unsetPhysicalDimension() {
        this.physicalDimension = null;
        this.physicalDimensionSet = false;
    }

    public void unsetSRGBIntent() {
        this.SRGBIntentSet = false;
    }

    public void unsetSignificantBits() {
        this.significantBits = null;
        this.significantBitsSet = false;
    }

    public void unsetSuggestedPalette() {
        this.suggestedPalette = null;
        this.suggestedPaletteSet = false;
    }

    public void unsetText() {
        this.text = null;
        this.textSet = false;
    }

    public void unsetTransparency() {
        this.transparencySet = false;
    }

    public static class Palette
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int[] palette = null;
        private boolean paletteSet = false;
        private int backgroundPaletteIndex;
        private int[] transparency;

        public int getBackgroundPaletteIndex() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam4"));
            }
            return this.backgroundPaletteIndex;
        }

        public int[] getPalette() {
            if (!this.paletteSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam3"));
            }
            return (int[])this.palette.clone();
        }

        public byte[] getPaletteTransparency() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam5"));
            }
            byte[] byArray = new byte[this.transparency.length];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = (byte)this.transparency[n];
                ++n;
            }
            return byArray;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public boolean isPaletteSet() {
            return this.paletteSet;
        }

        public void setBackgroundPaletteIndex(int n) {
            this.backgroundPaletteIndex = n;
            this.backgroundSet = true;
        }

        public void setBitDepth(int n) {
            if (n != 1 && n != 2 && n != 4 && n != 8) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam2"));
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setPalette(int[] nArray) {
            if (nArray.length < 3 || nArray.length > 768) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam0"));
            }
            if (nArray.length % 3 != 0) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam1"));
            }
            this.palette = (int[])nArray.clone();
            this.paletteSet = true;
        }

        public void setPaletteTransparency(byte[] byArray) {
            this.transparency = new int[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                this.transparency[n] = byArray[n] & 0xFF;
                ++n;
            }
            this.transparencySet = true;
        }

        public void unsetBackground() {
            this.backgroundSet = false;
        }

        public void unsetPalette() {
            this.palette = null;
            this.paletteSet = false;
        }
    }

    public static class Gray
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int backgroundPaletteGray;
        private int[] transparency;
        private int bitShift;
        private boolean bitShiftSet = false;

        public int getBackgroundGray() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam6"));
            }
            return this.backgroundPaletteGray;
        }

        public int getBitShift() {
            if (!this.bitShiftSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam8"));
            }
            return this.bitShift;
        }

        public int getTransparentGray() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam7"));
            }
            int n = this.transparency[0];
            return n;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public boolean isBitDepthSet() {
            return this.bitDepthSet;
        }

        public boolean isBitShiftSet() {
            return this.bitShiftSet;
        }

        public void setBackgroundGray(int n) {
            this.backgroundPaletteGray = n;
            this.backgroundSet = true;
        }

        public void setBitDepth(int n) {
            if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
                throw new IllegalArgumentException();
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setBitShift(int n) {
            if (n < 0) {
                throw new RuntimeException();
            }
            this.bitShift = n;
            this.bitShiftSet = true;
        }

        public void setTransparentGray(int n) {
            this.transparency = new int[1];
            this.transparency[0] = n;
            this.transparencySet = true;
        }

        public void unsetBackground() {
            this.backgroundSet = false;
        }

        public void unsetBitShift() {
            this.bitShiftSet = false;
        }
    }

    public static class RGB
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int[] backgroundRGB;
        private int[] transparency;

        public int[] getBackgroundRGB() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam9"));
            }
            return this.backgroundRGB;
        }

        public int[] getTransparentRGB() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam10"));
            }
            return (int[])this.transparency.clone();
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public void setBackgroundRGB(int[] nArray) {
            if (nArray.length != 3) {
                throw new RuntimeException();
            }
            this.backgroundRGB = nArray;
            this.backgroundSet = true;
        }

        public void setBitDepth(int n) {
            if (n != 8 && n != 16) {
                throw new RuntimeException();
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setTransparentRGB(int[] nArray) {
            this.transparency = (int[])nArray.clone();
            this.transparencySet = true;
        }

        public void unsetBackground() {
            this.backgroundSet = false;
        }
    }
}

