/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jfor.jfor.interfaces.ITableColumnsInfo;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfElement;
import org.jfor.jfor.rtflib.rtfdoc.RtfTable;
import org.jfor.jfor.rtflib.rtfdoc.RtfTableCell;
import org.jfor.jfor.rtflib.rtfdoc.RtfTableRow;

public class RtfExtraRowSet
extends RtfContainer {
    final int DEFAULT_IDNUM = 0;
    private ITableColumnsInfo parentITableColumnsInfo = null;
    private final List m_cells = new LinkedList();
    private int m_maxRowIndex;

    RtfExtraRowSet(Writer writer) throws IOException {
        super(null, writer);
    }

    int addTable(RtfTable rtfTable, int n, int n2) {
        Iterator iterator = rtfTable.getChildren().iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            if (!(rtfElement instanceof RtfTableRow)) continue;
            this.addRow((RtfTableRow)rtfElement, n, n2);
            this.m_maxRowIndex = Math.max(++n, this.m_maxRowIndex);
        }
        return n;
    }

    private void addRow(RtfTableRow rtfTableRow, int n, int n2) {
        Iterator iterator = rtfTableRow.getChildren().iterator();
        while (iterator.hasNext()) {
            RtfElement rtfElement = (RtfElement)iterator.next();
            if (!(rtfElement instanceof RtfTableCell)) continue;
            RtfTableCell rtfTableCell = (RtfTableCell)rtfElement;
            this.m_cells.add(new PositionedCell(rtfTableCell, n, n2));
            n2 += rtfTableCell.getCellWidth();
        }
    }

    RtfTableCell createExtraCell(int n, int n2, int n3, RtfAttributes rtfAttributes) throws IOException {
        RtfTableCell rtfTableCell = new RtfTableCell(null, this.m_writer, n3, rtfAttributes, 0);
        this.m_cells.add(new PositionedCell(rtfTableCell, n, n2));
        return rtfTableCell;
    }

    protected void writeRtfContent() throws IOException {
        Collections.sort(this.m_cells);
        LinkedList<PositionedCell> linkedList = null;
        int n = -1;
        Iterator iterator = this.m_cells.iterator();
        while (iterator.hasNext()) {
            PositionedCell positionedCell = (PositionedCell)iterator.next();
            if (positionedCell.rowIndex != n) {
                if (linkedList != null) {
                    this.writeRow(linkedList);
                }
                n = positionedCell.rowIndex;
                linkedList = new LinkedList<PositionedCell>();
            }
            linkedList.add(positionedCell);
        }
        if (linkedList != null) {
            this.writeRow(linkedList);
        }
    }

    private void writeRow(List list) throws IOException {
        if (RtfExtraRowSet.allCellsEmpty(list)) {
            return;
        }
        RtfTableRow rtfTableRow = new RtfTableRow(null, this.m_writer, 0);
        int n = 0;
        ITableColumnsInfo iTableColumnsInfo = this.getParentITableColumnsInfo();
        iTableColumnsInfo.selectFirstColumn();
        float f = 0.0f;
        float f2 = 0.0f;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PositionedCell positionedCell = (PositionedCell)iterator.next();
            if (n == 0 && positionedCell.xOffset > 0) {
                int n2 = 0;
                while (f < (float)positionedCell.xOffset && n2 < iTableColumnsInfo.getNumberOfColumns()) {
                    f += iTableColumnsInfo.getColumnWidth();
                    rtfTableRow.newTableCellMergedVertically((int)iTableColumnsInfo.getColumnWidth(), positionedCell.cell.m_attrib);
                    iTableColumnsInfo.selectNextColumn();
                    ++n2;
                }
            }
            rtfTableRow.addChild(positionedCell.cell);
            f2 = positionedCell.xOffset + positionedCell.cell.getCellWidth();
            ++n;
        }
        if (iTableColumnsInfo.getColumnIndex() < iTableColumnsInfo.getNumberOfColumns() - 1) {
            iTableColumnsInfo.selectNextColumn();
            while (iTableColumnsInfo.getColumnIndex() < iTableColumnsInfo.getNumberOfColumns()) {
                rtfTableRow.newTableCellMergedVertically((int)iTableColumnsInfo.getColumnWidth(), this.m_attrib);
                iTableColumnsInfo.selectNextColumn();
            }
        }
        rtfTableRow.writeRtf();
    }

    private static boolean allCellsEmpty(List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PositionedCell positionedCell = (PositionedCell)iterator.next();
            if (!positionedCell.cell.containsText()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isEmpty() {
        return false;
    }

    public ITableColumnsInfo getParentITableColumnsInfo() {
        return this.parentITableColumnsInfo;
    }

    public void setParentITableColumnsInfo(ITableColumnsInfo iTableColumnsInfo) {
        this.parentITableColumnsInfo = iTableColumnsInfo;
    }

    private static class PositionedCell
    implements Comparable {
        final RtfTableCell cell;
        final int xOffset;
        final int rowIndex;

        PositionedCell(RtfTableCell rtfTableCell, int n, int n2) {
            this.cell = rtfTableCell;
            this.xOffset = n2;
            this.rowIndex = n;
        }

        public String toString() {
            return "PositionedCell: row " + this.rowIndex + ", offset " + this.xOffset;
        }

        public int compareTo(Object object) {
            int n = 0;
            if (object == null) {
                n = 1;
            } else if (!(object instanceof PositionedCell)) {
                n = 1;
            } else {
                PositionedCell positionedCell = (PositionedCell)object;
                if (this.rowIndex < positionedCell.rowIndex) {
                    n = -1;
                } else if (this.rowIndex > positionedCell.rowIndex) {
                    n = 1;
                } else if (this.xOffset < positionedCell.xOffset) {
                    n = -1;
                } else if (this.xOffset > positionedCell.xOffset) {
                    n = 1;
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            return object != null && this.compareTo(object) == 0;
        }
    }
}

