/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.jfor.jfor.rtflib.rtfdoc.RtfHeader;

public class RtfFontManager {
    private static RtfFontManager instance = null;
    private Hashtable fontIndex = null;
    private Vector fontTable = new Vector();

    private RtfFontManager() {
        this.fontIndex = new Hashtable();
        this.init();
    }

    public static RtfFontManager getInstance() {
        if (instance == null) {
            instance = new RtfFontManager();
        }
        return instance;
    }

    private void init() {
        this.getFontNumber("Arial");
        this.getFontNumber("Symbol");
        this.getFontNumber("Times New Roman");
    }

    public int getFontNumber(String string) {
        int n;
        Object v = this.fontIndex.get(string = string.toLowerCase());
        if (v == null) {
            this.addFont(string);
            n = this.fontTable.size() - 1;
        } else {
            n = (Integer)v;
        }
        return n;
    }

    public void writeFonts(RtfHeader rtfHeader) throws IOException {
        if (this.fontTable == null || this.fontTable.size() == 0) {
            return;
        }
        rtfHeader.writeGroupMark(true);
        rtfHeader.writeControlWord("fonttbl;");
        int n = this.fontTable.size();
        int n2 = 0;
        while (n2 < n) {
            rtfHeader.writeGroupMark(true);
            rtfHeader.write("\\f" + n2);
            rtfHeader.write(" " + (String)this.fontTable.elementAt(n2));
            rtfHeader.writeGroupMark(false);
            ++n2;
        }
        rtfHeader.writeGroupMark(false);
    }

    private void addFont(String string) {
        this.fontIndex.put(string, new Integer(this.fontTable.size()));
        this.fontTable.addElement(string);
    }
}

