/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.SplusConnectSpec;
import com.insightful.splus.SplusIDMaker;
import com.insightful.splus.SplusSSLClientSocketFactory;
import com.insightful.splus.SplusSSLServerSocketFactory;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSessionFactory;
import com.insightful.splus.SplusSessionFactoryLog;
import com.insightful.splus.SplusSessionListEntry;
import com.insightful.splus.TelClient;
import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SplusSessionFactoryFloor
extends UnicastRemoteObject
implements SplusSessionFactory {
    private static boolean g_isWin = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    private List sessions = null;
    private int maxSessions;
    private final int defaultMaxSessions = 100;
    private int portNum;
    private Thread cleanUp;
    private boolean working;
    private boolean localRMI;
    private SplusSessionFactoryLog log;
    private String userRmiPort;
    private String userSessionID;

    private synchronized native int unixAuth(String var1, String var2);

    public SplusSessionFactoryFloor(int n, boolean bl, int n2) throws RemoteException {
        this.init(n, bl, n2);
    }

    public SplusSessionFactoryFloor(int n, boolean bl, int n2, boolean bl2) throws RemoteException {
        super(0, new SplusSSLClientSocketFactory(), new SplusSSLServerSocketFactory());
        this.init(n, bl, n2);
    }

    public SplusSessionFactoryFloor(int n, boolean bl) throws RemoteException {
        this(n, bl, 0);
    }

    public SplusSessionFactoryFloor(boolean bl) throws RemoteException {
        this(1099, bl);
    }

    public SplusSessionFactoryFloor(int n) throws RemoteException {
        this(n, false);
    }

    public SplusSessionFactoryFloor() throws RemoteException {
        this(1099, false);
    }

    public void init(int n, boolean bl, int n2) throws RemoteException {
        this.portNum = n;
        this.localRMI = bl;
        this.maxSessions = n2 > 0 ? n2 : 100;
        this.sessions = Collections.synchronizedList(new LinkedList());
        this.log = new SplusSessionFactoryLog(this.portNum);
        this.report("SplusSessionFactory started on port " + n);
        this.working = true;
        this.cleanUp = new Thread(new Runnable(){

            public void run() {
                while (SplusSessionFactoryFloor.this.working) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!SplusSessionFactoryFloor.this.working) continue;
                    SplusSessionFactoryFloor.this.validateList();
                }
            }
        });
        this.cleanUp.start();
    }

    public void close() throws RemoteException {
        if (this.localRMI) {
            this.working = false;
            this.cleanUp.interrupt();
            this.log.release();
        } else {
            System.exit(0);
        }
    }

    public static void stop(int n) {
        block8: {
            try {
                SplusSessionFactory splusSessionFactory = SplusSessionFactoryFloor.getFactory(n);
                if (splusSessionFactory == null) break block8;
                splusSessionFactory.report("Terminating SplusSessionFactory");
                String[] stringArray = splusSessionFactory.getSessionIDs();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        SplusSessionFactoryFloor.endSession(stringArray[i], n);
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                splusSessionFactory.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Naming.unbind("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + n + "/SplusSessionServer");
            System.out.println("Session server terminated");
        }
        catch (Exception exception) {
            System.out.println("Session server not found on port " + n);
        }
    }

    public static void stop() {
        SplusSessionFactoryFloor.stop(1099);
    }

    public void endRMIServer() throws RemoteException {
        if (this.localRMI) {
            SplusSessionFactoryFloor.stop(this.portNum);
            System.exit(0);
        } else {
            System.out.println("Splus is not managing RMI registry.  Use some other shutdown method.");
        }
    }

    public static void stopRMI(int n) {
        SplusSessionFactory splusSessionFactory = SplusSessionFactoryFloor.getFactory(n);
        if (splusSessionFactory != null) {
            try {
                splusSessionFactory.endRMIServer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void stopRMI() {
        SplusSessionFactoryFloor.stopRMI(1099);
    }

    public static SplusSessionFactory getFactory(int n) {
        try {
            SplusSessionFactory splusSessionFactory = (SplusSessionFactory)Naming.lookup("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + n + "/SplusSessionServer");
            return splusSessionFactory;
        }
        catch (Exception exception) {
            System.out.println("Session server not found on port " + n);
            return null;
        }
    }

    public static SplusSessionFactory getFactory() {
        return SplusSessionFactoryFloor.getFactory(1099);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSession(String string) throws RemoteException {
        if (this.sessions == null || this.sessions.size() == 0) {
            return;
        }
        this.report("Session \"" + string + "\" has ended");
        try {
            Naming.unbind("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + this.portNum + "/" + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SplusSessionListEntry[] splusSessionListEntryArray = this.getEntries();
        for (int i = 0; i < splusSessionListEntryArray.length; ++i) {
            if (!string.equals(splusSessionListEntryArray[i].getSessionID())) continue;
            List list = this.sessions;
            synchronized (list) {
                this.sessions.remove(splusSessionListEntryArray[i]);
            }
            return;
        }
        System.out.println("Session not found: " + string);
    }

    public static void endSession(final String string, final int n) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                SplusSession splusSession = null;
                try {
                    splusSession = (SplusSession)Naming.lookup("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + n + "/" + string);
                }
                catch (Exception exception) {
                    System.out.println("Session not found: " + string);
                    return;
                }
                try {
                    splusSession.sessionExit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        thread.start();
        try {
            thread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void endSession(String string) {
        SplusSessionFactoryFloor.endSession(string, 1099);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSessions() throws RemoteException {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        String[] stringArray = null;
        List list = this.sessions;
        synchronized (list) {
            stringArray = new String[this.sessions.size()];
            int n = 0;
            Iterator iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = new String(((SplusSessionListEntry)iterator.next()).toString());
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplusSessionListEntry[] getEntries() {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        SplusSessionListEntry[] splusSessionListEntryArray = null;
        List list = this.sessions;
        synchronized (list) {
            splusSessionListEntryArray = new SplusSessionListEntry[this.sessions.size()];
            int n = 0;
            Iterator iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                splusSessionListEntryArray[n++] = (SplusSessionListEntry)iterator.next();
            }
        }
        return splusSessionListEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSessionIDs() throws RemoteException {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        String[] stringArray = null;
        List list = this.sessions;
        synchronized (list) {
            stringArray = new String[this.sessions.size()];
            int n = 0;
            Iterator iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = new String(((SplusSessionListEntry)iterator.next()).getSessionID());
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateList() {
        if (this.sessions == null || this.sessions.size() == 0) {
            return;
        }
        String[] stringArray = null;
        List list = this.sessions;
        synchronized (list) {
            stringArray = new String[this.sessions.size()];
            int n = 0;
            Iterator iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = new String(((SplusSessionListEntry)iterator.next()).getSessionID());
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.validSession(stringArray[i])) continue;
            try {
                this.unregisterSession(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean validSession(String string) {
        ValidatorThread validatorThread = new ValidatorThread(string, this.portNum);
        validatorThread.start();
        try {
            validatorThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return validatorThread.getValue();
    }

    public static void whoami(String string, String string2, String string3, String string4, String string5, String string6, SplusSessionFactoryLog splusSessionFactoryLog, SplusSessionFactoryFloor splusSessionFactoryFloor) throws RemoteException, UnknownHostException {
        TelClient telClient = new TelClient(InetAddress.getLocalHost().getHostName(), splusSessionFactoryLog);
        String string7 = "echo SHOME/cmd/WHOAMI reports:`" + string6 + "/cmd/WHOAMI`";
        String string8 = "SHOME/cmd/WHOAMI reports:" + string;
        telClient.connect();
        splusSessionFactoryFloor.report("Telnet initiated for " + string);
        telClient.transact("ogin:", string);
        telClient.transact("ssword:", string2);
        telClient.transact(string3, "echo SplusAS-checking-that-login-process-is-finished | sed -e 's/finished/FINISHED/'");
        telClient.transact("SplusAS-checking-that-login-process-is-FINISHED", string7, 60);
        if (telClient.transact(string8, " ") == -1) {
            telClient.transact(string3, "exit");
            telClient.close();
            String string9 = "Telnet login failed for invalid user " + string + "\n" + "or invalid command (check " + string7 + ").\n" + "Session \"" + string5 + "\" aborted\n";
            splusSessionFactoryFloor.report(string9);
            throw new RemoteException("Bad login: \n" + string9);
        }
        telClient.transact(string3, string4);
        telClient.transact(string4, "exit");
        telClient.close();
    }

    public SplusConnectSpec getSession(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String[] stringArray) throws RemoteException {
        try {
            Object object;
            Object object2;
            this.report("Session Request from " + string2);
            if (this.sessions.size() >= this.maxSessions) {
                this.report("Session limit reached.  Session refused for user " + string2);
                throw new RemoteException("Too many sessions");
            }
            if (string7 == null) {
                string7 = " ";
            }
            String string9 = System.getProperty("splus.shome");
            if (string == null) {
                string = "1099";
            }
            String string10 = "SplusSession_" + string + "_";
            string10 = string10 + SplusIDMaker.instance().getID();
            StringBuffer stringBuffer = new StringBuffer();
            if (g_isWin) {
                object2 = System.getProperty("java.class.path", ".");
                object = System.getProperty("java.home", string9 + "/java/jre");
                stringBuffer.append('\"');
                stringBuffer.append((String)object);
                stringBuffer.append("/bin/java.exe");
                stringBuffer.append('\"');
                stringBuffer.append(" -classpath \"");
                stringBuffer.append((String)object2);
                stringBuffer.append("\"");
                stringBuffer.append(" -Dsplus.shome=\"");
                stringBuffer.append(string9);
                stringBuffer.append("\"");
                stringBuffer.append(" -Dsplus.session.id=");
                stringBuffer.append(string10);
                stringBuffer.append(" -Dsplus.server.rmiport=");
                stringBuffer.append(string);
                stringBuffer.append(" com.insightful.splus.SplusRemoteSessionStart");
            } else {
                stringBuffer.append(string9);
                stringBuffer.append("/cmd/SESSION ");
                stringBuffer.append(string9);
                stringBuffer.append(" ");
                stringBuffer.append(string4);
                stringBuffer.append(" ");
                stringBuffer.append(string5);
                stringBuffer.append(" ");
                stringBuffer.append(string10);
                stringBuffer.append(" ");
                stringBuffer.append(string6);
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" false false");
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(" " + stringArray[i]);
                    }
                }
                stringBuffer.append(" &");
            }
            if (g_isWin || System.getProperty("splus.single.user") != null) {
                Runtime.getRuntime().exec(stringBuffer.toString());
            } else if (System.getProperty("splus.root.server") != null) {
                this.report("Authenticating user: " + string2);
                if (1 != this.unixAuth(string2, string3)) {
                    this.report("Authentication failed for user " + string2);
                    this.report("Session \"" + string10 + "\" aborted");
                    throw new RemoteException("Bad login");
                }
                object2 = File.createTempFile("cmd", "sh");
                object = new FileOutputStream((File)object2);
                String string11 = "#!/bin/sh";
                ((FileOutputStream)object).write(string11.getBytes());
                ((FileOutputStream)object).write(10);
                ((FileOutputStream)object).write(stringBuffer.toString().getBytes());
                ((FileOutputStream)object).write(10);
                ((FileOutputStream)object).close();
                String string12 = "chmod 755 " + ((File)object2).getAbsolutePath();
                Runtime.getRuntime().exec(string12);
                string12 = "su - " + string2 + " -c " + ((File)object2).getAbsolutePath();
                Runtime.getRuntime().exec(string12);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((File)object2).delete();
            } else {
                stringBuffer.append(" \n");
                SplusSessionFactoryFloor.whoami(string2, string3, string7, stringBuffer.toString(), string10, string9, this.log, this);
            }
            this.report("Started session " + string10 + " for user " + string2);
            object2 = new SplusSessionListEntry(string2, string4, string5, null, string10, InetAddress.getLocalHost().getHostName(), string6, Integer.decode(string));
            this.userRmiPort = string;
            this.userSessionID = string10;
            object = new Thread(new Runnable((SplusSessionListEntry)object2){
                final /* synthetic */ SplusSessionListEntry val$entry;
                {
                    this.val$entry = splusSessionListEntry;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    boolean bl = true;
                    int n = 0;
                    while (bl) {
                        try {
                            SplusSession splusSession = (SplusSession)Naming.lookup("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + SplusSessionFactoryFloor.this.userRmiPort + "/" + SplusSessionFactoryFloor.this.userSessionID);
                            bl = false;
                        }
                        catch (Exception exception) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            if (!(exception instanceof NotBoundException)) {
                                String string = "Unexpected error during session-list update for session:" + SplusSessionFactoryFloor.this.userSessionID;
                                SplusSessionFactoryFloor.this.report(string);
                                break;
                            }
                            if (++n <= 30) continue;
                            SplusSessionFactoryFloor.this.report("Timeout occured while addingremote session, " + SplusSessionFactoryFloor.this.userSessionID + ", to the session-list");
                            break;
                        }
                    }
                    List list = SplusSessionFactoryFloor.this.sessions;
                    synchronized (list) {
                        SplusSessionFactoryFloor.this.sessions.add(this.val$entry);
                    }
                }
            });
            ((Thread)object).start();
            return new SplusConnectSpec(string10);
        }
        catch (RemoteException remoteException) {
            if (remoteException.getMessage().indexOf("Bad login") > -1 || remoteException.getMessage().indexOf("Too many sessions") > -1) {
                throw remoteException;
            }
            remoteException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Failure in starting SplusRemoteSession");
        return null;
    }

    public void report(String string) {
        if (this.log == null) {
            System.out.println(string);
        } else {
            this.log.append(string);
        }
    }

    public String getLogFileName() {
        return this.log.getName();
    }

    public void setLogFileName(String string) {
        this.log.setName(string);
    }

    public boolean getLogRotateFlag() {
        return this.log.getDaily();
    }

    public void setLogRotateFlag(boolean bl) {
        this.log.setDaily(bl);
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int n) {
        this.maxSessions = n;
    }

    protected void finalize() throws Throwable {
        this.log.release();
    }

    public char[] getAccess() throws RemoteException {
        return SplusSSLServerSocketFactory.getAccess();
    }

    static {
        String string = System.getProperty("os.name", "unknown").toLowerCase();
        if (string.indexOf("windows") < 0 && !string.startsWith("mac")) {
            try {
                System.loadLibrary("SplusAuth");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class ValidatorThread
    extends Thread {
        String tId;
        int tPortNum;
        boolean value = true;

        public ValidatorThread(String string, int n) {
            this.tId = string;
            this.tPortNum = n;
        }

        public boolean getValue() {
            return this.value;
        }

        public void run() {
            SplusSession splusSession = null;
            try {
                splusSession = (SplusSession)Naming.lookup("rmi://" + InetAddress.getLocalHost().getHostName() + ":" + this.tPortNum + "/" + this.tId);
                splusSession.isRemote();
            }
            catch (Exception exception) {
                this.value = false;
            }
        }
    }
}

