/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.graph;

import com.insightful.controls.SplusDialog;
import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.SCanvas;
import com.insightful.splus.SplusMinGui;
import com.insightful.splus.SplusSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;

public class GraphColorsDialog
extends JDialog {
    public boolean m_ok = false;
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    public static Vector m_standardColorSchemes = new Vector();
    public static Vector m_standardColorSchemeIndexNames = new Vector();
    private SCanvas m_canvas = null;
    private ColorScheme m_initCanvasColorScheme = null;
    private boolean m_splusCallable = true;

    public GraphColorsDialog() {
        this(SplusSystem.getDefaultFrame());
    }

    public GraphColorsDialog(Frame frame) {
        this(frame, (SCanvas)null, true);
    }

    public GraphColorsDialog(Frame frame, SCanvas sCanvas, boolean bl) {
        super(frame, "Set Graph Colors", true);
        this.m_canvas = sCanvas;
        if (this.m_canvas == null) {
            this.m_canvas = SplusSystem.getCanvasHandler().getActiveCanvas();
        }
        this.m_initCanvasColorScheme = this.getCanvasColorScheme();
        this.m_splusCallable = bl;
        if (this.m_splusCallable) {
            SplusSystem.getEngineQueryHandler().processDataQuery("java.colorscheme.update.java()");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1, 0, 0));
        jPanel2.add(new JLabel("Set Graph Color Scheme"));
        String[] stringArray = GraphColorsDialog.getStandardColorSchemeNames();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    GraphColorsDialog.this.applySchemeToActiveCanvas(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        for (int i = 0; i < stringArray.length; ++i) {
            jPanel2.add(this.createJButton(stringArray[i], Integer.toString(i), actionListener));
        }
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        Box box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(this.createJButton("Edit Colors...", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    EditColorsDialog editColorsDialog = new EditColorsDialog(GraphColorsDialog.this);
                    editColorsDialog.show();
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    System.out.flush();
                }
            }
        }));
        jPanel.add(box);
        jPanel.add(Box.createVerticalStrut(10));
        this.getContentPane().add(Box.createHorizontalStrut(8), "West");
        this.getContentPane().add(Box.createHorizontalStrut(8), "East");
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        this.okButton = this.createJButton("OK", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphColorsDialog.this.m_ok = true;
                GraphColorsDialog.this.dispose();
            }
        });
        jPanel3.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = this.createJButton("Cancel", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphColorsDialog.this.m_ok = false;
                GraphColorsDialog.this.applySchemeToActiveCanvas(GraphColorsDialog.this.m_initCanvasColorScheme);
                GraphColorsDialog.this.dispose();
            }
        });
        jPanel3.add(this.cancelButton);
        if (!(SplusSystem.getCanvasHandler() instanceof SplusMinGui)) {
            jPanel3.add(Box.createHorizontalGlue());
            this.helpButton = this.createJButton("Help", new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SplusSystem.getHelpQueryHandler().displayHelpOnTopic("Set_Graph_Colors");
                }
            });
            jPanel3.add(this.helpButton);
        }
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
        SplusDialog.centerComponent(this, SplusSystem.getDefaultFrame());
    }

    void applySchemeToActiveCanvas(ColorScheme colorScheme) {
        try {
            if (this.m_canvas != null) {
                this.m_canvas.getGraphicsDevice().setColorScheme(colorScheme);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.flush();
        }
    }

    void applySchemeToActiveCanvas(int n) {
        this.applySchemeToActiveCanvas(GraphColorsDialog.getStandardColorScheme(n));
    }

    JButton createJButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    JButton createJButton(String string, ActionListener actionListener) {
        return this.createJButton(string, string, actionListener);
    }

    ColorScheme getCanvasColorScheme() {
        return this.m_canvas == null ? new ColorScheme() : this.m_canvas.getColorScheme();
    }

    public static ColorScheme getStandardColorScheme(int n) {
        Vector vector = m_standardColorSchemes;
        if (n >= 0 && n < vector.size()) {
            return (ColorScheme)vector.get(n);
        }
        return new ColorScheme();
    }

    public static String getStandardColorSchemeIndexName(int n) {
        Vector vector = m_standardColorSchemeIndexNames;
        if (n >= 0 && n < vector.size()) {
            return (String)vector.get(n);
        }
        return "";
    }

    public static int getStandardColorSchemeSize() {
        Vector vector = m_standardColorSchemes;
        return vector.size();
    }

    public static int getDefaultColorSchemeIndex() {
        int n = GraphColorsDialog.getStandardColorSchemeSize();
        for (int i = 0; i < n; ++i) {
            if (!GraphColorsDialog.getStandardColorSchemeIndexName(i).equals("java.colorscheme.default")) continue;
            return i;
        }
        return -1;
    }

    public static ColorScheme getDefaultColorScheme() {
        int n = GraphColorsDialog.getDefaultColorSchemeIndex();
        return GraphColorsDialog.getStandardColorScheme(n);
    }

    public static String[] getStandardColorSchemeNames() {
        int n = GraphColorsDialog.getStandardColorSchemeSize();
        int n2 = GraphColorsDialog.getDefaultColorSchemeIndex();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = GraphColorsDialog.getStandardColorScheme(i).getName();
            if (i == n2) {
                string = "** Default **";
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static void setStandardColorScheme(int n, ColorScheme colorScheme) {
        Vector vector = m_standardColorSchemes;
        if (n >= 0 && n < vector.size()) {
            vector.set(n, colorScheme);
        }
    }

    class ColorGrid
    extends JPanel {
        Color[] m_colors = null;
        int m_maxColumns = 16;
        JButton m_blendButton = null;
        DefaultListSelectionModel m_selModel = new DefaultListSelectionModel();
        MouseInputAdapter m_mouseListener = new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = ColorGrid.this.xyToItemNum(mouseEvent.getX(), mouseEvent.getY());
                if (mouseEvent.isShiftDown()) {
                    ColorGrid.this.m_selModel.setLeadSelectionIndex(n);
                } else {
                    ColorGrid.this.m_selModel.setSelectionInterval(n, n);
                }
                ColorGrid.this.updateMapItems();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = ColorGrid.this.xyToItemNum(mouseEvent.getX(), mouseEvent.getY());
                ColorGrid.this.m_selModel.setLeadSelectionIndex(n);
                ColorGrid.this.updateMapItems();
            }
        };

        ColorGrid(Color[] colorArray, int n) {
            this(colorArray, n, null);
        }

        ColorGrid(Color[] colorArray, int n, JButton jButton) {
            this.m_colors = colorArray;
            this.m_maxColumns = n;
            this.m_blendButton = jButton;
            if (this.m_blendButton != null) {
                this.m_blendButton.setEnabled(false);
            }
            this.addMouseListener(this.m_mouseListener);
            this.addMouseMotionListener(this.m_mouseListener);
        }

        void setColors(Color[] colorArray) {
            this.m_colors = colorArray;
            this.repaint(1000L);
        }

        Color[] getColors() {
            Color[] colorArray = new Color[this.m_colors.length];
            for (int i = 0; i < this.m_colors.length; ++i) {
                colorArray[i] = this.m_colors[i];
            }
            return colorArray;
        }

        int getNumSelectedColors() {
            int n = 0;
            for (int i = 0; i <= this.getNumberColors(); ++i) {
                if (!this.m_selModel.isSelectedIndex(i)) continue;
                ++n;
            }
            return n;
        }

        int[] getSelectedIndices() {
            int[] nArray = new int[2];
            int n = 0;
            for (int i = 0; i <= this.getNumberColors(); ++i) {
                if (!this.m_selModel.isSelectedIndex(i)) continue;
                nArray[n] = i;
                if (n != 0) continue;
                ++n;
            }
            return nArray;
        }

        Color getFirstSelectedColor() {
            for (int i = 0; i <= this.getNumberColors(); ++i) {
                if (!this.m_selModel.isSelectedIndex(i)) continue;
                return this.m_colors[i];
            }
            return this.m_colors[0];
        }

        void setSelectedColors(Color color) {
            for (int i = 0; i <= this.getNumberColors(); ++i) {
                if (!this.m_selModel.isSelectedIndex(i)) continue;
                this.m_colors[i] = color;
            }
            this.repaint(1000L);
        }

        Color getColor(int n) {
            return this.m_colors[n];
        }

        void setColor(int n, Color color) {
            this.m_colors[n] = color;
            this.repaint(1000L);
        }

        public void paint(Graphics graphics) {
            graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
            for (int i = 0; i < this.getNumberColors(); ++i) {
                this.updateMapItem(graphics, i);
            }
        }

        void autoFill(int[] nArray) {
            int n = this.m_colors.length - 1;
            if (nArray == null || nArray.length == 0) {
                nArray = new int[]{0, this.m_colors.length - 1};
            } else {
                Arrays.sort(nArray);
            }
            for (int i = 0; i < nArray.length - 1; ++i) {
                int n2 = nArray[i];
                int n3 = nArray[i + 1];
                Color color = this.m_colors[n2];
                Color color2 = this.m_colors[n3];
                int n4 = color.getRed();
                int n5 = color.getGreen();
                int n6 = color.getBlue();
                int n7 = color2.getRed();
                int n8 = color2.getGreen();
                int n9 = color2.getBlue();
                int n10 = n3 - n2;
                float f = (float)(n7 - n4) / (float)(n10 * 255);
                float f2 = (float)(n8 - n5) / (float)(n10 * 255);
                float f3 = (float)(n9 - n6) / (float)(n10 * 255);
                float f4 = (float)n4 / 255.0f;
                float f5 = (float)n5 / 255.0f;
                float f6 = (float)n6 / 255.0f;
                for (int j = 1; j < n10; ++j) {
                    this.m_colors[n2 + j] = new Color(f4 += f, f5 += f2, f6 += f3);
                }
            }
            this.repaint(1000L);
        }

        int getNumberColors() {
            return this.m_colors.length;
        }

        int getBoxWidth() {
            return this.getSize().width / this.m_maxColumns;
        }

        int getBoxHeight() {
            int n = this.getNumberColors() / this.m_maxColumns;
            if (n * this.m_maxColumns < this.getNumberColors()) {
                ++n;
            }
            return this.getSize().height / n;
        }

        int itemNumToX(int n) {
            return n % this.m_maxColumns * this.getBoxWidth();
        }

        int itemNumToY(int n) {
            return n / this.m_maxColumns * this.getBoxHeight();
        }

        int xyToItemNum(int n, int n2) {
            int n3 = n / this.getBoxWidth();
            int n4 = n2 / this.getBoxHeight();
            int n5 = n3 + n4 * this.m_maxColumns;
            if (n4 < 0 || n3 < 0 || n5 >= this.getNumberColors()) {
                n5 = 0;
            }
            return n5;
        }

        void updateMapItem(Graphics graphics, int n) {
            int n2 = this.itemNumToX(n);
            int n3 = this.itemNumToY(n);
            int n4 = this.getBoxWidth();
            int n5 = this.getBoxHeight();
            this.setBackground(Color.white);
            graphics.setColor(Color.white);
            if (this.m_selModel.isSelectedIndex(n)) {
                graphics.setColor(Color.red);
            }
            graphics.fillRect(n2, n3, n4, n5);
            Color color = this.m_colors[n];
            graphics.setColor(color);
            graphics.fillRect(n2 + 2, n3 + 2, n4 - 4, n5 - 4);
            graphics.setColor(Color.black);
            graphics.drawRect(n2 + 2, n3 + 2, n4 - 4, n5 - 4);
        }

        void updateMapItem(int n) {
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                this.updateMapItem(graphics, n);
            }
        }

        void updateMapItems(int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                this.updateMapItem(i);
            }
        }

        void updateMapItems() {
            int n;
            int n2 = 0;
            for (n = 0; n < this.getNumberColors(); n += 1) {
                if (this.m_selModel.isSelectedIndex(n)) {
                    ++n2;
                }
                this.updateMapItem(n);
            }
            if (this.m_blendButton != null) {
                n = n2 >= 2 ? 1 : 0;
                this.m_blendButton.setEnabled(n != 0);
            }
        }
    }

    class EditColorsDialog
    extends JDialog {
        private JComboBox m_cbColorScheme;
        private ColorGrid m_backgroundColorGrid;
        private ColorGrid m_paletteColorGrid;
        private ColorGrid m_imageColorGrid;
        private JTextField m_tfName;
        private ColorScheme m_initCS;
        private ColorScheme[] m_modifiedColorSchemes;
        private JButton m_blendButton;
        final String BUTTON_EDIT_BACKGROUND = "Edit Background Color...";
        final String BUTTON_EDIT_LINE_COLOR = "Edit Selected Line Color...";
        final String BUTTON_EDIT_IMAGE_COLOR = "Edit Selected Image Color...";
        final String FIRST_EDIT_IMAGE_COLOR = "First...";
        final String LAST_EDIT_IMAGE_COLOR = "Last...";
        final String SEL_EDIT_IMAGE_COLOR = "Blend Selected Range";
        final String BUTTON_OK = "OK";
        final String BUTTON_CANCEL = "Cancel";
        final String BUTTON_GET_GRAPH_COLORS = "Get Colors From Current Graph";
        final String BUTTON_SET_GRAPH_COLORS = "Set Current Graph Colors";
        final String BUTTON_SET_DEFAULT_COLORSCHEME = "Set Default Color Scheme";
        final String BUTTON_GET_KNOWN_COLORSCHEME = "Get Known Color Scheme";
        final String BUTTON_SET_KNOWN_COLORSCHEME = "Set Known Color Scheme";
        ActionListener m_buttonListener;

        public EditColorsDialog(Dialog dialog) {
            super(dialog, "Edit Graph Colors", true);
            this.m_cbColorScheme = null;
            this.BUTTON_EDIT_BACKGROUND = "Edit Background Color...";
            this.BUTTON_EDIT_LINE_COLOR = "Edit Selected Line Color...";
            this.BUTTON_EDIT_IMAGE_COLOR = "Edit Selected Image Color...";
            this.FIRST_EDIT_IMAGE_COLOR = "First...";
            this.LAST_EDIT_IMAGE_COLOR = "Last...";
            this.SEL_EDIT_IMAGE_COLOR = "Blend Selected Range";
            this.BUTTON_OK = "OK";
            this.BUTTON_CANCEL = "Cancel";
            this.BUTTON_GET_GRAPH_COLORS = "Get Colors From Current Graph";
            this.BUTTON_SET_GRAPH_COLORS = "Set Current Graph Colors";
            this.BUTTON_SET_DEFAULT_COLORSCHEME = "Set Default Color Scheme";
            this.BUTTON_GET_KNOWN_COLORSCHEME = "Get Known Color Scheme";
            this.BUTTON_SET_KNOWN_COLORSCHEME = "Set Known Color Scheme";
            this.m_buttonListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    int n = EditColorsDialog.this.m_cbColorScheme.getSelectedIndex();
                    if (string.equals("Edit Background Color...")) {
                        Color color = EditColorsDialog.this.chooseColor("Edit Background Color", EditColorsDialog.this.m_backgroundColorGrid.getColor(0));
                        if (color != null) {
                            EditColorsDialog.this.m_backgroundColorGrid.setColor(0, color);
                        }
                    } else if (string.equals("Edit Selected Line Color...")) {
                        Color color = EditColorsDialog.this.chooseColor("Edit Line Color", EditColorsDialog.this.m_paletteColorGrid.getFirstSelectedColor());
                        if (color != null) {
                            EditColorsDialog.this.m_paletteColorGrid.setSelectedColors(color);
                        }
                    } else if (string.equals("OK")) {
                        GraphColorsDialog.this.applySchemeToActiveCanvas(EditColorsDialog.this.getColorScheme());
                        EditColorsDialog.this.updateModifiedColorSchemes();
                        EditColorsDialog.this.dispose();
                    } else if (string.equals("Cancel")) {
                        GraphColorsDialog.this.applySchemeToActiveCanvas(EditColorsDialog.this.m_initCS);
                        EditColorsDialog.this.dispose();
                    } else if (string.equals("Get Known Color Scheme")) {
                        EditColorsDialog.this.updateDisplay(EditColorsDialog.this.getModifiedColorScheme(n));
                    } else if (string.equals("Set Known Color Scheme")) {
                        EditColorsDialog.this.setModifiedColorScheme(n, EditColorsDialog.this.getColorScheme());
                    } else if (string.equals("Set Default Color Scheme")) {
                        EditColorsDialog.this.setModifiedColorScheme(GraphColorsDialog.getDefaultColorSchemeIndex(), EditColorsDialog.this.getColorScheme());
                    } else if (string.equals("Get Colors From Current Graph")) {
                        EditColorsDialog.this.updateDisplay(GraphColorsDialog.this.getCanvasColorScheme());
                    } else if (string.equals("Set Current Graph Colors")) {
                        GraphColorsDialog.this.applySchemeToActiveCanvas(EditColorsDialog.this.getColorScheme());
                    } else if (string.equals("Edit Selected Image Color...")) {
                        Color color = EditColorsDialog.this.chooseColor("Edit Image Color", EditColorsDialog.this.m_imageColorGrid.getFirstSelectedColor());
                        if (color != null) {
                            EditColorsDialog.this.m_imageColorGrid.setSelectedColors(color);
                        }
                    } else if (string.equals("First...")) {
                        int n2 = 0;
                        Color color = EditColorsDialog.this.chooseColor("Edit Image Color", EditColorsDialog.this.m_imageColorGrid.getColor(n2));
                        if (color != null) {
                            EditColorsDialog.this.m_imageColorGrid.setColor(n2, color);
                        }
                        EditColorsDialog.this.m_imageColorGrid.autoFill(new int[0]);
                    } else if (string.equals("Last...")) {
                        int n3 = EditColorsDialog.this.m_imageColorGrid.getNumberColors() - 1;
                        Color color = EditColorsDialog.this.chooseColor("Edit Image Color", EditColorsDialog.this.m_imageColorGrid.getColor(n3));
                        if (color != null) {
                            EditColorsDialog.this.m_imageColorGrid.setColor(n3, color);
                        }
                        EditColorsDialog.this.m_imageColorGrid.autoFill(new int[0]);
                    } else if (string.equals("Blend Selected Range")) {
                        int[] nArray = EditColorsDialog.this.m_imageColorGrid.getSelectedIndices();
                        EditColorsDialog.this.m_imageColorGrid.autoFill(nArray);
                    }
                }
            };
            this.m_initCS = GraphColorsDialog.this.getCanvasColorScheme();
            int n = GraphColorsDialog.getStandardColorSchemeSize();
            this.m_modifiedColorSchemes = new ColorScheme[n];
            for (int i = 0; i < n; ++i) {
                this.m_modifiedColorSchemes[i] = null;
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setAlignmentX(0.0f);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder("Color Scheme Name"));
            this.m_tfName = new JTextField();
            this.m_tfName.setText(this.m_initCS.getName());
            jPanel2.add(this.m_tfName);
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(2));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.setBorder(BorderFactory.createTitledBorder("Background Color"));
            this.m_backgroundColorGrid = new ColorGrid(new Color[]{this.m_initCS.getBackgroundColor()}, 1);
            this.m_backgroundColorGrid.setPreferredSize(new Dimension(450, 20));
            jPanel3.add(this.m_backgroundColorGrid);
            jPanel3.add(Box.createVerticalStrut(4));
            jPanel3.add(this.createJButton("Edit Background Color..."));
            jPanel.add(jPanel3);
            jPanel.add(Box.createVerticalStrut(2));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel4.setBorder(BorderFactory.createTitledBorder("Line Colors"));
            this.m_paletteColorGrid = new ColorGrid(this.m_initCS.getPaletteColors(), 4);
            this.m_paletteColorGrid.setPreferredSize(new Dimension(450, 40));
            jPanel4.add(this.m_paletteColorGrid);
            jPanel4.add(Box.createVerticalStrut(4));
            jPanel4.add(this.createJButton("Edit Selected Line Color..."));
            jPanel.add(jPanel4);
            jPanel.add(Box.createVerticalStrut(2));
            JPanel jPanel5 = this.createImageColorButtonPanel();
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 1));
            jPanel6.setBorder(BorderFactory.createTitledBorder("Image Colors"));
            this.m_imageColorGrid = new ColorGrid(this.m_initCS.getImageColors(), 32, this.m_blendButton);
            this.m_imageColorGrid.setPreferredSize(new Dimension(450, 80));
            jPanel6.add(this.m_imageColorGrid);
            jPanel6.add(Box.createVerticalStrut(4));
            jPanel6.add(jPanel5);
            jPanel.add(jPanel6);
            jPanel.add(Box.createVerticalStrut(2));
            String[] stringArray = GraphColorsDialog.getStandardColorSchemeNames();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Integer.toString(i + 1) + ": " + stringArray[i];
            }
            this.m_cbColorScheme = new JComboBox<String>(stringArray);
            this.m_cbColorScheme.setSelectedIndex(GraphColorsDialog.getDefaultColorSchemeIndex());
            this.m_cbColorScheme.setEditable(false);
            JPanel jPanel7 = new JPanel(new FlowLayout(0));
            jPanel7.setBorder(BorderFactory.createTitledBorder("Color Schemes"));
            jPanel7.add(this.m_cbColorScheme);
            jPanel7.add(this.createJButton("Get Colors", "Get Known Color Scheme"));
            jPanel7.add(this.createJButton("Set Color Scheme", "Set Known Color Scheme"));
            jPanel.add(jPanel7);
            jPanel.setAlignmentX(0.0f);
            jPanel.add(Box.createVerticalStrut(7));
            JPanel jPanel8 = new JPanel();
            jPanel8.add(this.createJButton("Get Graph Colors", "Get Colors From Current Graph"));
            jPanel8.add(this.createJButton("Set Graph Colors", "Set Current Graph Colors"));
            jPanel8.add(this.createJButton("Set Default Color Scheme", "Set Default Color Scheme"));
            jPanel.add(jPanel8);
            jPanel.setAlignmentX(0.0f);
            this.getContentPane().add(Box.createHorizontalStrut(8), "West");
            this.getContentPane().add(Box.createHorizontalStrut(8), "East");
            this.getContentPane().add((Component)jPanel, "Center");
            JPanel jPanel9 = new JPanel();
            jPanel9.add(this.createJButton("OK"));
            jPanel9.add(this.createJButton("Cancel"));
            this.getContentPane().add((Component)jPanel9, "South");
            this.pack();
        }

        JPanel createImageColorButtonPanel() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.createJButton("Edit Selected Image Color..."));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            this.m_blendButton = this.createJButton("Blend Selected Range");
            jPanel2.add(this.m_blendButton);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.add(Box.createHorizontalStrut(20));
            jPanel3.add(jPanel);
            jPanel3.add(Box.createHorizontalStrut(5));
            jPanel3.add(jPanel2);
            jPanel3.add(Box.createHorizontalGlue());
            return jPanel3;
        }

        ColorScheme getModifiedColorScheme(int n) {
            ColorScheme colorScheme = this.m_modifiedColorSchemes[n];
            return colorScheme != null ? colorScheme : GraphColorsDialog.getStandardColorScheme(n);
        }

        void setModifiedColorScheme(int n, ColorScheme colorScheme) {
            this.m_modifiedColorSchemes[n] = colorScheme;
        }

        void updateModifiedColorSchemes() {
            boolean bl = false;
            for (int i = 0; i < this.m_modifiedColorSchemes.length; ++i) {
                ColorScheme colorScheme = this.m_modifiedColorSchemes[i];
                if (colorScheme == null) continue;
                GraphColorsDialog.setStandardColorScheme(i, colorScheme);
                bl = true;
            }
            if (bl) {
                this.updateSplusStandardColorSchemes();
            }
        }

        ColorScheme getColorScheme() {
            ColorScheme colorScheme = new ColorScheme(this.m_tfName.getText(), this.m_backgroundColorGrid.getColor(0), this.m_paletteColorGrid.getColors(), this.m_imageColorGrid.getColors());
            return colorScheme;
        }

        JButton createJButton(String string) {
            return this.createJButton(string, string);
        }

        JButton createJButton(String string, String string2) {
            return GraphColorsDialog.this.createJButton(string, string2, this.m_buttonListener);
        }

        Color chooseColor(String string, Color color) {
            return JColorChooser.showDialog(GraphColorsDialog.this, string, color);
        }

        void updateDisplay(ColorScheme colorScheme) {
            this.m_tfName.setText(colorScheme.getName());
            this.m_backgroundColorGrid.setColors(new Color[]{colorScheme.getBackgroundColor()});
            this.m_paletteColorGrid.setColors(colorScheme.getPaletteColors());
            this.m_imageColorGrid.setColors(colorScheme.getImageColors());
        }

        void updateSplusStandardColorSchemes() {
            if (GraphColorsDialog.this.m_splusCallable) {
                SplusSystem.getEngineQueryHandler().processDataQuery("java.colorscheme.update.splus()");
            } else {
                String string = "The S-PLUS color scheme variables have not been updated.\nTo update them, execute java.colorscheme.update.splus()";
                JOptionPane.showMessageDialog(GraphColorsDialog.this, string, "Warning", 2);
            }
        }
    }
}

