/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.parser;

import com.insightful.splus.parser.GenParser;
import com.insightful.splus.parser.PObject;
import com.insightful.splus.parser.PObjectFactory;
import java.util.Vector;

public class ParserUtil {
    public static final String START_LINE_ATTRIBUTE = "start.line";
    public static final String START_COLUMN_ATTRIBUTE = "start.column";
    public static final String END_LINE_ATTRIBUTE = "end.line";
    public static final String END_COLUMN_ATTRIBUTE = "end.column";
    public static final String MODE_CALL_WITH_THREE_DOTS = "call with ...";
    public static final String MODE_LEFT_ARROW = "<-";
    public static final String MODE_DOUBLE_LEFT_ARROW = "<<-";
    public static final String MODE_LEFT_BRACE = "{";
    public static final String MODE_EQUALS_ASSIGN = "=";
    public static final String MODE_LEFT_PAR = "(";
    public static final String MODE_COMMENT_EXPRESSION = "comment expression";

    public static Pos createPos(int n, int n2, Object object) {
        return new Pos(n, n2, object);
    }

    public static Pos createPos(int n, int n2, int n3, int n4, Object object) {
        return new Pos(n, n2, n3, n4, object);
    }

    public static PObject[] vectorToPObjectArray(Vector vector) {
        PObject[] pObjectArray = new PObject[vector.size()];
        for (int i = 0; i < pObjectArray.length; ++i) {
            pObjectArray[i] = (PObject)vector.get(i);
        }
        return pObjectArray;
    }

    public static Vector removeSingleMissingArgList(GenParser genParser, Vector vector) {
        if (vector.size() != 1) {
            return vector;
        }
        PObject pObject = (PObject)vector.get(0);
        if (!(pObject = ParserUtil.extractCommentExpr(pObject)).poIsMissing()) {
            return vector;
        }
        return ParserUtil.createVector(null);
    }

    public static String[] extractNames(GenParser genParser, Vector vector, boolean bl) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            PObject pObject = (PObject)vector.get(i);
            if ((pObject = ParserUtil.extractCommentExpr(pObject)) != null) {
                if (pObject.poGetMode().equals(MODE_EQUALS_ASSIGN)) {
                    PObject pObject2 = pObject;
                    if (pObject2.poGetElement(0).poIsName()) {
                        string = pObject2.poGetElement(0).poGetName();
                    }
                } else if (bl) {
                    if (pObject.poIsName()) {
                        string = pObject.poGetName();
                    } else if (pObject.poIsString() && pObject.poGetLength() == 1) {
                        string = pObject.poGetStringElement(0);
                    }
                }
            }
            if (bl && (string == null || string.equals(""))) {
                ParserUtil.addParseError(genParser, "function arg name required", ParserUtil.getStartLine(pObject), ParserUtil.getStartColumn(pObject));
                string = "dummyArgName";
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static PObject[] extractExprs(GenParser genParser, Vector vector, boolean bl) {
        PObjectFactory pObjectFactory = genParser.m_pof;
        PObject[] pObjectArray = new PObject[vector.size()];
        try {
            for (int i = 0; i < pObjectArray.length; ++i) {
                PObject pObject = (PObject)vector.get(i);
                if ((pObject = ParserUtil.extractCommentExpr(pObject)) == null) {
                    pObject = pObjectFactory.pofCreateNull();
                } else if (pObject.poGetMode().equals(MODE_EQUALS_ASSIGN)) {
                    PObject pObject2 = pObject;
                    if (pObject2.poGetElement(0).poIsName()) {
                        pObject = pObject2.poGetElement(1);
                    }
                } else if (bl) {
                    if (pObject.poIsName()) {
                        pObject = pObjectFactory.pofCreateMissing();
                    } else if (pObject.poIsString() && pObject.poGetLength() == 1) {
                        pObject = pObjectFactory.pofCreateMissing();
                    }
                }
                pObjectArray[i] = pObject;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return pObjectArray;
    }

    public static PObject createBracketCall(GenParser genParser, String string, PObject pObject, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        stringArray2[0] = "";
        PObject[] pObjectArray2 = new PObject[pObjectArray.length + 1];
        System.arraycopy(pObjectArray, 0, pObjectArray2, 1, pObjectArray.length);
        pObjectArray2[0] = pObject;
        PObject pObject2 = ParserUtil.createName(genParser, string, n, n2);
        PObject pObject3 = ParserUtil.createCall(genParser, pObject2, stringArray2, pObjectArray2, n, n2, n3, n4);
        return pObject3;
    }

    public static PObject vectorToExpression(GenParser genParser, Vector vector) {
        PObject[] pObjectArray = ParserUtil.vectorToPObjectArray(vector);
        for (int i = 0; i < pObjectArray.length; ++i) {
            pObjectArray[i] = ParserUtil.extractCommentExpr(pObjectArray[i]);
        }
        if (pObjectArray.length == 1) {
            return pObjectArray[0];
        }
        PObject pObject = ParserUtil.createLanguage(genParser, "expression", pObjectArray);
        if (!genParser.m_addLimits) {
            return pObject;
        }
        PObject pObject2 = pObjectArray.length < 1 ? null : pObjectArray[0];
        PObject pObject3 = pObjectArray.length < 1 ? null : pObjectArray[pObjectArray.length - 1];
        return ParserUtil.addLimits(genParser, ParserUtil.createLanguage(genParser, "expression", pObjectArray), ParserUtil.getStartLine(pObject2), ParserUtil.getStartColumn(pObject2), ParserUtil.getEndLine(pObject3), ParserUtil.getEndColumn(pObject3));
    }

    public static String getNameOrStringAsString(PObject pObject) {
        if (pObject == null) {
            return null;
        }
        if (pObject.poIsName()) {
            return pObject.poGetName();
        }
        if (pObject.poIsString() && pObject.poGetLength() == 1) {
            return pObject.poGetStringElement(0);
        }
        return null;
    }

    public static boolean objectIsNameOrStringEqualTo(PObject pObject, String string) {
        String string2 = ParserUtil.getNameOrStringAsString(pObject);
        return string == null ? string2 == null : string.equals(string2);
    }

    public static void addToVector(Vector vector, Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                vector.addAll((Vector)object);
            } else {
                vector.add(object);
            }
        }
    }

    public static Vector createVector(Object object) {
        Vector vector = new Vector();
        ParserUtil.addToVector(vector, object);
        return vector;
    }

    public static Vector createVector(Object object, Object object2) {
        Vector vector = new Vector();
        ParserUtil.addToVector(vector, object);
        ParserUtil.addToVector(vector, object2);
        return vector;
    }

    public static PObject createDouble(GenParser genParser, Object object, int n, int n2) {
        Object object2;
        double d = 0.0;
        int n3 = 1;
        if (object != null && object instanceof String) {
            object2 = (String)object;
            n3 = ((String)object2).length();
            try {
                d = Double.parseDouble((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        object2 = genParser.m_pof.pofCreateDouble(d);
        return ParserUtil.addLimits(genParser, (PObject)object2, n, n2, n, n2 + n3 - 1);
    }

    public static PObject createComplex(GenParser genParser, Object object, int n, int n2) {
        PObject pObject = null;
        int n3 = 1;
        if (object != null && object instanceof String) {
            String string = (String)object;
            n3 = string.length();
            if (string.endsWith("i")) {
                string = string.substring(0, n3 - 1);
            }
            try {
                double d = Double.parseDouble(string);
                pObject = ParserUtil.createComplex(genParser, 0.0, d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pObject == null) {
            pObject = genParser.m_pof.pofCreateDouble(0.0);
        }
        return ParserUtil.addLimits(genParser, pObject, n, n2, n, n2 + n3 - 1);
    }

    public static void interpretStringCharacters(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        int n2 = 0;
        while ((n2 = stringBuffer.indexOf("\r", n2)) >= 0) {
            stringBuffer.deleteCharAt(n2);
            --n;
        }
        n2 = 0;
        while ((n2 = stringBuffer.indexOf("\\", n2)) >= 0) {
            if (n2 + 1 >= n) {
                stringBuffer.deleteCharAt(n2);
                --n;
                break;
            }
            char c = stringBuffer.charAt(n2 + 1);
            switch (c) {
                case 'n': {
                    c = '\n';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case '\\': {
                    break;
                }
                case '\'': {
                    break;
                }
                case '`': {
                    break;
                }
                case '\"': {
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (n2 + 3 >= n) break;
                    int n3 = c - 48;
                    int n4 = stringBuffer.charAt(n2 + 2) - 48;
                    int n5 = stringBuffer.charAt(n2 + 3) - 48;
                    c = (char)(n3 * 8 * 8 + n4 * 8 + n5);
                    stringBuffer.deleteCharAt(n2);
                    --n;
                    stringBuffer.deleteCharAt(n2);
                    --n;
                    break;
                }
            }
            stringBuffer.deleteCharAt(n2);
            --n;
            stringBuffer.deleteCharAt(n2);
            --n;
            stringBuffer.insert(n2, c);
            ++n;
            ++n2;
        }
    }

    public static PObject createString(GenParser genParser, String string, int n, int n2, int n3, int n4) {
        if (string == null) {
            string = "";
        }
        PObject pObject = genParser.m_pof.pofCreateString(new String[]{string});
        return ParserUtil.addLimits(genParser, pObject, n, n2, n3 < 0 ? n : n3, n4 < 0 ? n2 + string.length() - 1 : n4);
    }

    public static PObject createString(GenParser genParser, Pos pos) {
        PObject pObject = ParserUtil.createString(genParser, (String)pos.val, pos.line, pos.col, pos.line2, pos.col2);
        return pObject;
    }

    public static PObject createName(GenParser genParser, String string, int n, int n2, int n3, int n4) {
        if (string == null) {
            string = "";
        }
        PObject pObject = genParser.m_pof.pofCreateName(string);
        return ParserUtil.addLimits(genParser, pObject, n, n2, n3 < 0 ? n : n3, n4 < 0 ? n2 + string.length() - 1 : n4);
    }

    public static PObject createName(GenParser genParser, String string, int n, int n2) {
        return ParserUtil.createName(genParser, string, n, n2, -1, -1);
    }

    public static PObject createName(GenParser genParser, Pos pos) {
        PObject pObject = ParserUtil.createName(genParser, (String)pos.val, pos.line, pos.col, pos.line2, pos.col2);
        return pObject;
    }

    public static PObject createLanguage(GenParser genParser, String string, PObject pObject, int n, int n2, int n3, int n4) {
        return ParserUtil.createLanguage(genParser, string, new PObject[]{pObject}, n, n2, n3, n4);
    }

    public static PObject createLanguage(GenParser genParser, String string, PObject pObject, PObject pObject2, int n, int n2, int n3, int n4) {
        return ParserUtil.createLanguage(genParser, string, new PObject[]{pObject, pObject2}, n, n2, n3, n4);
    }

    public static PObject createLanguage(GenParser genParser, String string, PObject pObject, PObject pObject2, PObject pObject3, int n, int n2, int n3, int n4) {
        return ParserUtil.createLanguage(genParser, string, new PObject[]{pObject, pObject2, pObject3}, n, n2, n3, n4);
    }

    public static PObject createLanguage(GenParser genParser, String string, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        PObject pObject = ParserUtil.createLanguage(genParser, string, pObjectArray);
        return ParserUtil.addLimits(genParser, pObject, n, n2, n3, n4);
    }

    public static PObject createAssignment(GenParser genParser, String string, PObject pObject, PObject pObject2, int n, int n2, int n3, int n4) {
        PObject pObject3;
        Object object;
        if (pObject != null && pObject.poIsString() && pObject.poGetLength() == 1) {
            object = pObject.poGetStringElement(0);
            pObject3 = genParser.m_pof.pofCreateName((String)object);
            pObject = ParserUtil.addLimits(genParser, pObject3, ParserUtil.getStartLine(pObject), ParserUtil.getStartColumn(pObject), ParserUtil.getEndLine(pObject), ParserUtil.getEndColumn(pObject));
        }
        if (pObject2.poGetMode().equals(MODE_COMMENT_EXPRESSION)) {
            object = pObject2;
            pObject3 = object.poGetElement(0);
            PObject pObject4 = object.poGetElement(1);
            if (pObject4.poGetMode().equals("function")) {
                PObject pObject5 = pObject4;
                PObject pObject6 = pObject5.poGetElement(pObject5.poGetLength() - 1);
                String[] stringArray = new String[pObject5.poGetLength() - 1];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = pObject5.poGetName(i);
                }
                PObject[] pObjectArray = new PObject[pObject5.poGetLength() - 1];
                for (int i = 0; i < pObjectArray.length; ++i) {
                    pObjectArray[i] = pObject5.poGetElement(i);
                }
                PObject pObject7 = ParserUtil.createLanguage(genParser, MODE_COMMENT_EXPRESSION, pObject3, pObject6, ParserUtil.getStartLine(pObject5), ParserUtil.getStartColumn(pObject5), ParserUtil.getEndLine(pObject5), ParserUtil.getEndColumn(pObject5));
                pObject2 = ParserUtil.createFunction(genParser, stringArray, pObjectArray, pObject7);
                pObject2 = ParserUtil.addLimits(genParser, pObject2, ParserUtil.getStartLine(pObject5), ParserUtil.getStartColumn(pObject5), ParserUtil.getEndLine(pObject5), ParserUtil.getEndColumn(pObject5));
            } else {
                pObject2 = pObject4;
            }
        }
        return ParserUtil.createLanguage(genParser, string, new PObject[]{pObject, pObject2}, n, n2, n3, n4);
    }

    public static PObject createLeftBrace(GenParser genParser, Vector vector, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        if (pObjectArray.length > 0) {
            pObjectArray[0] = ParserUtil.createComment(genParser, vector, pObjectArray[0]);
        }
        PObject[] pObjectArray2 = ParserUtil.mergeLeftBraceElseObjects(genParser, pObjectArray);
        PObject pObject = ParserUtil.createLanguage(genParser, MODE_LEFT_BRACE, pObjectArray2, n, n2, n3, n4);
        return pObject;
    }

    public static Vector commentStringToVector(String string) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return vector;
        }
        string = string + "\n";
        int n = string.length();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = string.charAt(i);
            boolean bl2 = bl = c == '\n' || c == '\r';
            if (n2 < 0) {
                if (bl) continue;
                n2 = i;
                continue;
            }
            if (!bl) continue;
            vector.addElement(string.substring(n2, i));
            n2 = -1;
        }
        return vector;
    }

    public static PObject createComment(GenParser genParser, String string, PObject pObject) {
        return ParserUtil.createComment(genParser, ParserUtil.commentStringToVector(string), pObject);
    }

    public static PObject createComment(GenParser genParser, Vector vector, PObject pObject) {
        Object object;
        if (vector == null || vector.size() < 1) {
            return pObject;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        if (pObject == null) {
            pObject = genParser.m_pof.pofCreateMissing();
        } else if (pObject.poGetMode().equals(MODE_COMMENT_EXPRESSION)) {
            int n;
            PObject pObject2 = pObject.poGetElement(0);
            object = new String[pObject2.poGetLength() + stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                object[n] = stringArray[n];
            }
            for (n = 0; n < pObject2.poGetLength(); ++n) {
                object[n + stringArray.length] = pObject2.poGetStringElement(n);
            }
            stringArray = object;
            pObject = pObject.poGetElement(1);
        }
        PObject pObject3 = genParser.m_pof.pofCreateString(stringArray);
        object = ParserUtil.createLanguage(genParser, MODE_COMMENT_EXPRESSION, new PObject[]{pObject3, pObject});
        return ParserUtil.addLimits(genParser, (PObject)object, ParserUtil.getStartLine(pObject), ParserUtil.getStartColumn(pObject), ParserUtil.getEndLine(pObject), ParserUtil.getEndColumn(pObject));
    }

    public static PObject addLimits(GenParser genParser, PObject pObject, int n, int n2, int n3, int n4) {
        if (!genParser.m_addLimits) {
            return pObject;
        }
        PObject pObject2 = pObject;
        pObject2.poSetAttribute(START_LINE_ATTRIBUTE, genParser.m_pof.pofCreateDouble(n));
        pObject2.poSetAttribute(START_COLUMN_ATTRIBUTE, genParser.m_pof.pofCreateDouble(n2));
        pObject2.poSetAttribute(END_LINE_ATTRIBUTE, genParser.m_pof.pofCreateDouble(n3));
        pObject2.poSetAttribute(END_COLUMN_ATTRIBUTE, genParser.m_pof.pofCreateDouble(n4));
        return pObject2;
    }

    public static PObject addLimits(GenParser genParser, PObject pObject, PObject pObject2) {
        if (!genParser.m_addLimits) {
            return pObject2;
        }
        int n = ParserUtil.getStartLine(pObject);
        int n2 = ParserUtil.getStartColumn(pObject);
        int n3 = ParserUtil.getEndLine(pObject);
        int n4 = ParserUtil.getEndColumn(pObject);
        if (pObject2.poIsRecursive() && pObject2.poGetLength() > 0) {
            PObject pObject3 = pObject2.poGetElement(0);
            PObject pObject4 = pObject2.poGetElement(pObject2.poGetLength() - 1);
            if (!ParserUtil.unknownPositions(pObject3) && (ParserUtil.getStartLine(pObject3) < n || ParserUtil.getStartLine(pObject3) == n && ParserUtil.getStartColumn(pObject3) < n2)) {
                n = ParserUtil.getStartLine(pObject3);
                n2 = ParserUtil.getStartColumn(pObject3);
            }
            if (!ParserUtil.unknownPositions(pObject4) && (ParserUtil.getEndLine(pObject4) > n3 || ParserUtil.getEndLine(pObject4) == n3 && ParserUtil.getEndColumn(pObject4) > n4)) {
                n3 = ParserUtil.getEndLine(pObject4);
                n4 = ParserUtil.getEndColumn(pObject4);
            }
        }
        return ParserUtil.addLimits(genParser, pObject2, n, n2, n3, n4);
    }

    public static boolean unknownPositions(PObject pObject) {
        return ParserUtil.getStartLine(pObject) < 0 && ParserUtil.getStartColumn(pObject) < 0 && ParserUtil.getEndLine(pObject) < 0 && ParserUtil.getEndColumn(pObject) < 0;
    }

    public static int getStartLine(PObject pObject) {
        return ParserUtil.getIntAttribute(pObject, START_LINE_ATTRIBUTE);
    }

    public static int getStartColumn(PObject pObject) {
        return ParserUtil.getIntAttribute(pObject, START_COLUMN_ATTRIBUTE);
    }

    public static int getEndLine(PObject pObject) {
        return ParserUtil.getIntAttribute(pObject, END_LINE_ATTRIBUTE);
    }

    public static int getEndColumn(PObject pObject) {
        return ParserUtil.getIntAttribute(pObject, END_COLUMN_ATTRIBUTE);
    }

    public static int getIntAttribute(PObject pObject, String string) {
        PObject pObject2;
        PObject pObject3 = pObject2 = pObject == null ? null : pObject.poGetAttribute(string);
        if (pObject2 != null && pObject2.poIsDouble() && pObject2.poGetLength() > 0) {
            PObject pObject4 = pObject2;
            return (int)pObject4.poGetDoubleElement(0);
        }
        return -1;
    }

    public static void addUnmatchedElseError(GenParser genParser, PObject pObject) {
        ParserUtil.addParseError(genParser, "\"else\" with no preceding \"if\"", ParserUtil.getStartLine(pObject), ParserUtil.getStartColumn(pObject));
    }

    public static PObject[] mergeLeftBraceElseObjects(GenParser genParser, PObject[] pObjectArray) {
        PObjectFactory pObjectFactory = genParser.m_pof;
        Vector<PObject> vector = new Vector<PObject>(pObjectArray.length);
        boolean bl = false;
        for (int i = 0; i < pObjectArray.length; ++i) {
            PObject pObject;
            PObject pObject2;
            PObject pObject3;
            if (ParserUtil.extractCommentExpr(pObjectArray[i]).poIsMissing()) {
                bl = true;
                continue;
            }
            String string = pObjectArray[i].poGetMode();
            if (string.equals("else")) {
                bl = true;
                if (vector.isEmpty()) {
                    ParserUtil.addUnmatchedElseError(genParser, pObjectArray[i]);
                    continue;
                }
                pObject3 = (PObject)vector.elementAt(vector.size() - 1);
                vector.removeElementAt(vector.size() - 1);
                pObject2 = pObjectArray[i].poGetElement(0);
                pObject = ParserUtil.mergeElse(genParser, pObject3, pObject2);
                if (pObject == null) {
                    ParserUtil.addUnmatchedElseError(genParser, pObject2);
                    continue;
                }
                vector.add(pObject);
                continue;
            }
            if (string.equals(MODE_COMMENT_EXPRESSION)) {
                pObject3 = pObjectArray[i].poGetElement(0);
                pObject2 = pObjectArray[i].poGetElement(1);
                if (pObject2.poGetMode().equals("else")) {
                    bl = true;
                    if (vector.isEmpty()) {
                        ParserUtil.addUnmatchedElseError(genParser, pObject2);
                        continue;
                    }
                    pObject = (PObject)vector.elementAt(vector.size() - 1);
                    vector.removeElementAt(vector.size() - 1);
                    PObject pObject4 = pObject2.poGetElement(0);
                    PObject pObject5 = ParserUtil.mergeElse(genParser, pObject, pObject4);
                    if (pObject5 == null) {
                        ParserUtil.addUnmatchedElseError(genParser, pObject4);
                        continue;
                    }
                    PObject pObject6 = ParserUtil.addLimits(genParser, pObject5, ParserUtil.createLanguage(genParser, MODE_COMMENT_EXPRESSION, new PObject[]{pObject3, pObject5}));
                    vector.add(pObject6);
                    continue;
                }
                vector.add(pObjectArray[i]);
                continue;
            }
            vector.add(pObjectArray[i]);
        }
        if (!bl) {
            return pObjectArray;
        }
        PObject[] pObjectArray2 = new PObject[vector.size()];
        for (int i = 0; i < pObjectArray2.length; ++i) {
            pObjectArray2[i] = (PObject)vector.elementAt(i);
        }
        return pObjectArray2;
    }

    public static PObject mergeElse(GenParser genParser, PObject pObject, PObject pObject2) {
        PObjectFactory pObjectFactory = genParser.m_pof;
        String string = pObject.poGetMode();
        PObject pObject3 = pObject.poIsRecursive() ? pObject : null;
        PObject pObject4 = null;
        if (string.equals("if")) {
            if (pObject.poGetLength() == 2) {
                pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(1), pObject2);
                if (pObject4 == null) {
                    return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, "if", new PObject[]{pObject3.poGetElement(0), pObject3.poGetElement(1), pObject2}));
                }
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, "if", new PObject[]{pObject3.poGetElement(0), pObject4}));
            }
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(2), pObject2);
            if (pObject4 != null) {
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, "if", new PObject[]{pObject3.poGetElement(0), pObject3.poGetElement(1), pObject4}));
            }
        } else if (string.equals("for")) {
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(2), pObject2);
            if (pObject4 != null) {
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.copyNames(ParserUtil.createLanguage(genParser, "for", new PObject[]{pObject3.poGetElement(0), pObject3.poGetElement(1), pObject4}), pObject3));
            }
        } else if (string.equals("repeat")) {
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(0), pObject2);
            if (pObject4 != null) {
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, "repeat", new PObject[]{pObject4}));
            }
        } else if (string.equals("while")) {
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(1), pObject2);
            if (pObject4 != null) {
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, "while", new PObject[]{pObject3.poGetElement(0), pObject4}));
            }
        } else if (string.equals(MODE_EQUALS_ASSIGN)) {
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(1), pObject2);
            if (pObject4 != null) {
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, MODE_EQUALS_ASSIGN, new PObject[]{pObject3.poGetElement(0), pObject4}));
            }
        } else if (string.equals(MODE_LEFT_ARROW)) {
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(1), pObject2);
            if (pObject4 != null) {
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, MODE_LEFT_ARROW, new PObject[]{pObject3.poGetElement(0), pObject4}));
            }
        } else if (string.equals(MODE_DOUBLE_LEFT_ARROW)) {
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(1), pObject2);
            if (pObject4 != null) {
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, MODE_DOUBLE_LEFT_ARROW, new PObject[]{pObject3.poGetElement(0), pObject4}));
            }
        } else if (string.equals("function")) {
            pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(pObject3.poGetLength() - 1), pObject2);
            if (pObject4 != null) {
                PObject[] pObjectArray = new PObject[pObject3.poGetLength() - 1];
                String[] stringArray = new String[pObject3.poGetLength() - 1];
                for (int i = 0; i < pObjectArray.length; ++i) {
                    pObjectArray[i] = pObject3.poGetElement(i);
                    stringArray[i] = pObject3.poGetName(i);
                }
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createFunction(genParser, stringArray, pObjectArray, pObject4));
            }
        } else if (string.equals("call")) {
            String string2;
            if (pObject3.poGetElement(0).poIsName() && ParserUtil.isOperatorName(string2 = pObject3.poGetElement(0).poGetName(), pObject3.poGetLength()) && (pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(pObject3.poGetLength() - 1), pObject2)) != null) {
                PObject[] pObjectArray = new PObject[pObject3.poGetLength() - 1];
                String[] stringArray = new String[pObject3.poGetLength() - 1];
                for (int i = 0; i < pObjectArray.length; ++i) {
                    pObjectArray[i] = pObject3.poGetElement(i + 1);
                    stringArray[i] = pObject3.poGetName(i + 1);
                }
                pObjectArray[pObjectArray.length - 1] = pObject4;
                return ParserUtil.addLimits(genParser, pObject, ParserUtil.createCall(genParser, pObject3.poGetElement(0), stringArray, pObjectArray));
            }
        } else if (string.equals(MODE_COMMENT_EXPRESSION) && (pObject4 = ParserUtil.mergeElse(genParser, pObject3.poGetElement(1), pObject2)) != null) {
            return ParserUtil.addLimits(genParser, pObject, ParserUtil.createLanguage(genParser, MODE_COMMENT_EXPRESSION, new PObject[]{pObject3.poGetElement(0), pObject4}));
        }
        return null;
    }

    public static boolean isOperatorName(String string, int n) {
        if (string == null || string.length() < 1) {
            return false;
        }
        char c = string.charAt(0);
        char c2 = string.length() > 1 ? string.charAt(1) : (char)'\u0000';
        char c3 = string.length() > 2 ? string.charAt(2) : (char)'\u0000';
        switch (c) {
            case '+': 
            case '-': 
            case '?': {
                if (c2 != '\u0000') {
                    return false;
                }
                switch (n) {
                    case 2: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
            case ':': {
                if (n != 3) {
                    return false;
                }
                if (c2 == '\u0000') {
                    return true;
                }
                if (c2 == ':' && c3 == '\u0000') {
                    return true;
                }
                return c2 == ':' && c3 == ':' && string.length() == 3;
            }
            case '/': {
                return n == 3 && c2 == '\u0000';
            }
            case '^': {
                return n == 3 && c2 == '\u0000';
            }
            case '[': {
                if (n > 1 && c2 == '\u0000') {
                    return true;
                }
                if (n > 1 && c2 == '[' && c3 == '\u0000') {
                    return true;
                }
                if (n > 2 && ParserUtil.isOperatorArrow(string, 1)) {
                    return true;
                }
                return n > 2 && c2 == '[' && ParserUtil.isOperatorArrow(string, 2);
            }
            case '$': 
            case '@': {
                return n == 3 && c2 == '\u0000';
            }
            case '%': {
                return n == 3 && string.charAt(string.length() - 1) == '%';
            }
            case '*': {
                switch (c2) {
                    case '\u0000': {
                        return n == 3;
                    }
                    case '*': {
                        return n == 3 && c3 == '\u0000';
                    }
                }
                return false;
            }
            case '=': {
                if (c2 == '\u0000') {
                    return true;
                }
                if (c2 != '=' || c3 != '\u0000') break;
                return true;
            }
            case '>': {
                if ((n != 3 || c2 != '\u0000') && (c2 != '=' || c3 != '\u0000')) break;
                return true;
            }
            case '!': {
                if (n > 1 && c2 == '\u0000') {
                    return true;
                }
                if (n != 3 || c2 != '=' || c3 != '\u0000') break;
                return true;
            }
            case '<': {
                switch (c2) {
                    case '\u0000': {
                        return true;
                    }
                    case '=': {
                        return n == 3 && c3 == '\u0000';
                    }
                    case '-': {
                        return n == 3 && c3 == '\u0000';
                    }
                    case '<': {
                        return n == 3 && c3 == '-' && string.length() == 3;
                    }
                }
            }
            case '~': {
                return n > 1 && c2 == '\u0000';
            }
            case '(': {
                return n == 3 && c2 == '\u0000';
            }
            case '&': 
            case '|': {
                return n == 3 && (c2 == '\u0000' || c2 == c && c3 == '\u0000');
            }
            case ',': {
                return n == 3 && ParserUtil.isOperatorArrow(string, 1);
            }
        }
        return false;
    }

    public static boolean isOperatorArrow(String string, int n) {
        return string.charAt(n) == '<' && (string.length() == n + 2 && string.charAt(n + 1) == '-' || string.length() == n + 3 && string.charAt(n + 1) == '<' && string.charAt(n + 2) == '-');
    }

    public static PObject createFunction(GenParser genParser, String string, String[] stringArray, PObject[] pObjectArray, PObject pObject, int n, int n2, int n3, int n4) {
        pObject = ParserUtil.extractCommentExpr(pObject);
        if (string != null) {
            pObject = ParserUtil.createComment(genParser, string, pObject);
        }
        PObject pObject2 = ParserUtil.createFunction(genParser, stringArray, pObjectArray, pObject);
        return ParserUtil.addLimits(genParser, pObject2, n, n2, n3, n4);
    }

    public static PObject extractCommentExpr(PObject pObject) {
        if (pObject == null) {
            return null;
        }
        if (pObject.poGetMode().equals(MODE_COMMENT_EXPRESSION)) {
            return pObject.poGetElement(1);
        }
        return pObject;
    }

    public static PObject createMissing(GenParser genParser) {
        PObject pObject = genParser.m_pof.pofCreateMissing();
        return pObject;
    }

    public static PObject createUnsupportedInternalCall(GenParser genParser, String string, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        return ParserUtil.createUnsupportedInternalCall(genParser, string, null, pObjectArray, n, n2, n3, n4);
    }

    public static PObject createUnsupportedInternalCall(GenParser genParser, String string, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        PObject pObject = genParser.m_pof.pofCreateRecursive(string, stringArray, pObjectArray);
        return ParserUtil.addLimits(genParser, pObject, n, n2, n3, n4);
    }

    public static PObject createDotJCall(GenParser genParser, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        PObject pObject = genParser.m_pof.pofCreateRecursive(".JCall", stringArray, pObjectArray);
        return ParserUtil.addLimits(genParser, pObject, n, n2, n3, n4);
    }

    public static PObject createDotJPrimitive(GenParser genParser, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        PObject pObject = genParser.m_pof.pofCreateRecursive(".JPrimitive", stringArray, pObjectArray);
        return ParserUtil.addLimits(genParser, pObject, n, n2, n3, n4);
    }

    public static PObject createCall(GenParser genParser, String string, PObject pObject, PObject pObject2, int n, int n2, int n3, int n4) {
        return ParserUtil.createCall(genParser, genParser.m_pof.pofCreateName(string), null, new PObject[]{pObject, pObject2}, n, n2, n3, n4);
    }

    public static PObject createCall(GenParser genParser, String string, PObject pObject, int n, int n2, int n3, int n4) {
        return ParserUtil.createCall(genParser, genParser.m_pof.pofCreateName(string), null, new PObject[]{pObject}, n, n2, n3, n4);
    }

    public static PObject createCall(GenParser genParser, PObject pObject, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        if (pObject.poIsString() && pObject.poGetLength() == 1) {
            pObject = ParserUtil.createName(genParser, pObject.poGetStringElement(0), ParserUtil.getStartLine(pObject), ParserUtil.getStartColumn(pObject));
        }
        if (pObjectArray.length == 1 && (stringArray == null || stringArray.length < 1 || stringArray[0].equals("")) && pObjectArray[0].poIsMissing()) {
            stringArray = null;
            pObjectArray = new PObject[]{};
        }
        PObject pObject2 = ParserUtil.createCall(genParser, pObject, stringArray, pObjectArray);
        pObject2 = ParserUtil.addLimits(genParser, pObject2, n, n2, n3, n4);
        for (int i = 0; i < pObjectArray.length; ++i) {
            if (!pObjectArray[i].poIsName() || !pObjectArray[i].poGetName().equals("...")) continue;
            pObject2 = ParserUtil.createLanguage(genParser, MODE_CALL_WITH_THREE_DOTS, new PObject[]{pObject2});
            pObject2 = ParserUtil.addLimits(genParser, pObject2, n, n2, n3, n4);
            break;
        }
        return pObject2;
    }

    public static PObject nameToString(GenParser genParser, PObject pObject) {
        if (!pObject.poIsName()) {
            return pObject;
        }
        PObject pObject2 = genParser.m_pof.pofCreateString(new String[]{pObject.poGetName()});
        return ParserUtil.addLimits(genParser, pObject2, ParserUtil.getStartLine(pObject), ParserUtil.getStartColumn(pObject), ParserUtil.getEndLine(pObject), ParserUtil.getEndColumn(pObject));
    }

    public static PObject stringToName(GenParser genParser, PObject pObject) {
        if (!pObject.poIsString() || pObject.poGetLength() > 1) {
            return pObject;
        }
        PObject pObject2 = genParser.m_pof.pofCreateName(pObject.poGetStringElement(0));
        return ParserUtil.addLimits(genParser, pObject2, ParserUtil.getStartLine(pObject), ParserUtil.getStartColumn(pObject), ParserUtil.getEndLine(pObject), ParserUtil.getEndColumn(pObject));
    }

    public static PObject createFor(GenParser genParser, PObject pObject, PObject pObject2, PObject pObject3, int n, int n2, int n3, int n4) {
        String string = pObject.poGetName();
        PObject pObject4 = ParserUtil.createLanguage(genParser, "for", new PObject[]{genParser.m_pof.pofCreateNull(), pObject2, pObject3});
        pObject4.poSetName(0, string);
        return ParserUtil.addLimits(genParser, pObject4, n, n2, n3, n4);
    }

    public static PObject createDotCall(GenParser genParser, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        boolean bl;
        int n5;
        String string = null;
        if (pObjectArray.length > 0 && pObjectArray[0].poIsString() && pObjectArray[0].poGetLength() == 1) {
            string = pObjectArray[0].poGetStringElement(0);
        } else if (pObjectArray.length > 0 && pObjectArray[0].poIsName()) {
            string = pObjectArray[0].poGetName();
        } else {
            ParserUtil.addParseError(genParser, "bad first argument to .Call", n, n2);
            return ParserUtil.createMissing(genParser);
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i < pObjectArray.length; ++i) {
            vector.add(stringArray != null && i < stringArray.length ? stringArray[i] : "");
        }
        Vector<PObject> vector2 = new Vector<PObject>();
        for (n5 = 1; n5 < pObjectArray.length; ++n5) {
            vector2.add(pObjectArray[n5]);
        }
        n5 = vector.indexOf("COPY");
        PObject pObject = null;
        if (n5 >= 0) {
            pObject = (PObject)vector2.remove(n5);
            vector.remove(n5);
        }
        int n6 = vector.indexOf("CLASSES");
        PObject pObject2 = null;
        if (n6 >= 0) {
            pObject2 = (PObject)vector2.remove(n6);
            vector.remove(n6);
        }
        int n7 = vector.indexOf("PACKAGE");
        PObject pObject3 = null;
        if (n7 >= 0) {
            pObject3 = (PObject)vector2.remove(n7);
            vector.remove(n7);
        }
        vector.insertElementAt(string, 0);
        vector2.insertElementAt(genParser.m_pof.pofCreateMissing(), 0);
        boolean bl2 = bl = n5 >= 0 || n6 >= 0 || n7 >= 0;
        if (bl) {
            vector.add("COPY");
            vector2.add(pObject == null ? genParser.m_pof.pofCreateNull() : pObject);
            vector.add("CLASSES");
            vector2.add(pObject2 == null ? genParser.m_pof.pofCreateNull() : pObject2);
            if (n7 >= 0) {
                vector.add("PACKAGE");
                vector2.add(pObject3 == null ? genParser.m_pof.pofCreateNull() : pObject3);
            }
        }
        String[] stringArray2 = new String[vector2.size()];
        PObject[] pObjectArray2 = new PObject[vector2.size()];
        for (int i = 0; i < pObjectArray2.length; ++i) {
            stringArray2[i] = (String)vector.get(i);
            pObjectArray2[i] = (PObject)vector2.get(i);
        }
        PObject pObject4 = genParser.m_pof.pofCreateRecursive(".Call", stringArray2, pObjectArray2);
        return ParserUtil.addLimits(genParser, pObject4, n, n2, n3, n4);
    }

    public static PObject createDotInternal(GenParser genParser, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        String string;
        if (pObjectArray.length < 2) {
            pObjectArray = new PObject[]{pObjectArray.length > 0 && pObjectArray[0] != null ? pObjectArray[0] : ParserUtil.createString(genParser, "Unspecified .Internal expression", -1, -1, -1, -1), ParserUtil.createString(genParser, "Unspecified .Internal entry point", -1, -1, -1, -1)};
        }
        if (stringArray == null || stringArray.length < 2 || stringArray[1] == null || stringArray[1].equals("")) {
            string = null;
            if (pObjectArray[1].poIsName()) {
                string = pObjectArray[1].poGetName();
            } else if (pObjectArray[1].poIsString() && pObjectArray[1].poGetLength() == 1) {
                string = pObjectArray[1].poGetStringElement(0);
            } else {
                ParserUtil.addParseError(genParser, ".Internal 2nd argument must be name or string", n, n2);
                return ParserUtil.createMissing(genParser);
            }
            if (stringArray == null) {
                stringArray = new String[pObjectArray.length];
            } else if (stringArray.length < 2) {
                stringArray = new String[]{stringArray.length < 1 ? "" : stringArray[0], ""};
            }
            stringArray[1] = string;
        }
        pObjectArray[1] = genParser.m_pof.pofCreateMissing();
        if (pObjectArray.length > 2) {
            double d;
            if (pObjectArray[2].poIsName()) {
                string = pObjectArray[2].poGetName();
                if (string.equals("T") || string.equals("TRUE")) {
                    pObjectArray[2] = genParser.m_pof.pofCreateLogical(true);
                } else if (string.equals("F") || string.equals("FALSE")) {
                    pObjectArray[2] = genParser.m_pof.pofCreateLogical(false);
                }
            } else if (pObjectArray[2].poIsDouble() && pObjectArray[2].poGetLength() == 1 && !Double.isNaN(d = pObjectArray[2].poGetDoubleElement(0))) {
                pObjectArray[2] = d == 0.0 ? genParser.m_pof.pofCreateLogical(false) : genParser.m_pof.pofCreateLogical(true);
            }
        }
        PObject pObject = genParser.m_pof.pofCreateRecursive("internal", stringArray, pObjectArray);
        return ParserUtil.addLimits(genParser, pObject, n, n2, n3, n4);
    }

    public static PObject createDotS(GenParser genParser, String[] stringArray, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        if (pObjectArray.length < 1) {
            ParserUtil.addParseError(genParser, ".S wrong number arguments", n, n2);
            return ParserUtil.createMissing(genParser);
        }
        PObject pObject = pObjectArray[0];
        if (pObject.poGetMode().equals(MODE_CALL_WITH_THREE_DOTS)) {
            pObject = pObject.poGetElement(0);
        }
        if (!pObject.poGetMode().equals("call") || pObject.poGetLength() < 1) {
            ParserUtil.addParseError(genParser, ".S bad first argument", n, n2);
            return ParserUtil.createMissing(genParser);
        }
        PObject pObject2 = pObject;
        PObject pObject3 = pObject2.poGetElement(0);
        String string = ParserUtil.getNameOrStringAsString(pObject3);
        String string2 = null;
        if (string2 == null && stringArray.length > 1 && stringArray[1] != null && !stringArray[1].equals("")) {
            string2 = stringArray[1];
        }
        if (string2 == null && pObjectArray.length > 1) {
            string2 = ParserUtil.getNameOrStringAsString(pObjectArray[1]);
            if (string2 == null) {
                ParserUtil.addParseError(genParser, ".S bad second argument", n, n2);
                return ParserUtil.createMissing(genParser);
            }
            if (string2.equals("")) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        if (string2 == null) {
            ParserUtil.addParseError(genParser, ".S bad entry name", n, n2);
            return ParserUtil.createMissing(genParser);
        }
        if (string2 != null && (string2 = "z" + string2).length() > 6) {
            string2 = string2.substring(0, 6);
        }
        String[] stringArray2 = new String[pObject2.poGetLength()];
        PObject[] pObjectArray2 = new PObject[pObject2.poGetLength()];
        stringArray2[0] = "";
        pObjectArray2[0] = genParser.m_pof.pofCreateString(new String[]{string2});
        for (int i = 1; i < stringArray2.length; ++i) {
            stringArray2[i] = pObject2.poGetName(i);
            pObjectArray2[i] = pObject2.poGetElement(i);
        }
        PObject pObject4 = ParserUtil.createCall(genParser, pObject3, stringArray2, pObjectArray2, ParserUtil.getStartLine(pObject2), ParserUtil.getStartColumn(pObject2), ParserUtil.getEndLine(pObject2), ParserUtil.getEndColumn(pObject2));
        String[] stringArray3 = new String[]{"", "call_S_Version2"};
        PObject[] pObjectArray3 = new PObject[]{pObject4, ParserUtil.createMissing(genParser)};
        PObject pObject5 = ParserUtil.createDotInternal(genParser, stringArray3, pObjectArray3, n, n2, n3, n4);
        return pObject5;
    }

    public static PObject createReturn(GenParser genParser, PObject[] pObjectArray, int n, int n2, int n3, int n4) {
        String[] stringArray = null;
        boolean bl = false;
        if (pObjectArray.length > 1) {
            stringArray = new String[pObjectArray.length];
            for (int i = 0; i < pObjectArray.length; ++i) {
                if (pObjectArray[i].poIsName() && (stringArray[i] == null || stringArray[i].equals(""))) {
                    stringArray[i] = pObjectArray[i].poGetName();
                    bl = true;
                    continue;
                }
                stringArray[i] = "";
            }
        }
        PObject pObject = ParserUtil.createLanguage(genParser, "return", pObjectArray, n, n2, n3, n4);
        if (bl) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                pObject.poSetName(i, stringArray[i]);
            }
        }
        return pObject;
    }

    public static double getComplexReal(PObject pObject) {
        PObject pObject2;
        if (pObject.poGetMode().equals("complex") && pObject.poIsRecursive() && pObject.poGetLength() == 2 && (pObject2 = pObject.poGetElement(0)).poIsDouble() && pObject2.poGetLength() > 0) {
            return pObject2.poGetDoubleElement(0);
        }
        return 0.0;
    }

    public static double getComplexImag(PObject pObject) {
        PObject pObject2;
        if (pObject.poGetMode().equals("complex") && pObject.poIsRecursive() && pObject.poGetLength() == 2 && (pObject2 = pObject.poGetElement(1)).poIsDouble() && pObject2.poGetLength() > 0) {
            return pObject2.poGetDoubleElement(0);
        }
        return 0.0;
    }

    public static PObject createComplex(GenParser genParser, double d, double d2) {
        return genParser.m_pof.pofCreateRecursive("complex", null, new PObject[]{genParser.m_pof.pofCreateDouble(d), genParser.m_pof.pofCreateDouble(d2)});
    }

    public static PObject copyNames(PObject pObject, PObject pObject2) {
        int n;
        int n2 = pObject.poGetLength();
        if (n2 > (n = pObject2.poGetLength())) {
            n2 = n;
        }
        for (int i = 0; i < n2; ++i) {
            pObject.poSetName(i, pObject2.poGetName(i));
        }
        return pObject;
    }

    public static PObject createOpCall(GenParser genParser, Pos pos, PObject pObject, PObject pObject2, int n, int n2, int n3, int n4) {
        PObject pObject3;
        String string = (String)pos.val;
        PObject pObject4 = ParserUtil.createName(genParser, pos);
        if (pObject == null) {
            if (string.equals("+") || string.equals("-")) {
                if (pObject2.poIsDouble() && pObject2.poGetLength() == 1) {
                    double d = pObject2.poGetDoubleElement(0);
                    if (string.equals("-")) {
                        d = -d;
                    }
                    return ParserUtil.addLimits(genParser, genParser.m_pof.pofCreateDouble(d), n, n2, n3, n4);
                }
                if (pObject2.poGetMode().equals("complex")) {
                    double d = ParserUtil.getComplexReal(pObject2);
                    double d2 = ParserUtil.getComplexImag(pObject2);
                    if (string.equals("-")) {
                        d = -d;
                        d2 = -d2;
                    }
                    return ParserUtil.addLimits(genParser, ParserUtil.createComplex(genParser, d, d2), n, n2, n3, n4);
                }
            }
            PObject pObject5 = ParserUtil.createCall(genParser, pObject4, null, new PObject[]{pObject2});
            return ParserUtil.addLimits(genParser, pObject5, n, n2, n3, n4);
        }
        if (string != null && (string.equals("+") || string.equals("-")) && pObject.poIsDouble() && pObject.poGetLength() == 1 && pObject2.poGetMode().equals("complex")) {
            double d = pObject.poGetDoubleElement(0);
            double d3 = ParserUtil.getComplexReal(pObject2);
            double d4 = ParserUtil.getComplexImag(pObject2);
            if (d3 == 0.0) {
                double d5 = d;
                double d6 = d4;
                if (string.equals("-")) {
                    d6 = -d6;
                }
                PObject pObject6 = ParserUtil.createComplex(genParser, d5, d6);
                return ParserUtil.addLimits(genParser, pObject6, n, n2, n3, n4);
            }
        }
        if ((pObject3 = ParserUtil.createCall(genParser, pObject4, null, new PObject[]{pObject, pObject2}, n, n2, n3, n4)).poGetMode().equals(MODE_CALL_WITH_THREE_DOTS)) {
            pObject3 = pObject3.poGetElement(0);
        }
        return pObject3;
    }

    public static PObject createLanguage(GenParser genParser, String string, PObject[] pObjectArray) {
        PObject pObject = genParser.m_pof.pofCreateRecursive(string, null, pObjectArray);
        return pObject;
    }

    public static PObject createFunction(GenParser genParser, String[] stringArray, PObject[] pObjectArray, PObject pObject) {
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = "";
        }
        PObject[] pObjectArray2 = new PObject[pObjectArray.length + 1];
        System.arraycopy(pObjectArray, 0, pObjectArray2, 0, pObjectArray.length);
        pObjectArray2[pObjectArray.length] = pObject;
        PObject pObject2 = genParser.m_pof.pofCreateRecursive("function", stringArray2, pObjectArray2);
        return pObject2;
    }

    public static PObject createCall(GenParser genParser, PObject pObject, String[] stringArray, PObject[] pObjectArray) {
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray2[0] = "";
        }
        PObject[] pObjectArray2 = new PObject[pObjectArray.length + 1];
        System.arraycopy(pObjectArray, 0, pObjectArray2, 1, pObjectArray.length);
        pObjectArray2[0] = pObject;
        PObject pObject2 = genParser.m_pof.pofCreateRecursive("call", stringArray2, pObjectArray2);
        return pObject2;
    }

    public static void addParseError(GenParser genParser, String string, int n, int n2) {
        genParser.report_error(string, new Pos(n, n2, null));
    }

    public static class Pos {
        public int line = -1;
        public int col = -1;
        public int line2 = -1;
        public int col2 = -1;
        public Object val = null;

        public Pos(int n, int n2, Object object) {
            this(n, n2, -1, -1, object);
        }

        public Pos(int n, int n2, int n3, int n4, Object object) {
            this.line = n;
            this.col = n2;
            this.line2 = n3;
            this.col2 = n4;
            this.val = object;
        }
    }
}

