/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.record;

import com.insightful.splus.SplusSystem;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class UserInputRecorder {
    private Point frameLocation;
    private Dimension frameSize;
    private boolean isRunningFlag = false;
    private LocalAWTEventListener eventListener = null;
    private static final long EVENT_MASK = 24L;
    private static final int BUTTON_MASK = 28;
    private static final int KEY_MASK = 47;

    public UserInputRecorder(Frame frame) {
        if (frame == null) {
            this.frameLocation = new Point();
            this.frameSize = new Dimension();
        } else {
            this.frameLocation = frame.getLocationOnScreen();
            this.frameSize = frame.getSize();
        }
    }

    public void start() {
        if (!this.isRunning()) {
            this.eventListener = new LocalAWTEventListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.eventListener, 24L);
            this.setRunning(true);
        }
    }

    public void stop() {
        if (this.isRunning()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.eventListener);
            this.setRunning(false);
        }
    }

    public synchronized boolean isRunning() {
        return this.isRunningFlag;
    }

    private synchronized void setRunning(boolean bl) {
        this.isRunningFlag = bl;
    }

    public void save(String string) throws IOException {
        if (this.isRunning()) {
            this.stop();
        }
        FileOutputStream fileOutputStream = SplusSystem.getServerFileHandler().getServerFileOutputStream(string);
        byte[] byArray = System.getProperty("line.separator", "\n").getBytes();
        String string2 = "<UserInputRecording VERSION=\"1.0\" FRAMEWIDTH=\"" + this.frameSize.width + "\" FRAMEHEIGHT=\"" + this.frameSize.height + "\">";
        fileOutputStream.write(string2.getBytes());
        fileOutputStream.write(byArray);
        if (this.eventListener != null) {
            Vector vector = this.eventListener.getEventList();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                fileOutputStream.write(((String)enumeration.nextElement()).getBytes());
                fileOutputStream.write(byArray);
            }
        }
        fileOutputStream.write(new String("</UserInputRecording>").getBytes());
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    private class LocalAWTEventListener
    implements AWTEventListener {
        private long lastTime = System.currentTimeMillis();
        private Vector eventList = new Vector();
        private Vector downKeys = new Vector();
        private boolean altDown = false;
        private boolean altGraphDown = false;
        private boolean ctrlDown = false;
        private boolean metaDown = false;
        private boolean shiftDown = false;

        private LocalAWTEventListener() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            Object var2_2 = null;
            int n = aWTEvent.getID();
            block0 : switch (n) {
                case 401: 
                case 402: {
                    int n2 = ((KeyEvent)aWTEvent).getKeyCode();
                    switch (n2) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 157: 
                        case 65406: {
                            break block0;
                        }
                    }
                    Integer n3 = new Integer(n2);
                    boolean bl = false;
                    int n4 = -1;
                    for (int i = 0; !bl && i < this.downKeys.size(); ++i) {
                        if (!n3.equals(this.downKeys.get(i))) continue;
                        bl = true;
                        n4 = i;
                    }
                    if (!bl && n == 401) {
                        this.addEvent("<D MS=\"" + this.getDelay() + "\"/>");
                        this.checkModifiers((InputEvent)aWTEvent);
                        this.addEvent("<KP KEYCODE=\"" + n2 + "\"/>");
                        this.downKeys.add(n3);
                        break;
                    }
                    if (!bl || n != 402) break;
                    this.addEvent("<KR KEYCODE=\"" + n2 + "\"/>");
                    this.downKeys.remove(n4);
                    break;
                }
                case 501: {
                    Point point = ((MouseEvent)aWTEvent).getPoint();
                    Point point2 = ((MouseEvent)aWTEvent).getComponent().getLocationOnScreen();
                    int n5 = point2.x + point.x - ((UserInputRecorder)UserInputRecorder.this).frameLocation.x;
                    int n6 = point2.y + point.y - ((UserInputRecorder)UserInputRecorder.this).frameLocation.y;
                    int n7 = ((InputEvent)aWTEvent).getModifiers() & 0x1C;
                    this.addEvent("<D MS=\"" + this.getDelay() + "\"/>");
                    this.checkModifiers((InputEvent)aWTEvent);
                    this.addEvent("<MM X=\"" + n5 + "\" Y=\"" + n6 + "\"/>");
                    this.addEvent("<MP BUTTONS=\"" + n7 + "\"/>");
                    break;
                }
                case 502: {
                    int n8 = ((InputEvent)aWTEvent).getModifiers() & 0x1C;
                    this.addEvent("<MR BUTTONS=\"" + n8 + "\"/>");
                }
            }
        }

        public Vector getEventList() {
            return this.eventList;
        }

        private long getDelay() {
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            this.lastTime = l;
            return l2;
        }

        private void addEvent(String string) {
            this.eventList.add(string);
        }

        private void checkModifiers(InputEvent inputEvent) {
            if (inputEvent.isAltDown()) {
                if (!this.altDown) {
                    this.addEvent("<KP KEYCODE=\"18\"/>");
                    this.altDown = true;
                }
            } else if (this.altDown) {
                this.addEvent("<KR KEYCODE=\"18\"/>");
                this.altDown = false;
            }
            if (inputEvent.isAltGraphDown()) {
                if (!this.altGraphDown) {
                    this.addEvent("<KP KEYCODE=\"65406\"/>");
                    this.altGraphDown = true;
                }
            } else if (this.altGraphDown) {
                this.addEvent("<KR KEYCODE=\"65406\"/>");
                this.altGraphDown = false;
            }
            if (inputEvent.isControlDown()) {
                if (!this.ctrlDown) {
                    this.addEvent("<KP KEYCODE=\"17\"/>");
                    this.ctrlDown = true;
                }
            } else if (this.ctrlDown) {
                this.addEvent("<KR KEYCODE=\"17\"/>");
                this.ctrlDown = false;
            }
            if (inputEvent.isMetaDown()) {
                if (!this.metaDown) {
                    this.addEvent("<KP KEYCODE=\"157\"/>");
                    this.metaDown = true;
                }
            } else if (this.metaDown) {
                this.addEvent("<KR KEYCODE=\"157\"/>");
                this.metaDown = false;
            }
            if (inputEvent.isShiftDown()) {
                if (!this.shiftDown) {
                    this.addEvent("<KP KEYCODE=\"16\"/>");
                    this.shiftDown = true;
                }
            } else if (this.shiftDown) {
                this.addEvent("<KR KEYCODE=\"16\"/>");
                this.shiftDown = false;
            }
        }
    }
}

