/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusIntegerSpinner;
import com.insightful.controls.SplusTextField;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusObjectComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class QualityControlUngroupedDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataColumnComboBox dataColumn;
    SplusComboBox calibrationType;
    SplusComboBox chartType;
    SplusComboBox savedObject;
    SplusComboBox limitsType;
    SplusComboBox averagingMethod;
    SplusComboBox sigmaMethod;
    SplusCheckBox capabilitySummary;
    SplusCheckBox plotShewhart;
    SplusCheckBox includeStats;
    SplusCheckBox includeCalib;
    SplusTextField capabilityRange;
    SplusTextField capabilityMin;
    SplusTextField capabilityMax;
    SplusTextField targetOverride;
    SplusTextField stdDevOverride;
    SplusTextField confLevel;
    SplusTextField numSigmas;
    SplusTextField lowerLimit;
    SplusTextField upperLimit;
    SplusTextField sigmaSpan;
    SplusTextField statSpan;
    SplusTextField expWeight;
    SplusIntegerSpinner maxRunLength;

    public QualityControlUngroupedDialog() {
        super("Quality Control Charts (Continuous Ungrouped)");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuQccUngrouped");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(1);
        Box box2 = new Box(1);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "df");
        this.dataColumn = new SplusDataColumnComboBox("Variable", 'V', (SplusDataColumnListProvider)this.dataSet);
        splusGroupPanel.add(this.dataColumn);
        splusFunctionInfo.add(this.dataColumn, "sample.column", true);
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Chart Type");
        box.add(splusGroupPanel2);
        this.chartType = new SplusComboBox("Type", 'T', new String[]{"Mean (xbar)", "Std Dev (x)", "Range (R)"});
        this.chartType.setValue("Mean (xbar)");
        this.chartType.setEditable(false);
        splusGroupPanel2.add(this.chartType);
        splusFunctionInfo.add(this.chartType, "type", true);
        this.chartType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (QualityControlUngroupedDialog.this.chartType.getValue().equals("Mean (xbar)")) {
                    QualityControlUngroupedDialog.this.averagingMethod.setOptionList(new String[]{"Exp Wt Moving", "Simple Moving"});
                    QualityControlUngroupedDialog.this.averagingMethod.setValue("Exp Wt Moving");
                    QualityControlUngroupedDialog.this.averagingMethod.setEnabled(true);
                    QualityControlUngroupedDialog.this.expWeight.setEnabled(true);
                } else {
                    QualityControlUngroupedDialog.this.averagingMethod.setOptionList(new String[]{"Simple Moving"});
                    QualityControlUngroupedDialog.this.averagingMethod.setValue("Simple Moving");
                    QualityControlUngroupedDialog.this.averagingMethod.setEnabled(false);
                    QualityControlUngroupedDialog.this.expWeight.setEnabled(false);
                }
            }
        });
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Averaging Options");
        box.add(splusGroupPanel3);
        this.averagingMethod = new SplusComboBox("Averaging Method", 'A', new String[]{"Exp Wt Moving", "Simple Moving"});
        this.averagingMethod.setValue("Exp Wt Moving");
        this.averagingMethod.setEditable(false);
        splusGroupPanel3.add(this.averagingMethod);
        splusFunctionInfo.add(this.averagingMethod, "avg.method", true);
        this.sigmaMethod = new SplusComboBox("Sigma Method", 'M', new String[]{"Std Dev", "Range"});
        this.sigmaMethod.setValue("Std Dev");
        this.sigmaMethod.setEditable(false);
        splusGroupPanel3.add(this.sigmaMethod);
        splusFunctionInfo.add(this.sigmaMethod, "avg.sigma.method", true);
        this.sigmaSpan = new SplusTextField("Span for Sigma", 'G');
        this.sigmaSpan.setValue("2");
        splusGroupPanel3.add(this.sigmaSpan);
        splusFunctionInfo.add(this.sigmaSpan, "avg.sigma.span");
        this.statSpan = new SplusTextField("Span for Stat", 'P');
        this.statSpan.setValue("2");
        splusGroupPanel3.add(this.statSpan);
        splusFunctionInfo.add(this.statSpan, "avg.stat.span");
        this.expWeight = new SplusTextField("Exp Weight", 'W');
        this.expWeight.setValue("0.25");
        splusGroupPanel3.add(this.expWeight);
        splusFunctionInfo.add(this.expWeight, "ewma.wt");
        this.averagingMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlUngroupedDialog.this.averagingMethod.getValue().equals("Exp Wt Moving");
                QualityControlUngroupedDialog.this.expWeight.setEnabled(bl);
            }
        });
        box.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Calibration");
        box2.add(splusGroupPanel4);
        this.calibrationType = new SplusComboBox("Type", 'Y', new String[]{"Self", "Saved"});
        this.calibrationType.setValue("Self");
        this.calibrationType.setEditable(false);
        splusGroupPanel4.add(this.calibrationType);
        splusFunctionInfo.add(this.calibrationType, "calib.type", true);
        this.savedObject = new SplusComboBox("Saved Object", 'O', new String[0]);
        this.savedObject.setEnabled(false);
        this.savedObject.setOptionList(SplusObjectComboBox.getObjectsOfClass("qcc", true));
        this.savedObject.setValue("");
        splusGroupPanel4.add(this.savedObject);
        splusFunctionInfo.add(this.savedObject, "calib.saved", true);
        this.calibrationType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QualityControlUngroupedDialog.this.savedObject.setEnabled(QualityControlUngroupedDialog.this.calibrationType.getValue().equals("Saved"));
            }
        });
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Save Calibration Object");
        box2.add(splusGroupPanel5);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel5.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        box2.add(new SplusBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Results", jPanel2);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box3);
        jPanel2.add(box4);
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Printed Results");
        box3.add(splusGroupPanel6);
        SplusCheckBox splusCheckBox = new SplusCheckBox("Calibration Summary", 'C');
        splusGroupPanel6.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "print.calibration.p");
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Chart Summary", 'H');
        splusGroupPanel6.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.chart.p");
        this.capabilitySummary = new SplusCheckBox("Capability", 'P');
        splusGroupPanel6.add(this.capabilitySummary);
        splusFunctionInfo.add(this.capabilitySummary, "print.capability.p");
        box3.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Capability Options");
        box4.add(splusGroupPanel7);
        this.capabilityRange = new SplusTextField("Allowable Range", 'R');
        this.capabilityRange.setEnabled(false);
        splusGroupPanel7.add(this.capabilityRange);
        splusFunctionInfo.add(this.capabilityRange, "cap.range");
        this.capabilityMin = new SplusTextField("Lower Limit", 'L');
        this.capabilityMin.setEnabled(false);
        splusGroupPanel7.add(this.capabilityMin);
        splusFunctionInfo.add(this.capabilityMin, "cap.min");
        this.capabilityMax = new SplusTextField("Upper Limit", 'L');
        this.capabilityMax.setEnabled(false);
        splusGroupPanel7.add(this.capabilityMax);
        splusFunctionInfo.add(this.capabilityMax, "cap.max");
        this.capabilitySummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlUngroupedDialog.this.capabilitySummary.getValue().equals("T");
                QualityControlUngroupedDialog.this.capabilityRange.setEnabled(bl);
                QualityControlUngroupedDialog.this.capabilityMin.setEnabled(bl);
                QualityControlUngroupedDialog.this.capabilityMax.setEnabled(bl);
            }
        });
        box4.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel3);
        Box box5 = new Box(1);
        Box box6 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box5);
        jPanel3.add(box6);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Plots");
        box5.add(splusGroupPanel8);
        this.plotShewhart = new SplusCheckBox("Shewhart", 'H');
        this.plotShewhart.setValue("T");
        splusGroupPanel8.add(this.plotShewhart);
        splusFunctionInfo.add(this.plotShewhart, "plot.shewhart.p");
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("General Options");
        box5.add(splusGroupPanel9);
        this.includeStats = new SplusCheckBox("Include Statistics", 'S');
        this.includeStats.setValue("T");
        splusGroupPanel9.add(this.includeStats);
        splusFunctionInfo.add(this.includeStats, "add.stats");
        this.includeCalib = new SplusCheckBox("Include Calibration Data", 'C');
        this.includeCalib.setValue("T");
        splusGroupPanel9.add(this.includeCalib);
        splusFunctionInfo.add(this.includeCalib, "chart.all");
        this.targetOverride = new SplusTextField("Target Override", 'T');
        splusGroupPanel9.add(this.targetOverride);
        splusFunctionInfo.add(this.targetOverride, "target");
        this.stdDevOverride = new SplusTextField("Std Dev Override", 'D');
        splusGroupPanel9.add(this.stdDevOverride);
        splusFunctionInfo.add(this.stdDevOverride, "std.dev");
        box5.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("Shewhart Options");
        box6.add(splusGroupPanel10);
        this.limitsType = new SplusComboBox("Limits Type", 'T', new String[]{"Confidence Level", "Number of Sigmas", "Specified Limits"});
        this.limitsType.setValue("Confidence Level");
        this.limitsType.setEditable(false);
        splusGroupPanel10.add(this.limitsType);
        splusFunctionInfo.add(this.limitsType, "limits.type", true);
        this.confLevel = new SplusTextField("Confidence Level", 'L');
        this.confLevel.setValue("0.999");
        splusGroupPanel10.add(this.confLevel);
        splusFunctionInfo.add(this.confLevel, "confidence.level");
        this.numSigmas = new SplusTextField("Number of Sigmas", 'G');
        this.numSigmas.setEnabled(false);
        splusGroupPanel10.add(this.numSigmas);
        splusFunctionInfo.add(this.numSigmas, "nsigmas");
        this.lowerLimit = new SplusTextField("Lower Limit", 'L');
        this.lowerLimit.setEnabled(false);
        splusGroupPanel10.add(this.lowerLimit);
        splusFunctionInfo.add(this.lowerLimit, "limits.min");
        this.upperLimit = new SplusTextField("Upper Limit", 'U');
        this.upperLimit.setEnabled(false);
        splusGroupPanel10.add(this.upperLimit);
        splusFunctionInfo.add(this.upperLimit, "limits.max");
        this.maxRunLength = new SplusIntegerSpinner("Max Run Length", 'X', 1, 100, 1);
        this.maxRunLength.setValue("5");
        splusGroupPanel10.add(this.maxRunLength);
        splusFunctionInfo.add(this.maxRunLength, "run.length");
        this.limitsType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QualityControlUngroupedDialog.this.adjustLimitsType(QualityControlUngroupedDialog.this.plotShewhart.getValue().equals("T"));
            }
        });
        this.plotShewhart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = QualityControlUngroupedDialog.this.plotShewhart.getValue().equals("T");
                QualityControlUngroupedDialog.this.limitsType.setEnabled(bl);
                QualityControlUngroupedDialog.this.maxRunLength.setEnabled(bl);
                QualityControlUngroupedDialog.this.adjustLimitsType(bl);
                QualityControlUngroupedDialog.this.includeStats.setEnabled(bl);
                QualityControlUngroupedDialog.this.includeCalib.setEnabled(bl);
                QualityControlUngroupedDialog.this.targetOverride.setEnabled(bl);
                QualityControlUngroupedDialog.this.stdDevOverride.setEnabled(bl);
            }
        });
        box6.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    private void adjustLimitsType(boolean bl) {
        boolean[] blArray = new boolean[]{false, false, false, false};
        if (bl) {
            String string = this.limitsType.getValue();
            if (string.equals("Confidence Level")) {
                blArray[0] = true;
            } else if (string.equals("Number of Sigmas")) {
                blArray[1] = true;
            } else if (string.equals("Specified Limits")) {
                blArray[3] = true;
                blArray[2] = true;
            }
        }
        this.confLevel.setEnabled(blArray[0]);
        this.numSigmas.setEnabled(blArray[1]);
        this.lowerLimit.setEnabled(blArray[2]);
        this.upperLimit.setEnabled(blArray[3]);
    }

    public boolean isComplete() {
        boolean bl;
        boolean bl2 = bl = this.warnIfEmpty(this.dataSet) && this.warnIfEmpty(this.dataColumn);
        if (bl && this.calibrationType.getValue().equals("Saved")) {
            bl = this.warnIfEmpty(this.savedObject);
        }
        return bl;
    }
}

