/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusControlMethods;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.statdlg.TransformationBuilderDialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RegressionFormulaDialog
extends SplusDialog {
    SplusControlMethods incomingFormulaField;
    SplusDataSetComboBox dataSet;
    int dialogType;
    SplusWideTextField formulaField;
    SplusDataColumnListBox varList;
    SplusButton transformButton;
    SplusButton responseButton;
    SplusButton mainButton;
    SplusButton intButton;
    SplusButton bothButton;
    SplusButton quadButton;
    SplusButton cubicButton;
    SplusButton splineButton;
    SplusButton loessButton;
    SplusButton offsetButton;
    SplusButton interceptButton;
    SplusButton termButton;
    SplusButton removeAllButton;
    SplusButton removeLastButton;
    public static final int TYPE_MAIN_ONLY = 1;
    public static final int TYPE_LM = 2;
    public static final int TYPE_ANOVA = 3;
    public static final int TYPE_MANOVA = 4;
    public static final int TYPE_GLM = 5;
    public static final int TYPE_GAM = 6;

    public RegressionFormulaDialog(SplusControlMethods splusControlMethods, SplusDataSetComboBox splusDataSetComboBox, int n) {
        super("Formula");
        this.incomingFormulaField = splusControlMethods;
        this.dataSet = splusDataSetComboBox;
        this.dialogType = n;
        this.setApplyVisible(false);
        JPanel jPanel = new JPanel();
        Box box = new Box(0);
        Box box2 = new Box(0);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Variables");
        box3.add(splusGroupPanel);
        this.varList = new SplusDataColumnListBox("Choose Variables", 'V', (SplusDataColumnListProvider)this.dataSet);
        splusGroupPanel.add(this.varList);
        this.transformButton = new SplusButton("Transformation", 'T');
        this.transformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new TransformationBuilderDialog(RegressionFormulaDialog.this.varList).show();
            }
        });
        Box box5 = new Box(0);
        box5.add(Box.createHorizontalStrut(5));
        box5.add(this.transformButton);
        box5.add(Box.createHorizontalGlue());
        splusGroupPanel.add(Box.createVerticalStrut(5));
        splusGroupPanel.add(box5);
        splusGroupPanel.add(Box.createVerticalStrut(5));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Add");
        box3.add(splusGroupPanel2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(5, 2, 5, 5));
        this.responseButton = new SplusButton("Response", 'R');
        jPanel2.add(this.responseButton);
        this.responseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegressionFormulaDialog.this.setResponse();
            }
        });
        this.mainButton = new SplusButton("Main Effect: (+)", 'M');
        jPanel2.add(this.mainButton);
        this.mainButton.addActionListener(new AddOperatorActionListener("+"));
        this.intButton = new SplusButton("Interaction: (:)", 'I');
        jPanel2.add(this.intButton);
        this.intButton.addActionListener(new AddOperatorActionListener(":"));
        this.bothButton = new SplusButton("Main+Interact: (*)", 'N');
        jPanel2.add(this.bothButton);
        this.bothButton.addActionListener(new AddOperatorActionListener("*"));
        this.quadButton = new SplusButton("Quadratic: (x^2)", 'Q');
        jPanel2.add(this.quadButton);
        this.quadButton.addActionListener(new AddFunctionActionListener("(", "^2)"));
        this.cubicButton = new SplusButton("Cubic: (x^3)", 'C');
        jPanel2.add(this.cubicButton);
        this.cubicButton.addActionListener(new AddFunctionActionListener("(", "^3)"));
        this.splineButton = new SplusButton("Spline: (s)", 'S');
        jPanel2.add(this.splineButton);
        this.splineButton.addActionListener(new AddFunctionActionListener("s(", ")"));
        this.loessButton = new SplusButton("Loess: (lo)", 'E');
        jPanel2.add(this.loessButton);
        this.loessButton.addActionListener(new AddFunctionActionListener("lo(", ")"));
        this.offsetButton = new SplusButton("Offset: (offset)", 'O');
        jPanel2.add(this.offsetButton);
        this.offsetButton.addActionListener(new AddFunctionActionListener("offset(", ")"));
        this.interceptButton = new SplusButton("No Intercept", 'P');
        jPanel2.add(this.interceptButton);
        this.interceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegressionFormulaDialog.this.addNoIntercept();
            }
        });
        if (this.dialogType == 1) {
            this.intButton.setEnabled(false);
            this.bothButton.setEnabled(false);
            this.quadButton.setEnabled(false);
            this.cubicButton.setEnabled(false);
            this.splineButton.setEnabled(false);
            this.loessButton.setEnabled(false);
            this.offsetButton.setEnabled(false);
            this.interceptButton.setEnabled(false);
        } else if (this.dialogType == 2) {
            this.splineButton.setEnabled(false);
            this.loessButton.setEnabled(false);
            this.offsetButton.setEnabled(false);
        } else if (this.dialogType == 3 || this.dialogType == 4) {
            this.quadButton.setEnabled(false);
            this.cubicButton.setEnabled(false);
            this.splineButton.setEnabled(false);
            this.loessButton.setEnabled(false);
            this.offsetButton.setEnabled(false);
        } else if (this.dialogType == 5) {
            this.splineButton.setEnabled(false);
            this.loessButton.setEnabled(false);
        }
        splusGroupPanel2.add(jPanel2);
        splusGroupPanel2.add(Box.createVerticalStrut(5));
        box4.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Remove");
        box4.add(splusGroupPanel3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2, 5, 5));
        splusGroupPanel3.add(jPanel3);
        splusGroupPanel3.add(Box.createVerticalStrut(5));
        this.removeAllButton = new SplusButton("Remove All", 'R');
        jPanel3.add(this.removeAllButton);
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegressionFormulaDialog.this.formulaField.setValue("");
            }
        });
        this.removeLastButton = new SplusButton("Remove Last", 'L');
        jPanel3.add(this.removeLastButton);
        this.removeLastButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = RegressionFormulaDialog.this.formulaField.getValue();
                if (string.length() > 0) {
                    int n = string.lastIndexOf("+");
                    if (n > 0) {
                        RegressionFormulaDialog.this.formulaField.setValue(string.substring(0, n));
                    } else {
                        RegressionFormulaDialog.this.formulaField.setValue("");
                    }
                }
            }
        });
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("");
        box2.add(splusGroupPanel4);
        this.formulaField = new SplusWideTextField("Formula", 'F');
        splusGroupPanel4.add(this.formulaField);
        this.formulaField.setValue(this.incomingFormulaField.getValue());
        this.setCenterPanel(jPanel);
    }

    public void sendCommand() {
        this.incomingFormulaField.setValue(this.formulaField.getValue());
    }

    private void addOperatorTerm(String string) {
        String string2 = this.formulaField.getValue().trim();
        int n = string2.indexOf(126);
        String[] stringArray = this.varList.getValues();
        if (n < 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Add response before adding other terms.");
            return;
        }
        if (string2.substring(n + 1).trim().equals(".")) {
            string2 = string2.substring(0, n + 1);
        }
        if (stringArray.length == 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select variables to add terms.");
            return;
        }
        string2 = string2.endsWith("~") ? string2 + " " + stringArray[0] : string2 + "+" + stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + string + stringArray[i];
        }
        this.formulaField.setValue(string2);
    }

    private void addFunctionTerm(String string, String string2) {
        String string3 = this.formulaField.getValue().trim();
        int n = string3.indexOf(126);
        String[] stringArray = this.varList.getValues();
        if (n < 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Add response before adding other terms.");
            return;
        }
        if (string3.substring(n + 1).trim().equals(".")) {
            string3 = string3.substring(0, n + 1);
        }
        if (stringArray.length == 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select variables to add terms.");
            return;
        }
        string3 = string3.endsWith("~") ? string3 + " " + string + stringArray[0] + string2 : string3 + "+" + string + stringArray[0] + string2;
        for (int i = 1; i < stringArray.length; ++i) {
            string3 = string3 + "+" + string + stringArray[i] + string2;
        }
        this.formulaField.setValue(string3);
    }

    private void addNoIntercept() {
        String string = this.formulaField.getValue().trim();
        int n = string.indexOf(126);
        if (string.length() == 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Add response before adding other terms.");
            return;
        }
        if (string.substring(n + 1).trim().equals(".")) {
            string = string.substring(0, n + 1) + " -1";
        } else if (string.indexOf("-1") <= 0) {
            string = string + "+ -1";
        }
        this.formulaField.setValue(string);
    }

    private void setResponse() {
        String string;
        String string2 = this.formulaField.getValue().trim();
        int n = string2.indexOf(126);
        String[] stringArray = this.varList.getValues();
        if (stringArray.length == 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Select variable to add response.");
            return;
        }
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            string = "cbind(" + stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + "," + stringArray[i];
            }
            string = string + ")";
        }
        string2 = n < 0 ? string + " ~ ." : string + " " + string2.substring(n);
        this.formulaField.setValue(string2);
    }

    public void show() {
        if (this.dataSet.getValue().trim().length() == 0) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Enter Data Set before building formula.");
        } else {
            super.show();
        }
    }

    private class AddFunctionActionListener
    implements ActionListener {
        String prepend;
        String append;

        AddFunctionActionListener(String string, String string2) {
            this.prepend = string;
            this.append = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RegressionFormulaDialog.this.addFunctionTerm(this.prepend, this.append);
        }
    }

    private class AddOperatorActionListener
    implements ActionListener {
        String operator;

        AddOperatorActionListener(String string) {
            this.operator = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RegressionFormulaDialog.this.addOperatorTerm(this.operator);
        }
    }
}

