/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.util;

import com.insightful.splus.SplusEngineQueryHandler;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.util.JavaPrimitive;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Vector;

public class ClassUtilities {
    private static final Class primitiveClass;
    private static ClassLoader m_extensionClassLoader;
    public static boolean testFieldBoolean;
    public static byte testFieldByte;
    public static char testFieldChar;
    public static short testFieldShort;
    public static int testFieldInt;
    public static long testFieldLong;
    public static float testFieldFloat;
    public static double testFieldDouble;
    public static String testFieldString;
    public static Object testFieldObject;
    public static boolean[] testFieldBooleanArray;
    public static byte[] testFieldByteArray;
    public static char[] testFieldCharArray;
    public static short[] testFieldShortArray;
    public static int[] testFieldIntArray;
    public static long[] testFieldLongArray;
    public static float[] testFieldFloatArray;
    public static double[] testFieldDoubleArray;
    public static String[] testFieldStringArray;
    public static Object[] testFieldObjectArray;

    private ClassUtilities() {
    }

    public static Object getStaticFieldValue(String string, String string2) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        string = string.replace('/', '.');
        return ClassUtilities.getClassForName(string).getField(string2).get(null);
    }

    public static Object invokeStaticMethod(String string, String string2, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (classArray == null && objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!primitiveClass.equals(classArray[i])) continue;
                JavaPrimitive javaPrimitive = (JavaPrimitive)objectArray[i];
                classArray[i] = javaPrimitive.getPrimitiveClass();
                objectArray[i] = javaPrimitive.getWrappedValue();
            }
        }
        string = string.replace('/', '.');
        Method method = ClassUtilities.getClassForName(string).getMethod(string2, classArray);
        return method.invoke(null, objectArray);
    }

    public static Object invokeStaticMethod(String string, String string2) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassUtilities.invokeStaticMethod(string, string2, null, null);
    }

    public static Object newInstance(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        string = string.replace('/', '.');
        Class clazz = ClassUtilities.getClassForName(string);
        return clazz.newInstance();
    }

    public static boolean classExists(String string) {
        try {
            string = string.replace('/', '.');
            ClassUtilities.getClassForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static boolean fieldExists(String string, String string2) throws SecurityException {
        try {
            string = string.replace('/', '.');
            Class clazz = ClassUtilities.getClassForName(string);
            clazz.getField(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        return true;
    }

    public static boolean methodExists(String string, String string2, Class[] classArray) {
        try {
            string = string.replace('/', '.');
            Class clazz = ClassUtilities.getClassForName(string);
            clazz.getMethod(string2, classArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return true;
    }

    public static Class getClassForName(String string) throws ClassNotFoundException {
        if (string == null || string.equals("")) {
            throw new ClassNotFoundException("null class name");
        }
        String string2 = string.replace('/', '.');
        if (string2.indexOf("eclipse") != -1 && SplusSystem.getEngineQueryHandler() != null) {
            SplusEngineQueryHandler splusEngineQueryHandler = SplusSystem.getEngineQueryHandler();
            try {
                Class<?> clazz = splusEngineQueryHandler.getClass().getClassLoader().loadClass(string2);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m_extensionClassLoader == null) {
            return Class.forName(string2, true, ClassLoader.getSystemClassLoader());
        }
        return Class.forName(string2, true, m_extensionClassLoader);
    }

    public static void attachClassPath(String string) throws Exception {
        ClassUtilities.attachClassPath(new String[]{string});
    }

    public static void attachClassPath(String[] stringArray) throws Exception {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            uRLArray[i] = new File(stringArray[i]).toURI().toURL();
        }
        ClassUtilities.attachClassPath(uRLArray);
    }

    public static void attachClassPath(URL[] uRLArray) throws Exception {
        URLClassLoader uRLClassLoader = m_extensionClassLoader == null ? new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader()) : new URLClassLoader(uRLArray, m_extensionClassLoader);
        m_extensionClassLoader = uRLClassLoader;
    }

    public static ClassLoader getClassLoader() {
        return m_extensionClassLoader;
    }

    public static void setClassLoader(ClassLoader classLoader) {
        m_extensionClassLoader = classLoader;
    }

    public static boolean testMethodBoolean() {
        return testFieldBoolean;
    }

    public static byte testMethodByte() {
        return testFieldByte;
    }

    public static char testMethodChar() {
        return testFieldChar;
    }

    public static short testMethodShort() {
        return testFieldShort;
    }

    public static int testMethodInt() {
        return testFieldInt;
    }

    public static long testMethodLong() {
        return testFieldLong;
    }

    public static float testMethodFloat() {
        return testFieldFloat;
    }

    public static double testMethodDouble() {
        return testFieldDouble;
    }

    public static String testMethodString() {
        return testFieldString;
    }

    public static Object testMethodObject() {
        return testFieldObject;
    }

    public static boolean[] testMethodBooleanArray() {
        return testFieldBooleanArray;
    }

    public static byte[] testMethodByteArray() {
        return testFieldByteArray;
    }

    public static char[] testMethodCharArray() {
        return testFieldCharArray;
    }

    public static short[] testMethodShortArray() {
        return testFieldShortArray;
    }

    public static int[] testMethodIntArray() {
        return testFieldIntArray;
    }

    public static long[] testMethodLongArray() {
        return testFieldLongArray;
    }

    public static float[] testMethodFloatArray() {
        return testFieldFloatArray;
    }

    public static double[] testMethodDoubleArray() {
        return testFieldDoubleArray;
    }

    public static String[] testMethodStringArray() {
        return testFieldStringArray;
    }

    public static Object[] testMethodObjectArray() {
        return testFieldObjectArray;
    }

    public static void testMethodSetInt(int n) {
        Vector<String> vector;
        testFieldBoolean = n != 0;
        testFieldByte = (byte)n;
        testFieldChar = (char)n;
        testFieldShort = (short)n;
        testFieldInt = n;
        testFieldLong = n;
        testFieldFloat = n;
        testFieldDouble = n;
        testFieldString = String.valueOf(n);
        int n2 = Math.max(0, Math.min(200, n));
        testFieldObject = vector = new Vector<String>();
        testFieldBooleanArray = new boolean[n2];
        testFieldByteArray = new byte[n2];
        testFieldCharArray = new char[n2];
        testFieldShortArray = new short[n2];
        testFieldIntArray = new int[n2];
        testFieldLongArray = new long[n2];
        testFieldFloatArray = new float[n2];
        testFieldDoubleArray = new double[n2];
        testFieldStringArray = new String[n2];
        testFieldObjectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            vector.add(String.valueOf(i + 1));
            ClassUtilities.testFieldBooleanArray[i] = true;
            ClassUtilities.testFieldByteArray[i] = (byte)(i + 1);
            ClassUtilities.testFieldCharArray[i] = (char)(i + 1);
            ClassUtilities.testFieldShortArray[i] = (short)(i + 1);
            ClassUtilities.testFieldIntArray[i] = i + 1;
            ClassUtilities.testFieldLongArray[i] = i + 1;
            ClassUtilities.testFieldFloatArray[i] = i + 1;
            ClassUtilities.testFieldDoubleArray[i] = i + 1;
            ClassUtilities.testFieldStringArray[i] = String.valueOf(i + 1);
            ClassUtilities.testFieldObjectArray[i] = String.valueOf(i + 1);
        }
    }

    public static void testMethodSetBoolean(boolean bl) {
        ClassUtilities.testMethodSetInt(bl ? 1 : 0);
    }

    public static void testMethodSetByte(byte by) {
        ClassUtilities.testMethodSetInt(by);
    }

    public static void testMethodSetChar(char c) {
        ClassUtilities.testMethodSetInt(c);
    }

    public static void testMethodSetShort(short s) {
        ClassUtilities.testMethodSetInt(s);
    }

    public static void testMethodSetLong(long l) {
        ClassUtilities.testMethodSetInt((int)l);
    }

    public static void testMethodSetFloat(float f) {
        ClassUtilities.testMethodSetInt((int)f);
    }

    public static void testMethodSetDouble(double d) {
        ClassUtilities.testMethodSetInt((int)d);
    }

    public static void testMethodSetString(String string) {
        try {
            ClassUtilities.testMethodSetInt(Integer.parseInt(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testMethodSetBooleanArray(boolean[] blArray) {
        testFieldBooleanArray = blArray;
    }

    public static void testMethodSetByteArray(byte[] byArray) {
        testFieldByteArray = byArray;
    }

    public static void testMethodSetCharArray(char[] cArray) {
        testFieldCharArray = cArray;
    }

    public static void testMethodSetShortArray(short[] sArray) {
        testFieldShortArray = sArray;
    }

    public static void testMethodSetIntArray(int[] nArray) {
        testFieldIntArray = nArray;
    }

    public static void testMethodSetLongArray(long[] lArray) {
        testFieldLongArray = lArray;
    }

    public static void testMethodSetFloatArray(float[] fArray) {
        testFieldFloatArray = fArray;
    }

    public static void testMethodSetDoubleArray(double[] dArray) {
        testFieldDoubleArray = dArray;
    }

    public static void testMethodSetStringArray(String[] stringArray) {
        testFieldStringArray = stringArray;
    }

    public static String[] getPropertiesAsStringArray() {
        Properties properties = System.getProperties();
        ArrayList<?> arrayList = Collections.list(properties.propertyNames());
        Collections.sort(arrayList);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            stringArray[i] = string + "=" + properties.getProperty(string, "propnotfound");
        }
        return stringArray;
    }

    public static int testLoopInt(int n) {
        int n2 = 0;
        for (int i = 1; i <= n; ++i) {
            n2 += i;
        }
        return n2;
    }

    public static int testLoopInt2(int n, int n2) {
        int n3 = 0;
        for (int i = 1; i <= n; ++i) {
            n3 += ClassUtilities.testLoopInt(n2);
        }
        return n3;
    }

    public static double testLoopDouble(int n) {
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            d += (double)i;
        }
        return d;
    }

    public static double testLoopDouble2(int n, int n2) {
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            d += ClassUtilities.testLoopDouble(n2);
        }
        return d;
    }

    public static double testLoop(int n, int n2, boolean bl, boolean bl2) {
        return ClassUtilities.testLoop(n, n2, bl2 ? 0 : -1, bl);
    }

    public static double testLoop(int n, int n2, int n3, boolean bl) {
        double d = 0.0;
        int n4 = 0;
        for (int i = 1; i <= n; ++i) {
            if (bl) {
                d += n2 > 0 ? ClassUtilities.testLoopDouble(n2) : (double)i;
            } else {
                n4 += n2 > 0 ? ClassUtilities.testLoopInt(n2) : i;
            }
            try {
                if (n3 > 0) {
                    Thread.sleep(n3);
                    continue;
                }
                if (n3 != 0) continue;
                Thread.yield();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl ? d : (double)n4;
    }

    public static double maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static double totalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static double freeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    static {
        try {
            primitiveClass = Class.forName("com.insightful.splus.util.JavaPrimitive");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        m_extensionClassLoader = null;
    }
}

