/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.util;

import com.insightful.splus.util.StringMatrixTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class NamedTableScrollPane
extends JScrollPane {
    AbstractTableModel tableModel;
    LocalTable table;
    JList rowNameList;
    int rowHeight;
    static int EXTRA_HEIGHT = 5;

    public NamedTableScrollPane(StringMatrixTableModel stringMatrixTableModel) {
        this(stringMatrixTableModel, stringMatrixTableModel.getRowNames());
        stringMatrixTableModel.addTableModelListener(new RowNameListener());
    }

    public NamedTableScrollPane(AbstractTableModel abstractTableModel, String[] stringArray) {
        this.tableModel = abstractTableModel;
        this.table = new LocalTable(this.tableModel);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setFont(new Font("Monospaced", 0, 12));
        this.table.resizeColumns(null);
        this.setViewportView(this.table);
        if (stringArray != null) {
            this.rowNameList = new JList<String>(stringArray);
            this.rowNameList.setCellRenderer(new RowNameRenderer(this.table));
            this.rowHeight = Math.max(this.table.getRowHeight(), this.table.getTableHeader().getHeight()) + EXTRA_HEIGHT;
            this.table.setRowHeight(this.rowHeight);
            this.rowNameList.setFixedCellHeight(this.rowHeight);
            this.setRowHeaderView(this.rowNameList);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    private class LocalTable
    extends JTable {
        LocalTable(TableModel tableModel) {
            super(tableModel);
        }

        public void resizeColumns(Dimension dimension) {
            int n = this.getColumnCount();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = 0;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                Serializable serializable;
                Object object;
                int n3 = 0;
                int n4 = 0;
                Vector<String> vector = new Vector<String>();
                vector.addElement(this.getColumnName(i));
                for (int j = 0; j < this.getRowCount(); ++j) {
                    object = this.getValueAt(j, i);
                    if (object == null) {
                        vector.addElement("");
                        continue;
                    }
                    vector.addElement(object.toString());
                }
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    n3 = fontMetrics.stringWidth((String)enumeration.nextElement());
                    if (n3 <= n4) continue;
                    n4 = n3;
                }
                object = this.getColumnModel().getColumn(i);
                TableCellRenderer tableCellRenderer = ((TableColumn)object).getHeaderRenderer();
                if (tableCellRenderer == null) {
                    try {
                        serializable = this.getTableHeader();
                        Method method = serializable.getClass().getMethod("getDefaultRenderer", new Class[0]);
                        tableCellRenderer = (TableCellRenderer)method.invoke((Object)serializable, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (tableCellRenderer != null) {
                    serializable = tableCellRenderer.getTableCellRendererComponent(this, ((TableColumn)object).getHeaderValue(), false, false, 0, 0);
                    int n5 = ((Component)serializable).getPreferredSize().width;
                    if (n5 > n4) {
                        n4 = n5;
                    }
                }
                serializable = ((JComponent)((Object)this.getCellRenderer(0, i))).getInsets();
                this.getColumnModel().getColumn(i).setPreferredWidth(n4 += ((Insets)serializable).left + ((Insets)serializable).right + 10);
                this.getColumnModel().getColumn(i).setMinWidth(n4);
                this.getColumnModel().getColumn(i).setMaxWidth(n4);
                this.sizeColumnsToFit(i);
                n2 += n4;
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            super.tableChanged(tableModelEvent);
            if (this.getFont() != null) {
                this.resizeColumns(null);
                this.revalidate();
                this.repaint();
            }
        }

        protected void paintComponent(Graphics graphics) {
            if (this.getParent() != null) {
                Rectangle rectangle = graphics.getClipBounds();
                graphics.setColor(this.getParent().getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            super.paintComponent(graphics);
        }
    }

    private class RowNameListener
    implements TableModelListener {
        private RowNameListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (NamedTableScrollPane.this.rowNameList != null) {
                NamedTableScrollPane.this.rowNameList.setListData(((StringMatrixTableModel)NamedTableScrollPane.this.tableModel).getRowNames());
            }
        }
    }

    private class RowNameRenderer
    extends JLabel
    implements ListCellRenderer {
        RowNameRenderer(JTable jTable) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }
}

