/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusIncrementalParser;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusSourceSelectionDialog;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SplusFindSource
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private static SplusEditor m_sourceLookupEditor;
    private TextSelection fSelection = null;

    public static void findMethod(IRegion iRegion, boolean bl) {
        try {
            SplusEditor splusEditor = SplusFindSource.getActiveSplusEditor();
            IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            SplusFindSource.findMethod(string, bl);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static SplusEditor findAndWaitForEditor(String string) {
        return SplusFindSource.findAndWaitForEditor(string, -1, 50);
    }

    public static SplusEditor findAndWaitForEditor(final String string, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = Thread.currentThread() == SplusEditorPlugin.getDefault().getWorkbench().getDisplay().getThread();
        if (bl && n == -1) {
            n = 1;
        }
        m_sourceLookupEditor = null;
        int n3 = 0;
        while (m_sourceLookupEditor == null && (n == -1 || n3 < n)) {
            int n4 = n3++;
            Display.getDefault().syncExec((Runnable)new Thread("SplusFindSource-OpenNewEditor"){

                public void run() {
                    m_sourceLookupEditor = SplusFindSource.findOpenEditor(string);
                    if (m_sourceLookupEditor == null) {
                        m_sourceLookupEditor = SplusFindSource.findMethod(string, true);
                    }
                }
            });
            if (m_sourceLookupEditor != null) break;
            try {
                Thread.sleep(n2);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return m_sourceLookupEditor;
    }

    public static SplusEditor findMethod(String string, boolean bl) {
        try {
            SplusEditor splusEditor = SplusFindSource.findOpenEditor(string);
            if (splusEditor != null) {
                SplusFindSource.highlightLocation(splusEditor, string);
                return splusEditor;
            }
            if (bl) {
                NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
                noConnection.openEditor(string);
                return null;
            }
            IResource[] iResourceArray = SplusIncrementalParser.getFunctionResource(string);
            if (iResourceArray != null && iResourceArray.length != 0) {
                SplusSourceSelectionDialog splusSourceSelectionDialog;
                Shell shell;
                IResource iResource = null;
                if (iResourceArray.length > 1) {
                    shell = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                    splusSourceSelectionDialog = new SplusSourceSelectionDialog(shell, iResourceArray);
                    iResource = splusSourceSelectionDialog.open();
                } else {
                    iResource = iResourceArray[0];
                }
                if (iResource != null) {
                    shell = ResourcesPlugin.getWorkspace();
                    splusSourceSelectionDialog = shell.getRoot().getFile(iResource.getFullPath());
                    if (splusSourceSelectionDialog != null) {
                        FileEditorInput fileEditorInput;
                        IEditorPart iEditorPart;
                        IEditorRegistry iEditorRegistry = SplusEditorPlugin.getDefault().getWorkbench().getEditorRegistry();
                        IEditorDescriptor iEditorDescriptor = iEditorRegistry.findEditor("org.eclipse.ui.SplusEditor");
                        IWorkbenchPage iWorkbenchPage = SplusFindSource.getActivePage();
                        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.openEditor((IEditorInput)(fileEditorInput = new FileEditorInput((IFile)splusSourceSelectionDialog)), iEditorDescriptor.getId())) instanceof SplusEditor) {
                            SplusEditor splusEditor2 = (SplusEditor)iEditorPart;
                            SplusFindSource.highlightLocation(splusEditor2, string);
                            return splusEditor2;
                        }
                    }
                    return null;
                }
            }
            if ((splusEditor = SplusFindSource.findOpenEditor(string)) != null) {
                SplusFindSource.highlightLocation(splusEditor, string);
                return splusEditor;
            }
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        return null;
    }

    public static SplusEditor findOpenEditor(String string) {
        IWorkbenchPage iWorkbenchPage = SplusFindSource.getActivePage();
        if (iWorkbenchPage != null) {
            IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
            for (int i = 0; i < iEditorReferenceArray.length; ++i) {
                PObject pObject;
                PObject pObject2;
                IEditorPart iEditorPart = iEditorReferenceArray[i].getEditor(false);
                if (!(iEditorPart instanceof SplusEditor) || (pObject2 = SplusParseTreeBuilder.getFunctionDefinition(pObject = ((SplusEditor)iEditorPart).getParseTree(), string)) == null) continue;
                iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
                return (SplusEditor)iEditorPart;
            }
        }
        return null;
    }

    public static Position getCharRange(String string, long[] lArray) {
        Position position = new Position(0, 0);
        try {
            int n;
            int n2;
            if (lArray == null) {
                return position;
            }
            SplusEditor splusEditor = SplusFindSource.getActiveSplusEditor();
            IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
            PObject pObject = SplusParseTreeBuilder.getFunctionDefinition(splusEditor.getParseTree(), string);
            boolean bl = pObject != null && lArray.length != 0;
            for (n2 = 0; bl && n2 < lArray.length; ++n2) {
                n = (int)lArray[n2];
                if (pObject.poGetLength() > n) {
                    pObject = pObject.poGetElement(n);
                    continue;
                }
                bl = false;
            }
            if (bl) {
                n2 = iDocument.getLineOffset(SplusParseTreeBuilder.getStartLine(pObject)) + SplusParseTreeBuilder.getStartColumn(pObject);
                n = iDocument.getLineOffset(SplusParseTreeBuilder.getEndLine(pObject)) + SplusParseTreeBuilder.getEndColumn(pObject);
                position = new Position(n2, n);
            } else {
                IRegion iRegion = splusEditor.getHighlightRange();
                if (iRegion != null) {
                    position = new Position(iRegion.getOffset(), iRegion.getOffset() + iRegion.getLength());
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return position;
    }

    private static void highlightLocation(SplusEditor splusEditor, String string) {
        try {
            IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
            PObject pObject = SplusParseTreeBuilder.getFunctionDefinition(splusEditor.getParseTree(), string);
            int n = iDocument.getLineOffset(SplusParseTreeBuilder.getStartLine(pObject)) + SplusParseTreeBuilder.getStartColumn(pObject);
            splusEditor.highlightRange(n, 8);
            splusEditor.getViewer().revealRange(n, 8);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static void highlightBreak(final SplusEditor splusEditor, String string, long[] lArray) {
        try {
            int n;
            int n2;
            if (lArray == null) {
                return;
            }
            IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
            PObject pObject = SplusParseTreeBuilder.getFunctionDefinition(splusEditor.getParseTree(), string);
            boolean bl = pObject != null;
            for (n2 = 0; bl && n2 < lArray.length; ++n2) {
                n = (int)lArray[n2];
                if (pObject.poGetLength() > n) {
                    pObject = pObject.poGetElement(n);
                    continue;
                }
                bl = false;
            }
            if (bl) {
                n2 = iDocument.getLineOffset(SplusParseTreeBuilder.getStartLine(pObject)) + SplusParseTreeBuilder.getStartColumn(pObject);
                n = iDocument.getLineOffset(SplusParseTreeBuilder.getEndLine(pObject)) + SplusParseTreeBuilder.getEndColumn(pObject);
                Display.getDefault().syncExec((Runnable)new Thread("SplusFindSource-HighlightText"){

                    public void run() {
                        splusEditor.highlightRange(n2, n - n2 + 1);
                    }
                });
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private static SplusEditor getActiveSplusEditor() {
        try {
            IWorkbenchPage iWorkbenchPage = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            SplusEditor splusEditor = (SplusEditor)iWorkbenchPage.getActiveEditor();
            return splusEditor;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
        if (this.fSelection != null) {
            String string = this.fSelection.getText();
            SplusFindSource.findMethod(string, true);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (iSelection instanceof TextSelection) {
            this.fSelection = (TextSelection)iSelection;
            String string = this.fSelection.getText();
            if (string.length() > 10) {
                string = string.substring(0, 10) + "...";
            }
            iAction.setText("Fin&d \"" + string + "\"");
            iAction.setEnabled(string.length() != 0);
            return;
        }
        iAction.setEnabled(false);
        this.fSelection = null;
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        iAction.setEnabled(iEditorPart != null);
    }

    private static IWorkbenchPage getActivePage() {
        try {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            return iWorkbenchPage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

