/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.graph.DefaultDialog;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SplusSourceSelectionDialog
extends Dialog {
    private IResource[] m_resourceList;
    private IResource m_selection;
    private Button m_ok;
    private Button m_cancel;
    private List m_list;
    private Text m_text;

    public SplusSourceSelectionDialog(Shell shell, IResource[] iResourceArray) {
        super(shell, 66800);
        this.setText("Select S-PLUS Source");
        this.m_resourceList = iResourceArray;
        this.m_selection = null;
    }

    protected void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(1, true));
        SashForm sashForm = new SashForm((Composite)shell, 512);
        GridData gridData = new GridData(1808);
        sashForm.setLayoutData((Object)gridData);
        this.m_list = new List((Composite)sashForm, 2052);
        this.m_text = new Text((Composite)sashForm, 2818);
        this.m_list.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SplusSourceSelectionDialog.this.m_list.forceFocus();
            }
        });
        this.m_text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SplusSourceSelectionDialog.this.m_list.forceFocus();
            }
        });
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayoutData((Object)new GridData(128));
        FillLayout fillLayout = new FillLayout(256);
        composite.setLayout((Layout)fillLayout);
        fillLayout.marginWidth = 2;
        fillLayout.marginHeight = 5;
        fillLayout.spacing = 5;
        this.m_ok = new Button(composite, 0);
        this.m_ok.setText(" Use &Selection ");
        this.m_cancel = new Button(composite, 0);
        this.m_cancel.setText("S-PLUS &Database");
        this.m_ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusSourceSelectionDialog.this.m_selection = SplusSourceSelectionDialog.this.m_resourceList[SplusSourceSelectionDialog.this.m_list.getSelectionIndex()];
                shell.close();
                shell.dispose();
            }
        });
        this.m_cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusSourceSelectionDialog.this.m_selection = null;
                shell.close();
                shell.dispose();
            }
        });
    }

    private void initializeContents(final Shell shell) {
        for (int i = 0; i < this.m_resourceList.length; ++i) {
            this.m_list.add(this.m_resourceList[i].getLocation().toOSString());
        }
        this.m_list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SplusSourceSelectionDialog.this.updateText();
            }
        });
        this.m_list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                SplusSourceSelectionDialog.this.m_selection = SplusSourceSelectionDialog.this.m_resourceList[SplusSourceSelectionDialog.this.m_list.getSelectionIndex()];
                shell.close();
                shell.dispose();
            }
        });
        this.m_list.setSelection(0);
        this.updateText();
    }

    private void updateText() {
        File file = this.m_resourceList[this.m_list.getSelectionIndex()].getLocation().toFile();
        this.m_text.setText(SplusParseTreeBuilder.toString(file));
    }

    public IResource open() {
        Image[] imageArray;
        Shell shell = this.getParent();
        Shell shell2 = new Shell(shell, this.getStyle());
        shell2.setText(this.getText());
        Image image = shell.getImage();
        if (image != null) {
            shell2.setImage(image);
        }
        if ((imageArray = DefaultDialog.getImages(shell)) != null) {
            shell2.setImages(imageArray);
        }
        this.createContents(shell2);
        this.initializeContents(shell2);
        shell2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SplusSourceSelectionDialog.this.m_list.forceFocus();
            }
        });
        shell2.pack();
        shell2.setSize(400, 450);
        shell2.open();
        Display display = this.getParent().getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
            if (shell2.isFocusControl() || this.m_list.isFocusControl() || this.m_text.isFocusControl() || this.m_ok.isFocusControl() || this.m_cancel.isFocusControl()) continue;
            shell2.setFocus();
        }
        return this.m_selection;
    }
}

