/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context.intellisense;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.editors.spluseditor.context.intellisense.SplusIntelliSenseTrie;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import java.rmi.RemoteException;
import java.util.LinkedList;

public class SplusIntelliSenseHelper
extends Thread {
    private SplusIntelliSenseTrie trie = null;
    private DefaultConnection conn = null;
    private static String QUERY_FOR_FUNCTIONS = "unlist(lapply(search(), function(sp) objects(sp, classes=\"function\")))";

    public SplusIntelliSenseHelper(DefaultConnection defaultConnection) {
        super("SplusIntelliSenseHelper-TrieBuilder");
        this.conn = defaultConnection;
    }

    public void run() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        while (true) {
            boolean bl = this.buildTrie();
            try {
                if (bl) {
                    Thread.sleep(300000L);
                    continue;
                }
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    private SplusIntelliSenseTrie getTrie() {
        if (this.trie == null) {
            this.trie = new SplusIntelliSenseTrie();
        }
        return this.trie;
    }

    private boolean buildTrie() {
        try {
            SplusDataResult splusDataResult = this.conn.doDataQuery(QUERY_FOR_FUNCTIONS);
            this.getTrie().reset();
            String[] stringArray = splusDataResult.getStringData();
            for (int i = 1; i < stringArray.length; ++i) {
                this.getTrie().add(stringArray[i]);
            }
            return true;
        }
        catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
            splusIncompleteExpressionException.printStackTrace();
        }
        catch (SplusEngineBusyException splusEngineBusyException) {
            splusEngineBusyException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (SplusBadDataException splusBadDataException) {
            splusBadDataException.printStackTrace();
        }
        return false;
    }

    public LinkedList getFunctionList(String string) {
        return this.getTrie().getValues(string);
    }

    public String getFunctionArgList(String string) {
        try {
            String string2;
            String[] stringArray = SplusParseTreeBuilder.getInstance().getSyntaxErrors(string);
            if (stringArray != null && stringArray.length != 0) {
                return null;
            }
            SplusDataResult splusDataResult = this.conn.doDataQueryWithOutput("args(" + string + ")");
            String string3 = string2 = !splusDataResult.hasOutput() ? null : splusDataResult.getOutput();
            if (string2 != null) {
                return string + string2.substring(8, string2.length() - 6);
            }
        }
        catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
            splusIncompleteExpressionException.printStackTrace();
        }
        catch (SplusEngineBusyException splusEngineBusyException) {
            splusEngineBusyException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        return null;
    }
}

