/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.editors.spluseditor.SplusContentOutlinePage;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.eclipse.preferences.SplusOutlinePreferencePage;
import com.insightful.splus.parser.PObject;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SplusContentProvider
implements ITreeContentProvider {
    protected static final String SEGMENTS = "__java_segments";
    protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__java_segments");
    protected List fContent = new Vector();
    private Stack fScopeStack = new Stack();
    private Stack fDefinitionStack = new Stack();
    private Object fContentInput;
    private String[] watchFunctions = SplusOutlinePreferencePage.getWatchFunctions();
    private SplusContentOutlinePage m_Outline = null;
    private IDocument m_Document;
    private boolean m_HideFunctions;
    private boolean m_HideAnonFunctions;
    private boolean m_HideWatchFunctions;
    private boolean m_HideVariables;
    private boolean m_HideScope;

    public SplusContentProvider(PObject pObject, IDocument iDocument) {
        this(iDocument, false, false, false, false, false);
    }

    protected SplusContentProvider(IDocument iDocument, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.m_Document = iDocument;
        this.m_HideFunctions = bl;
        this.m_HideAnonFunctions = bl2;
        this.m_HideWatchFunctions = bl3;
        this.m_HideVariables = bl4;
        this.m_HideScope = bl5;
    }

    public SplusContentProvider(SplusContentOutlinePage splusContentOutlinePage) {
        this.m_Outline = splusContentOutlinePage;
    }

    private PObject getParseTree() {
        if (this.m_Outline != null) {
            return ((SplusEditor)this.m_Outline.getEditor()).getParseTree();
        }
        return null;
    }

    private IDocument getDocument() {
        if (this.m_Outline != null) {
            return this.m_Outline.getDocument();
        }
        return this.m_Document;
    }

    private boolean hideAnonFunctions() {
        if (this.m_Outline != null) {
            return this.m_Outline.m_hideAnonFunctions;
        }
        return this.m_HideAnonFunctions;
    }

    private boolean hideWatchFunctions() {
        if (this.m_Outline != null) {
            return this.m_Outline.m_hideWatchFunctions;
        }
        return this.m_HideWatchFunctions;
    }

    private boolean hideVariables() {
        if (this.m_Outline != null) {
            return this.m_Outline.m_hideVariables;
        }
        return this.m_HideVariables;
    }

    private boolean hideFunctions() {
        if (this.m_Outline != null) {
            return this.m_Outline.m_hideFunctions;
        }
        return this.m_HideFunctions;
    }

    private boolean hideScope() {
        if (this.m_Outline != null) {
            return this.m_Outline.m_hideScope;
        }
        return this.m_HideScope;
    }

    private void parse() {
        SplusContentOutlinePage.Member.resetAnonymousCount();
        this.watchFunctions = SplusOutlinePreferencePage.getWatchFunctions();
        PObject pObject = this.getParseTree();
        if (pObject == null) {
            return;
        }
        PObject pObject2 = pObject.poGetMode().equals("list") ? pObject.poGetElement(0) : pObject;
        this.fDefinitionStack.push(new HashMap());
        this.parse(pObject2, null, pObject2);
    }

    public SplusContentOutlinePage.Member handlePObject(PObject pObject, PObject pObject2, PObject pObject3) {
        SplusContentOutlinePage.Method method = this.fScopeStack.size() != 0 ? (SplusContentOutlinePage.Method)this.fScopeStack.peek() : null;
        SplusContentOutlinePage.Member member = null;
        HashMap hashMap = (HashMap)this.fDefinitionStack.peek();
        boolean bl = false;
        String string = pObject.poGetMode();
        if (pObject.poGetMode().equals("function")) {
            member = new SplusContentOutlinePage.Method(pObject, pObject2, method, this.getDocument());
            if (hashMap.get(member.name) != null && !(hashMap.get(member.name) instanceof SplusContentOutlinePage.Method)) {
                hashMap.remove(member.name);
            }
        } else if (pObject.poIsName() && pObject2 != null && !pObject2.poGetMode().equals("call") && SplusParseTreeBuilder.isAssignment(pObject2) && pObject2.poGetElement(1) != pObject && !pObject2.poGetElement(1).poGetMode().equals("function")) {
            member = new SplusContentOutlinePage.Member(pObject, pObject2, method, this.getDocument());
            bl = true;
        } else if (pObject.poGetMode().equals("call")) {
            String string2 = pObject.poGetElement(0).toString();
            for (int i = 0; i < this.watchFunctions.length; ++i) {
                if (!this.watchFunctions[i].equals(string2)) continue;
                member = new SplusContentOutlinePage.Watch(pObject, pObject2, method, this.getDocument());
            }
        } else if (SplusParseTreeBuilder.isIf(pObject) || SplusParseTreeBuilder.isWhile(pObject) || SplusParseTreeBuilder.isFor(pObject) || SplusParseTreeBuilder.isRepeat(pObject)) {
            member = new SplusContentOutlinePage.Scope(pObject, pObject2, method, this.getDocument());
        }
        if (member != null && method != null && !(member instanceof SplusContentOutlinePage.Scope)) {
            method.hasChildren = true;
        }
        if (!(member == null || bl && hashMap.get(member.name) != null)) {
            if (bl) {
                hashMap.put(member.name, member);
            }
            this.fContent.add(member);
        }
        return member;
    }

    public void parse(PObject pObject, PObject pObject2, PObject pObject3) {
        boolean bl;
        SplusContentOutlinePage.Member member = this.handlePObject(pObject, pObject2, pObject3);
        boolean bl2 = bl = member != null && member instanceof SplusContentOutlinePage.Method && !(member instanceof SplusContentOutlinePage.Scope);
        if (pObject.poIsRecursive()) {
            PObject pObject4;
            PObject pObject5 = pObject4 = pObject.poGetMode().equals("function") ? pObject : pObject3;
            if (bl) {
                this.fDefinitionStack.push(new HashMap());
                this.fScopeStack.push(member);
            }
            for (int i = 0; i < pObject.poGetLength(); ++i) {
                PObject pObject6 = pObject.poGetElement(i);
                this.parse(pObject6, pObject, pObject4);
            }
            if (bl) {
                this.fDefinitionStack.pop();
                this.fScopeStack.pop();
            }
        }
    }

    private Object[] filter(Object object) {
        Vector<SplusContentOutlinePage.Member> vector = new Vector<SplusContentOutlinePage.Member>();
        for (int i = 0; i < this.fContent.size(); ++i) {
            SplusContentOutlinePage.Member member = (SplusContentOutlinePage.Member)this.fContent.get(i);
            if (member.getParent() != object || (member instanceof SplusContentOutlinePage.Scope ? this.hideScope() : (member instanceof SplusContentOutlinePage.Method ? this.hideFunctions() || this.hideAnonFunctions() && ((SplusContentOutlinePage.Method)member).isAnon : (member instanceof SplusContentOutlinePage.Watch ? this.hideWatchFunctions() : this.hideVariables())))) continue;
            vector.add(member);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object != null && this.getDocument() != null) {
            try {
                this.getDocument().removePositionCategory(SEGMENTS);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            this.getDocument().removePositionUpdater(this.fPositionUpdater);
        }
        this.fContent.clear();
        if (object2 != null) {
            this.fContentInput = object2;
            if (this.getDocument() != null) {
                this.getDocument().addPositionCategory(SEGMENTS);
                this.getDocument().addPositionUpdater(this.fPositionUpdater);
                this.parse();
            }
        }
    }

    public void dispose() {
        if (this.fContent != null) {
            this.fContent.clear();
            this.fContent = null;
        }
    }

    public boolean isDeleted(Object object) {
        return false;
    }

    public Object[] getElements(Object object) {
        if (object == this.fContentInput) {
            return this.filter(null);
        }
        return this.fContent.toArray();
    }

    public boolean hasChildren(Object object) {
        if (object instanceof SplusContentOutlinePage.Member) {
            return ((SplusContentOutlinePage.Member)object).hasChildren();
        }
        return object == this.fContentInput;
    }

    public Object getParent(Object object) {
        if (object instanceof SplusContentOutlinePage.Member) {
            return ((SplusContentOutlinePage.Member)object).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object object) {
        if (object instanceof SplusContentOutlinePage.Member) {
            return this.filter(object);
        }
        return new Object[0];
    }
}

