/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SplusDocumentSetupParticipant
implements IDocumentSetupParticipant {
    public static final String SPLUS_PARTITIONING = "__splus_partitioning";
    public static final String SPLUS_QUOTE_STRING = "__splus_quote_string";
    public static final String SPLUS_DBL_QUOTE_STRING = "__splus_dbl_quote_string";
    public static final String SPLUS_SINGLE_LINE_COMMENT = "__splus_single_line_comment";
    public static final String SPLUS_TASK_COMMENT = "__splus_comment_task_tag";
    public static final String[] SPLUS_PARTITION_TYPES = new String[]{"__dftl_partition_content_type", "__splus_single_line_comment", "__splus_quote_string", "__splus_dbl_quote_string"};

    public void setup(IDocument iDocument) {
        if (iDocument instanceof IDocumentExtension3) {
            IDocumentExtension3 iDocumentExtension3 = (IDocumentExtension3)iDocument;
            FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new FastSplusPartitionScanner(), SPLUS_PARTITION_TYPES);
            fastPartitioner.connect(iDocument);
            iDocumentExtension3.setDocumentPartitioner(SPLUS_PARTITIONING, (IDocumentPartitioner)fastPartitioner);
        }
    }

    private class FastSplusPartitionScanner
    implements IPartitionTokenScanner {
        private static final int EOF = -1;
        private static final int SPLUS = 0;
        private static final int COMMENT = 1;
        private static final int QUOTE_STRING = 2;
        private static final int DBL_QUOTE_STRING = 3;
        private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
        private boolean fEscape = false;
        private int fHeadStart = 0;
        private int fScannerOffset = 0;
        private int fSilentUntilOffset = 0;
        private int fScannerLength = 0;
        private int fCurrentState = 0;
        private int fLastState = 0;
        private final IToken[] fTokens = new IToken[]{new Token((Object)SPLUS_PARTITION_TYPES[0]), new Token((Object)SPLUS_PARTITION_TYPES[1]), new Token((Object)SPLUS_PARTITION_TYPES[2]), new Token((Object)SPLUS_PARTITION_TYPES[3])};

        private void setEscape(boolean bl) {
            this.fEscape = bl;
        }

        private void setHeadStart(int n) {
            this.fHeadStart = n;
        }

        private boolean handleString(char c, char c2) {
            if (c2 == c && !this.fEscape) {
                return true;
            }
            if (c2 != '\n') {
                this.fEscape = this.fEscape ? false : c2 == '\\';
            }
            return false;
        }

        private void incrementPositioning() {
            this.setPositioningLength(this.fScannerLength + 1);
        }

        private void setPositioningLength(int n) {
            this.fScannerLength = n;
        }

        private void updatePositioning() {
            this.fScannerOffset += this.fScannerLength - this.fHeadStart;
            this.setPositioningLength(this.fHeadStart);
            this.setHeadStart(0);
        }

        private IToken returnToken(int n, int n2) {
            this.fLastState = n;
            this.fCurrentState = n2;
            if (n == -1 || this.getTokenLength() != 0) {
                if (this.fLastState != -1) {
                    return this.fTokens[this.fLastState];
                }
                return Token.EOF;
            }
            this.updatePositioning();
            return null;
        }

        public IToken nextToken() {
            IToken iToken;
            this.updatePositioning();
            block11: do {
                int n;
                if ((n = this.fScanner.read()) == -1) {
                    if (this.fScannerLength == 0 && this.fScannerOffset == 0) {
                        return Token.EOF;
                    }
                    iToken = this.returnToken(this.fCurrentState, -1);
                    if (iToken != null) {
                        return iToken;
                    }
                }
                iToken = null;
                block0 : switch (this.fCurrentState) {
                    case 0: {
                        this.incrementPositioning();
                        switch (n) {
                            case 35: {
                                this.setHeadStart(1);
                                iToken = this.returnToken(this.fCurrentState, 1);
                                break block0;
                            }
                            case 39: {
                                this.setHeadStart(1);
                                this.setEscape(false);
                                iToken = this.returnToken(this.fCurrentState, 2);
                                break block0;
                            }
                            case 34: {
                                this.setHeadStart(1);
                                this.setEscape(false);
                                iToken = this.returnToken(this.fCurrentState, 3);
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.incrementPositioning();
                        if (!this.handleString('\'', (char)n)) continue block11;
                        this.setHeadStart(0);
                        if (n == 10) {
                            iToken = this.returnToken(this.fCurrentState, this.fCurrentState);
                            break;
                        }
                        iToken = this.returnToken(this.fCurrentState, 0);
                        break;
                    }
                    case 3: {
                        this.incrementPositioning();
                        if (!this.handleString('\"', (char)n)) continue block11;
                        this.setHeadStart(0);
                        if (n == 10) {
                            iToken = this.returnToken(this.fCurrentState, this.fCurrentState);
                            break;
                        }
                        iToken = this.returnToken(this.fCurrentState, 0);
                        break;
                    }
                    case 1: {
                        this.incrementPositioning();
                        if (n != 10) continue block11;
                        this.setHeadStart(0);
                        iToken = this.returnToken(this.fCurrentState, 0);
                        break;
                    }
                    default: {
                        this.incrementPositioning();
                    }
                }
            } while (iToken == null);
            return iToken;
        }

        private int getState(String string) {
            if (string == null) {
                return 0;
            }
            if (string.equals(SplusDocumentSetupParticipant.SPLUS_SINGLE_LINE_COMMENT)) {
                return 1;
            }
            if (string.equals(SplusDocumentSetupParticipant.SPLUS_QUOTE_STRING)) {
                return 2;
            }
            if (string.equals(SplusDocumentSetupParticipant.SPLUS_DBL_QUOTE_STRING)) {
                return 3;
            }
            return 0;
        }

        public void setPartialRange(IDocument iDocument, int n, int n2, String string, int n3) {
            this.fScanner.setRange(iDocument, n, n2);
            if (n3 < 0) {
                this.fSilentUntilOffset = 0;
                this.fScannerLength = 0;
                this.fScannerOffset = 0;
            } else {
                this.fScannerLength = this.fSilentUntilOffset = n - n3;
                this.fScannerOffset = n3;
                this.setHeadStart(this.fSilentUntilOffset);
            }
            if (n == 0) {
                this.fCurrentState = 0;
                this.fLastState = 0;
            } else {
                this.fLastState = this.fCurrentState = this.getState(string);
            }
        }

        public void setRange(IDocument iDocument, int n, int n2) {
            this.fScanner.setRange(iDocument, n, n2);
            this.fScannerOffset = Math.max(0, n);
            this.fScannerLength = 0;
            this.fCurrentState = 0;
        }

        public int getTokenLength() {
            int n = this.fScannerLength - this.fHeadStart;
            if (this.fScannerOffset == -1) {
                n += this.fScannerOffset;
            }
            return n;
        }

        public int getTokenOffset() {
            return Math.max(this.fScannerOffset, 0);
        }

        private class BufferedDocumentScanner
        implements ICharacterScanner {
            private IDocument fDocument;
            private int fRangeOffset;
            private int fRangeLength;
            private char[][] fDelimiters;
            private final char[] fBuffer;
            private int fBufferOffset;
            private int fBufferLength;
            private int fOffset;

            public BufferedDocumentScanner(int n) {
                Assert.isTrue((n >= 1 ? 1 : 0) != 0);
                this.fBuffer = new char[n];
            }

            private final void updateBuffer(int n) {
                this.fBufferOffset = n;
                this.fBufferLength = this.fBufferOffset + this.fBuffer.length > this.fRangeOffset + this.fRangeLength ? this.fRangeLength - (this.fBufferOffset - this.fRangeOffset) : this.fBuffer.length;
                try {
                    String string = this.fDocument.get(this.fBufferOffset, this.fBufferLength);
                    string.getChars(0, this.fBufferLength, this.fBuffer, 0);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public final void setRange(IDocument iDocument, int n, int n2) {
                this.fDocument = iDocument;
                this.fRangeOffset = n;
                this.fRangeLength = n2;
                String[] stringArray = iDocument.getLegalLineDelimiters();
                this.fDelimiters = new char[stringArray.length][];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fDelimiters[i] = stringArray[i].toCharArray();
                }
                this.updateBuffer(n);
                this.fOffset = 0;
            }

            public final int read() {
                if (this.fOffset == this.fBufferLength) {
                    if (this.fBufferOffset + this.fBufferLength == this.fDocument.getLength()) {
                        return -1;
                    }
                    this.updateBuffer(this.fBufferOffset + this.fBufferLength);
                    this.fOffset = 0;
                }
                return this.fBuffer[this.fOffset++];
            }

            public final void unread() {
                if (this.fOffset == 0) {
                    if (this.fBufferOffset != this.fRangeOffset) {
                        this.updateBuffer(this.fBufferOffset - this.fBuffer.length);
                        this.fOffset = this.fBuffer.length - 1;
                    }
                } else {
                    --this.fOffset;
                }
            }

            public final int getColumn() {
                try {
                    int n = this.fBufferOffset + this.fOffset;
                    int n2 = this.fDocument.getLineOfOffset(n);
                    int n3 = this.fDocument.getLineOffset(n2);
                    return n - n3;
                }
                catch (BadLocationException badLocationException) {
                    return -1;
                }
            }

            public final char[][] getLegalLineDelimiters() {
                return this.fDelimiters;
            }
        }
    }
}

