/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.context.AbstractSplusScanner;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusCodeScanner;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusCommentScanner;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusCompletionProcessor;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusElementHyperlinkDetector;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusStringScanner;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusAnnotationHover;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusAutoIndentStrategy;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusDoubleClickSelector;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.DefaultHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ITextEditor;

public class SplusSourceViewerConfiguration
extends SourceViewerConfiguration {
    private SplusCompletionProcessor fSplusCompletionProcessor;
    private ContentAssistant fContentAssistant;
    private AbstractSplusScanner fSinglelineCommentScanner;
    private AbstractSplusScanner fDblQuoteStringScanner;
    private AbstractSplusScanner fQuoteStringScanner;
    private IPreferenceStore fPreferenceStore;
    private SplusEditor feditor;

    public SplusSourceViewerConfiguration(SplusEditor splusEditor, IPreferenceStore iPreferenceStore) {
        this.fPreferenceStore = iPreferenceStore;
        this.feditor = splusEditor;
        this.fSinglelineCommentScanner = new SplusCommentScanner(SplusEditorPlugin.getDefault().getSplusColorProvider(), this.fPreferenceStore, this.feditor, "splus_single_line_comment");
        this.fDblQuoteStringScanner = new SplusStringScanner(SplusEditorPlugin.getDefault().getSplusColorProvider(), this.fPreferenceStore, this.feditor, false);
        this.fQuoteStringScanner = new SplusStringScanner(SplusEditorPlugin.getDefault().getSplusColorProvider(), this.fPreferenceStore, this.feditor, true);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        SplusCodeScanner splusCodeScanner;
        if (this.fSinglelineCommentScanner.affectsBehavior(propertyChangeEvent)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(propertyChangeEvent);
            this.feditor.getViewer().invalidateTextPresentation();
        }
        if (this.fDblQuoteStringScanner.affectsBehavior(propertyChangeEvent)) {
            this.fDblQuoteStringScanner.adaptToPreferenceChange(propertyChangeEvent);
            this.feditor.getViewer().invalidateTextPresentation();
        }
        if (this.fQuoteStringScanner.affectsBehavior(propertyChangeEvent)) {
            this.fQuoteStringScanner.adaptToPreferenceChange(propertyChangeEvent);
            this.feditor.getViewer().invalidateTextPresentation();
        }
        if ((splusCodeScanner = (SplusCodeScanner)SplusEditorPlugin.getDefault().getSplusCodeScanner()).affectsBehavior(propertyChangeEvent)) {
            splusCodeScanner.adaptToPreferenceChange(propertyChangeEvent);
            this.feditor.getViewer().invalidateTextPresentation();
        }
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new SplusAnnotationHover();
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer iSourceViewer, String string) {
        return "__dftl_partition_content_type".equals(string) ? new SplusAutoIndentStrategy() : new DefaultAutoIndentStrategy();
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer iSourceViewer) {
        return "__splus_partitioning";
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__splus_quote_string", "__splus_dbl_quote_string", "__splus_single_line_comment"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer iSourceViewer) {
        this.fContentAssistant = new ContentAssistant();
        this.fSplusCompletionProcessor = new SplusCompletionProcessor(this.fContentAssistant);
        this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fSplusCompletionProcessor, "__dftl_partition_content_type");
        SplusCompletionProcessor.configure(this.fContentAssistant, this.fPreferenceStore);
        this.fContentAssistant.enableAutoActivation(true);
        this.fContentAssistant.setAutoActivationDelay(500);
        this.fContentAssistant.setProposalPopupOrientation(10);
        this.fContentAssistant.setContextInformationPopupOrientation(20);
        this.fContentAssistant.setContextInformationPopupBackground(SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(new RGB(150, 150, 0)));
        this.fContentAssistant.enablePrefixCompletion(false);
        return this.fContentAssistant;
    }

    public ContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public SplusCompletionProcessor getSplusCompletionProcessor() {
        return this.fSplusCompletionProcessor;
    }

    public String getDefaultPrefix(ISourceViewer iSourceViewer, String string) {
        return "__dftl_partition_content_type".equals(string) ? "#" : null;
    }

    public String[] getDefaultPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"#"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        return new SplusDoubleClickSelector();
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"\t", "    "};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer iSourceViewer) {
        PresentationReconciler presentationReconciler = new PresentationReconciler();
        presentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
        DefaultDamagerRepairer defaultDamagerRepairer = null;
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__splus_single_line_comment");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__splus_single_line_comment");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getQuoteStringScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__splus_quote_string");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__splus_quote_string");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)this.getDblQuoteStringScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__splus_dbl_quote_string");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__splus_dbl_quote_string");
        defaultDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)SplusEditorPlugin.getDefault().getSplusCodeScanner());
        presentationReconciler.setDamager((IPresentationDamager)defaultDamagerRepairer, "__dftl_partition_content_type");
        presentationReconciler.setRepairer((IPresentationRepairer)defaultDamagerRepairer, "__dftl_partition_content_type");
        return presentationReconciler;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected RuleBasedScanner getQuoteStringScanner() {
        return this.fQuoteStringScanner;
    }

    protected RuleBasedScanner getDblQuoteStringScanner() {
        return this.fDblQuoteStringScanner;
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(iSourceViewer);
        }
        return this.fPreferenceStore.getInt("tabWidth");
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return new SplusTextHover();
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        IHyperlinkDetector[] iHyperlinkDetectorArray = super.getHyperlinkDetectors(iSourceViewer);
        if (this.feditor == null) {
            return iHyperlinkDetectorArray;
        }
        int n = iHyperlinkDetectorArray != null ? iHyperlinkDetectorArray.length : 0;
        IHyperlinkDetector[] iHyperlinkDetectorArray2 = new IHyperlinkDetector[n + 1];
        iHyperlinkDetectorArray2[0] = new SplusElementHyperlinkDetector((ITextEditor)this.feditor);
        for (int i = 0; i < n; ++i) {
            iHyperlinkDetectorArray2[i + 1] = iHyperlinkDetectorArray[i];
        }
        return iHyperlinkDetectorArray2;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer iSourceViewer) {
        return new DefaultHyperlinkPresenter(this.fPreferenceStore);
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute textAttribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)textAttribute));
        }
    }
}

