/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.graph;

import com.insightful.controls.SplusButton;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.client.ServerFile;
import com.insightful.splus.eclipse.graph.DefaultDialog;
import com.insightful.splus.eclipse.graph.SWTExportGraphCommand;
import com.insightful.splus.graph.ExportGraphCommand;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class SWTExportGraphDialog
extends DefaultDialog {
    SWTExportGraphCommand m_cmd;
    JFileChooser m_fileChooser;
    Dialog m_saveAsDialog;
    AccessoryPanel m_accessory;
    public boolean m_ok = false;

    public SWTExportGraphDialog(SWTExportGraphCommand sWTExportGraphCommand, Shell shell) {
        super(shell, "Save Graph As");
        this.m_cmd = sWTExportGraphCommand;
        this.m_accessory = new AccessoryPanel();
        this.m_fileChooser = new JFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
        this.m_fileChooser.setAccessory(this.m_accessory);
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.removeChoosableFileFilter(this.m_fileChooser.getAcceptAllFileFilter());
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    SWTExportGraphDialog.this.m_ok = true;
                    SWTExportGraphDialog.this.m_cmd.setImageType(SWTExportGraphDialog.this.getChosenFilterType());
                    SWTExportGraphDialog.this.m_cmd.setImageFilename(ServerFile.convertServerFilePath((String)SWTExportGraphDialog.this.m_fileChooser.getSelectedFile().getPath()));
                    SplusSystem.setCwd((File)SWTExportGraphDialog.this.m_fileChooser.getCurrentDirectory());
                } else {
                    SWTExportGraphDialog.this.m_ok = false;
                }
                SWTExportGraphDialog.this.close();
            }
        });
        FileFilter fileFilter = null;
        for (int i = this.m_cmd.getFirstImageType(); i <= this.m_cmd.getLastImageType(); ++i) {
            FileFilter fileFilter2 = new FileFilter(i, ExportGraphCommand.getImageTypeDescription((int)i));
            this.m_fileChooser.addChoosableFileFilter(fileFilter2);
            if (i != this.m_cmd.getImageType()) continue;
            fileFilter = fileFilter2;
        }
        if (fileFilter != null) {
            this.m_fileChooser.setFileFilter(fileFilter);
        }
        this.SWT_AWT_fromPanel(this.m_fileChooser);
    }

    int getChosenFilterType() {
        FileFilter fileFilter = (FileFilter)this.m_fileChooser.getFileFilter();
        return fileFilter.getImageType();
    }

    public static class OptionsDialog
    extends DefaultDialog {
        SWTExportGraphCommand m_cmd;
        boolean m_cancel = true;
        int m_type;
        private final int SPACE_BETWEEN_BUTTONS = 8;
        private final String sm_strOK = "OK";
        private final String sm_strCancel = "Cancel";
        private String AUTO_SIZE = "Auto";
        private String UNITS_INCHES = "inches";
        private String UNITS_CM = "centimeters";
        private String UNITS_PIXELS = "pixels";
        private final double PIXELS_PER_INCH = 96.0;
        private final double PIXELS_PER_CM = 37.79527559055118;
        private Combo m_cbColorDepth;
        private Text m_tfQuality;
        private Combo m_cbHeight;
        private Combo m_cbWidth;
        private Combo m_cbUnits;
        String[] m_PNGColorDepthStrings = new String[]{"Black and White", "Grayscale 4 shades", "Grayscale 16 shades", "Grayscale 256 shades", "Color"};
        int[] m_PNGColorDepthValues = new int[]{1, 2, 4, 8, 8};
        boolean[] m_PNGColorDepthIsColor = new boolean[]{false, false, false, false, true};

        public OptionsDialog(Shell shell, SWTExportGraphCommand sWTExportGraphCommand, int n) {
            super(shell, "Export Options");
            this.m_cmd = sWTExportGraphCommand;
            this.m_type = n;
            this.m_cmd.setImageType(this.m_type);
        }

        public void openIgnoreResults() {
            this.m_shell.setText(this.m_title);
            this.setContents(this.m_shell);
            this.m_shell.setSize(400, 200);
            this.m_shell.open();
        }

        private void initializeCombo(Combo combo, String string) {
            boolean bl = true;
            for (int i = 0; i < combo.getItemCount(); ++i) {
                if (!combo.getItem(i).equals(string)) continue;
                combo.select(i);
                bl = false;
                break;
            }
            if (bl) {
                combo.add(string);
                combo.select(combo.getItemCount() - 1);
            }
        }

        private void setContents(Shell shell) {
            Label label;
            Composite composite;
            Composite composite2;
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite composite3 = new Composite((Composite)shell, 0);
            composite3.setLayout((Layout)new GridLayout(1, false));
            composite3.setLayoutData((Object)new GridData(1808));
            if (this.m_cmd.getImageType() == 2) {
                composite2 = new Composite(composite3, 0);
                composite2.setLayoutData((Object)new GridData(768));
                composite2.setLayout((Layout)new GridLayout(2, false));
                composite = new Label(composite2, 0);
                composite.setText("Colors: ");
                this.m_cbColorDepth = new Combo(composite2, 8);
                this.m_cbColorDepth.setLayoutData((Object)new GridData(768));
                int n = -1;
                for (int i = 0; i < this.m_PNGColorDepthStrings.length; ++i) {
                    this.m_cbColorDepth.add(this.m_PNGColorDepthStrings[i]);
                    if (this.m_PNGColorDepthValues[i] != this.m_cmd.getImageBitDepth() || this.m_PNGColorDepthIsColor[i] != this.m_cmd.getImageIsColor()) continue;
                    n = i;
                }
                if (n != -1) {
                    this.m_cbColorDepth.select(n);
                }
            } else if (this.m_cmd.getImageType() == 0) {
                composite2 = new Composite(composite3, 0);
                composite2.setLayoutData((Object)new GridData(768));
                composite2.setLayout((Layout)new GridLayout(2, false));
                composite = new Label(composite2, 0);
                composite.setText("Q Factor:");
                this.m_tfQuality = new Text(composite2, 2048);
                this.m_tfQuality.setText(Double.toString(this.m_cmd.getImageQuality()));
                this.m_tfQuality.setLayoutData((Object)new GridData(768));
            }
            composite2 = new Composite(composite3, 0);
            composite2.setLayoutData((Object)new GridData(1808));
            composite = new Composite(composite3, 0);
            composite.setLayoutData((Object)new GridData(896));
            if (this.m_cmd.getImageType() == 5) {
                composite2.setLayout((Layout)new GridLayout(1, false));
                label = new Label(composite2, 0);
                label.setText("There are no export options for this file type");
            } else {
                String string;
                composite2.setLayout((Layout)new GridLayout(6, false));
                label = new Label(composite2, 0);
                label.setText("Height");
                this.m_cbHeight = new Combo(composite2, 0);
                Label label2 = new Label(composite2, 0);
                label2.setText("Width");
                this.m_cbWidth = new Combo(composite2, 0);
                Label label3 = new Label(composite2, 0);
                label3.setText("Units");
                this.m_cbUnits = new Combo(composite2, 0);
                this.m_cbUnits.add(this.UNITS_PIXELS);
                this.m_cbUnits.add(this.UNITS_INCHES);
                this.m_cbUnits.add(this.UNITS_CM);
                this.m_cbUnits.select(0);
                this.m_cbUnits.setEnabled(false);
                this.m_cbHeight.add(this.AUTO_SIZE);
                this.m_cbWidth.add(this.AUTO_SIZE);
                this.m_cbHeight.setEnabled(true);
                this.m_cbWidth.setEnabled(true);
                Dimension dimension = this.m_cmd.getImageSize();
                if (dimension.width >= 0) {
                    string = Integer.toString(dimension.width);
                    this.initializeCombo(this.m_cbWidth, string);
                }
                if (dimension.height >= 0) {
                    string = Integer.toString(dimension.height);
                    this.initializeCombo(this.m_cbHeight, string);
                }
            }
            composite.setLayout((Layout)new GridLayout(2, false));
            label = new Button(composite, 0);
            label.setText("OK");
            Button button = new Button(composite, 0);
            button.setText("Cancel");
            label.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    OptionsDialog.this.doOK();
                }
            });
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    OptionsDialog.this.close();
                }
            });
        }

        public boolean wasCancelled() {
            return this.m_cancel;
        }

        int getDimension(Combo combo) {
            int n = combo.getSelectionIndex();
            if (n == -1) {
                String string = combo.getText();
                if (string.length() != 0) {
                    try {
                        return Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return -1;
            }
            String string = combo.getItem(n);
            if (0 == string.compareTo(this.AUTO_SIZE)) {
                return -1;
            }
            String string2 = this.m_cbUnits.getItem(combo.getSelectionIndex());
            double d = string2.compareTo(this.UNITS_INCHES) == 0 ? 96.0 : (string2.compareTo(this.UNITS_CM) == 0 ? 37.79527559055118 : 1.0);
            try {
                return (int)(Double.parseDouble(string) * d);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public void doOK() {
            this.m_cancel = false;
            this.m_cmd.setImageSize(this.getDimension(this.m_cbWidth), this.getDimension(this.m_cbHeight));
            if (this.m_cmd.getImageType() == 2) {
                int n = this.m_cbColorDepth.getSelectionIndex();
                this.m_cmd.setImageBitDepth(this.m_PNGColorDepthValues[n]);
                this.m_cmd.setImageIsColor(this.m_PNGColorDepthIsColor[n]);
            }
            if (this.m_cmd.getImageType() == 0) {
                double d = 1.0;
                try {
                    d = Double.parseDouble(this.m_tfQuality.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_cmd.setImageQuality(d);
            }
            this.close();
        }
    }

    class FileFilter
    extends javax.swing.filechooser.FileFilter {
        int m_type;
        String m_description;

        FileFilter(int n, String string) {
            this.m_type = n;
            this.m_description = string;
        }

        public String getDescription() {
            return this.m_description;
        }

        public int getImageType() {
            return this.m_type;
        }

        public boolean accept(File file) {
            return true;
        }
    }

    class AccessoryPanel
    extends JPanel {
        public AccessoryPanel() {
            SplusButton splusButton = new SplusButton("Options...");
            this.setPreferredSize(splusButton.getPreferredSize());
            this.add((Component)splusButton);
            splusButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SWTExportGraphDialog.this.m_shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            OptionsDialog optionsDialog = new OptionsDialog(new Shell(SWTExportGraphDialog.this.m_shell), SWTExportGraphDialog.this.m_cmd, SWTExportGraphDialog.this.getChosenFilterType());
                            optionsDialog.open();
                        }
                    });
                }
            });
        }
    }
}

