/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import com.insightful.splus.eclipse.preferences.SplusOutputPreferencePage;
import com.insightful.splus.eclipse.views.util.AdaptedViewerWrapper;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class SplusConsolePreferencePage
extends SplusOutputPreferencePage {
    private static SplusConsolePreferencePage m_consolePrefs = null;
    private BooleanFieldEditor fHistory;
    private ColorSelector m_inputColorSel;

    protected String preferencePrefix() {
        return "";
    }

    public String inputPropertyName() {
        return "input_color";
    }

    public String lineRetentionPropertyName() {
        return "consoleLineRetention";
    }

    public String historyPersistencePropertyName() {
        return "consoleHistoryPersistance";
    }

    public String copyPromptsPropertyName() {
        return "copyPrompts";
    }

    public static SplusConsolePreferencePage getConsolePreferencePage() {
        if (m_consolePrefs == null) {
            m_consolePrefs = new SplusConsolePreferencePage();
        }
        return m_consolePrefs;
    }

    public SplusConsolePreferencePage() {
        this.setDescription("Spotfire S+ Console options");
    }

    public static Color getConsoleViewBackground() {
        return SplusConsolePreferencePage.getBackground(SplusConsolePreferencePage.getConsolePreferencePage());
    }

    public static Color getConsoleViewInputColor() {
        String string = SplusEditorPlugin.getDefault().getPluginPreferences().getString(SplusConsolePreferencePage.getConsolePreferencePage().inputPropertyName());
        return SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(SplusEditorPreferencePage.stringToRGB(string));
    }

    public static Color getConsoleViewOutputColor() {
        return SplusConsolePreferencePage.getOutputColor(SplusConsolePreferencePage.getConsolePreferencePage());
    }

    public static FontData getConsoleViewConsoleFont() {
        return SplusConsolePreferencePage.getConsoleFont(SplusConsolePreferencePage.getConsolePreferencePage());
    }

    public static int getLineRetention() {
        String string = System.getProperty(SplusConsolePreferencePage.getConsolePreferencePage().lineRetentionPropertyName());
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n > 4) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getInt(SplusConsolePreferencePage.getConsolePreferencePage().lineRetentionPropertyName());
    }

    public static boolean getCopyPrompts() {
        return SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(SplusConsolePreferencePage.getConsolePreferencePage().copyPromptsPropertyName());
    }

    public static boolean getHistoryPersistance() {
        String string = System.getProperty(SplusConsolePreferencePage.getConsolePreferencePage().historyPersistencePropertyName());
        if (string != null && string.toLowerCase().startsWith("t")) {
            return true;
        }
        return SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(SplusConsolePreferencePage.getConsolePreferencePage().historyPersistencePropertyName());
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setDefault(this.inputPropertyName(), this.rgbToString(AdaptedViewerWrapper.DEFAULT_INPUT_COLOR.getRGB()));
        iPreferenceStore.setDefault(this.copyPromptsPropertyName(), false);
        iPreferenceStore.setDefault(this.lineRetentionPropertyName(), 150000);
        iPreferenceStore.setDefault(this.historyPersistencePropertyName(), false);
    }

    public void addControlsToPage(Composite composite) {
        Composite composite2 = SplusConsolePreferencePage.createComposite(composite, 4, false, 4);
        composite2.setLayoutData((Object)new GridData(768));
        this.createHistoryGroup(composite2);
        super.addControlsToPage(composite);
        Composite composite3 = SplusConsolePreferencePage.createComposite(composite, 4, false, 4);
        composite3.setLayoutData((Object)new GridData(768));
        this.createCopyGroup(composite3);
    }

    private void createHistoryGroup(Composite composite) {
        Group group = SplusConsolePreferencePage.createGroup(composite, "History Settings", 2, false);
        Composite composite2 = SplusConsolePreferencePage.createComposite((Composite)group, 2, false, 2);
        this.fHistory = new BooleanFieldEditor(this.historyPersistencePropertyName(), "Store Console History between sessions", composite2);
        this.addField((FieldEditor)this.fHistory);
    }

    private void createCopyGroup(Composite composite) {
        Group group = SplusConsolePreferencePage.createGroup(composite, "Copy Settings", 2, false);
        Composite composite2 = SplusConsolePreferencePage.createComposite((Composite)group, 2, false, 2);
        this.addField((FieldEditor)new BooleanFieldEditor(this.copyPromptsPropertyName(), "Include Prompts in Copy action", composite2));
    }

    protected void createColorSelectionControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Input Color");
        this.m_inputColorSel = new ColorSelector(composite);
        this.m_inputColorSel.setColorValue(SplusConsolePreferencePage.getConsoleViewInputColor().getRGB());
        super.createColorSelectionControls(composite);
    }

    protected boolean saveFontInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue(this.inputPropertyName(), this.rgbToString(this.m_inputColorSel.getColorValue()));
        return super.saveFontInfo();
    }

    protected void restoreFontDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = iPreferenceStore.getDefaultString(this.inputPropertyName());
        RGB rGB = SplusEditorPreferencePage.stringToRGB(string);
        this.m_inputColorSel.setColorValue(rGB);
        super.restoreFontDefaults();
    }
}

