/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.editors.spluseditor.util.ISplusColorConstants;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import com.insightful.splus.eclipse.views.util.ViewerWrapper;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SplusOutputPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
ISplusColorConstants {
    private static SplusOutputPreferencePage m_outputPrefs = null;
    private ColorSelector m_outputColorSel;
    private Text m_exampleText;
    private ColorFieldEditor fBackgroundColorEditor;
    private Composite fBackgroundColorEditorParent;
    private Button fBackgroundDefaultRadioButton;
    private Button fBackgroundCustomRadioButton;

    protected String preferencePrefix() {
        return "outputView_";
    }

    public String backgroundPropertyName() {
        return this.preferencePrefix() + "customBackground";
    }

    public String backgroundColorPropertyName() {
        return this.preferencePrefix() + "backgroundFont";
    }

    public String outputPropertyName() {
        return this.preferencePrefix() + "output_color";
    }

    public String fontPropertyName() {
        return this.preferencePrefix() + "console_font";
    }

    public static SplusOutputPreferencePage getOutputPreferencePage() {
        if (m_outputPrefs == null) {
            m_outputPrefs = new SplusOutputPreferencePage();
        }
        return m_outputPrefs;
    }

    public SplusOutputPreferencePage() {
        super(1);
        this.setPreferenceStore(SplusEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription("Spotfire S+ Output options");
        this.initializeDefaults();
    }

    public static Color getOutputViewBackground() {
        return SplusOutputPreferencePage.getBackground(SplusOutputPreferencePage.getOutputPreferencePage());
    }

    protected static Color getBackground(SplusOutputPreferencePage splusOutputPreferencePage) {
        if (!SplusEditorPlugin.getDefault().getPluginPreferences().getBoolean(splusOutputPreferencePage.backgroundPropertyName())) {
            return null;
        }
        String string = SplusEditorPlugin.getDefault().getPluginPreferences().getString(splusOutputPreferencePage.backgroundColorPropertyName());
        return SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(SplusEditorPreferencePage.stringToRGB(string));
    }

    public static Color getOutputViewOutputColor() {
        return SplusOutputPreferencePage.getOutputColor(SplusOutputPreferencePage.getOutputPreferencePage());
    }

    protected static Color getOutputColor(SplusOutputPreferencePage splusOutputPreferencePage) {
        String string = SplusEditorPlugin.getDefault().getPluginPreferences().getString(splusOutputPreferencePage.outputPropertyName());
        return SplusEditorPlugin.getDefault().getSplusColorProvider().getColor(SplusEditorPreferencePage.stringToRGB(string));
    }

    public static FontData getOutputViewConsoleFont() {
        return SplusOutputPreferencePage.getConsoleFont(SplusOutputPreferencePage.getOutputPreferencePage());
    }

    protected static FontData getConsoleFont(SplusOutputPreferencePage splusOutputPreferencePage) {
        String string = SplusEditorPlugin.getDefault().getPluginPreferences().getString(splusOutputPreferencePage.fontPropertyName());
        if (string.length() == 0) {
            return null;
        }
        return new FontData(string);
    }

    protected void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setDefault(this.backgroundPropertyName(), false);
        iPreferenceStore.setDefault(this.backgroundColorPropertyName(), "0,0,0");
        iPreferenceStore.setDefault(this.outputPropertyName(), this.rgbToString(ViewerWrapper.DEFAULT_OUTPUT_COLOR.getRGB()));
        iPreferenceStore.setDefault(this.fontPropertyName(), ViewerWrapper.getDefaultFontData().toString());
    }

    public String rgbToString(RGB rGB) {
        return Integer.toString(rGB.red) + "," + Integer.toString(rGB.green) + "," + Integer.toString(rGB.blue);
    }

    public boolean performOk() {
        return this.isValid() && this.saveSyntaxInfo() && this.saveFontInfo() && super.performOk();
    }

    public void performApply() {
        if (this.isValid()) {
            this.saveSyntaxInfo();
            this.saveFontInfo();
            super.performApply();
        }
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        composite.setLayout((Layout)new GridLayout(4, false));
        this.addControlsToPage(composite);
        Group group = SplusOutputPreferencePage.createGroup(composite, "", 2, false);
        Composite composite2 = SplusOutputPreferencePage.createComposite((Composite)group, 2, false, 2);
        this.addField((FieldEditor)new BooleanFieldEditor("foo", "", composite2));
        group.setVisible(false);
    }

    protected void addControlsToPage(Composite composite) {
        Composite composite2 = SplusOutputPreferencePage.createComposite(composite, 4, false, 4);
        composite2.setLayoutData((Object)new GridData(768));
        this.createFontGroup(composite2);
        Composite composite3 = SplusOutputPreferencePage.createComposite(composite, 4, false, 4);
        composite3.setLayoutData((Object)new GridData(768));
        this.createBackgroundGroup(composite3);
    }

    protected static void setCompositeLayout(Composite composite, int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        composite.setLayout((Layout)gridLayout);
    }

    protected static Composite createComposite(Composite composite, int n, boolean bl, int n2) {
        Composite composite2 = new Composite(composite, 0);
        SplusOutputPreferencePage.setCompositeLayout(composite2, n, bl);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = n2;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    protected static Group createGroup(Composite composite, String string, int n, boolean bl) {
        Group group = new Group(composite, 16);
        group.setText(string);
        SplusOutputPreferencePage.setCompositeLayout((Composite)group, n, bl);
        GridData gridData = new GridData(800);
        group.setLayoutData((Object)gridData);
        return group;
    }

    private Text createExampleText(Composite composite) {
        Text text = new Text(composite, 2050);
        text.setSize(350, 50);
        text.setText("abcdefghijkl...");
        text.setFont(new Font((Device)text.getDisplay(), SplusOutputPreferencePage.getConsoleFont(this)));
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 50;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected void createFontGroup(Composite composite) {
        Group group = SplusOutputPreferencePage.createGroup(composite, "Font Settings", 3, false);
        Label label = new Label((Composite)group, 0);
        label.setText("Font Selection");
        this.m_exampleText = this.createExampleText((Composite)group);
        Button button = new Button((Composite)group, 0);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SplusOutputPreferencePage.this.setNewFont(SplusOutputPreferencePage.this.m_exampleText.getShell());
                SplusOutputPreferencePage.this.updateFontGUI();
            }
        });
        button.setText("Change");
        Composite composite2 = SplusOutputPreferencePage.createComposite((Composite)group, 2, false, 2);
        this.createColorSelectionControls(composite2);
        this.updateFontGUI();
    }

    protected void createColorSelectionControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Output Color");
        this.m_outputColorSel = new ColorSelector(composite);
        this.m_outputColorSel.setColorValue(SplusOutputPreferencePage.getOutputColor(this).getRGB());
    }

    private void setNewFont(Shell shell) {
        FontDialog fontDialog = new FontDialog(shell);
        FontData[] fontDataArray = null;
        RGB rGB = null;
        fontDataArray = this.m_exampleText.getFont().getFontData();
        rGB = null;
        fontDialog.setFontList(fontDataArray);
        fontDialog.setRGB(rGB);
        FontData fontData = fontDialog.open();
        if (fontData == null) {
            return;
        }
        Font font = new Font((Device)this.m_exampleText.getDisplay(), fontData);
        this.m_exampleText.setFont(font);
    }

    private void updateFontGUI() {
        this.isValid();
    }

    protected void createBackgroundGroup(Composite composite) {
        Group group = SplusOutputPreferencePage.createGroup(composite, "Background Settings", 3, false);
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = SplusOutputPreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                SplusOutputPreferencePage.this.fBackgroundColorEditor.setEnabled(bl, SplusOutputPreferencePage.this.fBackgroundColorEditorParent);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        };
        boolean bl = iPreferenceStore.getBoolean(this.backgroundPropertyName());
        this.fBackgroundDefaultRadioButton = new Button((Composite)group, 16400);
        this.fBackgroundDefaultRadioButton.setText("System Default");
        this.fBackgroundDefaultRadioButton.addSelectionListener(selectionListener);
        this.fBackgroundDefaultRadioButton.setSelection(!bl);
        this.fBackgroundCustomRadioButton = new Button((Composite)group, 16400);
        this.fBackgroundCustomRadioButton.setText("Custom");
        this.fBackgroundCustomRadioButton.addSelectionListener(selectionListener);
        this.fBackgroundCustomRadioButton.setSelection(bl);
        Composite composite2 = new Composite((Composite)group, 16384);
        this.fBackgroundColorEditor = new ColorFieldEditor(this.backgroundColorPropertyName(), "", composite2);
        this.fBackgroundColorEditorParent = composite2;
        this.fBackgroundColorEditor.setPreferenceStore(iPreferenceStore);
        this.fBackgroundColorEditor.load();
        this.fBackgroundColorEditor.setEnabled(bl, this.fBackgroundColorEditorParent);
    }

    protected boolean saveFontInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue(this.fontPropertyName(), this.m_exampleText.getFont().getFontData()[0].toString());
        iPreferenceStore.setValue(this.outputPropertyName(), this.rgbToString(this.m_outputColorSel.getColorValue()));
        return true;
    }

    private boolean saveSyntaxInfo() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue(this.backgroundPropertyName(), this.fBackgroundCustomRadioButton.getSelection());
        String string = this.rgbToString(this.fBackgroundColorEditor.getColorSelector().getColorValue());
        iPreferenceStore.setValue(this.backgroundColorPropertyName(), string);
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.restoreSyntaxDefaults();
        this.restoreFontDefaults();
    }

    private void restoreSyntaxDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        boolean bl = iPreferenceStore.getDefaultBoolean(this.backgroundPropertyName());
        this.fBackgroundCustomRadioButton.setSelection(bl);
        this.fBackgroundDefaultRadioButton.setSelection(!bl);
        this.fBackgroundColorEditor.loadDefault();
    }

    protected void restoreFontDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        FontData fontData = new FontData(iPreferenceStore.getDefaultString(this.fontPropertyName()));
        this.m_exampleText.setFont(new Font((Device)this.m_exampleText.getDisplay(), fontData));
        String string = iPreferenceStore.getDefaultString(this.outputPropertyName());
        RGB rGB = SplusEditorPreferencePage.stringToRGB(string);
        this.m_outputColorSel.setColorValue(rGB);
        this.updateFontGUI();
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        return super.isValid();
    }
}

