/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.preferences;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.preferences.util.MultiSelectListEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SplusTaskPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final int TASKS = 0;
    public static final int SEVERITIES = 1;
    public static final String P_TASKS = "tasks";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String HIGH = "HIGH";
    public static final String NORMAL = "NORMAL";
    public static final String LOW = "LOW";
    public static final int HIGH_PRIORITY = 2;
    public static final int NORMAL_PRIORITY = 1;
    public static final int LOW_PRIORITY = 0;
    public static final String[] defaultTasks = new String[]{"FIXME {HIGH}", "TODO {NORMAL}", "XXX {LOW}"};
    public static boolean m_defaultsCreated = false;

    public SplusTaskPreferencePage() {
        super(1);
        this.setPreferenceStore(SplusEditorPlugin.getDefault().getPreferenceStore());
        this.initializeDefaults();
    }

    public static String[][] getTasks() {
        if (!m_defaultsCreated) {
            new SplusTaskPreferencePage();
        }
        String string = SplusEditorPlugin.getDefault().getPreferenceStore().getString(P_TASKS);
        String[] stringArray = SplusPreferencePage.convertFromCommaSepList(string);
        String[][] stringArray2 = new String[2][stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = stringBuffer;
            String string2 = stringArray[i];
            for (int j = 0; j < string2.length(); ++j) {
                char c = string2.charAt(j);
                if (c == '{' && stringBuffer3 == stringBuffer) {
                    stringBuffer3 = stringBuffer2;
                    continue;
                }
                if (c == '}') break;
                if (c == ' ') continue;
                stringBuffer3.append(c);
            }
            stringArray2[0][i] = stringBuffer.toString();
            stringArray2[1][i] = stringBuffer2.toString();
        }
        return stringArray2;
    }

    private void initializeDefaults() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setDefault(P_TASKS, SplusPreferencePage.convertToCommaSepList(defaultTasks));
        m_defaultsCreated = true;
    }

    public void createFieldEditors() {
        this.addField(new MultiSelectListEditor(P_TASKS, "Spotfire S+ &Task options", this.getFieldEditorParent()){

            protected String createList(String[] stringArray) {
                return SplusPreferencePage.convertToCommaSepList(stringArray);
            }

            protected String getNewInputObject() {
                try {
                    NewTaskDialog newTaskDialog = new NewTaskDialog(this.getShell());
                    newTaskDialog.open();
                    if (newTaskDialog.getReturnCode() == 1) {
                        return null;
                    }
                    return newTaskDialog.getString();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return "";
                }
            }

            protected String[] parseString(String string) {
                return SplusPreferencePage.convertFromCommaSepList(string);
            }
        });
    }

    public void init(IWorkbench iWorkbench) {
    }

    private class NewTaskDialog
    extends Dialog {
        private String m_str;

        public NewTaskDialog(Shell shell) {
            super(shell);
            this.m_str = "";
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        }

        public String getString() {
            return this.m_str;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setLayoutData((Object)new GridData(128));
            label.setText("Task Name:");
            final Text text = new Text(composite2, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.setText("XXX");
            Label label2 = new Label(composite2, 0);
            label2.setLayoutData((Object)new GridData(128));
            label2.setText("Severity:");
            final Combo combo = new Combo(composite2, 12);
            combo.setLayoutData((Object)new GridData(768));
            combo.add(SplusTaskPreferencePage.HIGH, 0);
            combo.add(SplusTaskPreferencePage.NORMAL, 1);
            combo.add(SplusTaskPreferencePage.LOW, 2);
            combo.setText(SplusTaskPreferencePage.NORMAL);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    NewTaskDialog.this.m_str = text.getText() + " {" + combo.getText() + "}";
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    NewTaskDialog.this.m_str = text.getText() + " {" + combo.getText() + "}";
                }
            });
            return composite2;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Add New Task Type");
        }

        protected Point getInitialSize() {
            Point point = super.getInitialSize();
            point.x *= 2;
            return point;
        }
    }
}

