/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.DrillableObjectsModel;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusPluginImages;
import com.insightful.splus.util.StringUtilities;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class ObjectsView
extends ViewPart
implements ISelectionChangedListener {
    public static final String ID = "com.insightful.splus.eclipse.views.ObjectsView";
    private Action m_refreshAction;
    private Action m_removeAction;
    private Action m_maxChildrenAction;
    private Action m_hideDotObjectsAction;
    private DrillableObjectsModel m_model;
    private SashForm m_sashForm;
    private TableViewer m_table;
    private TreeViewer m_tree;
    private final String NAME_COLUMN = "Name";
    private final String CLASS_COLUMN = "Data Class";
    private final String SUBCLASS_COLUMN = "Storage Mode";
    private final String LENGTH_COLUMN = "Extent";
    private final String DIM_COLUMN = "Object Size";
    private final String CREATE_COLUMN = "Date";
    private String[] columnNames = new String[]{"Name", "Data Class", "Storage Mode", "Extent", "Object Size", "Date"};
    private int[] columnWidths = new int[]{120, 105, 105, 65, 65, 150};
    private int m_sortColumn = -1;
    private int m_reverseSort = 1;
    private String m_currentDB = null;
    private static String g_objectInfoCommand = "javaGuiObjectsSummary";
    private static String g_dateFormat = ", date.format=11";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{13, 1};
    private boolean m_syncChange = false;
    private static HashMap IMG_MAP = new HashMap();

    public ObjectsView() {
        SplusEditorPlugin.getDefault().setObjects(this);
    }

    public void refreshObjects() {
        Object object;
        String string = this.m_currentDB;
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection && !noConnection.isEngineBusy()) {
            object = ((DefaultConnection)noConnection).processDataQueryAsStrings("search()", 50);
            this.m_currentDB = object[0];
            for (int i = 0; i < ((String[])object).length; ++i) {
                if (!object[i].equals(string)) continue;
                this.m_currentDB = object[i];
                break;
            }
        }
        if (!this.m_currentDB.equals(string)) {
            object = g_objectInfoCommand + "(where=\"" + this.m_currentDB + "\"" + g_dateFormat + ")";
            this.initializeModel((String)object, true);
            this.doRefresh();
        }
    }

    public Viewer getViewer() {
        if (this.m_tree != null && this.m_tree.getTree() != null && this.m_tree.getTree().isFocusControl()) {
            return this.m_tree;
        }
        return this.m_table;
    }

    public void dispose() {
    }

    public void doRefresh() {
        this.m_model.refresh();
        this.m_table.setInput((Object)this.m_model);
        this.m_tree.setInput((Object)this.m_model);
    }

    private void makeActions() {
        this.m_refreshAction = new Action(){

            public void run() {
                ObjectsView.this.doRefresh();
            }
        };
        this.m_refreshAction.setToolTipText("Refresh Objects View");
        this.m_removeAction = new Action(){

            public void run() {
                StructuredSelection structuredSelection = (StructuredSelection)ObjectsView.this.getViewer().getSelection();
                if (structuredSelection != null && !structuredSelection.isEmpty()) {
                    String[] stringArray = new String[structuredSelection.size()];
                    List list = structuredSelection.toList();
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        Vector vector = (Vector)list.get(i);
                        String string = "remove(\"" + vector.get(0) + "\", where=\"" + ObjectsView.this.m_currentDB + "\")";
                        if (!ObjectsView.this.processDataQuery(string, false)) continue;
                        bl = true;
                    }
                    if (bl) {
                        ObjectsView.this.m_refreshAction.run();
                    }
                }
                ObjectsView.this.doRefresh();
            }
        };
        this.m_removeAction.setText("Remove");
        this.m_removeAction.setToolTipText("Remove Selected Object");
        this.m_maxChildrenAction = new Action(){

            public void run() {
                int n;
                IInputValidator iInputValidator = new IInputValidator(){

                    public String isValid(String string) {
                        try {
                            Integer.parseInt(string);
                            return null;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return "Max children must be an Integer value";
                        }
                    }
                };
                int n2 = DrillableObjectsModel.getMaxChildren();
                InputDialog inputDialog = new InputDialog(ObjectsView.this.m_tree.getControl().getShell(), "Set Max Children", "Enter the maximum number of Children:", Integer.toString(n2), iInputValidator);
                if (inputDialog.open() == 0 && (n = Integer.parseInt(inputDialog.getValue())) != n2) {
                    DrillableObjectsModel.setMaxChildren(n);
                    ObjectsView.this.doRefresh();
                }
            }
        };
        this.m_maxChildrenAction.setText("Set Max Children");
        this.m_maxChildrenAction.setToolTipText("Set Max Children");
        this.m_hideDotObjectsAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                boolean bl = !DrillableObjectsModel.getHideDotObjects();
                DrillableObjectsModel.setHideDotObjects(bl);
                this.setChecked(bl);
                ObjectsView.this.doRefresh();
            }
        };
        this.m_hideDotObjectsAction.setChecked(DrillableObjectsModel.getHideDotObjects());
        this.m_hideDotObjectsAction.setText("Hide S-PLUS System Objects");
        this.m_hideDotObjectsAction.setToolTipText("Hide S-PLUS System Objects");
    }

    private boolean processDataQuery(String string, boolean bl) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            return ((DefaultConnection)noConnection).processDataQuery(string, this.getSite(), (IAction)(bl ? this.m_refreshAction : null));
        }
        return false;
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.removeAll();
                ObjectsView.this.fillContextMenu(iMenuManager);
            }
        });
        this.fillContextMenu(iMenuManager);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection && !noConnection.isEngineBusy()) {
            String[] stringArray = ((DefaultConnection)noConnection).processDataQueryAsStrings("search()", 50);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0 && this.m_currentDB == null) {
                    this.m_currentDB = stringArray[i];
                }
                SelectSearchPathAction selectSearchPathAction = new SelectSearchPathAction(stringArray[i]);
                iMenuManager.add((IAction)selectSearchPathAction);
            }
            iMenuManager.add((IContributionItem)new Separator("additions"));
            this.m_refreshAction.setText("Refresh: " + this.m_currentDB);
            iMenuManager.add((IAction)this.m_refreshAction);
            iMenuManager.add((IAction)this.m_removeAction);
            iMenuManager.add((IContributionItem)new Separator());
            iMenuManager.add((IAction)this.m_hideDotObjectsAction);
            iMenuManager.add((IAction)this.m_maxChildrenAction);
        }
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
    }

    private void hookContextMenu() {
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            MenuManager menuManager = new MenuManager("#PopupMenu");
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    ObjectsView.this.fillContextMenu(iMenuManager);
                }
            });
            Menu menu = menuManager.createContextMenu(this.m_table.getControl());
            this.m_table.getControl().setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.m_table);
            menu = menuManager.createContextMenu(this.m_tree.getControl());
            this.m_tree.getControl().setMenu(menu);
            this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.m_tree);
        }
    }

    public void createPartControl(Composite composite) {
        this.m_sashForm = new SashForm(composite, 256);
        GridData gridData = new GridData(1808);
        this.m_sashForm.setLayoutData((Object)gridData);
        this.m_table = new TableViewer((Composite)this.m_sashForm, 66306){

            protected void handleDispose(DisposeEvent disposeEvent) {
            }
        };
        this.m_tree = new TreeViewer((Composite)this.m_sashForm){

            protected void handleDispose(DisposeEvent disposeEvent) {
            }
        };
        this.m_sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        final Table table = this.m_table.getTable();
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
            }
        });
        GridData gridData2 = new GridData(1808);
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalSpan = 3;
        table.setLayoutData((Object)gridData2);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(SplusEditorPlugin.getDefaultFont(composite.getDisplay()));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = table.indexOf((TableColumn)selectionEvent.widget);
                if (ObjectsView.this.m_sortColumn == n) {
                    ObjectsView.this.m_reverseSort = ObjectsView.this.m_reverseSort * -1;
                } else {
                    ObjectsView.this.m_sortColumn = n;
                    ObjectsView.this.m_reverseSort = 1;
                }
                ObjectsView.this.m_table.refresh();
            }
        };
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.createTableColumn(table, (SelectionListener)selectionAdapter, i);
        }
        this.m_table.setUseHashlookup(true);
        this.m_table.setColumnProperties(this.columnNames);
        this.m_table.setSorter((ViewerSorter)new SplusObjectSorter());
        this.m_tree.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_table.addSelectionChangedListener((ISelectionChangedListener)this);
        this.initializeModel(g_objectInfoCommand + "(" + g_dateFormat + ")", false);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void initializeModel(String string, boolean bl) {
        if (!bl && this.m_model != null) {
            return;
        }
        try {
            NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
            if (noConnection instanceof DefaultConnection) {
                this.m_model = new DrillableObjectsModel(string);
                this.m_table.setContentProvider((IContentProvider)new ObjectDescriptionProvider(this.m_model, false));
                this.m_table.setLabelProvider((IBaseLabelProvider)new ObjectDescriptionLabelProvider());
                this.m_tree.setContentProvider((IContentProvider)new ObjectDescriptionProvider(this.m_model, true));
                this.m_tree.setLabelProvider((IBaseLabelProvider)new ObjectDescriptionLabelProvider());
                this.m_table.setInput((Object)this.m_model);
                this.m_tree.setInput((Object)this.m_model);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }

    private TableColumn createTableColumn(Table table, SelectionListener selectionListener, int n) {
        TableColumn tableColumn = new TableColumn(table, 0, n);
        tableColumn.setText(this.columnNames[n]);
        tableColumn.setWidth(this.columnWidths[n]);
        tableColumn.addSelectionListener(selectionListener);
        return tableColumn;
    }

    public void setFocus() {
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (!this.m_syncChange) {
            String string;
            DrillableObjectsModel.DrillableNode drillableNode;
            this.m_syncChange = true;
            StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
            Object object = structuredSelection.getFirstElement();
            Object object2 = selectionChangedEvent.getSource();
            if (object2 instanceof TreeViewer) {
                if (object instanceof DrillableObjectsModel.DrillableNode) {
                    DrillableObjectsModel.DrillableNode drillableNode2 = (DrillableObjectsModel.DrillableNode)object;
                    while (drillableNode2.getParent() != null) {
                        drillableNode2 = drillableNode2.getParent();
                    }
                    String string2 = drillableNode2.toString();
                    for (int i = 0; i < this.m_model.getRowCount(); ++i) {
                        if (!this.m_model.getValueAt(i, 0).equals(string2)) continue;
                        this.m_table.getTable().setSelection(i);
                        break;
                    }
                }
            } else if (object2 instanceof TableViewer && object instanceof Vector && (drillableNode = this.m_model.getDrillableNode(string = (String)((Vector)object).get(0))) != null) {
                this.m_tree.setSelection((ISelection)new StructuredSelection((Object)drillableNode));
            }
            this.m_syncChange = false;
        }
    }

    public class SplusObjectSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object object, Object object2) {
            if (ObjectsView.this.m_sortColumn != -1 && object instanceof Vector && object2 instanceof Vector) {
                String string = (String)((Vector)object).get(ObjectsView.this.m_sortColumn);
                String string2 = (String)((Vector)object2).get(ObjectsView.this.m_sortColumn);
                try {
                    double d = Double.parseDouble(string);
                    double d2 = Double.parseDouble(string2);
                    if (d == d2) {
                        return 0;
                    }
                    if (d > d2) {
                        return 1 * ObjectsView.this.m_reverseSort;
                    }
                    return -1 * ObjectsView.this.m_reverseSort;
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareTo(string2) * ObjectsView.this.m_reverseSort;
                }
            }
            return super.compare(viewer, object, object2);
        }
    }

    public class ObjectDescriptionLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private Vector m_listeners = new Vector();

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof Vector && ((Vector)object).size() > n) {
                return (String)((Vector)object).get(n);
            }
            return "";
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object object, String string) {
            return true;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.add(iLabelProviderListener);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.m_listeners.remove(iLabelProviderListener);
        }

        private boolean contains(String string, String string2) {
            return string != null && string2 != null && string2.indexOf(string) != -1;
        }

        public Image getImage(Object object) {
            if (object instanceof DrillableObjectsModel.DrillableNode) {
                DrillableObjectsModel.DrillableNode drillableNode = (DrillableObjectsModel.DrillableNode)object;
                if (drillableNode.isType("data.frame")) {
                    return this.getImage(SplusPluginImages.DESCR_DF_PUBLIC);
                }
                if (drillableNode.isType("matrix")) {
                    return this.getImage(SplusPluginImages.DESCR_MATRIX_PUBLIC);
                }
                if (drillableNode.isType("array")) {
                    return this.getImage(SplusPluginImages.DESCR_ARRAY_PUBLIC);
                }
                if (drillableNode.isType("list") || drillableNode.isType("named")) {
                    return this.getImage(SplusPluginImages.DESCR_LIST_PUBLIC);
                }
                if (drillableNode.isType("date")) {
                    return this.getImage(SplusPluginImages.DESCR_DATE_PUBLIC);
                }
                if (drillableNode.isType("factor")) {
                    return this.getImage(SplusPluginImages.DESCR_FACTOR_PUBLIC);
                }
                if (drillableNode.isType("logical")) {
                    return this.getImage(SplusPluginImages.DESCR_LOGICAL_PUBLIC);
                }
                if (drillableNode.isType("character")) {
                    return this.getImage(SplusPluginImages.DESCR_CHAR_PUBLIC);
                }
                if (drillableNode.isType("integer")) {
                    return this.getImage(SplusPluginImages.DESCR_INT_PUBLIC);
                }
                if (drillableNode.isType("complex")) {
                    return this.getImage(SplusPluginImages.DESCR_COMPLEX_PUBLIC);
                }
                if (drillableNode.isType("numeric")) {
                    return this.getImage(SplusPluginImages.DESCR_NUMERIC_PUBLIC);
                }
                return this.getImage(SplusPluginImages.DESCR_UNKNOWN_PUBLIC);
            }
            if (object instanceof ImageDescriptor) {
                ImageDescriptor imageDescriptor = (ImageDescriptor)object;
                Image image = (Image)IMG_MAP.get(imageDescriptor);
                if (image == null && (image = imageDescriptor.createImage()) != null) {
                    IMG_MAP.put(imageDescriptor, image);
                }
                return image;
            }
            return null;
        }

        public String getText(Object object) {
            if (object instanceof DrillableObjectsModel.DrillableNode) {
                return ((DrillableObjectsModel.DrillableNode)object).toString();
            }
            return null;
        }
    }

    public class ObjectDescriptionProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private DrillableObjectsModel m_model;
        private boolean m_tree;

        public ObjectDescriptionProvider(DrillableObjectsModel drillableObjectsModel, boolean bl) {
            this.m_model = drillableObjectsModel;
            this.m_tree = bl;
        }

        public Object[] getElements(Object object) {
            if (this.m_tree) {
                int n = this.m_model.getChildCount(object);
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = (DrillableObjectsModel.DrillableNode)this.m_model.getChild(object, i);
                }
                return objectArray;
            }
            int n = this.m_model.getColumnCount();
            int n2 = this.m_model.getRowCount();
            Object[] objectArray = new Vector[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = new Vector();
                for (int j = 0; j < n; ++j) {
                    ((Vector)objectArray[i]).add(this.m_model.getValueAt(i, j));
                }
            }
            return objectArray;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            viewer.refresh();
        }

        public void dispose() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof DrillableObjectsModel.DrillableNode) {
                return ((DrillableObjectsModel.DrillableNode)object).getChildren();
            }
            return null;
        }

        public Object getParent(Object object) {
            if (object instanceof DrillableObjectsModel.DrillableNode) {
                return ((DrillableObjectsModel.DrillableNode)object).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            if (object instanceof DrillableObjectsModel.DrillableNode) {
                return !this.m_model.isLeaf(object);
            }
            return false;
        }
    }

    public class SelectSearchPathAction
    extends Action {
        private String m_searchPath;

        public SelectSearchPathAction(String string) {
            super(string);
            this.m_searchPath = string;
        }

        public boolean isChecked() {
            return this.m_searchPath.equals(ObjectsView.this.m_currentDB);
        }

        public int getStyle() {
            return 8;
        }

        public void run() {
            String string = StringUtilities.escapeSpecialCharacters((String)this.m_searchPath);
            String string2 = g_objectInfoCommand + "(where=\"" + string + "\"" + g_dateFormat + ")";
            ObjectsView.this.initializeModel(string2, true);
            ObjectsView.this.m_currentDB = this.m_searchPath;
        }
    }
}

