/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.views.util.ViewerWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class OutputView
extends ViewPart {
    public static final String ID = "com.insightful.splus.eclipse.views.OutputView";
    private ViewerWrapper m_viewer;
    private Action m_clearOutputAction;

    public OutputView() {
        SplusEditorPlugin.getDefault().setOutput(this);
    }

    public void createPartControl(Composite composite) {
        int n = 770;
        SplusEditorPlugin splusEditorPlugin = SplusEditorPlugin.getDefault();
        splusEditorPlugin.getConnection();
        try {
            this.m_viewer = new ViewerWrapper(composite, n, splusEditorPlugin.getOutputDocument(), (IWorkbenchPart)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider(this.m_viewer.getSelectionProvider());
    }

    public IDocument getDocument() {
        return SplusEditorPlugin.getDefault().getOutputDocument();
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IFindReplaceTarget.class) {
            return this.m_viewer.getViewer().getFindReplaceTarget();
        }
        return super.getAdapter(clazz);
    }

    public ViewerWrapper getViewer() {
        return this.m_viewer;
    }

    public void setFocus() {
        this.m_viewer.getControl().setFocus();
    }

    private void makeActions() {
        this.m_clearOutputAction = new Action(){

            public void run() {
                Runnable runnable = new Runnable(){

                    public void run() {
                        SplusEditorPlugin.getDefault().getOutputDocument().set("");
                    }
                };
                Display display = OutputView.this.getSite().getShell().getDisplay();
                display.asyncExec(runnable);
            }
        };
        this.m_clearOutputAction.setText("Clear");
        this.m_clearOutputAction.setToolTipText("Clear console text");
        this.m_clearOutputAction.setAccelerator(262220);
        this.m_viewer.getViewer().getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 108) {
                    OutputView.this.m_clearOutputAction.run();
                }
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.m_clearOutputAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        this.m_viewer.fillMenu(iMenuManager, false);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                OutputView.this.fillContextMenu(iMenuManager);
            }
        });
        this.m_viewer.hookContextMenu(menuManager, this.getSite());
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.m_clearOutputAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        this.m_viewer.fillMenu(iMenuManager, false);
    }
}

