/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views.util;

import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PromptRulerColumn
extends AnnotationRulerColumn {
    private TupleComparator myTupleComparator = new TupleComparator();
    private IAnnotationAccessExtension myAnnotationAccess;
    private ConsoleHistoryDocument myModel;
    private int myScrollPos;

    public PromptRulerColumn(IAnnotationModel iAnnotationModel, int n, IAnnotationAccess iAnnotationAccess) {
        super(iAnnotationModel, n, iAnnotationAccess);
        if (iAnnotationAccess instanceof IAnnotationAccessExtension) {
            this.myAnnotationAccess = (IAnnotationAccessExtension)iAnnotationAccess;
        }
        if (iAnnotationModel instanceof ConsoleHistoryDocument) {
            this.myModel = (ConsoleHistoryDocument)iAnnotationModel;
        }
    }

    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        Control control = super.createControl(compositeRuler, composite);
        return control;
    }

    protected void doPaint1(GC gC) {
        int n;
        Object object;
        if (this.getCachedTextViewer() == null) {
            return;
        }
        ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)this.getCachedTextViewer();
        StyledText styledText = this.getCachedTextViewer().getTextWidget();
        this.myScrollPos = styledText.getTopPixel();
        int n2 = styledText.getLineHeight();
        Point point = this.getControl().getSize();
        int n3 = this.getCachedTextViewer().getTopInset();
        int n4 = this.getInclusiveTopIndexStartOffset();
        int n5 = 0;
        if (styledText != null && !styledText.isDisposed()) {
            int n6 = this.getCachedTextViewer().getBottomIndex();
            if ((styledText.getTopPixel() + styledText.getClientArea().height) % styledText.getLineHeight() != 0) {
                ++n6;
            }
            try {
                object = this.getCachedTextViewer().getDocument();
                if (n6 >= object.getNumberOfLines()) {
                    n6 = object.getNumberOfLines() - 1;
                }
                n5 = object.getLineOffset(n6) + object.getLineLength(n6);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            n5 = -1;
        }
        if ((n5 -= n4) != 0) {
            ++n5;
        }
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        object = new ReusableRegion();
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>();
        Iterator iterator = this.myModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Position position = this.myModel.getPosition(annotation);
            if (position == null || !position.overlapsWith(n4, n5)) continue;
            n = 0;
            if (this.myAnnotationAccess != null) {
                n = this.myAnnotationAccess.getLayer(annotation);
            }
            n7 = Math.min(n7, n);
            n8 = Math.max(n8, n);
            arrayList.add(new Tuple(annotation, position));
        }
        Collections.sort(arrayList, this.myTupleComparator);
        for (int i = n7; i <= n8; ++i) {
            n = arrayList.size();
            for (int j = 0; j < n; ++j) {
                int n9;
                int n10;
                Tuple tuple = (Tuple)arrayList.get(j);
                Annotation annotation = tuple.annotation;
                Position position = tuple.position;
                int n11 = 0;
                if (this.myAnnotationAccess != null) {
                    n11 = this.myAnnotationAccess.getLayer(annotation);
                }
                if (n11 != i) continue;
                ((ReusableRegion)object).update(position.getOffset(), position.getLength());
                IRegion iRegion = iTextViewerExtension5.modelRange2WidgetRange((IRegion)object);
                if (iRegion == null || (n10 = iTextViewerExtension5.widgetLineOfWidgetOffset(iRegion.getOffset())) == -1 || (n9 = iTextViewerExtension5.widgetLineOfWidgetOffset(iRegion.getOffset() + Math.max(iRegion.getLength() - 1, 0))) == -1) continue;
                rectangle.x = 0;
                rectangle.y = n10 * n2 - this.myScrollPos + n3;
                rectangle.width = point.x;
                int n12 = n9 - n10;
                if (n12 < 0) {
                    n12 = -n12;
                }
                rectangle.height = (n12 + 1) * n2;
                if (rectangle.y >= point.y || this.myAnnotationAccess == null) continue;
                this.myAnnotationAccess.paint(annotation, gC, (Canvas)this.getControl(), rectangle);
            }
        }
    }

    private class TupleComparator
    implements Comparator {
        private TupleComparator() {
        }

        public int compare(Object object, Object object2) {
            Position position = ((Tuple)object).position;
            Position position2 = ((Tuple)object2).position;
            return position.getOffset() - position2.getOffset();
        }
    }

    private class Tuple {
        Annotation annotation;
        Position position;

        Tuple(Annotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }

    private class ReusableRegion
    implements IRegion {
        private int fOffset;
        private int fLength;

        private ReusableRegion() {
        }

        public int getLength() {
            return this.fLength;
        }

        public int getOffset() {
            return this.fOffset;
        }

        public void update(int n, int n2) {
            this.fOffset = n;
            this.fLength = n2;
        }
    }
}

