/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.SplusProjectWizard;
import com.insightful.splus.eclipse.editors.spluseditor.util.SplusPluginImages;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SplusDecoratingLabelProvider
extends DecoratingLabelProvider
implements ILabelDecorator,
IResourceChangeListener,
IResourceDeltaVisitor {
    private SplusWorkbenchLabelProvider m_labelProvider = (SplusWorkbenchLabelProvider)this.getLabelProvider();
    private SplusDecoratorManager m_labelDecorator = (SplusDecoratorManager)this.getLabelDecorator();

    public SplusDecoratingLabelProvider() {
        super((ILabelProvider)new SplusWorkbenchLabelProvider(), (ILabelDecorator)new SplusDecoratorManager());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 16);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        try {
            iResourceChangeEvent.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
        IResource iResource = iResourceDelta.getResource();
        if (iResource instanceof IProject || iResource instanceof IFile || iResource instanceof IFolder) {
            ViewerLabel viewerLabel = new ViewerLabel(this.getText(iResource), this.getImage(iResource));
            this.updateLabel(viewerLabel, iResource);
        }
        return true;
    }

    public Image decorateImage(Image image, Object object) {
        return this.m_labelDecorator.decorateImage(image, object, true);
    }

    public String decorateText(String string, Object object) {
        return this.m_labelProvider.decorateText(string, object);
    }

    public Image getImage(Object object) {
        Image image;
        Image image2 = this.getLabelProvider().getImage(object);
        if (this.getLabelDecorator() != null && (image = this.getLabelDecorator().decorateImage(image2, object)) != null) {
            return image;
        }
        return image2;
    }

    private static class SplusElementImageDescriptor
    extends CompositeImageDescriptor {
        public static final int SPLUS = 1;
        public static final int ERROR = 2;
        public static final int DEPRECATED = 4;
        public static final int ACTIVE = 8;
        private ImageDescriptor fBaseImage;
        private int fFlags;
        private Point fSize;
        private static Hashtable LOADED_DECORATION_IMAGES = new Hashtable();

        public SplusElementImageDescriptor(ImageDescriptor imageDescriptor, int n, Point point) {
            this.fBaseImage = imageDescriptor;
            Assert.isNotNull((Object)this.fBaseImage);
            this.fFlags = n;
            Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
            this.fSize = point;
            Assert.isNotNull((Object)this.fSize);
        }

        public void setAdornments(int n) {
            Assert.isTrue((n >= 0 ? 1 : 0) != 0);
            this.fFlags = n;
        }

        public int getAdronments() {
            return this.fFlags;
        }

        public void setImageSize(Point point) {
            Assert.isNotNull((Object)point);
            Assert.isTrue((point.x >= 0 && point.y >= 0 ? 1 : 0) != 0);
            this.fSize = point;
        }

        public Point getImageSize() {
            return new Point(this.fSize.x, this.fSize.y);
        }

        protected Point getSize() {
            return this.fSize;
        }

        public boolean equals(Object object) {
            if (object == null || !SplusElementImageDescriptor.class.equals(object.getClass())) {
                return false;
            }
            SplusElementImageDescriptor splusElementImageDescriptor = (SplusElementImageDescriptor)((Object)object);
            return this.fBaseImage.equals(splusElementImageDescriptor.fBaseImage) && this.fFlags == splusElementImageDescriptor.fFlags && this.fSize.equals((Object)splusElementImageDescriptor.fSize);
        }

        public int hashCode() {
            return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
        }

        protected void drawCompositeImage(int n, int n2) {
            this.drawImage(this.getImageData(this.fBaseImage), 0, 0);
            this.drawTopRight();
            this.drawBottomRight();
            this.drawTopLeft();
            this.drawBottomLeft();
        }

        private ImageData getImageData(ImageDescriptor imageDescriptor) {
            if (LOADED_DECORATION_IMAGES.get(imageDescriptor) == null) {
                ImageData imageData = imageDescriptor.getImageData();
                if (imageData == null) {
                    imageData = DEFAULT_IMAGE_DATA;
                }
                LOADED_DECORATION_IMAGES.put(imageDescriptor, imageData);
            }
            return (ImageData)LOADED_DECORATION_IMAGES.get(imageDescriptor);
        }

        private void drawTopRight() {
            int n = this.getSize().x;
            if ((this.fFlags & 1) != 0) {
                ImageData imageData = this.getImageData(SplusPluginImages.DESC_OVR_SPLUS);
                this.drawImage(imageData, n -= imageData.width, 0);
                imageData = null;
            }
        }

        private void drawBottomRight() {
        }

        private void drawTopLeft() {
            Point point = this.getSize();
            int n = 0;
            if ((this.fFlags & 8) != 0) {
                ImageData imageData = this.getImageData(SplusPluginImages.DESC_ACTIVE_PROJECT);
                this.drawImage(imageData, n, 0);
                n += imageData.width;
                imageData = null;
            }
        }

        private void drawBottomLeft() {
            Point point = this.getSize();
            int n = 0;
            if ((this.fFlags & 2) != 0) {
                ImageData imageData = this.getImageData(SplusPluginImages.DESC_OVR_ERROR);
                this.drawImage(imageData, n, point.y - imageData.height);
                n += imageData.width;
                imageData = null;
            }
        }
    }

    private static class ImageImageDescriptor
    extends ImageDescriptor {
        private Image fImage;

        public ImageImageDescriptor(Image image) {
            this.fImage = image;
        }

        public ImageData getImageData() {
            return this.fImage.getImageData();
        }

        public boolean equals(Object object) {
            return object != null && ((Object)((Object)this)).getClass().equals(object.getClass()) && this.fImage.equals((Object)((ImageImageDescriptor)((Object)object)).fImage);
        }

        public int hashCode() {
            return this.fImage.hashCode();
        }
    }

    private static class SplusDecoratorManager
    extends DecoratorManager {
        public Image decorateImage(Image image, Object object) {
            return this.decorateImage(image, object, false);
        }

        public Image decorateImage(Image image, Object object, boolean bl) {
            IMarker[] iMarkerArray;
            Object object2;
            int n = 0;
            if (object instanceof IResource) {
                try {
                    if (object instanceof IProject && (object2 = (IProject)object).isOpen() && SplusProjectWizard.isSplusProject(object2)) {
                        n |= 1;
                        if (SplusEditorPlugin.getDefault().isActiveProject(object2.getName())) {
                            n |= 8;
                        }
                    }
                    if ((object2 = (IResource)object).isAccessible() && object2.exists()) {
                        iMarkerArray = object2.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        for (int i = 0; i < iMarkerArray.length; ++i) {
                            int n2 = iMarkerArray[i].getAttribute("severity", -1);
                            if (n2 != 2) continue;
                            n |= 2;
                        }
                    }
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
            if (n != 0) {
                object2 = new ImageImageDescriptor(image);
                iMarkerArray = image.getBounds();
                SplusElementImageDescriptor splusElementImageDescriptor = new SplusElementImageDescriptor((ImageDescriptor)object2, n, new Point(iMarkerArray.width, iMarkerArray.height));
                Image image2 = splusElementImageDescriptor.createImage();
                return image2;
            }
            if (bl) {
                return image;
            }
            return super.decorateImage(image, object);
        }
    }

    private static class SplusWorkbenchLabelProvider
    extends WorkbenchLabelProvider {
        protected String decorateText(String string, Object object) {
            String string2 = SplusEditorPlugin.getDefault().getActiveProject();
            if (string2 == null ? object instanceof IWorkspace : string.equals(string2) && object instanceof IProject) {
                return string + " (working)";
            }
            return string;
        }
    }
}

