/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.webdavaccess;

import com.insightful.webdavaccess.ICache;
import com.insightful.webdavaccess.exceptions.CacheException;
import java.util.Enumeration;
import java.util.Hashtable;

public class MRUCache
implements ICache {
    Hashtable mHash = new Hashtable();
    int mMaxCapacity;
    CacheEntry mFirstElement;
    CacheEntry mLastElement;

    public MRUCache(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("MRU cache must contain at least one entry");
        }
        this.mMaxCapacity = max;
    }

    public void put(Object key, Object value) throws CacheException {
        CacheEntry entry = (CacheEntry)this.mHash.get(key);
        if (entry != null) {
            entry.setValue(value);
            this.touchEntry(entry);
        } else {
            if (this.mHash.size() == this.mMaxCapacity) {
                entry = this.purgeEntry();
                entry.setKey(key);
                entry.setValue(value);
            } else {
                entry = new CacheEntry(key, value);
            }
            this.addEntry(entry);
            this.mHash.put(entry.getKey(), entry);
        }
    }

    public Object get(Object key) {
        CacheEntry entry = (CacheEntry)this.mHash.get(key);
        if (entry != null) {
            this.touchEntry(entry);
            return entry.getValue();
        }
        return null;
    }

    public void remove(Object key) {
        CacheEntry entry = (CacheEntry)this.mHash.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            this.mHash.remove(entry.getKey());
        }
    }

    public void removeAll() {
        this.mHash = new Hashtable();
        this.mFirstElement = null;
        this.mLastElement = null;
    }

    public Enumeration elements() {
        return new MRUEnumeration(this.mHash.elements());
    }

    protected void addEntry(CacheEntry entry) {
        if (this.mFirstElement == null) {
            this.mFirstElement = entry;
            this.mLastElement = entry;
        } else {
            this.mLastElement.setNext(entry);
            entry.setPrevious(this.mLastElement);
            this.mLastElement = entry;
        }
    }

    protected void removeEntry(CacheEntry entry) {
        if (entry == this.mFirstElement) {
            this.mFirstElement = entry.getNext();
        }
        if (this.mLastElement == entry) {
            this.mLastElement = entry.getPrevious();
        }
        CacheEntry previous = entry.getPrevious();
        CacheEntry next = entry.getNext();
        if (previous != null) {
            previous.setNext(next);
        }
        if (next != null) {
            next.setPrevious(previous);
        }
        entry.setPrevious(null);
        entry.setNext(null);
    }

    protected void touchEntry(CacheEntry entry) {
        if (this.mLastElement == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    protected CacheEntry purgeEntry() throws CacheException {
        CacheEntry entry = this.mFirstElement;
        this.removeEntry(entry);
        this.mHash.remove(entry.getKey());
        entry.setValue(null);
        return entry;
    }

    public boolean containsKey(Object key) {
        CacheEntry entry = (CacheEntry)this.mHash.get(key);
        return entry != null;
    }

    class MRUEnumeration
    implements Enumeration {
        Enumeration mEnumaration;

        MRUEnumeration(Enumeration en) {
            this.mEnumaration = en;
        }

        public boolean hasMoreElements() {
            return this.mEnumaration.hasMoreElements();
        }

        public Object nextElement() {
            CacheEntry entry = (CacheEntry)this.mEnumaration.nextElement();
            return entry.getValue();
        }
    }

    class CacheEntry {
        private Object mKey;
        private Object mValue;
        private CacheEntry mPrevious;
        private CacheEntry mNext;

        CacheEntry(Object key, Object value) {
            this.mKey = key;
            this.mValue = value;
        }

        Object getKey() {
            return this.mKey;
        }

        void setKey(Object obj) {
            this.mKey = obj;
        }

        Object getValue() {
            return this.mValue;
        }

        void setValue(Object obj) {
            this.mValue = obj;
        }

        CacheEntry getPrevious() {
            return this.mPrevious;
        }

        void setPrevious(CacheEntry entry) {
            this.mPrevious = entry;
        }

        CacheEntry getNext() {
            return this.mNext;
        }

        void setNext(CacheEntry entry) {
            this.mNext = entry;
        }
    }
}

