#ifndef S_R_H /* ( */
#define S_R_H

/* R.h emulation for use with Splus */
/* Map R's C definitions to Splus equivalents */

#define S_USING_PSL
#include <S.h>
#undef S_USING_PSL

#include <Rmath.h>
#include <R_ext/Arith.h>
#include <R_ext/Boolean.h>
#include <R_ext/Complex.h>
#include <R_ext/Error.h>
#include <R_ext/Memory.h>
#include <R_ext/Print.h>
#include <R_ext/Random.h>
#include <R_ext/Utils.h>
#include <R_ext/RS.h>

#ifdef __cplusplus
extern "C" {
#endif

/* don't use S version of LENGTH macro */
#ifdef LENGTH
#undef LENGTH
#endif

#ifdef LITTLE_ENDIAN
#undef WORDS_BIGENDIAN
#else
#define WORDS_BIGENDIAN
#endif

#undef TRUE
#define TRUE S_TRUE
#undef FALSE
#define FALSE S_FALSE

#ifdef vector
#undef vector
#endif

#define MAXIDSIZE   256
#define HSIZE      4119

#ifndef DBL_MAX
#define DBL_MAX DOUBLE_XMAX
#endif

#ifndef DBL_MIN
#define DBL_MIN DOUBLE_XMIN
#endif

/* ignore inline: can't map to anything useful */
#define INLINE_FUN
#define R_INLINE

/* macro for wide string constant stuff */
#define _(String) (String)


#ifdef __cplusplus
}
#endif

#endif /* S_R_H) */
