#ifndef R_EXT_ARITH_H /* ( */
#define R_EXT_ARITH_H

/* Note that Splus's is_na family of function take pointers,
 * R's do not.  R's are for doubles only.  Also,
 * R's ISNA(x) tests for x being NA (and not any other NaN)
 * and ISNAN(x) tests for x being NA or NaN and
 * R_IsNaN(x) tests for NaN but not NA.
 * Splus's is_na_DOUBLE tests for NA or NaN, but returns 1 or 2, respectively
 */
#define R_IsNaN(x)  (is_na_DOUBLE(&x)==2)
#define ISNAN(x)    is_nan_DOUBLE(&x)
#define R_IsNA(x)   (is_na_DOUBLE(&x)==1)
#define ISNA        R_IsNA

#define R_FINITE(x) (!is_inf_DOUBLE(&x) && !is_na_DOUBLE(&x))
#define R_finite    R_FINITE

#define R_PosInf    dPosInf
#define R_NegInf    dNegInf
#define R_NaN       dNaN
#define R_NaReal    dNA

#define NA_REAL     R_NaReal
/* The following should be ifdef'ed for 64/32 bit machines,
 * but R and Splus have big differences on 64 bit machines.
 * NA_PATTERN_32 should be 0x7ff0001. */
#define NA_INTEGER  NA_PATTERN_32
#define NA_LOGICAL  NA_PATTERN_32

#endif /* ) R_EXT_ARITH_H */
