/*
   NAME     S_math.h
   PURPOSE  This file contains extern function declarations for some math routines used by S-PLUS.
*/

#ifndef __S_MATH_H_INCLUDE__
#define __S_MATH_H_INCLUDE__

#include "system.h"
#include "S_types.h"

#include "libext.h"
S_begin_extern_c

#ifdef S_F77_DECL
	#undef S_F77_DECL
#endif

#define S_F77_DECL(ret, x) LibExtern ret S_STDCALL F77_NAME(x)


/* BLAS level 1 */

S_F77_DECL(double, dasum)(long *n,double *x,long *incx);
S_F77_DECL(void,   daxpy)(long *n,double *alpha,double *x,long *incx,double *y,long *incy);
S_F77_DECL(void,   daxpyi)(long *nz,double *a,double *x,long *indx,double *y);
S_F77_DECL(void,   dcopy)(long *n,double *x,long *incx,double *y,long *incy);
S_F77_DECL(double, ddot)(long *n,double *x,long *incx,double *y,long *incy);
S_F77_DECL(double, ddoti)(long *nz,double *x,long *indx,double *y);
S_F77_DECL(void,   dgthr)(long *nz,double *y,double *x,long *indx);
S_F77_DECL(void,   dgthrz)(long *nz,double *y,double *x,long *indx);
S_F77_DECL(double, dnrm2)(long *n,double *x,long *incx);
S_F77_DECL(void,   drot)(long *n,double *x,long *incx,double *y,long *incy,double *c,double *s);
S_F77_DECL(void,   drotg)(double *a,double *b,double *c,double *s);
S_F77_DECL(void,   droti)(long *nz,double *x,long *indx,double *y,double *c,double *s);
S_F77_DECL(void,   drotm)(long *n,double *x,long *incx,double *y,long *incy,double *param);
S_F77_DECL(void,   drotmg)(double *d1,double *d2,double *x1,double *y1,double *param);
S_F77_DECL(void,   dscal)(long *n,double *a,double *x,long *incx);
S_F77_DECL(void,   dsctr)(long *nz,double *x,long *indx,double *y);
S_F77_DECL(void,   dswap)(long *n,double *x,long *incx,double *y,long *incy);
S_F77_DECL(double, dzasum)(long *n,s_complex *x,long *incx); 
S_F77_DECL(double, dznrm2)(long *n,s_complex *x,long *incx); 
S_F77_DECL(int,    idamax)(long *n,double *x,long *incx);
S_F77_DECL(int,    idamin)(long *n,double *x,long *incx);

S_F77_DECL(void, zaxpy)(long *n,s_complex *alpha,s_complex *x,long *incx,s_complex *y,long *incy); 
S_F77_DECL(void, zaxpyi)(long *nz,s_complex *a,s_complex *x,long *indx,s_complex *y); 
S_F77_DECL(void, zcopy)(long *n,s_complex *x,long *incx,s_complex *y,long *incy); 
S_F77_DECL(void, zdotc)(s_complex *pres,long *n,s_complex *x,long *incx,s_complex *y,long *incy); 
S_F77_DECL(void, zdotci)(s_complex *pres,long *nz,s_complex *x,long *indx,s_complex *y); 
S_F77_DECL(void, zdotu)(s_complex *pres,long *n,s_complex *x,long *incx,s_complex *y,long *incy); 
S_F77_DECL(void, zdotui)(s_complex *pres,long *nz,s_complex *x,long *indx,s_complex *y); 
S_F77_DECL(void, zdrot)(long *n,s_complex *x,long *incx,s_complex *y,long *incy,double *c,double *s); 
S_F77_DECL(void, zdscal)(long *n,double *a,s_complex *x,long *incx); 
S_F77_DECL(void, zgthr)(long *nz,s_complex *y,s_complex *x,long *indx); 
S_F77_DECL(void, zgthrz)(long *nz,s_complex *y,s_complex *x,long *indx); 
S_F77_DECL(void, zrotg)(s_complex *a,s_complex *b,double *c,s_complex *s); 
S_F77_DECL(void, zscal)(long *n,s_complex *a,s_complex *x,long *incx); 
S_F77_DECL(void, zsctr)(long *nz,s_complex *x,long *indx,s_complex *y); 
S_F77_DECL(void, zswap)(long *n,s_complex *x,long *incx,s_complex *y,long *incy); 
S_F77_DECL(int,  izamax)(long *n,s_complex *x,long *incx); 
S_F77_DECL(int,  izamin)(long *n,s_complex *x,long *incx); 
 
/* BLAS level 2 */
 
S_F77_DECL(void, dgbmv)(F77_CHAR_DECL(trans),long *m,long *n,long *kl,long *ku,double *alpha,double *a,long *lda,double *x,long *incx,double *beta,double *y,long *incy);
S_F77_DECL(void, dgemv)(F77_CHAR_DECL(trans),long *m,long *n,double *alpha,double *a,long *lda,double *x,long *incx,double *beta,double *y,long *incy);
S_F77_DECL(void, dger)(long *m,long *n,double *alpha,double *x,long *incx,double *y,long *incy,double *a,long *lda);
S_F77_DECL(void, dsbmv)(F77_CHAR_DECL(uplo),long *n,long *k,double *alpha,double *a,long *lda,double *x,long *incx,double *beta,double *y,long *incy);
S_F77_DECL(void, dspmv)(F77_CHAR_DECL(uplo),long *n,double *alpha,double *ap,double *x,long *incx,double *beta,double *y,long *incy);
S_F77_DECL(void, dspr)(F77_CHAR_DECL(uplo),long *n,double *alpha,double *x,long *incx,double *ap);
S_F77_DECL(void, dspr2)(F77_CHAR_DECL(uplo),long *n,double *alpha,double *x,long *incx,double *y,long *incy,double *ap);
S_F77_DECL(void, dsymv)(F77_CHAR_DECL(uplo),long *n,double *alpha,double *a,long *lda,double *x,long *incx,double *beta,double *y,long *incy);
S_F77_DECL(void, dsyr)(F77_CHAR_DECL(uplo),long *n,double *alpha,double *x,long *incx,double *a,long *lda);
S_F77_DECL(void, dsyr2)(F77_CHAR_DECL(uplo),long *n,double *alpha,double *x,long *incx,double *y,long *incy,double *a,long *lda);
S_F77_DECL(void, dtbmv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,long *k,double *a,long *lda,double *x,long *incx);
S_F77_DECL(void, dtbsv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,long *k,double *a,long *lda,double *x,long *incx);
S_F77_DECL(void, dtpmv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,double *ap,double *x,long *incx);
S_F77_DECL(void, dtpsv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,double *ap,double *x,long *incx);
S_F77_DECL(void, dtrmv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(transa),F77_CHAR_DECL(diag),long *n,double *a,long *lda,double *b,long *incx);
S_F77_DECL(void, dtrsv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,double *a,long *lda,double *x,long *incx);

S_F77_DECL(void, zgbmv)(F77_CHAR_DECL(trans),long *m,long *n,long *kl,long *ku,s_complex *alpha,s_complex *a,long *lda,s_complex *x,long *incx,s_complex *beta,s_complex *y,long *incy); 
S_F77_DECL(void, zgemv)(F77_CHAR_DECL(trans),long *m,long *n,s_complex *alpha,s_complex *a,long *lda,s_complex *x,long *incx,s_complex *beta,s_complex *y,long *incy); 
S_F77_DECL(void, zgerc)(long *m,long *n,s_complex *alpha,s_complex *x,long *incx,s_complex *y,long *incy,s_complex *a,long *lda); 
S_F77_DECL(void, zgeru)(long *m,long *n,s_complex *alpha,s_complex *x,long *incx,s_complex *y,long *incy,s_complex *a,long *lda); 
S_F77_DECL(void, zhbmv)(F77_CHAR_DECL(uplo),long *n,long *k,s_complex *alpha,s_complex *a,long *lda,s_complex *x,long *incx,s_complex *beta,s_complex *y,long *incy); 
S_F77_DECL(void, zhemv)(F77_CHAR_DECL(uplo),long *n,s_complex *alpha,s_complex *a,long *lda,s_complex *x,long *incx,s_complex *beta,s_complex *y,long *incy); 
S_F77_DECL(void, zher)(F77_CHAR_DECL(uplo),long *n,double *alpha,s_complex *x,long *incx,s_complex *a,long *lda); 
S_F77_DECL(void, zher2)(F77_CHAR_DECL(uplo),long *n,s_complex *alpha,s_complex *x,long *incx,s_complex *y,long *incy,s_complex *a,long *lda); 
S_F77_DECL(void, zhpmv)(F77_CHAR_DECL(uplo),long *n,s_complex *alpha,s_complex *ap,s_complex *x,long *incx,s_complex *beta,s_complex *y,long *incy); 
S_F77_DECL(void, zhpr)(F77_CHAR_DECL(uplo),long *n,double *alpha,s_complex *x,long *incx,s_complex *ap); 
S_F77_DECL(void, zhpr2)(F77_CHAR_DECL(uplo),long *n,s_complex *alpha,s_complex *x,long *incx,s_complex *y,long *incy,s_complex *ap); 
S_F77_DECL(void, ztbmv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,long *k,s_complex *a,long *lda,s_complex *x,long *incx); 
S_F77_DECL(void, ztbsv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,long *k,s_complex *a,long *lda,s_complex *x,long *incx); 
S_F77_DECL(void, ztpmv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,s_complex *ap,s_complex *x,long *incx); 
S_F77_DECL(void, ztpsv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,s_complex *ap,s_complex *x,long *incx); 
S_F77_DECL(void, ztrmv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(transa),F77_CHAR_DECL(diag),long *n,s_complex *a,long *lda,s_complex *b,long *incx); 
S_F77_DECL(void, ztrsv)(F77_CHAR_DECL(uplo),F77_CHAR_DECL(trans),F77_CHAR_DECL(diag),long *n,s_complex *a,long *lda,s_complex *x,long *incx); 

/* BLAS level 3 */

S_F77_DECL(void, dgemm)(F77_CHAR_DECL(transa),F77_CHAR_DECL(transb),long *m,long *n,long *k,double *alpha,double *a,long *lda,double *b,long *ldb,double *beta,double *c,long *ldc);
S_F77_DECL(void, dsymm)(F77_CHAR_DECL(side),  F77_CHAR_DECL(uplo),long *m,long *n,double *alpha,double *a,long *lda,double *b,long *ldb,double *beta,double *c,long *ldc);
S_F77_DECL(void, dsyr2k)(F77_CHAR_DECL(uplo), F77_CHAR_DECL(trans),long *n,long *k,double *alpha,double *a,long *lda,double *b,long *ldb,double *beta,double *c,long *ldc);
S_F77_DECL(void, dsyrk)(F77_CHAR_DECL(uplo),  F77_CHAR_DECL(trans),long *n,long *k,double *alpha,double *a,long *lda,double *beta,double *c,long *ldc);
S_F77_DECL(void, dtrmm)(F77_CHAR_DECL(side),  F77_CHAR_DECL(uplo),F77_CHAR_DECL(transa),F77_CHAR_DECL(diag),long *m,long *n,double *alpha,double *a,long *lda,double *b,long *ldb);
S_F77_DECL(void, dtrsm)(F77_CHAR_DECL(side),  F77_CHAR_DECL(uplo),F77_CHAR_DECL(transa),F77_CHAR_DECL(diag),long *m,long *n,double *alpha,double *a,long *lda,double *b,long *ldb);

S_F77_DECL(void, zgemm)(F77_CHAR_DECL(transa),F77_CHAR_DECL(transb),long *m,long *n,long *k,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb,s_complex *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, zgemm)(F77_CHAR_DECL(transa),F77_CHAR_DECL(transb),long *m,long *n,long *k,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb,s_complex *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, zhemm)(F77_CHAR_DECL(side),  F77_CHAR_DECL(uplo),long *m,long *n,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb,s_complex *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, zher2k)(F77_CHAR_DECL(uplo), F77_CHAR_DECL(trans),long *n,long *k,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb,double *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, zherk)(F77_CHAR_DECL(uplo),  F77_CHAR_DECL(trans),long *n,long *k,double *alpha,s_complex *a,long *lda,double *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, zsymm)(F77_CHAR_DECL(side),  F77_CHAR_DECL(uplo),long *m,long *n,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb,s_complex *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, zsyr2k)(F77_CHAR_DECL(uplo), F77_CHAR_DECL(trans),long *n,long *k,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb,s_complex *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, zsyrk)(F77_CHAR_DECL(uplo),  F77_CHAR_DECL(trans),long *n,long *k,s_complex *alpha,s_complex *a,long *lda,s_complex *beta,s_complex *c,long *ldc); 
S_F77_DECL(void, ztrmm)(F77_CHAR_DECL(side),  F77_CHAR_DECL(uplo),F77_CHAR_DECL(transa),F77_CHAR_DECL(diag),long *m,long *n,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb); 
S_F77_DECL(void, ztrsm)(F77_CHAR_DECL(side),  F77_CHAR_DECL(uplo),F77_CHAR_DECL(transa),F77_CHAR_DECL(diag),long *m,long *n,s_complex *alpha,s_complex *a,long *lda,s_complex *b,long *ldb);

/* matmult.f */

S_F77_DECL(void, dcrossp2)(double* pdA, long* pnDA, double* pdB, long* pnDB, double* pdC );
S_F77_DECL(void, dmatmult)(double* pdA, long* pnDA, double* pdB, long* pnDB, double* pdC );
S_F77_DECL(void, dbksl)(double* pR, long* pnDR, long* pk, double* px, long* pnDX, long* pinfo);
S_F77_DECL(void, daxpy)(long* pn, double* pscale, double* px, long* pincx, double* py, long* incy);

/* LAPACK */

// DOUBLE PRECISION FUNCTION DLANGE( NORM, M, N, A, LDA, WORK )
S_F77_DECL(double, dlange)( F77_CHAR_DECL(pszNorm), long* pnM, long* pnN, double* pdA, long* pnLDA, double* pdWORK);

// SUBROUTINE DGECON( NORM, N, A, LDA, ANORM, RCOND, WORK, IWORK, INFO )
S_F77_DECL(void, dgecon)( F77_CHAR_DECL(pszNorm), long* pnN, double* pdA, long* pnLDA, double* pdANORM, double* pdRCOND, double* pdWORK, long* pnIWORK, long* pnINFO);




S_end_extern_c
#include "unlibext.h"
#endif /* __S_MATH_H_INCLUDE__ */
