/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_spec.h,v $: $Revision: #17 $, $Date: 2006/06/26 $  */
/***
   NAME S_spec
   PURPOSE
     Split off some IEEE special value handling macros from S.h to make
     for easier inclusion into other sources.
   NOTES
***/
#ifndef S_specINCLUDED
#define S_specINCLUDED 1

/* Pre-requisite includes go here. */
#include "cdefs.h"
#include "system.h"
#include "newNA.h"
#include "S_ansi.h"
#include "signed.h"
#include "libext.h"

#define LPNTR(a) ((long *) (a))
#define RPNTR(a) ((float *) (a))
#define DPNTR(a) ((double *) (a))

/* Keep the following in sync. They all have to do with testing/setting NA's
 * and Inf's:
 * 
 * $QPE/comp_util.c:test_na,set_na,test_inf,set_inf
 * $INC/S.h:is_na,is_na_*,is_inf,is_inf_*
 * $I/u/mach.m[pp]:NA,INF
 * $P/natst.C, $P/inftst.C
 * $DEV/gr_extern/test_inf.c
 * $SL/data.ed/S_specials.c
 */

/* macros for testing and setting special values */
#define is_na(a,m) test_na((char *)(a),m, S_evaluator)
#define is_nan(a,m) (((m)==S_MODE_COMPLEX)?is_na((a),(m)):(is_na((a),(m))!=0))
#define na_set(a,m) set_na3((char *)(a),m,To_NA,S_evaluator)
#define na_set3(a,m,t)   set_na3((char *)(a),m,(t),S_evaluator)
#define is_inf(a,m) test_inf((char *)(a),m)
#define inf_set(a,m,s) set_inf((char *)(a),m,s,S_evaluator)
/*
 * Fast macros for testing NA's/NaN's/Inf's when mode known at compile time.
 * These must be kept in sync with comp_util.c:test_na() and test_inf(). The 
 * fast macros are used if DO_NOT_INLINE_IS_NA is not defined.
 * IEEE754 is defined by system.h.
 */

#ifdef DO_NOT_INLINE_IS_NA	/*(*/

#define is_na_pattern(a)	is_na((a),S_MODE_INT)
    /* works independent of mode for all Splus-created data since 2.3 */

/* is_nan_{LGL,INT}: test whether it's NA_PATTERN. Strictly speaking there are 
   no non-float NaN's. */
#define is_nan_LGL(a)		is_nan((a),S_MODE_LGL)
#define is_nan_INT(a)		is_nan((a),S_MODE_INT)
#define is_nan_CHAR(a)		0
#define is_nan_REAL(a)		is_nan((a),S_MODE_REAL)
#define is_nan_DOUBLE(a)	is_nan((a),S_MODE_DOUBLE)
#define is_nan_COMPLEX(a)	is_nan((a),S_MODE_COMPLEX)

#define is_na_LGL(a)		is_na((a),S_MODE_LGL)
#define is_na_INT(a)		is_na((a),S_MODE_INT)
#define is_na_CHAR(a)		0
#define is_na_REAL(a)		is_na((a),S_MODE_REAL)
#define is_na_DOUBLE(a)		is_na((a),S_MODE_DOUBLE)
#define is_na_COMPLEX(a)	is_na((a),S_MODE_COMPLEX)

#define is_inf_LGL(a)		0
#define is_inf_INT(a)		0
#define is_inf_CHAR(a)		0
#define is_inf_REAL(a)		is_inf((a),S_MODE_REAL)
#define is_inf_DOUBLE(a)	is_inf((a),S_MODE_DOUBLE)
#define is_inf_COMPLEX(a)	is_inf((a),S_MODE_COMPLEX)

#else /* )( ! DO_NOT_INLINE_IS_NA */

#define is_na_pattern(a)	(*LPNTR(a) == NA_PATTERN)
    /* works independent of mode for all Splus-created data since 2.3 */
    /* The above statement not true on 64 bit machines */

/* is_nan_{LGL,INT}: test whether it's NA_PATTERN. Strictly speaking there are 
   no non-float NaN's. */
#define is_nan_LGL(a)		is_na_pattern(a)
#define is_nan_INT(a)		is_na_pattern(a)
#define is_nan_CHAR(a)		0
#if defined(WIN32) || defined(mips)
	/* ( Any platform where x != x doesn't work */
#define is_nan_REAL(a)		(((*LPNTR(a)&FEXP_BITS)==FEXP_BITS) && (*LPNTR(a)<<9))
#define is_nan_DOUBLE(a)	(((LPNTR(a)[HI]&DEXP_BITS)==DEXP_BITS) && \
					((LPNTR(a)[HI]<<12) || LPNTR(a)[LO] ))

#else /*)( ! WIN32*/
#define is_nan_REAL(a)		(*(a) != *(a))
#define is_nan_DOUBLE(a)	(*(a) != *(a))
#endif /*) ! WIN32*/
#define is_nan_COMPLEX(a)	((is_nan_DOUBLE(DPNTR(a)) ? Is_NaN : 0) | \
	(is_nan_DOUBLE(DPNTR(a)+1) ? Is_NaNi : 0))

#define is_na_LGL(a)		is_na_pattern(a)
#define is_na_INT(a)		is_na_pattern(a)
#define is_na_CHAR(a)		0
#ifdef HAS_64BIT_LONG
#define IPNTR(a) ((int *) (a))
#define is_na_pattern_int(a)	(*IPNTR(a) == NA_PATTERN_32)
#define is_na_REAL(a)		(is_nan_REAL(a) ? (is_na_pattern_int(a) ? Is_NA : Is_NaN) : 0)
#else
#define is_na_REAL(a)		(is_nan_REAL(a) ? (is_na_pattern(a) ? Is_NA : Is_NaN) : 0)
#endif
#define is_na_DOUBLE(a)		(is_nan_DOUBLE(a) ? (is_na_pattern(a) ? Is_NA : Is_NaN) : 0)

#define is_na_COMPLEX(a)	((is_nan_DOUBLE(&(a)->re) || is_nan_DOUBLE(&(a)->im)) ? \
                                     is_na(a, S_MODE_COMPLEX) : \
                                     0)

#define is_inf_LGL(a)		0
#define is_inf_INT(a)		0
#define is_inf_CHAR(a)		0
#if defined(WIN32) /* ( cannot do == in case *a is a NaN */
#define is_inf_REAL(a)		(is_nan_REAL(a) ? 0 : \
				 (*(a)==sPosInf ? 1 : (*(a)==sNegInf ? -1 : 0)))
#define is_inf_DOUBLE(a)	(is_nan_DOUBLE(a) ? 0 : \
				 (*(a)==dPosInf ? 1 : (*(a)==dNegInf ? -1 : 0)))
#define is_inf_COMPLEX(a)	((is_inf_DOUBLE(DPNTR(a))==1?\
					Is_Inf: \
					(is_inf_DOUBLE(DPNTR(a))?Is_NInf:0))\
				| \
				(is_inf_DOUBLE(DPNTR(a)+1)==1?\
					Is_Infi: \
					(is_inf_DOUBLE(DPNTR(a)+1)?Is_NInfi:0)))
#else /*)( ! WIN32*/
#define is_inf_REAL(a)		(*(a)==sPosInf ? 1 : (*(a)==sNegInf ? -1 : 0))
#define is_inf_DOUBLE(a)	(*(a)==dPosInf ? 1 : (*(a)==dNegInf ? -1 : 0))
#define is_inf_COMPLEX(a)	((*DPNTR(a)==dPosInf? \
					Is_Inf:\
					(*DPNTR(a)==dNegInf?Is_NInf:0)) \
				| \
				(*(DPNTR(a)+1)==dPosInf? \
					Is_Infi:\
					(*(DPNTR(a)+1)==dNegInf?Is_NInfi:0)))
#endif /*) ! WIN32*/

#endif /* ) ! DO_NOT_INLINE_IS_NA */

#ifdef S_ANSI_Syntax
#define Is_bad(t,a,m)		((t & Is_Inf) ? is_inf_##m(a) : is_na_##m(a))
#define Is_na(a,m)		((1 & Is_Inf) ? is_inf_##m(a) : is_na_##m(a))
#define Is_inf(a,m)	is_inf_##m(a)
#else
#define Is_bad(t,a,m)		((t & Is_Inf) ? is_inf_/**/m(a) : is_na_/**/m(a))
#define Is_na(x,m)	is_na_/**/m(x)
#define Is_inf(x,m)	is_inf_/**/m(x)
#endif

#ifdef S_specDEFINE
#define vextern LibExport
#else 
#define vextern LibExtern
#endif

S_begin_extern_c
/* Functions and global variables which are used in macros found in S_spec.h */
LibExtern int S_STDCALL test_na(char *p, int mode, s_evaluator *S_evaluator);
LibExtern int S_STDCALL test_inf(char *p, int mode);
LibExtern void S_STDCALL set_na(char *p, int mode, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_na3(char *p, int mode, int type, s_evaluator *S_evaluator);
LibExtern void S_STDCALL set_inf(char *p, int mode, int sign, s_evaluator *S_evaluator);
 
vextern int na_t;
#ifdef IEEE754
vextern float sPosInf, sNegInf, sNaN;
vextern double dPosInf, dNegInf, dNaN;
#endif

S_end_extern_c
#undef vextern
#include "unlibext.h"
#endif /* S_specINCLUDED */
