/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: S_struct.h,v $: $Revision: #22 $, $Date: 2006/06/26 $  */
/***
   NAME S_structs
   PURPOSE
     Split off some struct/union defs from S.h for potential inclusion
     elsewhere, along with a few macros for looking at their contents.
   NOTES
     
***/
#ifndef S_structsINCLUDED
#define S_structsINCLUDED 1

/* Pre-requisite includes go here. */
#include <sys/types.h>
#include "machine.h" /* //YB: need s_index */
#include <S_ansi.h>
#include <S_rpc.h>
#include <S_types.h>

#if defined(S_LEVEL_THREADS)
#include "PthreadAliases.h"
#else
#include "PseudoThreadAliases.h"
#endif

/* Define a token that will always be the "FILE" used by Splus, whether or not
 * newredef.h redefines it (which it won't if NO_NEWIO is #defined above S.h).
 */
#if defined(USE_NEWIO) /*(*/
#define S_FILE S_newio_FILE
#else /*)(*/
#define S_FILE FILE
#endif /*)*/

S_begin_extern_c

enum s_verify_level_enum {NO_VERIFY, CLASS_VERIFY, STD_VERIFY};
typedef enum s_verify_level_enum s_verify_level;

enum s_db_purposes_enum {REGULAR_DB, META_DB, HELP_DB, SEARCH_DB,
                  DATA_DB, RELOAD_DB, TEMP_DB, LOCK_DB, MAX_DB_PURPOSE};
typedef enum s_db_purposes_enum s_db_purposes;

struct s_tname_struct {
        const char *text;
        long probe;
        struct s_class_rep *name_class; /* must NOT point to S_name_class */
   };
typedef struct s_tname_struct s_tname;

struct s_symbol_address_struct {
  char *name;
  void *address;
};
typedef struct s_symbol_address_struct s_symbol_address;

/* structure for parameters involved in printing floating-point numbers -
 * originally only in library/main/pratom.c 
 */
struct numsize {
	int sign, nsignif;
	int nleft, nright, nexp;
	char pmode, width;
};
typedef struct numsize NUMSIZE;

struct s_extended_parse_info {
	int max_expr;
	int expr_count;
	int chars_parsed;
	char *completions;
};
typedef struct s_extended_parse_info extended_parse_info;

typedef struct s_object_struct s_object;
#if defined(S_COMPATIBILITY) && S_COMPATIBILITY>=10 && !defined(vector)
typedef struct s_object_struct vector;
#endif
typedef struct s_index_table_struct s_index_table;
typedef struct s_name_struct s_name;

/* the internal representation of a class, reflecting the meta-object produced */
/* by setClass().  Currently missing some of the meta-data */
/* It is not conceptually allowed for the class representation to change during */
/* a session, so this object is not updated (the policy may change).  */
struct s_class_rep {
	char *name;
	int name_length;
	char *meta_name; /* the name of the class meta-object */
	int index; /* the index in Classes vector in meta-data */
	struct s_name_table_struct *slots_table; /* table of slot names */
	int nslots;
	struct s_class_rep **slot_classes;
	s_object *slot_names;
	s_object *prototype;
	s_index contains;
	s_object *validity; /* any special validity test method */
	s_object *access; /* any special access list for slots */
	s_object *vec; /* the name as a length-1 char. object, for  methods*/
	int database; /* where rep was found */
	unsigned char Virtual;
	unsigned char complete;
	unsigned char Verify; /* should this class be 
				 verified on read/write */
        s_index_table *coerce_table;
};
typedef struct s_class_rep s_class;

#if defined(S_API_PERSISTENCY)
typedef struct {
	int	ref_count;
	long	index;
	char	name[1];
} PERSIST_INFO;

typedef struct {
	int		ignore;
	int		compcount;
	long		offset;
	PERSIST_INFO	*dbobj_path;
	PERSIST_INFO	**complist;
} S_apiPersistPath;
#endif

/* the symbols for the four interfaces:  1 and 2 need to correspond to
   to the codes used in the .Internal calls in the .Fortran and .C functions */
enum s_interface_type {INTF_INTERNAL=0, INTF_FORTRAN=1, INTF_C=2, INTF_CALL};
 
struct s_entry_point_struct {
  s_name *ep_func_name; /* name of function, as programmer see it */
  enum s_interface_type ep_type;
  s_name *ep_symbol_name; /* mangled name of function, as nm sees it */
  /* nargs will be number of arguments, except that -1 means we don't know */
  long ep_nargs;
  s_class **ep_Classes;
  s_boolean *ep_copy;
  s_boolean *ep_naok;
  /* ep_found_interface_data tells whether we have already looked for
   * and found the ic#name * or if#name * object.  (If we have have looked
   * and not found it we don't need to look again except when ic#name
   * is assigned.)
   */
  enum { ep_found_DIDNT_LOOK = 0, ep_found_LOOKED_NOT_FOUND = 1, ep_found_FOUND = 2 }  ep_found_interface_data ;
  s_object *(*ep_func)();     /* type for an internal system function */
  long ep_trace ; /* tell how much debugging info to print when calling this function, 0 means none */
};
typedef struct s_entry_point_struct s_entry_point;

union s_pointer_union {
	RPCMOD(caseis(S_MODE_LGL)) long *Long;
        RPCMOD(caseis(S_MODE_REAL))    float *Float;
        RPCMOD(caseis(S_MODE_CHAR))    string8 **Char;
        RPCMOD(caseis(S_MODE_DOUBLE))  double *Double;
        RPCMOD(caseis(S_MODE_COMPLEX)) struct s_complex_struct *Complex;
        RPCMOD(caseis(S_MODE_NAME))    string8 *name;
#ifndef RPC_FILE    /*(*/
    /* I don't think These cases shouldn't be going thru the RPC
       interface. -SAB */
        unsigned long offset;	/* disk offset */
#if 0
	s_object *(*sys)();	/* SHOULD NOT BE USED !!! type for an internal system function */
#endif
	s_entry_point *entry_point ;    /* for class internal_symbol, which has mode MISSING */
#endif /* ) RPC_FILE */
	RPCMOD(caseis(LIST)) struct s_object_struct **tree; /* lists & other 
                                                            recursive objects 
                                                            */
};

/* s_name structure, to be used for character strings that should be
 quick to look up or to test for equality.  If the code faithfully
 uses make_string to create them, only pointer equality of the text
 pointer need ever be tested. This structure is deliberately organized
 to match the s_object_struct structure.  That is, s_object_struct
 behaves as if it contains a s_name_struct PROVIDED that the char *
 pointer here takes same space as the union value in
 s_object_struct. Given this, all name objects in S can use this
 structure with consequent efficiency boost (see s_modernize_class)
 Particularly critical: the `casting' asserts that the value.name in
 the vector will be treated as a constant. See, e.g., copy_lev */
struct s_name_struct {
	const char *text;
	long probe;
	struct s_class_rep *name_class; /* must point to S_name_class */
	long dummy_length;
   };

#ifndef S_NAME_DEBUG
struct s_name_hash_struct {
	struct s_name_struct *string;
	s_index value;
};
#else
struct s_name_hash_struct {
	struct s_name_struct *string;
	s_index value;
};
#endif

typedef struct s_name_hash_struct s_name_hash;

struct s_name_table_struct {
  struct s_name_hash_struct *table;
  long tlen;
  long entries;
  double open_ratio;
  long storage_frame;
  long unhashed;
  MUTEX lock;
};

typedef struct s_name_table_struct s_name_table;

/* the index table structure is similar to s_name_table, but keys on */
/* unsigned integers rather than names.  Therefore its structure and */
/* algorithms are simpler.  Largely used for storing sparse data */
/* structures and in particular for inter-class path info */
enum s_hash_state {VIRGIN, OCCUPIED, AVAILABLE};
struct s_index_hash_struct {
  s_index key;
  s_index value;
  enum s_hash_state state;
};
typedef struct s_index_hash_struct s_index_hash;
struct s_index_table_struct {
  s_index_hash *table;
  long tlen;
  long entries;
  double open_ratio;
  long storage_frame;
  long unhashed;
  MUTEX lock;
};

typedef union s_pointer_union s_pointer;
struct s_object_struct {
        RPCMOD(unionis(mode) sizeis(nalloc)) s_pointer value;
	long nalloc;
	s_class *Class;
	long length;
	struct s_mmap_struct *map;
	s_object *frame;
	int Type;
	char *name;
	int mode;
 /* Put an evaluator pointer (s_evaluator*) here if objects are to be associated
    with threads. Also, could put in a lock to allow per object locking.
  */
#if defined(S_API_PERSISTENCY)
    S_apiPersistPath *p_path;
#endif
};

enum s_map_type { S_M_PRIVATE, S_M_SHARED, S_M_COPY};
      /* duplicates partially info in flags, but we avoid assuming */
      /* anything about the bit patterns used by mman.h */

typedef void (*s_map_notify)(s_index tag);

/* memory mapping */
struct s_mmap_struct {
  FILE *f;
  void *ptr;
  size_t len;
  off_t offset;
  int prot;
  int flags;
  enum s_map_type mtype; 
  char *path;
  long pid;
  long frame;
  int count;
  s_index tag;
  s_map_notify notify;
};

/* For use with c_support.c:SGUI_isinmainmenu, for now only S+Win GUI */
enum mainmenu_type {MAINMENU_ANY, MAINMENU_HELP};
S_end_extern_c
#endif /* S_structsINCLUDED */
