#ifndef SPRINTER_H
#define SPRINTER_H

/* number of local state variables to be retained by device */
#define NLOCAL 7


typedef struct {

  S_sigpf osig;
  FILE *outfile;

  float parameters[NLOCAL];
  device *dev;

} SPrinter_Attrs;



         /* definitions for the state variables */
#define width(p)        ((long *) ((p)->parameters))[0]
#define height(p)       ((long *) ((p)->parameters))[1]
#define to_do(p)        ((long *) ((p)->parameters))[2]
#define curx(p)         ((long *) ((p)->parameters))[3]
#define cury(p)         ((long *) ((p)->parameters))[4]
#define is_command(p)   ((long *) ((p)->parameters))[5]
#define pic(p)          ((char **)((p)->parameters))[6]

#endif


