#ifndef THREADENUMS_H
#define THREADENUMS_H

    /* */
typedef enum _ThreadStatus {
  Status_UNKNOWN,  /* status returned by the evaluator manager for a thread id not in the table */
  Status_ALIVE,
  Status_BUSY,
  Status_IDLE,
  Status_FINISHED,
  Status_BLOCKED,
  Status_TERMINATE,
  Status_CANCEL_TASK,
  Status_CANCEL,
  Status_CANCELLED,
  Status_SUSPEND,
  Status_SUSPENDED,
  Status_CONTINUE,
  Status_DUMP_FOR_RELOAD,
  Status_SESSION_QUIT,
  Status_IN_DOT_C,
  Status_IN_DOT_CALL,
  Status_IN_DOT_FORTRAN
} ThreadStatus;


 /* These are the messages/request types that the Evaluator knows how
    to respond to.
    A more interesting way to do this is to have the Evaluator Manager
    use its evaluator to compute the values using S and to basically
    have only one type of message - the SEVAL type.
    For the moment, we won't do this, but it does seem a shame to 
    implement a large switch statement when we have a language
    that can interpret the request. The overhead would be large
    using the evaluator and each request reduces to a C level call to
    access the evaluator manager's data structures anyhow.

    More can be added and a corresponding method added to the 
    table of function pointers used to implement them.
  */

typedef enum _ManagerMessageTypes {
                      ManagerMessage_SESSION_QUIT = 0,

                      ManagerMessage_SET_STATUS,
                      ManagerMessage_GET_STATUS,

                      ManagerMessage_GET_THREAD_OBJECT,

                      ManagerMessage_REMOVE_TASK,
                      ManagerMessage_SEND_TASK,
                      ManagerMessage_COPY_OBJECT,

                      ManagerMessage_CHILDREN,
                      ManagerMessage_PARENT,

                      ManagerMessage_HAS_ACCESS,

                      ManagerMessage_SEVAL,

                      ManagerMessage_SET_ATTRIBUTES,
                      ManagerMessage_GET_ATTRIBUTES,

                      ManagerMessage_JOIN, /* Not implemented at the C level (yet) */

                      ManagerMessage_NEW_THREAD,
                      ManagerMessage_MEM_EXCEEDED,
                      ManagerMessage_THREAD_LIST,

                                /* ThreadLock messages */
                      ManagerMessage_THREADLOCK_WAIT,
                      ManagerMessage_THREADLOCK_UNREGISTER,

                      ManagerMessage_THREADLOCK_EVENT,
                      ManagerMessage_THREADLOCK_ASSIGN,
                      ManagerMessage_THREADLOCK_REMOVE,


                      ManagerMessage_REGISTER_METHOD,
            
                          /* Always the last so we know how many messages are defined */
                      ManagerMessage_MAX_INDEX
                     } ManagerMessageTypes;


typedef enum _ActionMessageTypes {
                  ActionMessage_QUIT = 0,
                  ActionMessage_SUSPEND,
                  ActionMessage_CONTINUE
} ActionMessageTypes;


/*
ManagerMessage_GET_OBJECT takes care of retrieving all the 
 objects referenced in the following enum.
    DB - not implemented as meaningless here or doable through S.
    SEARCHPATH
    VALUE
    TASK_QUEUE
    CURRENT_TASK
    OPTIONS
    LAST_VALUE
*/


typedef enum  _ObjectID {
  Object_DB=1,
  Object_SEARCHPATH,
  Object_VALUE,
  Object_TASK_QUEUE,
  Object_CURRENT_TASK,
  Object_OPTIONS,
  Object_LAST_VALUE,
  Object_TASK_HISTORY
} ObjectID;

#endif
