/* %Z%%Q% */

#ifndef _S_IEEE_H_ /*(*/
#define _S_IEEE_H_
#include <local_os.h>


#define DNANEXP 0x7ff
typedef struct {
#if defined(LINUX) || defined(SUN386I) || defined(DECSTATION) || defined(OSF1_DECALPHA)
		unsigned lo:32;
		unsigned hi:20;
		unsigned exp:11;
		unsigned sign:1;
#else  
		unsigned sign:1;
		unsigned exp:11;
		unsigned hi:20;
		unsigned lo:32;
#endif
	} fp;			
typedef union {
		double dbl;
		fp     dfp;
} sfp;
extern fp strnan;
extern fp strinf;
#define _dnan  (*(double *)&strnan)
#define _dinf  (*(double *)&strinf)

#define dsign dfp.sign
#define dexp  dfp.exp
#define dhi   dfp.hi
#define dlo   dfp.lo
 
#define DINF 0x7ff00000
#define SINF 0x7f800000
#define DHIMANT 0xfffff
#define SHIMANT 0x7fffff
#define SIGNBIT 0x80000000
/* !!! assume that sizeof(int)==sizeof(float) and 2*sizeof(int)==sizeof(double)
 * This had been declared long but sizeof(long)==sizeof(double) on DecAlpha
 * New def could run into problems on old 16 machines, should #ifdef it?
 */
typedef union fs { float f;  int l; } FS,*FSP; 
typedef union ds { double f;  int l[2]; } DS,*DSP; 
#if defined(LINUX) || defined(SUN386I)||defined(DECSTATION)||defined(DOS386)||defined(OSF1_DECALPHA) ||defined(WIN32)
#define HI 1
#define LO 0
#else
#define HI 0
#define LO 1
#endif
#define _dfinite(x) ((sizeof(x)==sizeof(double))&&(((((DSP)&x)->l[HI])&DINF) !=DINF))
#define _sfinite(x) ((sizeof(x)==sizeof(float))&&(((((FSP)&x)->l)&SINF) !=SINF))
#define _finite(x) (_dfinite(x)||_sfinite(x))

#define _is_nan(x) (_is_dnan(x)||_is_snan(x))
#define _is_dnan(x) ((sizeof(x)==sizeof(double))&&\
			(((((DSP)&x)->l[HI])&DINF)==DINF)&&\
				(((DSP)&x)->l[LO]||((((DSP)&x)->l[HI])&DHIMANT)))
#define _is_snan(x) ((sizeof(x)==sizeof(float))&&\
			(((((FSP)&x)->l)&SINF)==SINF)&&\
					((((FSP)&x)->l)&SHIMANT))
#define _is_inf(x) (_is_dinf(x)||_is_sinf(x))
#define _is_dinf(x) ((sizeof(x)==sizeof(double))&&\
			(((((DSP)&x)->l[HI])&DINF)==DINF)&&\
			    ((((((DSP)&x)->l[LO])==0)&&((((DSP)&x)->l[HI])&DHIMANT)==0)))
#define _is_sinf(x) ((sizeof(x)==sizeof(float))&&\
			(((((FSP)&x)->l)&SINF)==SINF)&&\
				(((((FSP)&x)->l)&SHIMANT)==0))
#define _ssignbit(x) ((sizeof(x)==sizeof(float))&&((((FSP)&x)->l)&SIGNBIT))
#define _dsignbit(x) ((sizeof(x)==sizeof(double))&&((((DSP)&x)->l[HI])&SIGNBIT))
#define _signum(x)	(_dsignbit(x)||_ssignbit(x))

 
#if defined(HP300)||defined(APOLLO)  /*structure of 68881 fpsr - incomplete*/
typedef struct fpsr_str {
	unsigned unknown:4;
	unsigned sign_bit:1;
	unsigned unnamed :11;
	unsigned excep	:8;
	unsigned end	:8;
};
#endif

#endif /* !_S_IEEE_H_ )*/
