/* @(#) Copyright (c), 1987, 2001 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile$: $Revision: #10 $, $Date: 2001/08/28 $  */
#ifndef _PTEMPLATE_H
#define _PTEMPLATE_H

#ifdef _PTEMPLATE_G
#define vextern
#define INIT(x) = (x)
#else
#define vextern extern
#define INIT(x)
#endif

#ifdef X11_PROGRAM
#include <X11/Intrinsic.h>
#else
#include <sys/types.h>
#define XtPointer    caddr_t
#define XtAppContext caddr_t
#define XtInputId    caddr_t
#endif

/* The GENERAL idea is that "process_*" are symbols that the actual symbols
   the subprocess defines and/or initializes. The "S_process_*" symbols are
   things defined outside of the subprocess' control.
 */

vextern int process_parent_pid INIT(0);
vextern int process_exit INIT(0);
vextern int process_exit_status INIT(0);
vextern int process_fd_to_parent INIT(-1);
vextern int process_fd_from_parent INIT(-1);
vextern int process_timeout_secs INIT(300);

#define WL_DEBUG        (-1)
#define WL_INFO         0
#define WL_MINOR        1
#define WL_SERIOUS      2
#define WL_VERY_SERIOUS 3
#ifdef DEBUG
vextern int warning_level INIT(WL_DEBUG);
#else
vextern int warning_level INIT(WL_MINOR);
#endif
extern void Fatal(char *msg ) ;
extern void Error(char *msg ) ;
extern void Warning(char *msg ) ;
extern void Info(char *msg ) ;
extern void Debug(char *msg ) ;
extern void report_message( char *msg, int level ) ;

extern void process_push_msg ( char *msg );
extern char *process_pop_msg ();
extern int  process_num_msg ();

/* xarg is (XtAppContext *) for X11 versions; unused otherwise. */
extern void process_initialize ( int argc, char **argv, XtAppContext *xarg );

extern void process_handle_command ( char *command, char *arguments );
extern void process_handle_bcommand ( char *buf, int buflen );
extern void process_shutdown ();
extern char *process_alloc ( int num, int size );
extern char *process_realloc ( char *ptr, int num, int size );
extern void  process_free ( char *ptr );

/* Provided in template main program. */
extern void S_process_returnstr ( char *str );
extern void S_process_returnbuf ( char *buf, int buflen );
extern int  S_process_parent_exists ();

#undef vextern
#undef INIT
#endif
