/* %Z%%Q% */
/* %Z%$RCSfile: smsgloop.h,v $ version $Revision: #17 $ created $Date: 2001/08/28 $ */

/* Note: This file is shared by both the S-PLUS GUI and engine */

#ifndef _MSGLOOP2_H__
#define _MSGLOOP2_H__

#include "cdefs.h"
#if !defined(S_ENGINE_BUILD) && !defined(SPPROC_EXPORTS) && defined(WIN32) /*(*/
#define _GUI_MSGLOOP_H_
#endif /*)*/

#ifdef _GUI_MSGLOOP_H_
#include "TxSclApi.h"
#endif

#ifdef _GUI_MSGLOOP_H_
extern BOOL bInSecondaryMsgLoop;
extern BOOL bInSecondaryMsgBreakCheck;
#endif

/* Hardcoded return codes for SecondaryMsgLoop().
   (Other possible values are an index into the 
   array of Window Messages, so values 0 and up are 'reserved'.)
 */
enum SMLStatus
{
	SML_STATUS_BREAK =-4,	/* Break is on (Esc key has been hit or an ESC msg was posted) */
	SML_STATUS_END,				/* Someone posted an END msg */
	SML_STATUS_OK,				/* OK, Break is not set */
	SML_STATUS_ERROR      /* Error */
};

#define SML_STATUSSTR_BREAK "User interrupt requested."
#define SML_STATUSSTR_ERROR "Unexpected error received during client window message processing."
		
/* Modes that are used by SecondaryMsgLoop() */
enum SMLMode
{             
   SML_ISBREAKON,    /* Return status of Is break on? (Esc key down) */
   SML_WNDMSG_BRK,   /* Process non-data affecting messages; return upon break (or timeout/idle?) */
   SML_ALL					 /* NO break processing! Process all messages until msg in array is hit, then return */
}; 
		
#ifdef _GUI_MSGLOOP_H_
extern "C" 
{
/* todo: __inline*/ UINT GetSMLEndMsgValue(void);
/* todo: __inline*/ UINT GetSMLEscapeMsgValue(void);
/* todo: __inline*/ void End2ndMsgLoop(void);
/* todo: __inline*/ void Escape2ndMsgLoop(void);
	TxExport32 void __stdcall S_AXUM_End2ndMsgLoop(void);
	TxExport32 void __stdcall S_AXUM_2ndMsgLoop(int *pnStatus, SMLMode nMode, UINT* pnQuitMsgs, UINT nNumQuitMsgs);
	TxExport32 void __stdcall S_AXUM_setguilock(BOOL bLockValue);
	TxExport32 void SecondaryMsgLoop(int*, SMLMode, UINT*, UINT);
	TxExport32 BOOL IsInSecondaryMsgLoop(void);
} 
TxDllApi int IsBreakOnThenStdioDispatch(void);
#endif

#if defined(_GUI_MSGLOOP_H_) /*(*/
#undef _GUI_MSGLOOP_H_
#endif /*)*/

#endif /* _MSGLOOP2_H__ */
