#ifndef S_SYSTEM_H
#define S_SYSTEM_H 1

#ifdef __cplusplus
extern "C" {
#endif

  /* define the macro below if the system obeys IEEE floating point
     arithmetic standard */
#include "local_os.h"
#include "cdefs.h"

#define IEEE754 1

  /* the following NA tests are defined here because they may be
     system-dependent.  For machines that really obey IEEE, the
     first are valid. */
#ifdef IEEE754
#define IEEE
/* the following is probably system dependant -- it should be defined
 * if floating point exceptions are never generated by floating point
 * overflows, underflows, and the like.  If defined arithmetic functions
 * in comp_util.c go faster, but expression could crash if FPE's are
 * generated.
 */
#define NO_FPE
#else
#define is_na_REAL(p) NA_PATTERN_REAL((p))
#define is_na_DOUBLE(p) NA_PATTERN_DOUBLE((p))
#define is_na_COMPLEX(p) NA_PATTERN_DOUBLE((&((p)->re)))
#endif
/* defines for NA */
#if (defined(IEEE) && defined(HAS_64BIT_LONG))
#undef NA_PATTERN
#define NA_PATTERN 0x7fffffff7fffffffL
#define NA_PATTERN_32 0x7ff00001
#define NA_PATTERN32 0x7fffffffL
#define NA_PATTERN64 0x7fffffff7fffffffL
#else
#define NA_PATTERN_32 0x7ff00001
#define NA_PATTERN32 0x7fffffffL
#define NA_PATTERN_64 0x7fffffff7fffffffL
#endif

#if (defined(HPUX) && !defined(HAS_64BIT_LONG)) || defined(_AIX)
#define F77_SUB(x) x
#define F77_NAME(x) x
#define F77_COM(x) x
#define F77_COMDECL(x) F77_COM(x)
#define F77_CALL(x)    x
#else
#define F77_SUB(x) x##_
#define F77_NAME(x) x##_
#define F77_COM(x) x##_
#define F77_COMDECL(x) F77_COM(x)
#define F77_CALL(x)    x##_
#endif

/* Define a type VOID_P which is void * for those machines whose
   compiler allows it, and char * for others (like mips).
   */
   
#if defined(IRIS4D) || defined(DECSTATION)
typedef char *	VOID_P;
#else
typedef void *	VOID_P;
#endif
/* Defines to handle generation of internal names for C and Fortran
 * on many machines, these symbols are have a leading underscore
 * but on some, particularly System V, they do not
 */

#define SYMBOL(x)	QUOTE(x)
#if (defined(HPUX) && !defined(HAS_64BIT_LONG)) || defined(_AIX)
#define FSYMBOL(x)	QUOTE(x)
#else
#define FSYMBOL(x)	QUOTE(x##_)
#endif
#define QUOTE(x)	#x

/* Typedef and define to handle conversion of character variables between
 * Fortran and C
 */

typedef char *F_CHARTYPE;	/* how C sees F77 character variables */
#define F_CHARP(x)	(x)	/* how to convert F_CHARTYPE to a pointer to
				 * the real string */
#ifdef NOEXTRAS
#define F77_CHAR_DECL(x) F_CHARTYPE x,int x##__len_
#define F77_CHAR_CALL(x) F_CHARP(x),strlen(F_CHARP(x))
#else
#define F77_CHAR_DECL(x) F_CHARTYPE x
#define F77_CHAR_CALL(x) F_CHARP(x)
#endif

/* max file name length - dataset names truncated to this size*/
#if !defined(WIN32) /*(*/
#define MAX_FILE_NAME_LEN 255
#else /*)(*/
/* defines for DOS file name checking */
#if !defined(_MAX_PATH) /*(*/
#include <stdlib.h>
#endif /*)*/
#define DOS_MAX_PATH_LEN (_MAX_PATH-1)
#define DOS_MAX_DIR (DOS_MAX_PATH_LEN-DOS_MAX_NAME-1)
#define DOS_MAX_BASE 8
#define DOS_MAX_EXT 3
#define DOS_MAX_NAME (DOS_MAX_BASE+1+DOS_MAX_EXT)
#define MAX_FILE_NAME_LEN DOS_MAX_PATH_LEN
#include "libext.h"
LibExtern char dos_fchar[];		/* gives each char's validity in DOS filename */
#include "unlibext.h"
#define CASE_BADMASK 1
#define DOS_OKMASK   2
#define NTFS_OKMASK  4
#define SSDB_OKMASK  8
/* IS_BDCHAR==FALSE, i.e. it's an ok char, if only case is "bad" */
#define IS_BDCHAR(x,y) (!IS_OKCHAR(x,(y)|CASE_BADMASK))
#define IS_BDCASE(x)   ((x) < 128 && dos_fchar[x] & CASE_BADMASK)
#define IS_OKCHAR(x,y) ((x) < 128 && dos_fchar[x] & (y))
#include "dos/dos_util.h"
#endif /*)*/

/* The references to the standard streams as files */
/* Used to initialize the standard connections (stdin_connection, etc.)*/
/* Following Posix, we map these to a string set up from ctermid */
#define DEFAULT_STDIN cterm_path
#define DEFAULT_STDOUT cterm_path
#define DEFAULT_STDERR cterm_path
extern char *cterm_path;

/* How to cast an arbitrary object's value pointer to char * for */
/* purposes of copying.  In an arbitrarily nasty system this could */
/* require a switch on all the members of the union of value pointers */
/* The following assumes that a pointer is a pointer; given that */
/* alignment has been handled correctly (and it has), then the numeric */
/* contents of the pointer are independent of what it points to */
#define VALUE_POINTER(obj) obj->value.name
#define SET_VALUE_POINTER(obj, p) (obj)->value.name = (char *)(p)

/* test a (char *) pointer for alignment as an element of of array x */
/* of type t.  We insist the pointer be a +ve offset and an integral */
/* number of t's away.  It would be attractive to test for alignment */
/* w/o reference to an array by checking that the address was an */
/* integral number t's but I don't believe this is reliable */
#define ALIGNED_MEMBER(p, x, t)  (((t *)p >= x) && (((t *)p - x) % sizeof(t)) == 0)

/* define STANDARD_MALLOC iff we want to use the system malloc, not
   the one in library/malloc */
#define STANDARD_MALLOC 1
typedef char SIGNED_CHAR;
#define IS_FTRUE(x) ((x) != FFALSE)
#ifdef SPLUS
/* Define "VOLATILE".  The volatile type is only available with ANSI C */
#if defined(S_ANSI_Syntax)
#define VOLATILE volatile
#else
#define VOLATILE
#endif
/* There are source-level routine names like coevec in both C and Fortran
source files, and this would cause confusion at link time on platforms
like HP-300 where the compilers don't add leading/trailing underscores to
distinguish.  We used to make these C name changes directly in the source;
now we leave things as they are in AT&T source, and map via cpp. */

#define seedin	seed_in
#define seedout	seed_out

/* UNIX/DOS C library differences */

#if defined(DOS386) /*(*/
#if !defined(WIN32) /*)(*/
#define link rename
#define kill(x,y) raise(y)
#else /*)(*/
#define ERROR_FILE_NOT_FOUND_STR	"The system cannot find the file specified."
#define ERROR_MOD_NOT_FOUND_STR		"The specified module could not be found."
#if defined(S_ENGINE_BUILD) /*(*/
#define isatty SGUI_isatty
#endif /*)*/
#endif /*)*/
extern int dos_system(char *command, int multi, int minimized);
#if defined(S_ENGINE_BUILD) /*(*/
#include "../slocal/win32/SpPosix/include/posext.h"
SpDllApi char * S_STDCALL realpath(const char *pszFileName, char *pszResolvedName);
#include "../slocal/win32/SpPosix/include/unposext.h"
#endif /*)*/
#if defined(S_NEWREDEF_SOURCE) /*(*/
extern FILE *Binopen(const char *filename, const char *mode);
#endif /*)*/
#else /*)(*/
#define IS_DELIM(x) ((x) == '/')
#define Binopen fopen
#endif /*)*/
extern int SGUI_isatty(int handle);

/* DOS vs Unix filename restriction defines, 2nd arg of define is in cdefs.h: */
#define FUNS_DIR	FunctionsDir
#define DSETS_DIR	DatasetsDir
#define HELP_DIR	HelpDir
#define DATA_DIR	DataDir
#define AUDIT_FILE	AuditFile
#define IS_AUDITNAME(x)	(stricmp(x,AUDIT_FILE)==0)

#if defined(WIN386) /*(*/
/* for S+Win's history() function */
#include <limits.h>
#define HISTBREAK_MARKER LONG_MIN
#endif /*)*/

#define PIPESIZE 4096
#if defined(SUNOS4) && !defined(__GNUC__)
typedef char *  S_malloc_t;
#elif defined(S_ANSI_Syntax) || defined(HPUX) || defined(IRIS4D) || defined(ULTRIX) || defined(IBMRS6000) || defined(OSF1_DECALPHA)
typedef void *  S_malloc_t;
#else
typedef char *  S_malloc_t;
#endif
#if defined(SUNOS4) && defined(__malloc_h)
/* We've already got a malloc_t definition since SunOS 4.x's malloc.h has
  been included already. */
#else
typedef S_malloc_t malloc_t;
#endif
/* AT&T typedef a malloc_t for all platforms and thus it may be used in code. */
/* We already had S_malloc_t. -ps */
#if defined(APOLLO) /*(*/
#define FTRUE -1  
/* Would the default IS_FTRUE definition be OK for Apollo? */
#define IS_FTRUE(x) (((x) & (1 << 31)) != 0)
#define IS_FFALSE(x) (((x) & (1 << 31)) == 0)
#endif /*)*/

#if defined(OSF1_DECALPHA) || defined(DECSTATION) /*(*/
#define FTRUE -1  
#undef IS_FTRUE /* prevent compiler warnings */
#undef IS_FFALSE
#define IS_FTRUE(x) (((x) & 1) != 0)
#define IS_FFALSE(x) (((x) & 1) == 0)
#endif /*)*/

#if defined(HP800) /*(*/
#define FTRUE 0x01000000
#define IS_FTRUE(x) (((x) & (1 << 24)) != 0)
#define IS_FFALSE(x) (((x) & (1 << 24)) == 0)
#endif /*)*/

#ifndef FTRUE /*(*/
#define FTRUE 1
#endif /*)*/

#ifndef FFALSE /*(*/
#define FFALSE 0
#endif /*)*/

#ifndef IS_FTRUE /*(*/
#define IS_FTRUE(x) ((x) != FFALSE)
#endif /*)*/

#ifndef IS_FFALSE /*(*/
#define IS_FFALSE(x) ((x) == FFALSE)
#endif /*)*/

#endif


#ifdef __cplusplus
}
#endif
#endif

#define INT_MAXDIGITS 10

