<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!--define the color types used by the tables -->
	<xsl:variable name="g_tableBG" select="'yellow'"/>
	<xsl:variable name="g_headerBG" select="'silver'"/>
	<xsl:variable name="g_rowBG_1" select="'#0099cc'"/>
	<xsl:variable name="g_rowBG_2" select="'#00cccc'"/>
	<xsl:variable name="g_defaultPattern" select="'#,##0.00'" />
	<xsl:variable name="g_defaultScientific" select="'0.00E0'" />

	<xsl:attribute-set name="title">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">20pt</xsl:attribute>
		<xsl:attribute name="line-height">24pt</xsl:attribute>
		<xsl:attribute name="space-after">10pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bold-emph">
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="line-height">18pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="small-cap">
		<xsl:attribute name="font-variant">small-caps</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="line-height">18pt</xsl:attribute>
		<xsl:attribute name="space-after">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="column-header">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-after-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="table-content">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-family">Courier</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="row-header">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="left">
		<xsl:attribute name="border-start-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="right">
		<xsl:attribute name="border-end-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="top">
		<xsl:attribute name="border-before-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="bottom">
		<xsl:attribute name="border-after-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">2pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="table-atts">
		<xsl:attribute name="border-before-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-before-style">double</xsl:attribute>
		<xsl:attribute name="border-before-width">6pt</xsl:attribute>
		<xsl:attribute name="border-start-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-start-style">double</xsl:attribute>
		<xsl:attribute name="border-start-width">3pt</xsl:attribute>
		<xsl:attribute name="border-after-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-after-style">double</xsl:attribute>
		<xsl:attribute name="border-after-width">3pt</xsl:attribute>
		<xsl:attribute name="border-end-color"><xsl:value-of select="$g_tableBG" /></xsl:attribute>
		<xsl:attribute name="border-end-style">double</xsl:attribute>
		<xsl:attribute name="border-end-width">3pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page" page-width="11in" page-height="8.5in">
					<fo:region-body region-name="body" margin-top="0.5in" margin-bottom="0.5in" margin-left="0.5in" margin-right="0.5in"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="page">
				<fo:flow flow-name="body"><fo:block>
						<xsl:apply-templates/>
				</fo:block></fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<xsl:template match="S-PLUS">
		<xsl:if test="boolean(./Header/Annotation)"><fo:block xsl:use-attribute-sets="title">
			<xsl:value-of select="./Header/Annotation/text()"/>
		</fo:block></xsl:if>

		<xsl:call-template name="GroupingInfo">
			<xsl:with-param name="element" select="./Generic/List/Components/Component/MultiDimensionalArray" />
			<xsl:with-param name="dimensionColumnNames" select="./Generic/List/Components/Component[2]/Vector" />
			<xsl:with-param name="maxColumnsPerTable" select="./Generic/List/Components/Component[3]/Vector/Items/Item/text()" />
		</xsl:call-template>
		<xsl:call-template name="GroupingInfo">
			<xsl:with-param name="element" select="./Generic/List/Components/Component/Matrix" />
			<xsl:with-param name="dimensionColumnNames" select="./Generic/List/Components/Component[2]/Vector" />
			<xsl:with-param name="maxColumnsPerTable" select="./Generic/List/Components/Component[3]/Vector/Items/Item/text()" />
		</xsl:call-template>
		<xsl:call-template name="ColumnInfo">
			<xsl:with-param name="splusElement" select="."/>
			<xsl:with-param name="element" select="./Generic/List/Components/Component"/>
			<xsl:with-param name="dimensionColumnNames" select="./Generic/List/Components/Component[2]/Vector" />
			<xsl:with-param name="maxColumnsPerTable" select="./Generic/List/Components/Component[3]/Vector/Items/Item/text()" />
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="GroupingInfo">
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />


		<xsl:if test="name($element) = 'Matrix'">
			<xsl:call-template name="Matrix">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="name($element) = 'MultiDimensionalArray'">
			<xsl:call-template name="MultiDimensionalArray">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="ColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<fo:block>
			<fo:block xsl:use-attribute-sets="title">Column Summary</fo:block>
			<xsl:choose>
				<xsl:when test="boolean($splusElement/Generic/List/Components/Component/Matrix)">
					<!-- EXACTLY 2 GROUPING VARS -->
					<xsl:call-template name="MatrixColumnInfo">
						<xsl:with-param name="splusElement" select="$splusElement" />
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="boolean($splusElement/Generic/List/Components/Component/MultiDimensionalArray)">
					<!-- ANY OTHER NUM GROUPING  VARS (EXCEPT 2) -->
					<xsl:call-template name="ArrayColumnInfo">
						<xsl:with-param name="splusElement" select="$splusElement" />
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- NO GROUPING -->
					<xsl:call-template name="NoGroupColumnInfo">
						<xsl:with-param name="splusElement" select="$splusElement" />
						<xsl:with-param name="element" select="$element" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</fo:block>
	</xsl:template>

	<xsl:template name="ArrayColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="decimalPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@decimalPattern))"><xsl:value-of select="$g_defaultPattern"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@decimalPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="scientificPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@scientificPattern))"><xsl:value-of select="$g_defaultScientific"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@scientificPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

 		<xsl:variable name="splusGrouping" select="$splusElement/Generic/List/Components/Component" />
 		<xsl:variable name="dominantLevels" select="$splusGrouping/MultiDimensionalArray/Attrs/Attr[@name = '.Dimnames']/List/Components/Component[1]/Vector/Items/Item" />
 		<xsl:variable name="otherLevels" select="$splusGrouping/MultiDimensionalArray/Attrs/Attr[@name = '.Dimnames']/List/Components/Component[position() != 1]/Vector/Items/Item" />
		<xsl:variable name="numLevels" select="count($dominantLevels)" />

 		<xsl:variable name="columnNames" select="$element/Generic/List/Components/Component/Generic/Attrs/Attr[@name = '.Names']"/>
 		<xsl:variable name="listChildren" select="$element/Generic/List/Components/Component/*" />

		<xsl:for-each select="$listChildren[position() mod $numLevels = 0]" >
			<xsl:variable name="tableNum" select="position() - 1" />
			<xsl:variable name="columnNameSet" select="$columnNames[last()]/Vector/Items/Item" />
			<xsl:variable name="startPosition" select="$tableNum * $numLevels"/>
			<xsl:variable name="endPosition" select="$startPosition + $numLevels" />

			<xsl:if test="count($listChildren[position() &gt; $startPosition and position() &lt;= $endPosition][name() != 'Vector']) > 0">
				<fo:block space-after="10pt"	>
					<xsl:if test="count($otherLevels/../..) &gt; 0">
						<fo:block xsl:use-attribute-sets="small-cap">
							<xsl:call-template name="ArrayGetTableTitle">
								<xsl:with-param name="tableNum" select="$tableNum"/>
								<xsl:with-param name="numOtherDim" select="count($otherLevels/../..)" />
								<xsl:with-param name="levelDims" select="$otherLevels/.." />
								<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
								<xsl:with-param name="ignoreFirstNDims" select="1"/>
							</xsl:call-template>
						</fo:block>
					</xsl:if>

					<xsl:call-template name="CreateTable">
						<xsl:with-param name="columnNameSet" select="$columnNameSet" />
						<xsl:with-param name="columnNames" select="$columnNames" />
						<xsl:with-param name="dominantLevels" select="$dominantLevels" />
						<xsl:with-param name="otherLevels" select="$otherLevels" />
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="tableNum" select="$tableNum" />
						<xsl:with-param name="element" select="$element[last()]" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
						<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
					</xsl:call-template>
				</fo:block>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="MatrixColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="decimalPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@decimalPattern))"><xsl:value-of select="$g_defaultPattern"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@decimalPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="scientificPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@scientificPattern))"><xsl:value-of select="$g_defaultScientific"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@scientificPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

 		<xsl:variable name="columnNames" select="$element/Generic/List/Components/Component/Generic/Attrs/Attr[@name = '.Names']"/>
 		<xsl:variable name="splusGrouping" select="$splusElement/Generic/List/Components/Component" />

		<xsl:variable name="dominantLevels" select="$splusGrouping/Matrix/RowNames/Items/Item" />
		<xsl:variable name="otherLevels" select="$splusGrouping/Matrix/Columns/Column" />
		<xsl:variable name="numLevels" select="count($dominantLevels)" />

		<xsl:for-each select="$splusGrouping/Matrix/Columns/Column">
			<xsl:variable name="tableNum" select="position() - 1" />
			<xsl:variable name="columnNameSet" select="$columnNames[last()]/Vector/Items/Item" />

			<fo:block space-after="10pt"	>
				<fo:block xsl:use-attribute-sets="small-cap">
					<xsl:call-template name="MatrixGetTableTitle">
						<xsl:with-param name="levelDims" select="$otherLevels" />
						<xsl:with-param name="tableNum" select="$tableNum"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
					</xsl:call-template>
				</fo:block>

				<xsl:call-template name="CreateTable">
					<xsl:with-param name="columnNameSet" select="$columnNameSet" />
					<xsl:with-param name="columnNames" select="$columnNames" />
					<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
					<xsl:with-param name="dominantLevels" select="$dominantLevels" />
					<xsl:with-param name="otherLevels" select="$otherLevels" />
					<xsl:with-param name="tableNum" select="$tableNum" />
					<xsl:with-param name="element" select="$element" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
					<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
				</xsl:call-template>

			</fo:block>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="NoGroupColumnInfo">
		<xsl:param name="splusElement" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="decimalPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@decimalPattern))"><xsl:value-of select="$g_defaultPattern"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@decimalPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="scientificPattern">
			<xsl:choose>
				<xsl:when test="not(boolean($splusElement/DisplayOptions/@scientificPattern))"><xsl:value-of select="$g_defaultScientific"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$splusElement/DisplayOptions/@scientificPattern"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

 		<xsl:variable name="dominantLevels" select="$splusElement/Generic/Components/Component/Matrix" />
 		<xsl:variable name="otherLevels" select="$splusElement/Generic/Components/Component/Matrix" />
 		<xsl:variable name="columnNames" select="$element/Generic/Attrs/Attr[@name = '.Names']"/>
		<xsl:variable name="numLevels" select="count($dominantLevels)" />

		<xsl:variable name="tableNum" select="position() - 1" />
		<xsl:variable name="columnNameSet" select="$columnNames[last()]/Vector/Items/Item" />

		<fo:block space-after="10pt"	>
			<xsl:call-template name="CreateTable">
				<xsl:with-param name="columnNameSet" select="$columnNameSet" />
				<xsl:with-param name="columnNames" select="$columnNames" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="dominantLevels" select="$dominantLevels" />
				<xsl:with-param name="otherLevels" select="$otherLevels" />
				<xsl:with-param name="tableNum" select="0" />
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
			</xsl:call-template>
		</fo:block>
	</xsl:template>

	<xsl:template name="CreateTable">
		<xsl:param name="columnNameSet" select="''" />
		<xsl:param name="columnNames" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="dominantLevels" select="''" />
		<xsl:param name="otherLevels" select="''" />
		<xsl:param name="tableNum" select="''" />
		<xsl:param name="element" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="currentLevelNum" select="1" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<!--
			in order to break the tables up to fit onto a page
			we need to store the start and end levels so we
			can iterativly cover all the levels.
		-->
		<xsl:variable name="domLevelCount" select="count($dominantLevels)" />
		<xsl:variable name="startLevel">
			<xsl:choose><xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$currentLevelNum"/></xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose>
		</xsl:variable>
		<xsl:variable name="endLevel">
			<xsl:choose>
				<xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$currentLevelNum + $maxColumnsPerTable"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$domLevelCount + 1"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="dominantLevelsSubset" select="$dominantLevels[position() &gt;= $startLevel and position() &lt; $endLevel]" />
		<xsl:variable name="totalDominantLevelCount" select="count($dominantLevels)" />

		<xsl:variable name="testChildren" select="$element/Generic/List/Components/Component/*" />
		<xsl:variable name="testStartPosition" select="$tableNum * $totalDominantLevelCount+ $startLevel"/>
		<xsl:variable name="testEndPosition" select="$testStartPosition + count($dominantLevelsSubset)" />

		<xsl:if test="($totalDominantLevelCount = 0) or (count($testChildren[position() &gt;= $testStartPosition and position() &lt; $testEndPosition][name() != 'Vector']) > 0)">
			<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed" space-after="5pt">
				<!-- column used for column names -->
				<xsl:element name="fo:table-column">
					<xsl:attribute name="column-number">1</xsl:attribute>
					<xsl:attribute name="column-width">
						<xsl:call-template name="ItemTextWidth">
							<xsl:with-param name="element" select="$columnNameSet/.."/>
							<xsl:with-param name="TotalNum" select="count($columnNameSet)"/>
						</xsl:call-template><xsl:text>pt</xsl:text>
					</xsl:attribute>
				</xsl:element>
				<!-- column used for statistic description -->
				<xsl:element name="fo:table-column">
					<xsl:attribute name="column-number">2</xsl:attribute>
					<xsl:attribute name="column-width">
						<xsl:choose>
							<xsl:when test="count($otherLevels) + count($dominantLevelsSubset) > 0">
								<xsl:call-template name="ColumnNameWidth">
									<xsl:with-param name="element" select="$otherLevels"/>
									<xsl:with-param name="TotalNum" select="count($otherLevels)"/>
									<xsl:with-param name="minWidth">
										<xsl:call-template name="ItemTextWidth">
											<xsl:with-param name="element" select="$dominantLevelsSubset/.."/>
											<xsl:with-param name="TotalNum" select="count($dominantLevelsSubset)"/>
										</xsl:call-template>
									</xsl:with-param>
								</xsl:call-template><xsl:text>pt</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="TextNodeWidth">
									<xsl:with-param name="element" select="$element/Generic/List/Components/Component/Generic/List/Components/Component/MultiDimensionalArray/Attrs/Attr[@name = '.Dimnames']/List/Components/Component/Vector/Items/Item"/>
									<xsl:with-param name="TotalNum" select="count($element/Generic/List/Components/Component/Generic/List/Components/Component/MultiDimensionalArray/Attrs/Attr[@name = '.Dimnames']/List/Components/Component/Vector/Items/Item)"/>
									<xsl:with-param name="minWidth">
										<xsl:call-template name="TextNodeWidth">
											<xsl:with-param name="element" select="$element/Generic/List/Components/Component/Generic/Attrs/Attr/Vector/Items/Item"/>
											<xsl:with-param name="TotalNum" select="count($element/Generic/List/Components/Component/Generic/Attrs/Attr/Vector/Items/Item)"/>
										</xsl:call-template>
									</xsl:with-param>
								</xsl:call-template><xsl:text>pt</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</xsl:element>
				<!-- column for each of the dominant levels -->
				<xsl:if test="count($dominantLevelsSubset) = 0">
					<xsl:element name="fo:table-column">
						<xsl:attribute name="column-width">
							<xsl:call-template name="GetWidth">
								<xsl:with-param name="string" select="'Statistic'"/>
								<xsl:with-param name="minWidth" select="100" />
							</xsl:call-template><xsl:text>pt</xsl:text>
						</xsl:attribute>
					</xsl:element>
				</xsl:if>
				<xsl:for-each select="$dominantLevelsSubset">
					<xsl:element name="fo:table-column">
						<xsl:attribute name="column-width">
							<xsl:call-template name="GetWidth">
								<xsl:with-param name="string" select="./text()"/>
								<xsl:with-param name="minWidth" select="100" />
							</xsl:call-template><xsl:text>pt</xsl:text>
						</xsl:attribute>
					</xsl:element>
				</xsl:for-each>
				<fo:table-header>
					<xsl:if test="count($dominantLevelsSubset) != 0">
						<fo:table-row background-color="{$g_headerBG}">
							<fo:table-cell background-color="{$g_tableBG}">	<fo:block></fo:block></fo:table-cell>
							<fo:table-cell background-color="{$g_tableBG}">	<fo:block></fo:block></fo:table-cell>
							<xsl:element name="fo:table-cell" use-attribute-sets="column-header top bottom left right">
								<xsl:attribute name="background-color"><xsl:value-of select="$g_headerBG"/></xsl:attribute>
								<xsl:attribute name="number-columns-spanned"><xsl:value-of select="count($dominantLevelsSubset)"/></xsl:attribute>
								<xsl:attribute name="text-align">center</xsl:attribute>
								<fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]" /></fo:block>
							</xsl:element>
						</fo:table-row>
					</xsl:if>
					<fo:table-row background-color="{$g_headerBG}">
						<fo:table-cell xsl:use-attribute-sets="top bottom left right" background-color="{$g_tableBG}"><fo:block><xsl:text> </xsl:text></fo:block></fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="top bottom left right" background-color="{$g_tableBG}"><fo:block><xsl:text> </xsl:text></fo:block></fo:table-cell>
						<xsl:if test="count($dominantLevelsSubset) = 0">
							<fo:table-cell xsl:use-attribute-sets="column-header top bottom left right" background-color="{$g_headerBG}"><fo:block>Statistic</fo:block></fo:table-cell>
						</xsl:if>
						<xsl:for-each select="$dominantLevelsSubset">
							<fo:table-cell xsl:use-attribute-sets="column-header top bottom left right" background-color="{$g_headerBG}"><fo:block><xsl:value-of select="./text()" /></fo:block></fo:table-cell>
						</xsl:for-each>
					</fo:table-row>
				</fo:table-header>
				<fo:table-body>
					<!-- add statistics for the "rows" described by the column/level combination -->
					<xsl:for-each select="$columnNames[last()]/Vector/Items/Item">
						<xsl:variable name="columnNum" select="position() - 1"/>

						<xsl:call-template name="ColumnInfoRowsPerColumnAndLevel">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="levels" select="$dominantLevelsSubset"/>
							<xsl:with-param name="numLevels" select="$totalDominantLevelCount" />
							<xsl:with-param name="columnNum" select="$columnNum"/>
							<xsl:with-param name="tableNum" select="$tableNum" />
							<xsl:with-param name="columnName" select="./text()" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
							<xsl:with-param name="startLevel" select="$startLevel" />
						</xsl:call-template>
					</xsl:for-each>
				</fo:table-body>
			</fo:table>
		</xsl:if>

		<xsl:if test="$maxColumnsPerTable &gt; 0 and $endLevel &lt;= $domLevelCount">
			<xsl:call-template name="CreateTable">
				<xsl:with-param name="columnNameSet" select="$columnNameSet" />
				<xsl:with-param name="columnNames" select="$columnNames" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames" />
				<xsl:with-param name="dominantLevels" select="$dominantLevels" />
				<xsl:with-param name="otherLevels" select="$otherLevels" />
				<xsl:with-param name="tableNum" select="$tableNum" />
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				<xsl:with-param name="currentLevelNum" select="$endLevel" />
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable"/>
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

	<xsl:template name="MatrixGetTableTitle">
		<xsl:param name="tableNum" select="''"/>
		<xsl:param name="levelDims" select="''" />
		<xsl:param name="dimensionColumnNames" select="''" />

		<xsl:variable name="modulus" select="count($levelDims)" />
		<xsl:variable name="curDimVal" select="$tableNum mod $modulus" />
		<xsl:variable name="curDimName" select="$levelDims[$curDimVal + 1]/@name" />

		<xsl:variable name="dimensionalOutput">
 			<xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/><xsl:text> = </xsl:text><xsl:value-of select="$curDimName"/>
 		</xsl:variable>

 		<xsl:value-of select="$dimensionalOutput"/>

	</xsl:template>

	<xsl:template name="ArrayGetTableTitle">
		<xsl:param name="tableNum" select="''"/>
		<xsl:param name="levelDims" select="''" />
		<xsl:param name="numOtherDim" select="0" />
		<xsl:param name="curDim" select="1" />
		<xsl:param name="dividor" select="1" />
		<xsl:param name="label" select="'(,'" />
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="ignoreFirstNDims" select="1"/>


		<xsl:variable name="modulus" select="count($levelDims[$curDim]/Item)" />
		<xsl:variable name="curDimVal" select="(floor($tableNum div $dividor)) mod $modulus" />
		<xsl:variable name="curDimName" select="$levelDims[$curDim]/Item[$curDimVal + 1]/text()" />
 		<xsl:variable name="dimensionalOutput">
 			<xsl:value-of select="$dimensionColumnNames/Items/Item[$curDim + $ignoreFirstNDims]"/><xsl:text> = </xsl:text><xsl:value-of select="$curDimName"/>
 		</xsl:variable>

 		<fo:block><xsl:value-of select="$dimensionalOutput"/></fo:block>

 		<xsl:if test="$curDim != $numOtherDim">
 			<xsl:call-template name="ArrayGetTableTitle">
 				<xsl:with-param name="tableNum" select="$tableNum"/>
 				<xsl:with-param name="numOtherDim" select="$numOtherDim" />
 				<xsl:with-param name="levelDims" select="$levelDims" />
 				<xsl:with-param name="dividor" select="$dividor * $modulus" />
 				<xsl:with-param name="curDim" select="$curDim + 1" />
 				<xsl:with-param name="label" select="concat($label, $curDimName, '[', $dimensionColumnNames/Items/Item[$curDim + $ignoreFirstNDims], ']', ', ')" />
 				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames" />
 				<xsl:with-param name="ignoreFirstNDims" select="$ignoreFirstNDims"/>
 			</xsl:call-template>
 		</xsl:if>
	</xsl:template>

	<xsl:template name="ColumnInfoRowsPerColumnAndLevel">
		<xsl:param name="element" select="''" />
		<xsl:param name="columnName" select="''" />
		<xsl:param name="columnNum" select="''" />
		<xsl:param name="tableNum" select="'0'" />
		<xsl:param name="levels" select="''" />
		<xsl:param name="numLevels" select="0" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="startLevel" select="0" />

		<xsl:variable name="noLevelChildren" select="$element/Generic" />
		<xsl:variable name="levelChildren" select="$element/Generic/List/Components/Component/*" />
		<xsl:variable name="rowChildren" select="$noLevelChildren[position() &lt;= (last() * number($numLevels = 0))]  | $levelChildren[position() &lt;= (last() * number($numLevels != 0))]"/>
		<xsl:variable name="rowStartPos">
			<xsl:choose>
				<xsl:when test="$numLevels = 0"><xsl:value-of select="$tableNum + 1"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="($tableNum * $numLevels) + 1"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:call-template name="GetNumericInfoRows">
			<xsl:with-param name="levels" select="$levels" />
			<xsl:with-param name="numLevels" select="$numLevels" />
			<xsl:with-param name="element" select="$rowChildren" />
			<xsl:with-param name="startPos" select="$rowStartPos" />
			<xsl:with-param name="columnNum" select="$columnNum + 1" />
			<xsl:with-param name="columnName" select="$columnName" />
			<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
			<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
			<xsl:with-param name="startLevel" select="$startLevel"/>
		</xsl:call-template>
		<xsl:call-template name="GetCategoryInfoRows">
			<xsl:with-param name="levels" select="$levels" />
			<xsl:with-param name="numLevels" select="$numLevels" />
			<xsl:with-param name="element" select="$rowChildren" />
			<xsl:with-param name="startPos" select="$rowStartPos" />
			<xsl:with-param name="columnNum" select="$columnNum + 1" />
			<xsl:with-param name="columnName" select="$columnName" />
			<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
			<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
			<xsl:with-param name="startLevel" select="$startLevel"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="GetNumericInfoRows">
		<xsl:param name="levels" select="''" />
		<xsl:param name="numLevels" select="0" />
		<xsl:param name="element" select="''" />
		<xsl:param name="startPos" select="0" />
		<xsl:param name="columnNum" select="1" />
		<xsl:param name="columnName" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="startLevel" select="1" />

		<xsl:variable name="adjustedLevelCount">
			<xsl:choose>
				<xsl:when test="$numLevels = 0">1</xsl:when>
				<xsl:otherwise><xsl:value-of select="$numLevels"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
 		<xsl:variable name="possibleData" select="$element[$startPos]/List/Components/Component/*" />
 		<xsl:variable name="firstList" select="$element[position() &gt;= $startPos and position() &lt; ($startPos + $adjustedLevelCount)]/List" />
 		<xsl:variable name="data" select="$possibleData[$columnNum]/List/Components/Component/Vector"  />
		<xsl:variable name="itemCount" select="count($data)" />

 		<xsl:if test="count($firstList[1]/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray) = 0">
 			<xsl:variable name="rowNames" select="$firstList[1]/Components/Component[$columnNum]/Generic/Attrs/Attr[last()]/Vector/Items/Item" />
			<xsl:for-each select="$rowNames">
				<xsl:variable name="dataItem" select="position()" />
				<xsl:variable name="rowName" select="./text()" />

				<xsl:element name="fo:table-row">
					<xsl:attribute name="background-color"><xsl:choose>
							<xsl:when test="$dataItem mod 2 = 1"><xsl:value-of select="$g_rowBG_1"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise>
					</xsl:choose></xsl:attribute>

					<xsl:choose>
						<xsl:when test="count($rowNames) = 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block><xsl:value-of select="$columnName"/></fo:block></fo:table-cell></xsl:when>
						<xsl:when test="$dataItem = 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top left right"><fo:block><xsl:value-of select="$columnName"/></fo:block></fo:table-cell></xsl:when>
						<xsl:when test="itemCount = $dataItem"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="bottom left right"><fo:block></fo:block></fo:table-cell></xsl:when>
						<xsl:otherwise><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="left right"><fo:block></fo:block></fo:table-cell></xsl:otherwise>
					</xsl:choose>
					<fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block><xsl:value-of select="$rowName"/></fo:block></fo:table-cell>

					<xsl:if test="$numLevels = 0">
						<fo:table-cell xsl:use-attribute-sets="table-content top bottom left right"><fo:block>
							<xsl:call-template name="OutputNumericItem">
								<xsl:with-param name="element" select="$element" />
								<xsl:with-param name="startPos" select="$startPos" />
								<xsl:with-param name="columnNum" select="$columnNum" />
								<xsl:with-param name="dataItem" select="$dataItem" />
								<xsl:with-param name="rowName" select="$rowName" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
								<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
							</xsl:call-template>
						</fo:block></fo:table-cell>
					</xsl:if>
					<xsl:for-each select="$levels">
						<xsl:variable name="levelNum" select="position()" />

						<fo:table-cell xsl:use-attribute-sets="table-content top bottom left right"><fo:block>
							<xsl:call-template name="OutputNumericItem">
								<xsl:with-param name="element" select="$element" />
								<xsl:with-param name="startPos" select="($startLevel - 1) + $startPos + $levelNum - 1" />
								<xsl:with-param name="columnNum" select="$columnNum" />
								<xsl:with-param name="dataItem" select="$dataItem" />
								<xsl:with-param name="rowName" select="$rowName" />
								<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
								<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
							</xsl:call-template>
						</fo:block></fo:table-cell>
					</xsl:for-each>
				</xsl:element>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="OutputNumericItem">
		<xsl:param name="element" select="''" />
		<xsl:param name="startPos" select="''" />
		<xsl:param name="columnNum" select="''" />
		<xsl:param name="dataItem" select="''" />
		<xsl:param name="rowName" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

		<xsl:choose>
			<xsl:when test="name($element[$startPos]) = 'Null'"><xsl:text> </xsl:text></xsl:when>
			<xsl:otherwise>
				<xsl:variable name="nonListItems" select="$element[$startPos]/List/Components/Component[$columnNum]/Generic/List/Components/Component[$dataItem]/Vector/Items/Item" />
				<xsl:variable name="listItems" select="$element[$startPos]/List/Components/Component[$columnNum]/Generic/List/Components/Component[$dataItem]/Generic/Vector/Items/Item" />
				<xsl:variable name="items" select="$nonListItems[position() &lt;= (last() * number(boolean($nonListItems)))] | $listItems[position() &lt;= (last() * number(boolean($listItems)))]" />
				<xsl:choose>
					<xsl:when test="$rowName = 'missing'">
						<xsl:call-template name="OutputCountAndPercent">
							<xsl:with-param name="count" select="$items[1]/text()" />
							<xsl:with-param name="percent" select="$items[2]/text()" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="count($items) &gt; 1">(</xsl:if>
						<xsl:for-each select="$items">
							<xsl:element name="fo:inline">
								<xsl:if test="./text() &gt; 0">
									<xsl:attribute name="color">#FF0000</xsl:attribute>
								</xsl:if>
								<xsl:call-template name="roundNumber">
									<xsl:with-param name="string" select="./text()"/>
									<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
									<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
								</xsl:call-template>
								<xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if>
							</xsl:element>
						</xsl:for-each>
						<xsl:if test="count($items) &gt; 1">)</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="GetCategoryInfoRows">
		<xsl:param name="levels" select="''" />
		<xsl:param name="numLevels" select="0" />
		<xsl:param name="element" select="''" />
		<xsl:param name="startPos" select="0" />
		<xsl:param name="columnNum" select="1" />
		<xsl:param name="columnName" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />
		<xsl:param name="startLevel" select="1" />

		<xsl:variable name="adjustedLevelCount">
			<xsl:choose>
				<xsl:when test="$numLevels = 0">1</xsl:when>
				<xsl:otherwise><xsl:value-of select="$numLevels"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="firstArray"  select="$element[position() &gt;= $startPos and position() &lt; ($startPos + $adjustedLevelCount)]/List/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray"/>
		<xsl:variable name="data" select="$element[$startPos]/List/Components/Component/Generic/List/Components/Component[$columnNum]/MultiDimensionalArray"  />
		<xsl:variable name="loopData" select="$firstArray[1]/Attrs/Attr[@name = '.Dimnames']/List/Components/Component/Vector/Items/Item" />
   		<xsl:variable name="loopCount" select="count($loopData)" />
   		<xsl:variable name="itemCount" select="count($data)" />

		<xsl:for-each select="$loopData">
			<xsl:variable name="levelPos" select="position()" />
			<xsl:variable name="levelName" select="./text()" />

			<xsl:element name="fo:table-row">
				<xsl:attribute name="background-color"><xsl:choose>
						<xsl:when test="$levelPos mod 2 = 1"><xsl:value-of select="$g_rowBG_1"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise>
				</xsl:choose></xsl:attribute>

				<xsl:choose>
					<xsl:when test="$loopCount = 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block><xsl:value-of select="$columnName"/></fo:block></fo:table-cell></xsl:when>
					<xsl:when test="$levelPos= 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top left right"><fo:block><xsl:value-of select="$columnName"/></fo:block></fo:table-cell></xsl:when>
					<xsl:when test="itemCount = $levelPos"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="bottom left right"><fo:block></fo:block></fo:table-cell></xsl:when>
					<xsl:otherwise><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="left right"><fo:block></fo:block></fo:table-cell></xsl:otherwise>
				</xsl:choose>
				<fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block><xsl:value-of select="$levelName"/></fo:block></fo:table-cell>

				<xsl:if test="$numLevels = 0">
 					<xsl:variable name="mdarrays" select="$element[$startPos]/List/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray" />

					<fo:table-cell xsl:use-attribute-sets="table-content top bottom left right"><fo:block>
						<xsl:call-template name="OutputCountAndPercent">
							<xsl:with-param name="count" select="$mdarrays[1]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="percent" select="$mdarrays[2]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</fo:block></fo:table-cell>
				</xsl:if>
				<xsl:for-each select="$levels">
					<xsl:variable name="domLevelNum" select="position()" />
 					<xsl:variable name="mdarrays" select="$element[($startLevel - 1) + $startPos + $domLevelNum - 1]/List/Components/Component[$columnNum]/Generic/List/Components/Component/MultiDimensionalArray" />

					<fo:table-cell xsl:use-attribute-sets="table-content top bottom left right"><fo:block>
						<xsl:call-template name="OutputCountAndPercent">
							<xsl:with-param name="count" select="$mdarrays[1]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="percent" select="$mdarrays[2]/Vector/Items/Item[$levelPos]/text()" />
							<xsl:with-param name="decimalPattern" select="$decimalPattern" />
							<xsl:with-param name="scientificPattern" select="$scientificPattern" />
						</xsl:call-template>
					</fo:block></fo:table-cell>
				</xsl:for-each>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="OutputCountAndPercent">
		<xsl:param name="count" select="''" />
		<xsl:param name="percent" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

		<xsl:element name="fo:inline">
			<xsl:if test="$count &gt; 0">
				<xsl:attribute name="color">#FF0000</xsl:attribute>
			</xsl:if>

			<xsl:value-of select="$count"/>
			<xsl:if test="boolean($percent)">
				(<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="$percent"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>%)
			</xsl:if>
		</xsl:element>
	</xsl:template>

	<xsl:template name="ColumnNameWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="1"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>

		<xsl:variable name="this" select="$element[$CurrentNum]/@name"/>
		<xsl:variable name="thisWidth" select="string-length($this) * 8"/>

		<xsl:choose>
			<xsl:when test="$TotalNum = 0 or $TotalNum = $CurrentNum">
				<!-- final case....return actual max -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $thisWidth"><xsl:value-of select="$minWidth"/></xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$thisWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="$minWidth &gt; $maxWidth">	<xsl:value-of select="$minWidth"/>	</xsl:when>
							<xsl:otherwise>	<xsl:value-of select="$maxWidth"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further -->
				<xsl:choose>
					<xsl:when test="$thisWidth &gt; $maxWidth">
						<xsl:call-template name="ColumnNameWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$thisWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="ColumnNameWidth">
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
							<xsl:with-param name="TotalNum" select="$TotalNum"/>
							<xsl:with-param name="maxWidth" select="$maxWidth"/>
							<xsl:with-param name="minWidth" select="$minWidth"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE ALL MATRIX & ARRAY HERE -->
<!--   borrow code from splus.objects.fo.xsl     -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE DATAFRAME OR MATRIX OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="Matrix">
		<xsl:param name="element" select="''"/>
		<xsl:param name="title" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

		<fo:block space-after="10pt">
			<!-- display title -->
			<fo:block xsl:use-attribute-sets="title"><xsl:value-of select="$title"/></fo:block>
			<!-- display the dimensions -->
			<fo:block xsl:use-attribute-sets="bold-emph" space-after="5pt">
	 			<xsl:text>Number of Categories:</xsl:text>
	 			<fo:block start-indent="30pt">
					<fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/><xsl:text> : </xsl:text><xsl:value-of select="count($element/RowNames/Items/Item)"/><xsl:text> categories</xsl:text></fo:block>
					<fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/><xsl:text> : </xsl:text><xsl:value-of select="count($element/Columns/Column)"/><xsl:text> categories</xsl:text></fo:block>
				</fo:block>
			</fo:block>

			<xsl:call-template name="MatrixTable">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
			</xsl:call-template>
		</fo:block>
	</xsl:template>

	<xsl:template name="MatrixTable">
		<xsl:param name="element" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />
		<xsl:param name="startLevel" select="1" />
		<xsl:param name="title" select="''"/>

		<xsl:variable name="numRows" select="count($element/RowNames/Items/Item)"/>

		<xsl:variable name="allColumns" select="$element/Columns/Column" />
		<xsl:variable name="numColumns" select="count($allColumns)" />
		<xsl:variable name="endLevel">
			<xsl:choose>
				<xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$startLevel + $maxColumnsPerTable" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$numColumns + 1" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="limitedColumns" select="$allColumns[position() &gt;= $startLevel and position() &lt; $endLevel]" />

		<!-- create table for display of data frame or of matrix -->
		<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed" space-after="5pt">
			<!-- total num columns = 1 (for row names/headers) + num columns -->
			<!-- create columns and assign widths -->
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="GetWidth"><xsl:with-param name="string" select="$dimensionColumnNames/Items/Item[1]"/></xsl:call-template><xsl:text>pt</xsl:text>
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">2</xsl:attribute>
				<xsl:attribute name="column-width"><xsl:call-template name="ItemTextWidth"><xsl:with-param name="element" select="$element/RowNames/Items"/><xsl:with-param name="TotalNum" select="count($element/RowNames/Items/Item)"/></xsl:call-template><xsl:text>pt</xsl:text>
				</xsl:attribute>
			</xsl:element>
			<xsl:for-each select="$limitedColumns">
				<xsl:element name="fo:table-column">
					<xsl:attribute name="column-width"><xsl:call-template name="ItemTextWidth"><xsl:with-param name="element" select="./Items"/><xsl:with-param name="maxWidth" select="string-length(./@name)*9"/><xsl:with-param name="TotalNum" select="count(./Items/Item)"/></xsl:call-template><xsl:text>pt</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:for-each>
			<!--assign values to row header -->
			<fo:table-header>
				<fo:table-row background-color="{$g_headerBG}">
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<xsl:element name="fo:table-cell" use-attribute-sets="column-header left right top bottom">
						<xsl:attribute name="background-color"><xsl:value-of select="$g_headerBG"/></xsl:attribute>
						<xsl:attribute name="number-columns-spanned"><xsl:value-of select="count($limitedColumns)"/></xsl:attribute>
						<xsl:attribute name="text-align">center</xsl:attribute>
						<fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/></fo:block>
					</xsl:element>
				</fo:table-row>
				<fo:table-row background-color="{$g_headerBG}">
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<xsl:for-each select="$limitedColumns">
						<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom">
							<fo:block><xsl:value-of select="@name"/></fo:block>
						</fo:table-cell>
					</xsl:for-each>
				</fo:table-row>
			</fo:table-header>

			<fo:table-body>
				<xsl:for-each select="$element/RowNames/Items/Item">
					<fo:table-row>
						<xsl:variable name="position" select="position()"/>

						<!-- create dimension column label -->
						<xsl:choose>
							<xsl:when test="$numRows = 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></fo:block></fo:table-cell></xsl:when>
							<xsl:when test="$position = 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top left right"><fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></fo:block></fo:table-cell></xsl:when>
							<xsl:when test="$position = $numRows"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="bottom left right"><fo:block></fo:block></fo:table-cell></xsl:when>
							<xsl:otherwise><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="left right"><fo:block></fo:block></fo:table-cell></xsl:otherwise>
						</xsl:choose>

						<!-- first item is row header that contains row name -->
						<xsl:element name="fo:table-cell" use-attribute-sets="row-header top bottom left right">
							<xsl:attribute name="background-color"><xsl:value-of select="$g_headerBG"/></xsl:attribute>
							<fo:block><xsl:value-of select="./text()"/></fo:block>
						</xsl:element>
						<!-- add actual data...watch for factors and missng values -->
						<xsl:for-each select="$limitedColumns">
							<xsl:variable name="value" select="./Items/Item[$position]/text()"/>
							<xsl:variable name="innerElement" select="."/>
							<xsl:element name="fo:table-cell" use-attribute-sets="table-content top bottom left right">
								<xsl:attribute name="background-color"><xsl:choose><xsl:when test="$position mod 2 = 1"><xsl:value-of select="$g_rowBG_1"/></xsl:when><xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise></xsl:choose></xsl:attribute>
								<fo:block><xsl:choose>
										<!-- factor -->
										<xsl:when test="count($innerElement/Attrs/Attr[@name = 'levels']) = 0"><xsl:value-of select="$value"/></xsl:when>
										<!-- missing factor -->
										<xsl:when test="$value = 'NA'"><xsl:text/></xsl:when>
										<!-- non-factor value -->
										<xsl:otherwise>	<xsl:value-of select="$innerElement/Attrs/Attr[@name='levels']/Vector/Items/Item[$value]/text()"/>	</xsl:otherwise>
								</xsl:choose></fo:block>
							</xsl:element>
						</xsl:for-each>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>

		<xsl:if test="$maxColumnsPerTable &gt; 0 and $endLevel &lt;= $numColumns">
			<xsl:call-template name="MatrixTable">
				<xsl:with-param name="element" select="$element" />
				<xsl:with-param name="title" select="'Grouping Description'" />
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
				<xsl:with-param name="startLevel" select="$endLevel" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
<!--	HANDLE MULTIDIMENSIONALARRAY OBJECTS HERE -->
<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
	<xsl:template name="MultiDimensionalArray">
		<xsl:param name="element" select="''"/>
		<xsl:param name="indent" select="'0'" />
		<xsl:param name="title" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="maxColumnsPerTable" select="''" />

 		<xsl:variable name="dimensionNodes" select="$element/Attrs/Attr[@name='.Dim']/Vector/Items/Item"/>
 		<xsl:variable name="dimensionNameNodes" select="$element/Attrs/Attr[@name='.Dimnames']/List/Components/Component/Vector"/>
		<xsl:variable name="curDimNum" select="count($dimensionNodes)"/>
		<xsl:variable name="cellsPerTable" select="$dimensionNodes[1]/text() * $dimensionNodes[2]/text()"/>
		<xsl:variable name="numTables" select="floor(count($element/Vector/Items/Item) div ($cellsPerTable))"/>

		<!-- label the array -->
		<fo:inline xsl:use-attribute-sets="title"><xsl:value-of select="$title"/></fo:inline>
		<!-- display the dimensions -->
		<fo:block xsl:use-attribute-sets="bold-emph" space-after="5pt">
 			<xsl:text>Number of Categories:</xsl:text>
 			<fo:block start-indent="30pt">
 				<xsl:for-each select="$dimensionNodes">
 					<xsl:variable name="dimNum" select="position()" />
 					<fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[$dimNum]/text()"/><xsl:text> : </xsl:text><xsl:value-of select="./text()"/><xsl:text> categories</xsl:text></fo:block>
 				</xsl:for-each>
 			</fo:block>
		</fo:block>

		<!--
			call function that iterates over all possible dimension combinations
			creating a two dimensional (use the first two dimensions)
			representation of the array.  for example, a 5x4x3x2 array would
			be represented by 3*2 tables with the dimensions: 5 rows and
			4 columns.
		-->
		<xsl:call-template name="CreateArrayTables">
			<xsl:with-param name="dimNodes" select="$dimensionNodes"/>
			<xsl:with-param name="dimNameNodes" select="$dimensionNameNodes"/>
			<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
			<xsl:with-param name="numDims" select="$curDimNum"/>
			<xsl:with-param name="curDimNum" select="$curDimNum"/>
			<xsl:with-param name="curDimMax" select="$dimensionNodes[$curDimNum]/text()"/>
			<xsl:with-param name="numTables" select="$numTables"/>
			<xsl:with-param name="data" select="$element/Vector/Items"/>
			<xsl:with-param name="indent" select="$indent"/>
			<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
		</xsl:call-template>
	</xsl:template>

	<!-- recursively build tables that represent array -->
	<xsl:template name="CreateArrayTables">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''"/>
		<xsl:param name="numDims" select="'2'"/>
		<xsl:param name="curDimNum" select="'1'"/>
		<xsl:param name="curDimMax" select="'1'"/>
		<xsl:param name="curDimVal" select="1"/>
		<xsl:param name="label" select="''"/>
		<xsl:param name="numTables" select="'0'"/>
		<xsl:param name="tableNum" select="'0'"/>
		<xsl:param name="tableDividor" select="'1'"/>
		<xsl:param name="data" select="''"/>
		<xsl:param name="indent" select="''"/>
		<xsl:param name="maxColumnsPerTable" select="''" />

		<xsl:variable name="tableSize" select="($dimNodes[1]/text() * $dimNodes[2]/text())"/>
		<xsl:variable name="startIndex" select="($tableNum * $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<xsl:choose>
			<xsl:when test="$curDimNum = 1">
				<!--
					there's only 1 dimension in the array.
				-->
				<fo:block space-after="10pt">
					<xsl:call-template name="Create1DArrayTable">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="zeroBasedTableNum" select="0"/>
						<xsl:with-param name="numDims" select="1"/>
						<xsl:with-param name="numRows" select="$dimNodes[1]/text()"/>
						<xsl:with-param name="numCols" select="1"/>
						<xsl:with-param name="indent" select="$indent + .5"/>
						<xsl:with-param name="data" select="$data"/>
					</xsl:call-template>
				</fo:block>
			</xsl:when>
			<xsl:when test="$curDimNum = 2">
				<!-- filter out any tables of ALL 0's -->
				<xsl:if test="count($data/Item[position() &gt; $startIndex and position() &lt;= $endIndex][./text() != 0]) > 0">

				<!--
					we have evaluated all but 2 dimensions.  these dimensions will
					be used as row and column dimensions in the table.  use
					recursively constructed label describing the dimensional
					position of this particular table.
				-->
				<xsl:variable name="tableLabel" select="concat('( , ', $label, ')')"/>
				<fo:block space-after="10pt">
					<fo:block xsl:use-attribute-sets="small-cap">
						<xsl:call-template name="ArrayGetTableTitle">
	 						<xsl:with-param name="tableNum" select="$tableNum"/>
	 						<xsl:with-param name="numOtherDim" select="count($dimNameNodes) - 2" />
	 						<xsl:with-param name="levelDims" select="$dimNameNodes[position() &gt; 2]/Items" />
	 						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames" />
	 						<xsl:with-param name="ignoreFirstNDims" select="2"/>
	 					</xsl:call-template>
					</fo:block>

					<xsl:call-template name="CreateArrayTable">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="zeroBasedTableNum" select="$tableNum"/>
						<xsl:with-param name="numDims" select="$numDims"/>
						<xsl:with-param name="numRows" select="$dimNodes[1]/text()"/>
						<xsl:with-param name="numCols" select="$dimNodes[2]/text()"/>
						<xsl:with-param name="indent" select="$indent + .5"/>
						<xsl:with-param name="data" select="$data"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
					</xsl:call-template>
				</fo:block>

				</xsl:if>

			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="newLabel">
					<xsl:choose>
						<xsl:when test="boolean($dimNameNodes and $dimNameNodes[$curDimNum]/Items/Item[$curDimVal])">
							<xsl:value-of select="concat(', ', $dimNameNodes[$curDimNum]/Items/Item[$curDimVal],'[', $dimensionColumnNames/Items/Item[$curDimNum], ']', $label)"/>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="concat(', ', $curDimVal, '[', $dimensionColumnNames/Items/Item[$curDimNum], ']', $label)"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<!--
					still need to evaluate another level of dimensions.  we started looking
					at the final dimension, so, the next level is evaluated by subtracting
					1 from the $curDimNum.
				-->
				<xsl:call-template name="CreateArrayTables">
					<xsl:with-param name="dimNodes" select="$dimNodes"/>
					<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
					<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
					<xsl:with-param name="numDims" select="$numDims"/>
					<xsl:with-param name="curDimNum" select="$curDimNum - 1"/>
					<xsl:with-param name="curDimMax" select="$dimNodes[$curDimNum - 1]/text()"/>
					<xsl:with-param name="label" select="$newLabel"/>
					<xsl:with-param name="numTables" select="$numTables"/>
					<xsl:with-param name="tableNum" select="$tableNum + (($curDimVal - 1)*(floor($numTables div ($tableDividor * $curDimMax))))"/>
					<xsl:with-param name="tableDividor" select="$tableDividor * $curDimMax"/>
					<xsl:with-param name="data" select="$data"/>
					<xsl:with-param name="indent" select="$indent"/>
					<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
				</xsl:call-template>
				<xsl:if test="$curDimVal &lt; $curDimMax">
					<!--
						need to evaluate this dimension's peers.  to do so, add one to
						$curDimVal.  this allows us to display 2,3...n within a dimension.
					-->
					<xsl:call-template name="CreateArrayTables">
						<xsl:with-param name="dimNodes" select="$dimNodes"/>
						<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
						<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
						<xsl:with-param name="numDims" select="$numDims"/>
						<xsl:with-param name="curDimNum" select="$curDimNum"/>
						<xsl:with-param name="curDimMax" select="$curDimMax"/>
						<xsl:with-param name="curDimVal" select="$curDimVal + 1"/>
						<xsl:with-param name="label" select="$label"/>
						<xsl:with-param name="numTables" select="$numTables"/>
						<xsl:with-param name="tableNum" select="$tableNum"/>
						<xsl:with-param name="tableDividor" select="$tableDividor"/>
						<xsl:with-param name="data" select="$data"/>
						<xsl:with-param name="indent" select="$indent"/>
						<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
					</xsl:call-template>
				</xsl:if>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- CREATE ACTUAL TABLE -->
	<xsl:template name="CreateArrayTable">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="zeroBasedTableNum" select="0"/>
		<xsl:param name="numDims" select="0"/>
		<xsl:param name="curDim" select="3"/>
		<xsl:param name="dividor" select="1"/>
		<xsl:param name="numRows" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="startPos" select="0"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="data" select="''"/>
		<xsl:param name="maxColumnsPerTable" select="''" />
		<xsl:param name="startLevel" select="1" />

		<xsl:variable name="tableSize" select="($numRows * $numCols)"/>
		<xsl:variable name="startIndex" select="($zeroBasedTableNum* $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<xsl:variable name="allColumns" select="$data/Item[position() &lt;= $numCols]" />
		<xsl:variable name="numColumns" select="count($allColumns)" />
		<xsl:variable name="endLevel">
			<xsl:choose>
				<xsl:when test="$maxColumnsPerTable &gt; 0"><xsl:value-of select="$startLevel + $maxColumnsPerTable" /></xsl:when>
				<xsl:otherwise><xsl:value-of select="$numColumns + 1" /></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="limitedColumns" select="$allColumns[position() &gt;= $startLevel and position() &lt; $endLevel]" />

		<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed" space-after="5pt">
			<!-- total num columns = one (for row labels) + second dimension value -->
			<!-- assign column widths and create columns -->
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="GetWidth"><xsl:with-param name="string" select="$dimensionColumnNames/Items/Item[1]"/></xsl:call-template><xsl:text>pt</xsl:text>
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">2</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:choose>
						<xsl:when test="boolean($dimNameNodes)">
							<xsl:call-template name="TextNodeWidth">
								<xsl:with-param name="element" select="$dimNameNodes[1]/Items/Item"/>
								<xsl:with-param name="TotalNum" select="count($dimNameNodes[1]/Items/Item)"/>
							</xsl:call-template><xsl:text>pt</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="GetWidth"><xsl:with-param name="string" select="concat('[', $numRows, ', ]')"/></xsl:call-template><xsl:text>pt</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:element>
			<xsl:for-each select="$limitedColumns">
				<xsl:variable name="colPos" select="position() + $startLevel - 1" />
				<xsl:variable name="columnHeader">
					<xsl:choose>
						<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[2]/Items/Item[$colPos]/text()"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="$colPos"/></xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:element name="fo:table-column">
					<xsl:attribute name="column-width">
						<xsl:call-template name="TextNodeWidth">
							<xsl:with-param name="element" select="$data/Item[position() &gt; $startIndex and position() &lt;= $endIndex]"/>
							<xsl:with-param name="maxWidth" select="string-length($columnHeader) * 8"/>
							<xsl:with-param name="TotalNum" select="count($data/Item[position() &gt; $startIndex and position() &lt; $endIndex])"/>
							<xsl:with-param name="numCols" select="$numCols"/>
							<xsl:with-param name="colNum" select="position()"/>
						</xsl:call-template><xsl:text>pt</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:for-each>
			<!-- assign values of header -->
			<fo:table-header>
				<fo:table-row background-color="{$g_headerBG}">
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<xsl:element name="fo:table-cell" use-attribute-sets="column-header left right top bottom">
						<xsl:attribute name="background-color"><xsl:value-of select="$g_headerBG"/></xsl:attribute>
						<xsl:attribute name="number-columns-spanned"><xsl:value-of select="count($limitedColumns)"/></xsl:attribute>
						<xsl:attribute name="text-align">center</xsl:attribute>
						<fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[2]"/></fo:block>
					</xsl:element>
				</fo:table-row>
				<fo:table-row background-color="{$g_headerBG}">
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<xsl:for-each select="$limitedColumns">
						<xsl:variable name="colPos" select="position() + $startLevel - 1" />
						<fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="column-header left right top bottom"><fo:block>
							<xsl:choose>
								<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[2]/Items/Item[$colPos]/text()"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="$colPos"/></xsl:otherwise>
							</xsl:choose>
						</fo:block></fo:table-cell>
					</xsl:for-each>
				</fo:table-row>
			</fo:table-header>

			<fo:table-body>
				<xsl:for-each select="$data/Item[position() &lt;= $numRows]">
					<xsl:variable name="rowStartPos" select="((position()-1) * $numCols) + $startIndex"/>
					<xsl:variable name="rowEndPos" select="$rowStartPos + $numCols"/>
					<xsl:variable name="rowData" select="$data/Item[position() &gt; $startIndex and position() &lt;= $endIndex]"/>
					<xsl:variable name="rowPosition" select="position() - 1"/>

					<fo:table-row>
						<!-- create dimension column label -->
						<xsl:choose>
							<xsl:when test="$numRows = 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></fo:block></fo:table-cell></xsl:when>
							<xsl:when test="$rowPosition = 0"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top left right"><fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></fo:block></fo:table-cell></xsl:when>
							<xsl:when test="($rowPosition + 1) = $numRows"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="bottom left right"><fo:block></fo:block></fo:table-cell></xsl:when>
							<xsl:otherwise><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="left right"><fo:block></fo:block></fo:table-cell></xsl:otherwise>
						</xsl:choose>

						<!-- create row labels -->
						<fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block>
							<xsl:choose>
									<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[1]/Items/Item[$rowPosition + 1]/text()"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$rowPosition + 1"/></xsl:otherwise>
							</xsl:choose>
						</fo:block></fo:table-cell>
						<!-- display actual data in row-major depite being stored in column-major-->
						<xsl:for-each select="$rowData[(position() - 1) mod $numRows = $rowPosition]">
							<xsl:variable name="columnNumber" select="position()" />
							<xsl:if test="$columnNumber &gt;= $startLevel and $columnNumber &lt; $endLevel">
								<xsl:element name="fo:table-cell" use-attribute-sets="table-content top bottom left right">
									<xsl:attribute name="background-color"><xsl:choose><xsl:when test="$rowPosition mod 2 = 1"><xsl:value-of select="$g_rowBG_1"/></xsl:when><xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise></xsl:choose></xsl:attribute>
									<fo:block><xsl:value-of select="./text()"/></fo:block>
								</xsl:element>
							</xsl:if>
						</xsl:for-each>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>

		<xsl:if test="$maxColumnsPerTable &gt; 0 and $endLevel &lt;= $numColumns">
			<xsl:call-template name="CreateArrayTable">
				<xsl:with-param name="dimNodes" select="$dimNodes"/>
				<xsl:with-param name="dimNameNodes" select="$dimNameNodes"/>
				<xsl:with-param name="dimensionColumnNames" select="$dimensionColumnNames"/>
				<xsl:with-param name="zeroBasedTableNum" select="$zeroBasedTableNum"/>
				<xsl:with-param name="numDims" select="$numDims"/>
				<xsl:with-param name="numRows" select="$numRows"/>
				<xsl:with-param name="numCols" select="$numCols"/>
				<xsl:with-param name="indent" select="$indent"/>
				<xsl:with-param name="data" select="$data"/>
				<xsl:with-param name="maxColumnsPerTable" select="$maxColumnsPerTable" />
				<xsl:with-param name="startLevel" select="$endLevel" />
			</xsl:call-template>
		</xsl:if>

	</xsl:template>

	<!-- CREATE ACTUAL ONE DIMENSIONAL TABLE -->
	<xsl:template name="Create1DArrayTable">
		<xsl:param name="dimNodes" select="''"/>
		<xsl:param name="dimNameNodes" select="''"/>
		<xsl:param name="dimensionColumnNames" select="''" />
		<xsl:param name="zeroBasedTableNum" select="0"/>
		<xsl:param name="numDims" select="0"/>
		<xsl:param name="curDim" select="3"/>
		<xsl:param name="dividor" select="1"/>
		<xsl:param name="numRows" select="0"/>
		<xsl:param name="numCols" select="0"/>
		<xsl:param name="startPos" select="0"/>
		<xsl:param name="indent" select="0"/>
		<xsl:param name="data" select="''"/>

		<xsl:variable name="tableSize" select="($numRows * $numCols)"/>
		<xsl:variable name="startIndex" select="($zeroBasedTableNum* $tableSize)"/>
		<xsl:variable name="endIndex" select="$startIndex + $tableSize"/>

		<fo:table xsl:use-attribute-sets="table-atts" table-layout="fixed">
			<!-- total num columns = one (for row labels) + second dimension value -->
			<!-- assign column widths and create columns -->
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">1</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:call-template name="GetWidth"><xsl:with-param name="string" select="$dimensionColumnNames/Items/Item[1]"/></xsl:call-template><xsl:text>pt</xsl:text>
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-number">2</xsl:attribute>
				<xsl:attribute name="column-width">
					<xsl:choose>
						<xsl:when test="boolean($dimNameNodes)">
							<xsl:call-template name="TextNodeWidth">
								<xsl:with-param name="element" select="$dimNameNodes[1]/Items/Item"/>
								<xsl:with-param name="TotalNum" select="count($dimNameNodes[1]/Items/Item)"/>
							</xsl:call-template><xsl:text>pt</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="GetWidth"><xsl:with-param name="string" select="concat('[', $numRows, ', ]')"/></xsl:call-template><xsl:text>pt</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</xsl:element>
			<xsl:element name="fo:table-column">
				<xsl:attribute name="column-width">
					<xsl:call-template name="TextNodeWidth">
						<xsl:with-param name="element" select="$data/Item"/>
						<xsl:with-param name="maxWidth" select="string-length('Value') * 8"/>
						<xsl:with-param name="TotalNum" select="count($data/Item)"/>
						<xsl:with-param name="numCols" select="1"/>
						<xsl:with-param name="colNum" select="position()"/>
					</xsl:call-template><xsl:text>pt</xsl:text>
				</xsl:attribute>
			</xsl:element>
			<!-- assign values of header -->
			<fo:table-header>
				<fo:table-row background-color="{$g_headerBG}">
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="column-header left right top bottom" background-color="{$g_tableBG}"><fo:block/></fo:table-cell>
					<fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="column-header left right top bottom">
						<fo:block>Value</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-header>

			<fo:table-body>
				<xsl:for-each select="$data/Item">
					<xsl:variable name="rowPosition" select="position() - 1"/>
					<fo:table-row>
						<!-- create dimension column label -->
						<xsl:choose>
							<xsl:when test="$numRows = 1"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right"><fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></fo:block></fo:table-cell></xsl:when>
							<xsl:when test="$rowPosition = 0"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top left right"><fo:block><xsl:value-of select="$dimensionColumnNames/Items/Item[1]"/></fo:block></fo:table-cell></xsl:when>
							<xsl:when test="($rowPosition + 1) = $numRows"><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="bottom left right"><fo:block></fo:block></fo:table-cell></xsl:when>
							<xsl:otherwise><fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="left right"><fo:block></fo:block></fo:table-cell></xsl:otherwise>
						</xsl:choose>

						<!-- create row labels -->
						<fo:table-cell background-color="{$g_headerBG}" xsl:use-attribute-sets="row-header top bottom left right">
							<fo:block>
								<xsl:choose>
									<xsl:when test="boolean($dimNameNodes)"><xsl:value-of select="$dimNameNodes[1]/Items/Item[$rowPosition+1]/text()"/></xsl:when>
									<xsl:otherwise><xsl:value-of select="$rowPosition+1"/></xsl:otherwise>
								</xsl:choose>
							</fo:block>
						</fo:table-cell>
						<!-- display actual data in row-major depite being stored in column-major-->
						<xsl:element name="fo:table-cell" use-attribute-sets="table-content top bottom left right">
							<xsl:attribute name="background-color"><xsl:choose><xsl:when test="$rowPosition mod 2 = 1"><xsl:value-of select="$g_rowBG_1"/></xsl:when><xsl:otherwise><xsl:value-of select="$g_rowBG_2"/></xsl:otherwise></xsl:choose></xsl:attribute>
							<fo:block><xsl:value-of select="./text()"/></fo:block>
						</xsl:element>
					</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>
	</xsl:template>

	<!-- RETURN STRING WIDTH w/ MIN SETTING -->
	<xsl:template name="GetWidth">
		<xsl:param name="string" select="''"/>
		<xsl:param name="minWidth" select="50"/>

		<xsl:variable name="length" select="string-length($string) * 7"/>

		<xsl:choose>
			<xsl:when test="$length &lt; $minWidth">	<xsl:value-of select="$minWidth"/></xsl:when>
			<xsl:otherwise>	<xsl:value-of select="$length"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- EVALUATE MAX WIDTH IN AN ITEM LIST -->
	<xsl:template name="ItemTextWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="1"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>
		<xsl:param name="extraWidth" select="0"/>

		<xsl:variable name="this" select="$element/Item[$CurrentNum]/text()"/>
		<xsl:variable name="fontWidth" select="8"/>
		<xsl:variable name="thisWidth" select="string-length($this) * $fontWidth"/>

		<xsl:variable name="thisIterationMaxWidth" select="$thisWidth * number($thisWidth &gt; $maxWidth) + $maxWidth * number($thisWidth &lt;= $maxWidth)" />
		<xsl:variable name="overallMaxWidth" select="$thisIterationMaxWidth * number($thisIterationMaxWidth &gt; $minWidth) + $minWidth * number($thisIterationMaxWidth &lt;= $minWidth)" />

		<xsl:choose>
			<xsl:when test="$TotalNum &lt;= $CurrentNum">
				<!-- final case....return actual max -->
				<xsl:value-of select="$overallMaxWidth + ($extraWidth * $fontWidth)"/>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further -->
				<xsl:call-template name="ItemTextWidth">
					<xsl:with-param name="element" select="$element"/>
					<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
					<xsl:with-param name="TotalNum" select="$TotalNum"/>
					<xsl:with-param name="maxWidth" select="$overallMaxWidth"/>
					<xsl:with-param name="minWidth" select="$minWidth"/>
					<xsl:with-param name="extraWidth" select="$extraWidth"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- EVALUATE MAX TEXT VAL IN NODESET -->
	<xsl:template name="TextNodeWidth">
		<xsl:param name="element" select="''"/>
		<xsl:param name="CurrentNum" select="1"/>
		<xsl:param name="TotalNum" select="0"/>
		<xsl:param name="minWidth" select="50"/>
		<xsl:param name="maxWidth" select="0"/>
		<xsl:param name="numCols" select="''"/>
		<xsl:param name="colNum" select="''"/>
		<xsl:param name="charWidth" select="8"/>

		<xsl:variable name="this" select="$element[$CurrentNum]/text()"/>
		<xsl:variable name="thisWidth" select="string-length($this) * $charWidth"/>

		<xsl:variable name="thisIterationMaxWidth" select="$thisWidth * number($thisWidth &gt; $maxWidth) + $maxWidth * number($thisWidth &lt;= $maxWidth)" />
		<xsl:variable name="overallMaxWidth" select="$thisIterationMaxWidth * number($thisIterationMaxWidth &gt; $minWidth) + $minWidth * number($thisIterationMaxWidth &lt;= $minWidth)" />

		<xsl:choose>
			<xsl:when test="$TotalNum &lt;= $CurrentNum">
				<!-- return final max value  -->
				<xsl:value-of select="$overallMaxWidth"/>
			</xsl:when>
			<xsl:when test="boolean($numCols) and boolean($colNum) and ($CurrentNum mod $numCols) != $colNum">
				<!-- this value isn't important...iterate on without changing values -->
				<xsl:call-template name="TextNodeWidth">
					<xsl:with-param name="element" select="$element"/>
					<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
					<xsl:with-param name="TotalNum" select="$TotalNum"/>
					<xsl:with-param name="maxWidth" select="$maxWidth"/>
					<xsl:with-param name="minWidth" select="$minWidth"/>
					<xsl:with-param name="numCols" select="$numCols"/>
					<xsl:with-param name="colNum" select="$colNum"/>
					<xsl:with-param name="charWidth" select="$charWidth"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!--iterate further...change max as needed -->
				<xsl:call-template name="TextNodeWidth">
					<xsl:with-param name="element" select="$element"/>
					<xsl:with-param name="CurrentNum" select="$CurrentNum + 1"/>
					<xsl:with-param name="TotalNum" select="$TotalNum"/>
					<xsl:with-param name="maxWidth" select="$overallMaxWidth"/>
					<xsl:with-param name="minWidth" select="$minWidth"/>
					<xsl:with-param name="numCols" select="$numCols"/>
					<xsl:with-param name="colNum" select="$colNum"/>
					<xsl:with-param name="charWidth" select="$charWidth"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''"/>
		<xsl:param name="decimalPattern"><xsl:value-of select="$g_defaultPattern"/></xsl:param>
		<xsl:param name="scientificPattern"><xsl:value-of select="$g_defaultScientific"/></xsl:param>

		<xsl:variable name="lowerCasePattern" select="'e'"/>
		<xsl:variable name="upperCasePattern" select="'E'"/>

		<xsl:choose>
			<xsl:when test="contains($string, $lowerCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($string, $upperCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>  </xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''"/>
		<xsl:param name="exponentString" select="''"/>
		<xsl:param name="decimalPattern"><xsl:value-of select="$g_defaultPattern"/></xsl:param>

		<xsl:value-of select="format-number($valueString, $decimalPattern)"/>E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>
</xsl:stylesheet>
