/**************************************************************************/
#if !defined(_IM_COX_REGRESSION_H_)
#define _IM_COX_REGRESSION_H_

#include "IMObjects.h"

#define IMinerCoxRegressionModel IMinerObject

#define IMINER_COX_REGR_META_DATA_NUM		0
#define IMINER_COX_REGR_COEFFICIENTS_NUM	1
#define IMINER_COX_REGR_CENTERS_NUM			2
#define IMINER_COX_REGR_SURVIVAL_NUM		3
#define IMINER_COX_REGR_HESSIAN_NUM			4

/* macro to access a matrix element from IMinerMatrix object*/
#define IMINER_COX_REGR_WEIGHTS_PTR(pObj, i)	(pObj)->m_uData.m_ppList[i]
#define IMINER_COX_REGR_META_DATA(model)		IMINER_COX_REGR_WEIGHTS_PTR(model, IMINER_COX_REGR_META_DATA_NUM)
#define IMINER_COX_REGR_COEFFICIENTS(model)		IMINER_COX_REGR_WEIGHTS_PTR(model, IMINER_COX_REGR_COEFFICIENTS_NUM)
#define IMINER_COX_REGR_CENTERS(model)			IMINER_COX_REGR_WEIGHTS_PTR(model, IMINER_COX_REGR_CENTERS_NUM)
#define IMINER_COX_REGR_SURVIVAL(model)			IMINER_COX_REGR_WEIGHTS_PTR(model, IMINER_COX_REGR_SURVIVAL_NUM)
#define IMINER_COX_REGR_HESSIAN(model)			IMINER_COX_REGR_WEIGHTS_PTR(model, IMINER_COX_REGR_HESSIAN_NUM)

#ifdef __cplusplus
extern "C" {
#endif

/* alloc memory and set content for class KMeans Cluster */
IMCSRC_DLLAPI(long) IMinerCoxRegressionModel_create(
 IMinerObject* pModel,		    /* out: data object */
 IMinerObject* md,			    /* in:  meta data object */
 long nInputs,                  /* in:  number of inputs */
 long nBaselines,				/* in:  number of baselines */
 const double* pdCoefficients,  /* in:  model coefficients of length nInputs */
 const double* pdCenters,       /* in:  model centers of length nInputs */
 const double* pdSurvival,      /* in:  survival matrix of length (5 * 62) */
 const double* pdHessian        /* in:  hessian matrix of length (nInputs * nInputs) */
);

/* validate the object */
IMCSRC_DLLAPI(long) IMinerCoxRegressionModel_isValid(const IMinerObject* pModel);

/* free memory */
IMCSRC_DLLAPI(long) IMinerCoxRegressionModel_destroy(IMinerObject* pModel );

/* write to stdout */
IMCSRC_DLLAPI(long) IMinerCoxRegressionModel_print(const IMinerObject* pModel);

/* predict cluster memberships */
IMCSRC_DLLAPI(long) IMinerCoxRegressionModel_predict(
 IMinerObject* pOutput,      /* out: output rectangular data */
 const IMinerObject* pInput, /* in: input rectangular data */
 IMinerObject* pDescr,		 /* in: input description (if NULL, description will be 
                                    created from input data) */
 const IMinerObject* pModel  /* in: the model */
);

#ifdef __cplusplus
}
#endif

#endif /*_IM_NEURAL_NETWORK_H_ */

